/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.AQAgentI;
import oracle.jdbc.driver.AQMessagePropertiesI;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIaqjms;
import oracle.jdbc.driver.T4CTTIaqm;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.T4Ctoh;
import oracle.jdbc.internal.JMSEnqueueOptions;
import oracle.jdbc.internal.JMSMessageProperties;

public class T4CTTIoaqenq
extends T4CTTIfun {
    T4CTTIaqm aqm;
    T4Ctoh toh;
    T4CTTIaqjms aqjms;
    private JMSEnqueueOptions enqueueOptions = null;
    private AQMessagePropertiesI messageProperties = null;
    private JMSMessageProperties jmsProp = null;
    private byte[] aqmcorBytes;
    private byte[] aqmeqnBytes;
    private byte[] senderAgentName = null;
    private byte[] senderAgentAddress = null;
    private byte senderAgentProtocol = 0;
    private byte[] messageData = null;
    private byte[] messageOid = null;
    private AQAgentI[] attrRecipientList = null;
    private byte[][] recipientTextValues = null;
    private byte[][] recipientBinaryValues = null;
    private int[] recipientKeywords = null;
    private byte[] queueNameBytes = null;
    private byte[] outMsgId = null;
    private int bitMappedEnqueueOption = 0;
    private byte[] headerPropBytes;
    private byte[] userPropBytes;
    private boolean retrieveMessageId = false;

    T4CTTIoaqenq(T4CConnection t4CConnection) {
        super(t4CConnection, (byte)3);
        this.setFunCode((short)184);
        this.toh = new T4Ctoh();
        this.aqm = new T4CTTIaqm(this.connection, this.toh);
        this.aqjms = new T4CTTIaqjms(this.connection);
    }

    void doJMSEnq(String string, JMSEnqueueOptions jMSEnqueueOptions, AQMessagePropertiesI aQMessagePropertiesI, JMSMessageProperties jMSMessageProperties, byte[] byArray, byte[] byArray2) throws SQLException, IOException {
        this.enqueueOptions = jMSEnqueueOptions;
        this.messageProperties = aQMessagePropertiesI;
        this.jmsProp = jMSMessageProperties;
        this.messageData = byArray2;
        if (this.messageProperties != null) {
            String string2 = this.messageProperties.getCorrelation();
            this.aqmcorBytes = (byte[])(string2 != null && string2.length() != 0 ? this.meg.conv.StringToCharBytes(string2) : null);
            String string3 = this.messageProperties.getExceptionQueue();
            this.aqmeqnBytes = (byte[])(string3 != null && string3.length() != 0 ? this.meg.conv.StringToCharBytes(string3) : null);
            AQAgentI aQAgentI = (AQAgentI)this.messageProperties.getSender();
            if (aQAgentI != null) {
                this.senderAgentName = (byte[])(aQAgentI.getName() != null ? this.meg.conv.StringToCharBytes(aQAgentI.getName()) : null);
                this.senderAgentAddress = (byte[])(aQAgentI.getAddress() != null ? this.meg.conv.StringToCharBytes(aQAgentI.getAddress()) : null);
                this.senderAgentProtocol = (byte)aQAgentI.getProtocol();
            } else {
                this.senderAgentName = null;
                this.senderAgentAddress = null;
                this.senderAgentProtocol = 0;
            }
            this.attrRecipientList = (AQAgentI[])this.messageProperties.getRecipientList();
            if (this.attrRecipientList != null && this.attrRecipientList.length > 0) {
                this.recipientTextValues = new byte[this.attrRecipientList.length * 3][];
                this.recipientBinaryValues = new byte[this.attrRecipientList.length * 3][];
                this.recipientKeywords = new int[this.attrRecipientList.length * 3];
                for (int i2 = 0; i2 < this.attrRecipientList.length; ++i2) {
                    if (this.attrRecipientList[i2].getName() != null) {
                        this.recipientTextValues[3 * i2] = this.meg.conv.StringToCharBytes(this.attrRecipientList[i2].getName());
                    }
                    if (this.attrRecipientList[i2].getAddress() != null) {
                        this.recipientTextValues[3 * i2 + 1] = this.meg.conv.StringToCharBytes(this.attrRecipientList[i2].getAddress());
                    }
                    this.recipientBinaryValues[3 * i2 + 2] = new byte[1];
                    this.recipientBinaryValues[3 * i2 + 2][0] = (byte)this.attrRecipientList[i2].getProtocol();
                    this.recipientKeywords[3 * i2] = 3 * i2;
                    this.recipientKeywords[3 * i2 + 1] = 3 * i2 + 1;
                    this.recipientKeywords[3 * i2 + 2] = 3 * i2 + 2;
                }
            }
        } else {
            this.aqmcorBytes = null;
            this.aqmeqnBytes = null;
            this.senderAgentName = null;
            this.senderAgentAddress = null;
            this.senderAgentProtocol = 0;
        }
        this.messageData = byArray2;
        this.messageOid = byArray;
        this.queueNameBytes = (byte[])(string != null && string.length() != 0 ? this.meg.conv.StringToCharBytes(string) : null);
        this.bitMappedEnqueueOption = jMSEnqueueOptions.getDeliveryMode().getCode() + jMSEnqueueOptions.getVisibility().getCode();
        if (this.jmsProp != null) {
            this.headerPropBytes = this.meg.conv.StringToCharBytes(this.jmsProp.getHeaderProperties());
            this.userPropBytes = this.meg.conv.StringToCharBytes(this.jmsProp.getUserProperties());
        } else {
            this.headerPropBytes = null;
            this.userPropBytes = null;
        }
        this.outMsgId = null;
        this.doRPC();
    }

    @Override
    void marshal() throws IOException {
        if (this.queueNameBytes != null && this.queueNameBytes.length != 0) {
            this.meg.marshalPTR();
            this.meg.marshalSWORD(this.queueNameBytes.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        this.aqm.initToDefaultValues();
        if (this.messageProperties != null) {
            this.aqm.aqmpri = this.messageProperties.getPriority();
            this.aqm.aqmdel = this.messageProperties.getDelay();
            this.aqm.aqmexp = this.messageProperties.getExpiration();
            this.aqm.originalMsgId = this.messageProperties.getPreviousQueueMessageId();
        }
        this.aqm.aqmcorBytes = this.aqmcorBytes;
        this.aqm.aqmeqnBytes = this.aqmeqnBytes;
        this.aqm.senderAgentName = this.senderAgentName;
        this.aqm.senderAgentAddress = this.senderAgentAddress;
        this.aqm.senderAgentProtocol = this.senderAgentProtocol;
        this.aqm.marshal();
        this.meg.marshalSB4(this.bitMappedEnqueueOption);
        if (this.jmsProp != null) {
            this.aqjms.aqjmsflags = this.jmsProp.getJMSMessageType().getCode();
            this.aqjms.aqjmshdrpcnt = 0;
            this.aqjms.aqjmsusrprpcnt = 0;
        } else {
            this.aqjms.aqjmsflags = 0;
            this.aqjms.aqjmshdrpcnt = 0;
            this.aqjms.aqjmsusrprpcnt = 0;
        }
        this.aqjms.aqjmshdrprop = this.headerPropBytes;
        this.aqjms.aqjmsuserprop = this.userPropBytes;
        this.aqjms.marshal();
        if (this.messageOid != null) {
            this.meg.marshalPTR();
            this.meg.marshalSWORD(16);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        this.meg.marshalUB2(1);
        this.meg.marshalNULLPTR();
        if (this.messageData != null) {
            this.meg.marshalPTR();
            this.meg.marshalUB4(this.messageData.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
        }
        this.meg.marshalSB4(0);
        if (this.enqueueOptions.isRetrieveMessageId()) {
            this.retrieveMessageId = true;
            this.meg.marshalPTR();
            this.meg.marshalSWORD(16);
        } else {
            this.retrieveMessageId = false;
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        if (this.queueNameBytes != null && this.queueNameBytes.length != 0) {
            this.meg.marshalCHR(this.queueNameBytes);
        }
        if (this.messageOid != null) {
            this.meg.marshalB1Array(this.messageOid);
        }
        if (this.messageData != null) {
            this.meg.marshalB1Array(this.messageData);
        }
    }

    @Override
    void readRPA() throws SQLException, IOException {
        if (this.retrieveMessageId) {
            this.outMsgId = new byte[16];
            this.meg.unmarshalBuffer(this.outMsgId, 0, 16);
        }
    }

    public byte[] getMsgId() {
        return this.outMsgId;
    }
}

