/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBufferedStream;
import oracle.jdbc.internal.OracleBfile;
import oracle.jdbc.internal.OracleBlob;
import oracle.jdbc.internal.OracleConnection;

class OracleBlobInputStream
extends OracleBufferedStream {
    long lobOffset;
    OracleBlob blob;
    OracleBfile bfile;
    boolean isStreamForBlob;
    long markedByte;
    boolean endOfStream = false;
    long maxPosition = Long.MAX_VALUE;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Apr_04_15:09:24_PDT_2013";
    public static final boolean TRACE = false;

    public OracleBlobInputStream(OracleBlob oracleBlob, int n2) throws SQLException {
        this(oracleBlob, n2, 1L);
    }

    public OracleBlobInputStream(OracleBlob oracleBlob, int n2, long l2) throws SQLException {
        super(n2);
        if (oracleBlob == null || n2 <= 0 || l2 < 1L) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        this.isStreamForBlob = true;
        this.blob = oracleBlob;
        this.bfile = null;
        this.markedByte = -1L;
        this.lobOffset = l2;
    }

    public OracleBlobInputStream(OracleBlob oracleBlob, int n2, long l2, long l3) throws SQLException {
        this(oracleBlob, n2, l2);
        this.maxPosition = l2 + l3;
    }

    public OracleBlobInputStream(OracleBfile oracleBfile, int n2) throws SQLException {
        this(oracleBfile, n2, 1L);
    }

    public OracleBlobInputStream(OracleBfile oracleBfile, int n2, long l2) throws SQLException {
        super(n2);
        if (oracleBfile == null || n2 <= 0 || l2 < 1L) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        this.isStreamForBlob = false;
        this.blob = null;
        this.bfile = oracleBfile;
        this.markedByte = -1L;
        this.lobOffset = l2;
    }

    @Override
    public boolean needBytes(int n2) throws IOException {
        this.ensureOpen();
        if (this.pos >= this.count) {
            if (!this.endOfStream) {
                if (n2 > this.currentBufferSize || n2 == 0) {
                    this.currentBufferSize = Math.max(n2, this.initialBufferSize);
                    this.resizableBuffer = new byte[this.currentBufferSize];
                }
                try {
                    int n3 = (long)this.currentBufferSize < this.maxPosition - this.lobOffset ? this.currentBufferSize : (int)(this.maxPosition - this.lobOffset);
                    this.count = this.isStreamForBlob ? this.blob.getBytes(this.lobOffset, n3, this.resizableBuffer) : this.bfile.getBytes(this.lobOffset, n3, this.resizableBuffer);
                    if (this.count < this.currentBufferSize) {
                        this.endOfStream = true;
                    }
                    if (this.count > 0) {
                        this.pos = 0;
                        this.lobOffset += (long)this.count;
                        if (this.lobOffset > this.maxPosition) {
                            this.endOfStream = true;
                        }
                        return true;
                    }
                }
                catch (SQLException sQLException) {
                    IOException iOException = DatabaseError.createIOException(sQLException);
                    iOException.fillInStackTrace();
                    throw iOException;
                }
            }
            return false;
        }
        return true;
    }

    void ensureOpen() throws IOException {
        try {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 57, null);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        catch (SQLException sQLException) {
            IOException iOException = DatabaseError.createIOException(sQLException);
            iOException.fillInStackTrace();
            throw iOException;
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        this.markedByte = this.lobOffset - (long)this.count + (long)this.pos;
    }

    public void markInternal(int n2) {
    }

    @Override
    public void reset() throws IOException {
        this.ensureOpen();
        if (this.markedByte < 0L) {
            throw new IOException("Mark invalid or stream not marked.");
        }
        this.lobOffset = this.markedByte;
        this.pos = this.count;
        this.endOfStream = false;
    }

    @Override
    public long skip(long l2) throws IOException {
        this.ensureOpen();
        long l3 = 0L;
        if ((long)(this.count - this.pos) >= l2) {
            this.pos = (int)((long)this.pos + l2);
            l3 += l2;
        } else {
            l3 += (long)(this.count - this.pos);
            this.pos = this.count;
            try {
                long l4 = 0L;
                l4 = this.isStreamForBlob ? this.blob.length() - this.lobOffset + 1L : this.bfile.length() - this.lobOffset + 1L;
                if (l4 >= l2 - l3) {
                    this.lobOffset += l2 - l3;
                    l3 += l2 - l3;
                } else {
                    this.lobOffset += l4;
                    l3 += l4;
                }
            }
            catch (SQLException sQLException) {
                IOException iOException = DatabaseError.createIOException(sQLException);
                iOException.fillInStackTrace();
                throw iOException;
            }
        }
        return l3;
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        OracleConnection oracleConnection = null;
        try {
            if (this.isStreamForBlob && this.blob != null) {
                oracleConnection = this.blob.getInternalConnection();
            } else if (!this.isStreamForBlob && this.bfile != null) {
                oracleConnection = this.bfile.getInternalConnection();
            }
        }
        catch (Exception exception) {
            oracleConnection = null;
        }
        return oracleConnection;
    }
}

