/*
 * Decompiled with CFR 0.152.
 */
package de.weingardt.mylyn.gitlab.core;

import de.weingardt.mylyn.gitlab.core.ConnectionManager;
import de.weingardt.mylyn.gitlab.core.GitlabAction;
import de.weingardt.mylyn.gitlab.core.GitlabAttribute;
import de.weingardt.mylyn.gitlab.core.GitlabAttributeMapper;
import de.weingardt.mylyn.gitlab.core.GitlabConnection;
import de.weingardt.mylyn.gitlab.core.GitlabConnector;
import de.weingardt.mylyn.gitlab.core.exceptions.GitlabException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMetaData;
import org.eclipse.mylyn.tasks.core.data.TaskCommentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskOperation;
import org.gitlab.api.GitlabAPI;
import org.gitlab.api.models.GitlabIssue;
import org.gitlab.api.models.GitlabMilestone;
import org.gitlab.api.models.GitlabNote;
import org.gitlab.api.models.GitlabProjectMember;

public class GitlabTaskDataHandler
extends AbstractTaskDataHandler {
    private static Pattern priorityPattern = Pattern.compile("(?:priority:)?(high|normal|low)");
    private static Pattern typePattern = Pattern.compile("(?:type:)?(bug|feature|story)");

    public TaskAttributeMapper getAttributeMapper(TaskRepository repository) {
        try {
            return ConnectionManager.get((TaskRepository)repository).mapper;
        }
        catch (CoreException e) {
            throw new Error(e);
        }
    }

    public boolean initializeTaskData(TaskRepository repository, TaskData data, ITaskMapping mapping, IProgressMonitor monitor) throws CoreException {
        this.createDefaultAttributes(data, false);
        GitlabConnection connection = ConnectionManager.get(repository);
        TaskAttribute root = data.getRoot();
        root.getAttribute(GitlabAttribute.PROJECT.getTaskKey()).setValue(connection.project.getName());
        root.getAttribute(GitlabAttribute.LABELS.getTaskKey()).setValue("");
        root.getAttribute(GitlabAttribute.STATUS.getTaskKey()).setValue("open");
        root.getAttribute(GitlabAttribute.MILESTONE.getTaskKey()).setValue("");
        return true;
    }

    public RepositoryResponse postTaskData(TaskRepository repository, TaskData data, Set<TaskAttribute> attributes, IProgressMonitor monitor) throws CoreException {
        GitlabAttributeMapper attributeMapper = (GitlabAttributeMapper)data.getAttributeMapper();
        TaskAttribute root = data.getRoot();
        String labels = root.getAttribute(GitlabAttribute.LABELS.getTaskKey()).getValue();
        String title = root.getAttribute(GitlabAttribute.TITLE.getTaskKey()).getValue();
        String body = root.getAttribute(GitlabAttribute.BODY.getTaskKey()).getValue();
        Integer assigneeId = 0;
        for (TaskAttribute a : attributes) {
            if (!a.getId().equals(GitlabAttribute.ASSIGNEE.getTaskKey())) continue;
            GitlabProjectMember assignee = attributeMapper.findProjectMemberByName(root.getAttribute(GitlabAttribute.ASSIGNEE.getTaskKey()).getValue());
            assigneeId = assignee == null ? -1 : assignee.getId();
        }
        GitlabMilestone milestone = attributeMapper.findMilestoneByName(root.getAttribute(GitlabAttribute.MILESTONE.getTaskKey()).getValue());
        Integer milestoneId = milestone == null ? 0 : milestone.getId();
        GitlabConnection connection = ConnectionManager.get(repository);
        GitlabAPI api = connection.api();
        try {
            monitor.beginTask("Uploading task", -1);
            GitlabIssue issue = null;
            if (data.isNew()) {
                issue = api.createIssue(connection.project.getId().intValue(), assigneeId.intValue(), milestoneId, labels, body, title);
                RepositoryResponse repositoryResponse = new RepositoryResponse(RepositoryResponse.ResponseKind.TASK_CREATED, "" + issue.getIid());
                return repositoryResponse;
            }
            if (root.getAttribute("task.common.comment.new") != null && !root.getAttribute("task.common.comment.new").getValue().equals("")) {
                api.createNote((Serializable)connection.project.getId(), GitlabConnector.getTicketId(data.getTaskId()), root.getAttribute("task.common.comment.new").getValue());
            }
            String action = root.getAttribute("task.common.operation").getValue();
            issue = api.editIssue(connection.project.getId().intValue(), GitlabConnector.getTicketId(data.getTaskId()).intValue(), assigneeId.intValue(), milestoneId.intValue(), labels, body, title, GitlabAction.find(action).getGitlabIssueAction());
            RepositoryResponse repositoryResponse = new RepositoryResponse(RepositoryResponse.ResponseKind.TASK_UPDATED, "" + issue.getIid());
            return repositoryResponse;
        }
        catch (IOException e) {
            throw new GitlabException("Unknown connection error!");
        }
        finally {
            monitor.done();
        }
    }

    public TaskData downloadTaskData(TaskRepository repository, Integer ticketId) throws CoreException {
        try {
            GitlabConnection connection = ConnectionManager.get(repository);
            GitlabAPI api = connection.api();
            GitlabIssue issue = api.getIssue((Serializable)connection.project.getId(), ticketId);
            List notes = api.getNotes(issue);
            return this.createTaskDataFromGitlabIssue(issue, repository, notes);
        }
        catch (IOException e) {
            throw new GitlabException("Unknown connection error!");
        }
    }

    public TaskData createTaskDataFromGitlabIssue(GitlabIssue issue, TaskRepository repository, List<GitlabNote> notes) throws CoreException {
        GitlabConnection connection = ConnectionManager.get(repository);
        TaskData data = new TaskData((TaskAttributeMapper)connection.mapper, "gitlab", repository.getUrl(), "" + issue.getIid());
        String labels = StringUtils.join((Object[])issue.getLabels(), (String)", ");
        this.createDefaultAttributes(data, true);
        TaskAttribute root = data.getRoot();
        root.getAttribute(GitlabAttribute.AUTHOR.getTaskKey()).setValue(issue.getAuthor().getName());
        root.getAttribute(GitlabAttribute.CREATED.getTaskKey()).setValue("" + issue.getCreatedAt().getTime());
        root.getAttribute(GitlabAttribute.BODY.getTaskKey()).setValue(issue.getDescription() == null ? "" : issue.getDescription());
        root.getAttribute(GitlabAttribute.LABELS.getTaskKey()).setValue(labels);
        root.getAttribute(GitlabAttribute.PROJECT.getTaskKey()).setValue(connection.project.getName());
        root.getAttribute(GitlabAttribute.STATUS.getTaskKey()).setValue(issue.getState());
        root.getAttribute(GitlabAttribute.TITLE.getTaskKey()).setValue(issue.getTitle());
        root.getAttribute(GitlabAttribute.IID.getTaskKey()).setValue("" + issue.getIid());
        root.getAttribute(GitlabAttribute.PRIORITY.getTaskKey()).setValue(this.getPriority(labels));
        root.getAttribute(GitlabAttribute.TYPE.getTaskKey()).setValue(this.getType(labels));
        if (issue.getMilestone() != null) {
            root.getAttribute(GitlabAttribute.MILESTONE.getTaskKey()).setValue(issue.getMilestone().getTitle());
        }
        if (issue.getUpdatedAt() != null) {
            root.getAttribute(GitlabAttribute.UPDATED.getTaskKey()).setValue("" + issue.getUpdatedAt().getTime());
        }
        if (issue.getState().equals("closed")) {
            root.getAttribute(GitlabAttribute.COMPLETED.getTaskKey()).setValue("" + issue.getUpdatedAt().getTime());
        }
        if (issue.getAssignee() != null) {
            root.getAttribute(GitlabAttribute.ASSIGNEE.getTaskKey()).setValue(issue.getAssignee().getName());
        }
        Collections.sort(notes, new Comparator<GitlabNote>(){

            @Override
            public int compare(GitlabNote o1, GitlabNote o2) {
                return o1.getCreatedAt().compareTo(o2.getCreatedAt());
            }
        });
        int i = 0;
        while (i < notes.size()) {
            TaskCommentMapper cmapper = new TaskCommentMapper();
            cmapper.setAuthor(repository.createPerson(notes.get(i).getAuthor().getName()));
            cmapper.setCreationDate(notes.get(i).getCreatedAt());
            cmapper.setText(notes.get(i).getBody());
            cmapper.setNumber(Integer.valueOf(i + 1));
            TaskAttribute attribute = data.getRoot().createAttribute("task.common.comment-" + (i + 1));
            cmapper.applyTo(attribute);
            ++i;
        }
        GitlabAction[] actions = GitlabAction.getActions(issue);
        int i2 = 0;
        while (i2 < actions.length) {
            GitlabAction action = actions[i2];
            TaskAttribute attribute = data.getRoot().createAttribute("task.common.operation-" + action.label);
            TaskOperation.applyTo((TaskAttribute)attribute, (String)action.label, (String)action.label);
            ++i2;
        }
        return data;
    }

    private void createDefaultAttributes(TaskData data, boolean existingTask) {
        this.createAttribute(data, GitlabAttribute.BODY);
        this.createAttribute(data, GitlabAttribute.TITLE);
        this.createAttribute(data, GitlabAttribute.LABELS);
        this.createAttribute(data, GitlabAttribute.STATUS);
        this.createAttribute(data, GitlabAttribute.PROJECT);
        this.createAttribute(data, GitlabAttribute.CREATED);
        this.createAttribute(data, GitlabAttribute.COMPLETED);
        this.createAttribute(data, GitlabAttribute.UPDATED);
        this.createAttribute(data, GitlabAttribute.ASSIGNEE);
        this.createAttribute(data, GitlabAttribute.MILESTONE);
        this.createAttribute(data, GitlabAttribute.IID);
        this.createAttribute(data, GitlabAttribute.PRIORITY);
        this.createAttribute(data, GitlabAttribute.TYPE);
        data.getRoot().getAttribute(GitlabAttribute.CREATED.getTaskKey()).setValue("" + new Date().getTime());
        if (existingTask) {
            data.getRoot().createAttribute("task.common.comment.new").getMetaData().setType("longRichText").setReadOnly(false);
            this.createAttribute(data, GitlabAttribute.AUTHOR);
        }
        TaskAttribute operation = data.getRoot().createAttribute("task.common.operation");
        operation.getMetaData().setType("operation");
    }

    private void createAttribute(TaskData data, GitlabAttribute attribute) {
        TaskAttribute attr = data.getRoot().createAttribute(attribute.getTaskKey());
        TaskAttributeMetaData metaData = attr.getMetaData();
        metaData.setType(attribute.getType());
        metaData.setKind(attribute.getKind());
        metaData.setLabel(attribute.toString());
        metaData.setReadOnly(attribute.isReadOnly());
    }

    private String getPriority(String labels) {
        Matcher m = priorityPattern.matcher(labels);
        if (m.find()) {
            String p = m.group(1);
            if (p.equals("high")) {
                return ITask.PriorityLevel.P1.toString();
            }
            if (p.equals("low")) {
                return ITask.PriorityLevel.P5.toString();
            }
        }
        return ITask.PriorityLevel.P3.toString();
    }

    private String getType(String labels) {
        Matcher m = typePattern.matcher(labels);
        if (m.find()) {
            return m.group(1);
        }
        return "";
    }
}

