/*
 * Decompiled with CFR 0.152.
 */
package de.weingardt.mylyn.gitlab.core;

import de.weingardt.mylyn.gitlab.core.ConnectionManager;
import de.weingardt.mylyn.gitlab.core.GitlabConnection;
import de.weingardt.mylyn.gitlab.core.GitlabIssueSearch;
import de.weingardt.mylyn.gitlab.core.GitlabTaskDataHandler;
import de.weingardt.mylyn.gitlab.core.GitlabTaskMapper;
import de.weingardt.mylyn.gitlab.core.exceptions.GitlabException;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.mylyn.tasks.core.sync.ISynchronizationSession;
import org.gitlab.api.GitlabAPI;
import org.gitlab.api.models.GitlabIssue;

public class GitlabConnector
extends AbstractRepositoryConnector {
    private GitlabTaskDataHandler handler = new GitlabTaskDataHandler();

    public boolean canCreateNewTask(TaskRepository repository) {
        return true;
    }

    public boolean canCreateTaskFromKey(TaskRepository repository) {
        return false;
    }

    public String getConnectorKind() {
        return "gitlab";
    }

    public String getLabel() {
        return "Gitlab issues";
    }

    public String getRepositoryUrlFromTaskUrl(String arg0) {
        return null;
    }

    public TaskData getTaskData(TaskRepository repository, String id, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("Task Download", -1);
            TaskData taskData = this.handler.downloadTaskData(repository, GitlabConnector.getTicketId(id));
            return taskData;
        }
        finally {
            monitor.done();
        }
    }

    public String getTaskIdFromTaskUrl(String url) {
        return null;
    }

    public String getTaskUrl(String arg0, String arg1) {
        return null;
    }

    public boolean hasTaskChanged(TaskRepository repository, ITask task, TaskData data) {
        GitlabTaskMapper mapper = new GitlabTaskMapper(data);
        if (data.isPartial()) {
            return mapper.hasChanges(task);
        }
        Date repositoryDate = mapper.getModificationDate();
        Date localDate = task.getModificationDate();
        return repositoryDate == null || !repositoryDate.equals(localDate);
    }

    public IStatus performQuery(TaskRepository repository, IRepositoryQuery query, TaskDataCollector collector, ISynchronizationSession session, IProgressMonitor monitor) {
        try {
            monitor.beginTask("Tasks querying", -1);
            GitlabConnection connection = ConnectionManager.get(repository);
            GitlabAPI api = connection.api();
            GitlabIssueSearch search = new GitlabIssueSearch(query);
            List issues = api.getIssues(connection.project);
            for (GitlabIssue i : issues) {
                if (!search.doesMatch(i)) continue;
                collector.accept(this.handler.createTaskDataFromGitlabIssue(i, repository, api.getNotes(i)));
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (CoreException e) {
            Status status = new Status(4, "de.weingardt.gitlab.core", "Unable to execute Query: " + e.getMessage());
            return status;
        }
        catch (IOException e) {
            Status status = new Status(4, "de.weingardt.gitlab.core", "Unable to execute Query: " + e.getMessage());
            return status;
        }
        finally {
            monitor.done();
        }
    }

    public void updateRepositoryConfiguration(TaskRepository repository, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("Updating repository configuration", -1);
            ConnectionManager.get(repository, true);
        }
        finally {
            monitor.done();
        }
    }

    public void updateTaskFromTaskData(TaskRepository repository, ITask task, TaskData data) {
        GitlabTaskMapper mapper = new GitlabTaskMapper(data);
        mapper.applyTo(task);
    }

    public static void validate(TaskRepository taskRepo) throws CoreException {
        try {
            ConnectionManager.validate(taskRepo);
        }
        catch (GitlabException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GitlabException("Connection not successful or repository not found: " + e.getMessage());
        }
        catch (Error e) {
            throw new GitlabException("Connection not successful or repository not found: " + e.getMessage());
        }
    }

    public AbstractTaskDataHandler getTaskDataHandler() {
        return this.handler;
    }

    public static Integer getTicketId(String id) {
        return Integer.parseInt(id);
    }
}

