/*
 * Decompiled with CFR 0.152.
 */
package de.weingardt.mylyn.gitlab.core;

import org.gitlab.api.models.GitlabIssue;

public enum GitlabAction {
    LEAVE("leave"),
    CLOSE("close"),
    REOPEN("reopen");

    private static final GitlabAction[] opened;
    private static final GitlabAction[] closed;
    public final String label;

    static {
        opened = new GitlabAction[]{LEAVE, CLOSE};
        closed = new GitlabAction[]{LEAVE, REOPEN};
    }

    private GitlabAction(String label) {
        this.label = label;
    }

    public static GitlabAction[] getActions(GitlabIssue issue) {
        if (issue.getState().equals("closed")) {
            return closed;
        }
        return opened;
    }

    public static GitlabAction find(String action) {
        GitlabAction[] gitlabActionArray = GitlabAction.values();
        int n = gitlabActionArray.length;
        int n2 = 0;
        while (n2 < n) {
            GitlabAction a = gitlabActionArray[n2];
            if (a.label.equals(action)) {
                return a;
            }
            ++n2;
        }
        return LEAVE;
    }

    public GitlabIssue.Action getGitlabIssueAction() {
        switch (this) {
            case CLOSE: {
                return GitlabIssue.Action.CLOSE;
            }
            case LEAVE: {
                return GitlabIssue.Action.LEAVE;
            }
            case REOPEN: {
                return GitlabIssue.Action.REOPEN;
            }
        }
        return GitlabIssue.Action.LEAVE;
    }
}

