/*
 * Decompiled with CFR 0.152.
 */
package de.weingardt.mylyn.gitlab.core;

import de.weingardt.mylyn.gitlab.core.GitlabAttributeMapper;
import de.weingardt.mylyn.gitlab.core.GitlabConnection;
import de.weingardt.mylyn.gitlab.core.exceptions.GitlabException;
import de.weingardt.mylyn.gitlab.core.exceptions.GitlabExceptionHandler;
import de.weingardt.mylyn.gitlab.core.exceptions.UnknownProjectException;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.gitlab.api.GitlabAPI;
import org.gitlab.api.models.GitlabProject;
import org.gitlab.api.models.GitlabSession;

public class ConnectionManager {
    private static HashMap<String, GitlabConnection> connections = new HashMap();
    private static Pattern URLPattern = Pattern.compile("((?:http|https)://(?:[^\\/]*))/((?:.*?)/(?:[^\\/]*?))$");

    public static GitlabConnection get(TaskRepository repository) throws GitlabException {
        return ConnectionManager.get(repository, false);
    }

    public static GitlabConnection getSafe(TaskRepository repository) {
        try {
            return ConnectionManager.get(repository);
        }
        catch (GitlabException e) {
            return null;
        }
    }

    private static String constructURL(TaskRepository repository) {
        String username = repository.getCredentials(AuthenticationType.REPOSITORY).getUserName();
        String password = repository.getCredentials(AuthenticationType.REPOSITORY).getPassword();
        return String.valueOf(repository.getUrl()) + "?username=" + username + "&password=" + password.hashCode();
    }

    static GitlabConnection validate(TaskRepository repository) throws GitlabException {
        try {
            String projectPath = null;
            String host = null;
            if (repository.getProperty("gitlabBaseUrl").trim().length() > 0) {
                host = repository.getProperty("gitlabBaseUrl").trim();
                if (!repository.getUrl().startsWith(host)) {
                    throw new GitlabException("Invalid project URL!");
                }
                projectPath = repository.getUrl().replaceFirst(Matcher.quoteReplacement(host), "");
                if (projectPath.startsWith("/")) {
                    projectPath = projectPath.substring(1);
                }
            } else {
                Matcher matcher = URLPattern.matcher(repository.getUrl());
                if (!matcher.find()) {
                    throw new GitlabException("Invalid Project-URL!");
                }
                projectPath = matcher.group(2);
                host = matcher.group(1);
            }
            String username = repository.getCredentials(AuthenticationType.REPOSITORY).getUserName();
            String password = repository.getCredentials(AuthenticationType.REPOSITORY).getPassword();
            GitlabSession session = null;
            String token = null;
            if (repository.getProperty("usePrivateToken") != null && repository.getProperty("usePrivateToken").equals("true")) {
                session = GitlabAPI.connect((String)host, (String)password).getCurrentSession();
                token = password;
            } else {
                token = session.getPrivateToken();
            }
            GitlabAPI api = GitlabAPI.connect((String)host, (String)token);
            if (projectPath.endsWith(".git")) {
                projectPath = projectPath.substring(0, projectPath.length() - 4);
            }
            List projects = api.getMembershipProjects();
            for (GitlabProject p : projects) {
                if (!p.getPathWithNamespace().equals(projectPath)) continue;
                GitlabConnection connection = new GitlabConnection(host, p, token, new GitlabAttributeMapper(repository));
                return connection;
            }
            throw new UnknownProjectException(projectPath);
        }
        catch (GitlabException e) {
            throw e;
        }
        catch (Exception e) {
            throw GitlabExceptionHandler.handle(e);
        }
        catch (Error e) {
            throw GitlabExceptionHandler.handle(e);
        }
    }

    static GitlabConnection get(TaskRepository repository, boolean forceUpdate) throws GitlabException {
        try {
            String hash = ConnectionManager.constructURL(repository);
            if (connections.containsKey(hash) && !forceUpdate) {
                return connections.get(hash);
            }
            GitlabConnection connection = ConnectionManager.validate(repository);
            connections.put(hash, connection);
            connection.update();
            return connection;
        }
        catch (GitlabException e) {
            throw e;
        }
        catch (Exception e) {
            throw GitlabExceptionHandler.handle(e);
        }
        catch (Error e) {
            throw GitlabExceptionHandler.handle(e);
        }
    }
}

