/*
 * Decompiled with CFR 0.152.
 */
package de.weingardt.mylyn.gitlab.core.exceptions;

import de.weingardt.mylyn.gitlab.core.exceptions.GitlabException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import javax.net.ssl.SSLHandshakeException;

public class GitlabExceptionHandler {
    public static GitlabException handle(Throwable e) {
        if (e instanceof SSLHandshakeException) {
            return new GitlabException("Invalid TLS Certificate: " + e.getMessage());
        }
        if (e instanceof ConnectException) {
            return new GitlabException("Connection refused");
        }
        if (e instanceof NoRouteToHostException) {
            return new GitlabException("No route to host");
        }
        if (e instanceof FileNotFoundException) {
            return new GitlabException("Invalid path in host: " + e.getMessage());
        }
        if (e instanceof IOException) {
            return new GitlabException("Invalid username/password/private token combination");
        }
        return new GitlabException("Unknown Exception: " + e.getMessage());
    }
}

