/*
 * Decompiled with CFR 0.152.
 */
package de.weingardt.mylyn.gitlab.core;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.gitlab.api.models.GitlabIssue;

public class GitlabIssueSearch {
    private String assignee;
    private String milestone;
    private Boolean opened;
    private Boolean closed;
    private List<Pattern> labels = new ArrayList<Pattern>();

    public GitlabIssueSearch(IRepositoryQuery query) {
        this.assignee = query.getAttribute("assignee");
        this.milestone = query.getAttribute("milestone");
        this.opened = Boolean.parseBoolean(query.getAttribute("opened"));
        this.closed = Boolean.parseBoolean(query.getAttribute("closed"));
        String[] stringArray = query.getAttribute("labels").split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String label = stringArray[n2];
            if (label.trim().length() > 0) {
                this.labels.add(Pattern.compile(label.trim()));
            }
            ++n2;
        }
    }

    public boolean doesMatch(GitlabIssue issue) {
        if (!(this.assignee.equals("") || issue.getAssignee() != null && (this.assignee.equals(issue.getAssignee().getUsername()) || this.assignee.equals(issue.getAssignee().getName())))) {
            return false;
        }
        if (!(this.milestone.equals("") || issue.getMilestone() != null && this.milestone.equals(issue.getMilestone().getTitle()))) {
            return false;
        }
        ArrayList<Pattern> matchedLabels = new ArrayList<Pattern>();
        for (Pattern p : this.labels) {
            String[] stringArray = issue.getLabels();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String label = stringArray[n2];
                if (p.matcher(label).find()) {
                    matchedLabels.add(p);
                }
                ++n2;
            }
        }
        if (matchedLabels.size() < this.labels.size()) {
            return false;
        }
        if (!this.closed.booleanValue() && issue.getState().equals("closed")) {
            return false;
        }
        return this.opened != false || !issue.getState().equals("opened");
    }
}

