/*
 * Decompiled with CFR 0.152.
 */
package de.weingardt.mylyn.gitlab.core;

import de.weingardt.mylyn.gitlab.core.GitlabAttributeMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gitlab.api.GitlabAPI;
import org.gitlab.api.models.GitlabMilestone;
import org.gitlab.api.models.GitlabProject;
import org.gitlab.api.models.GitlabProjectMember;

public class GitlabConnection {
    public final String host;
    public final String token;
    public final GitlabProject project;
    public final GitlabAttributeMapper mapper;
    private List<GitlabMilestone> milestones;
    private List<GitlabProjectMember> members;

    public GitlabConnection(String host, GitlabProject project, String token, GitlabAttributeMapper mapper) {
        this.host = host;
        this.project = project;
        this.token = token;
        this.mapper = mapper;
    }

    public GitlabAPI api() {
        return GitlabAPI.connect((String)this.host, (String)this.token);
    }

    public void update() throws IOException {
        ArrayList memberList = new ArrayList();
        this.milestones = this.api().getMilestones(this.project);
        memberList.addAll(this.api().getProjectMembers(this.project));
        try {
            memberList.addAll(this.api().getNamespaceMembers(this.project.getNamespace()));
        }
        catch (Exception exception) {
        }
        catch (Error error) {
            // empty catch block
        }
        this.members = Collections.unmodifiableList(memberList);
    }

    public List<GitlabMilestone> getMilestones() {
        return Collections.unmodifiableList(this.milestones);
    }

    public List<GitlabProjectMember> getProjectMembers() {
        return Collections.unmodifiableList(this.members);
    }
}

