/*
 * Decompiled with CFR 0.152.
 */
package de.weingardt.mylyn.gitlab.core;

import de.weingardt.mylyn.gitlab.core.ConnectionManager;
import de.weingardt.mylyn.gitlab.core.GitlabAttribute;
import de.weingardt.mylyn.gitlab.core.GitlabConnection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.gitlab.api.models.GitlabMilestone;
import org.gitlab.api.models.GitlabProjectMember;

public class GitlabAttributeMapper
extends TaskAttributeMapper {
    public GitlabAttributeMapper(TaskRepository taskRepository) throws CoreException, IOException {
        super(taskRepository);
    }

    public Map<String, String> getOptions(TaskAttribute attribute) {
        if (attribute.getId().equals(GitlabAttribute.MILESTONE.getTaskKey())) {
            return this.getAsMap(this.getMilestones());
        }
        return super.getOptions(attribute);
    }

    private GitlabConnection getConnection() throws CoreException {
        return ConnectionManager.get(this.getTaskRepository());
    }

    public GitlabProjectMember findProjectMemberByName(String name) {
        try {
            List<GitlabProjectMember> members = this.getConnection().getProjectMembers();
            for (GitlabProjectMember member : members) {
                if (!member.getName().equals(name) && !member.getUsername().equals(name)) continue;
                return member;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    public GitlabMilestone findMilestoneByName(String name) {
        try {
            List<GitlabMilestone> milestones = this.getConnection().getMilestones();
            for (GitlabMilestone m : milestones) {
                if (!m.getTitle().equals(name)) continue;
                return m;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    private List<String> getMilestones() {
        ArrayList<String> target = new ArrayList<String>();
        try {
            List<GitlabMilestone> milestones = this.getConnection().getMilestones();
            for (GitlabMilestone m : milestones) {
                target.add(m.getTitle());
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return target;
    }

    private HashMap<String, String> getAsMap(List<String> list) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("", "");
        for (String s : list) {
            map.put(s, s);
        }
        return map;
    }
}

