/*
 * Decompiled with CFR 0.152.
 */
package de.weingardt.mylyn.gitlab.core;

import de.weingardt.mylyn.gitlab.core.GitlabFlag;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;

public enum GitlabAttribute {
    BODY("Description", "task.common.description", "longRichText"),
    TITLE("Summary", "task.common.summary", "shortRichText"),
    STATUS("Status", "task.common.status", "shortText", GitlabFlag.ATTRIBUTE, GitlabFlag.READ_ONLY),
    LABELS("Labels", "de.weingardt.gitlab.issue.labels", "longText", GitlabFlag.ATTRIBUTE),
    UPDATED("Updated", "task.common.date.modified", "dateTime", GitlabFlag.READ_ONLY, GitlabFlag.ATTRIBUTE),
    CREATED("Created", "task.common.date.created", "dateTime", GitlabFlag.READ_ONLY, GitlabFlag.ATTRIBUTE),
    COMPLETED("Completed", "task.common.date.completed", "dateTime", GitlabFlag.READ_ONLY),
    AUTHOR("Author", "task.common.user.reporter", "person", GitlabFlag.READ_ONLY, GitlabFlag.ATTRIBUTE),
    PROJECT("Project", "task.common.product", "shortText", GitlabFlag.READ_ONLY, GitlabFlag.ATTRIBUTE),
    ASSIGNEE("Assignee", "task.common.user.assigned", "person", GitlabFlag.ATTRIBUTE),
    MILESTONE("Milestone", "de.weingardt.gitlab.issue.milestone", "singleSelect", GitlabFlag.ATTRIBUTE),
    IID("IID", "task.common.key", "integer", GitlabFlag.READ_ONLY),
    PRIORITY("Priority", "task.common.priority", "shortText", GitlabFlag.READ_ONLY),
    TYPE("Type", "task.common.kind", "shortText", GitlabFlag.READ_ONLY);

    public static final String TypeBug = "bug";
    public static final String TypeFeature = "feature";
    public static final String TypeStory = "story";
    private Set<GitlabFlag> flags;
    private final String prettyName;
    private final String taskKey;
    private final String type;

    public String getKind() {
        if (this.type.equals("person")) {
            return "task.common.kind.people";
        }
        if (this.flags.contains((Object)GitlabFlag.ATTRIBUTE)) {
            return "task.common.kind.default";
        }
        return null;
    }

    public boolean isReadOnly() {
        return this.flags.contains((Object)GitlabFlag.READ_ONLY);
    }

    private GitlabAttribute(String prettyName, String taskKey, String type, GitlabFlag ... flags) {
        this.taskKey = taskKey;
        this.prettyName = prettyName;
        this.type = type;
        if (flags == null || flags.length == 0) {
            this.setFlags(EnumSet.noneOf(GitlabFlag.class));
        } else {
            this.setFlags(EnumSet.copyOf(Arrays.asList(flags)));
        }
    }

    private GitlabAttribute(String prettyName, String taskKey, String type) {
        this(prettyName, taskKey, type, new GitlabFlag[0]);
    }

    public Set<GitlabFlag> getFlags() {
        return this.flags;
    }

    public void setFlags(Set<GitlabFlag> flags) {
        this.flags = flags;
    }

    public String getPrettyName() {
        return this.prettyName;
    }

    public String getTaskKey() {
        return this.taskKey;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return this.prettyName;
    }

    public static GitlabAttribute get(String key) {
        GitlabAttribute[] gitlabAttributeArray = GitlabAttribute.values();
        int n = gitlabAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            GitlabAttribute attr = gitlabAttributeArray[n2];
            if (attr.getTaskKey().equals(key)) {
                return attr;
            }
            ++n2;
        }
        return null;
    }
}

