/*
 * Decompiled with CFR 0.152.
 */
package de.verit.klaros.service.issuemanagement.redmine;

import com.taskadapter.redmineapi.bean.Issue;
import de.verit.klaros.service.issuemanagement.BaseIssueModel;
import de.verit.klaros.service.issuemanagement.IssueCustomAttribute;
import de.verit.klaros.service.issuemanagement.IssueCustomField;
import de.verit.klaros.service.issuemanagement.IssueManagementServiceType;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;

public class RedmineIssueModel
extends BaseIssueModel
implements Serializable {
    private static final long serialVersionUID = -7958907454650153966L;
    private String category;
    private Date dueDate;
    private String estimate;
    private String doneRatio;
    private Date startDate;
    private String tracker;
    private String version;
    private String assignedTo;
    private String parentId;

    public RedmineIssueModel(Issue issue, Map<String, IssueCustomAttribute> customFieldAttributes, Map<String, IssueCustomField> customFields) {
        super(customFieldAttributes, customFields);
        if (issue.getId() != null) {
            this.setId(issue.getId().toString());
        }
        this.setOwner(issue.getAssigneeName());
        this.setAssignedTo(issue.getAssigneeName());
        this.setReporter(issue.getAuthorName());
        this.setPriority(issue.getPriorityText());
        this.setStatus(issue.getStatusName());
        this.setSummary(issue.getSubject());
        this.setDescription(issue.getDescription());
        this.setCreationDate(issue.getCreatedOn());
        this.setLastChanged(issue.getUpdatedOn());
        this.setStartDate(issue.getStartDate());
        this.setDueDate(issue.getDueDate());
        this.setParentId(issue.getParentId() != null ? issue.getParentId().toString() : null);
        if (issue.getCategory() != null) {
            this.setCategory(issue.getCategory().getName());
        }
        if (issue.getEstimatedHours() != null) {
            this.setEstimate(issue.getEstimatedHours().toString());
        }
        if (issue.getDoneRatio() != null) {
            this.setDoneRatio(issue.getDoneRatio().toString());
        }
        if (issue.getTracker() != null) {
            this.setTracker(issue.getTracker().getName());
        }
        if (issue.getTargetVersion() != null) {
            this.setVersion(issue.getTargetVersion().getName());
        }
    }

    public final void setCategory(String category) {
        this.category = category;
    }

    public String getCategory() {
        return this.category;
    }

    public final void setDueDate(Date date) {
        this.dueDate = date != null ? new Date(date.getTime()) : null;
    }

    public Date getDueDate() {
        if (this.dueDate != null) {
            return new Date(this.dueDate.getTime());
        }
        return null;
    }

    public final void setEstimate(String estimate) {
        this.estimate = estimate;
    }

    public String getEstimate() {
        return this.estimate;
    }

    public final void setDoneRatio(String doneRatio) {
        this.doneRatio = doneRatio;
    }

    public String getDoneRatio() {
        return this.doneRatio;
    }

    public final void setStartDate(Date date) {
        this.startDate = date != null ? new Date(date.getTime()) : null;
    }

    public Date getStartDate() {
        if (this.startDate != null) {
            return new Date(this.startDate.getTime());
        }
        return null;
    }

    public final void setTracker(String tracker) {
        this.tracker = tracker;
    }

    public String getTracker() {
        return this.tracker;
    }

    public final void setVersion(String version) {
        this.version = version;
    }

    public final String getVersion() {
        return this.version;
    }

    public final void setAssignedTo(String assignee) {
        this.assignedTo = assignee;
    }

    public final String getAssignedTo() {
        return this.assignedTo;
    }

    public String getParentId() {
        return this.parentId;
    }

    public final void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public IssueManagementServiceType getServiceType() {
        return IssueManagementServiceType.REDMINE;
    }
}

