/*
 * Decompiled with CFR 0.152.
 */
package de.verit.klaros.service.issuemanagement.redmine;

import com.google.common.collect.Maps;
import com.taskadapter.redmineapi.Include;
import com.taskadapter.redmineapi.NotFoundException;
import com.taskadapter.redmineapi.RedmineAuthenticationException;
import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.RedmineInternalError;
import com.taskadapter.redmineapi.RedmineManager;
import com.taskadapter.redmineapi.RedmineManagerFactory;
import com.taskadapter.redmineapi.bean.CustomField;
import com.taskadapter.redmineapi.bean.CustomFieldDefinition;
import com.taskadapter.redmineapi.bean.Issue;
import com.taskadapter.redmineapi.bean.IssueCategory;
import com.taskadapter.redmineapi.bean.IssuePriority;
import com.taskadapter.redmineapi.bean.IssueStatus;
import com.taskadapter.redmineapi.bean.Membership;
import com.taskadapter.redmineapi.bean.Project;
import com.taskadapter.redmineapi.bean.Tracker;
import com.taskadapter.redmineapi.bean.Version;
import com.taskadapter.redmineapi.internal.RequestParam;
import de.verit.klaros.exception.KlarosServiceException;
import de.verit.klaros.service.connection.BaseExternalService;
import de.verit.klaros.service.issuemanagement.IssueCustomAttribute;
import de.verit.klaros.service.issuemanagement.IssueCustomField;
import de.verit.klaros.service.issuemanagement.IssueManagementService;
import de.verit.klaros.service.issuemanagement.IssueManagementServiceType;
import de.verit.klaros.service.issuemanagement.IssueModel;
import de.verit.klaros.service.issuemanagement.mylyn.MylynIssueCustomField;
import de.verit.klaros.service.issuemanagement.mylyn.MylynIssueCustomFieldType;
import de.verit.klaros.service.issuemanagement.redmine.RedmineIssueModel;
import de.verit.klaros.service.issuemanagement.redmine.RedmineMylynIssueCustomAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedmineIssueManagementService
extends BaseExternalService
implements IssueManagementService {
    private static final String MSG_SWALLOWING_EXCEPTION = "Swallowing exception";
    private static final String CUSTOM_FIELD_FORMAT_DATE = "date";
    private static final String CUSTOM_FIELD_FORMAT_USER = "user";
    private static final String CUSTOM_FIELD_FORMAT_VERSION = "version";
    private static final Logger LOG = LoggerFactory.getLogger(RedmineIssueManagementService.class);
    private static final String UNABLE_TO_RETRIEVE_ISSUE = "Unable to retrieve issue";
    private static final String PROCRESSING_MESSAGE = "Processing exception";
    private final String url;
    private final String projectKey;
    private int projectId;
    private RedmineManager manager;
    private final Map<String, Map<String, IssueCustomField>> customFieldsPerTracker;
    private final Map<Integer, CustomFieldDefinition> customFieldDefinitions;

    public RedmineIssueManagementService(String url, String projectKey) {
        this.url = url;
        this.projectKey = projectKey;
        this.manager = RedmineManagerFactory.createWithApiKey((String)url, (String)"");
        this.customFieldsPerTracker = new HashMap<String, Map<String, IssueCustomField>>();
        this.customFieldDefinitions = new HashMap<Integer, CustomFieldDefinition>();
    }

    public IssueModel getIssue(String issueId) throws KlarosServiceException {
        try {
            Issue issue = this.manager.getIssueManager().getIssueById(Integer.valueOf(issueId), new Include[0]);
            return this.buildIssue(issue);
        }
        catch (RedmineException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
    }

    public List<String> getAllProjects() throws KlarosServiceException {
        try {
            List allProjects = this.manager.getProjectManager().getProjects();
            ArrayList<String> result = new ArrayList<String>(allProjects.size());
            for (Project project : allProjects) {
                result.add(project.getName());
            }
            return result;
        }
        catch (RedmineException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
    }

    public List<String> getAllProjectKeys() throws KlarosServiceException {
        try {
            List allProjectKeys = this.manager.getProjectManager().getProjects();
            ArrayList<String> result = new ArrayList<String>(allProjectKeys.size());
            for (Project project : allProjectKeys) {
                result.add(project.getIdentifier());
            }
            return result;
        }
        catch (RedmineException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
    }

    public Issue storeIssue(IssueModel issueModel) throws KlarosServiceException {
        RedmineIssueModel model = RedmineIssueManagementService.convertToRedmineIssueModel(issueModel);
        try {
            Issue issue = new Issue(this.manager.getTransport(), this.projectId);
            if (StringUtils.isNotEmpty((CharSequence)model.getId())) {
                issue.setId(Integer.valueOf(model.getId()));
            }
            for (Object tracker : this.manager.getIssueManager().getTrackers()) {
                if (!tracker.getName().equals(model.getTracker())) continue;
                issue.setTracker((Tracker)tracker);
                break;
            }
            List versions = this.manager.getProjectManager().getVersions(this.projectId);
            if (StringUtils.isNotBlank((CharSequence)model.getVersion())) {
                for (Version version : versions) {
                    if (!version.getName().equals(model.getVersion())) continue;
                    issue.setTargetVersion(version);
                    break;
                }
            } else {
                issue.setTargetVersion(null);
            }
            if (StringUtils.isNotBlank((CharSequence)model.getCategory())) {
                for (IssueCategory category : this.manager.getIssueManager().getCategories(this.projectId)) {
                    if (!category.getName().equals(model.getCategory())) continue;
                    issue.setCategory(category);
                    break;
                }
            } else {
                issue.setCategory(null);
            }
            List projectMembers = this.manager.getProjectManager().getProjectMembers(this.projectId);
            if (StringUtils.isNotBlank((CharSequence)model.getAssignedTo())) {
                for (Membership membership : projectMembers) {
                    if (!membership.getUserName().equals(model.getAssignedTo())) continue;
                    issue.setAssigneeId(membership.getUserId());
                    break;
                }
            } else {
                issue.setAssigneeId(null);
            }
            for (IssuePriority priority : this.manager.getIssueManager().getIssuePriorities()) {
                if (!priority.getName().equals(model.getPriority())) continue;
                issue.setPriorityId(priority.getId());
            }
            issue.setSubject(model.getSummary());
            issue.setDoneRatio(Integer.valueOf(RedmineIssueManagementService.checkIntegerFormat(model.getDoneRatio())));
            issue.setSubject(model.getSummary());
            issue.setDescription(model.getDescription());
            issue.setEstimatedHours(Float.valueOf(RedmineIssueManagementService.checkFloatFormat(model.getEstimate())));
            issue.setStartDate(model.getStartDate());
            issue.setDueDate(model.getDueDate());
            if (StringUtils.isNumeric((CharSequence)model.getParentId())) {
                issue.setParentId(Integer.valueOf(model.getParentId()));
            } else {
                issue.setParentId(null);
            }
            for (IssueStatus status : this.manager.getIssueManager().getStatuses()) {
                if (!status.getName().equals(model.getStatus())) continue;
                issue.setStatusId(status.getId());
            }
            for (IssueCustomAttribute customAttribute : model.getCustomFieldAttributes().values()) {
                ArrayList<String> result;
                CustomField customField = new CustomField();
                customField.setId(Integer.valueOf(customAttribute.getId()));
                customField.setName(customAttribute.getLabel());
                CustomFieldDefinition customFieldDefinition = this.customFieldDefinitions.get(customField.getId());
                if (CUSTOM_FIELD_FORMAT_DATE.equals(customFieldDefinition.getFieldFormat())) {
                    customField.setValue(RedmineMylynIssueCustomAttribute.toRedmineDate(customAttribute.getValue()));
                } else if (CUSTOM_FIELD_FORMAT_VERSION.equals(customFieldDefinition.getFieldFormat())) {
                    if (customFieldDefinition.isMultiple()) {
                        result = new ArrayList();
                        if (customAttribute.getValues() != null) {
                            block9: for (String value : customAttribute.getValues()) {
                                for (Version version : versions) {
                                    if (!version.getName().equals(value)) continue;
                                    result.add(version.getId().toString());
                                    continue block9;
                                }
                            }
                        }
                        customField.setValues(result);
                    } else {
                        for (Object version : versions) {
                            if (!version.getName().equals(customAttribute.getValue())) continue;
                            customField.setValue(version.getId().toString());
                            break;
                        }
                    }
                } else if (CUSTOM_FIELD_FORMAT_USER.equals(customFieldDefinition.getFieldFormat())) {
                    if (customFieldDefinition.isMultiple()) {
                        result = new ArrayList<String>();
                        if (customAttribute.getValues() != null) {
                            Object version;
                            version = customAttribute.getValues().iterator();
                            block12: while (version.hasNext()) {
                                String value;
                                value = (String)version.next();
                                for (Membership membership : projectMembers) {
                                    if (!membership.getUserName().equals(value)) continue;
                                    result.add(membership.getUserId().toString());
                                    continue block12;
                                }
                            }
                        }
                        customField.setValues(result);
                    } else {
                        for (Membership membership : projectMembers) {
                            if (!membership.getUserName().equals(customAttribute.getValue())) continue;
                            customField.setValue(membership.getUserId().toString());
                            break;
                        }
                    }
                } else if (customFieldDefinition.isMultiple()) {
                    customField.setValues(customAttribute.getValues() != null ? customAttribute.getValues() : new ArrayList());
                } else {
                    customField.setValue(customAttribute.getValue());
                }
                issue.addCustomField(customField);
            }
            return issue;
        }
        catch (RedmineException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
    }

    private static float checkFloatFormat(String string) {
        float result = 0.0f;
        if (StringUtils.isNotBlank((CharSequence)string)) {
            try {
                result = Float.parseFloat(string);
            }
            catch (RuntimeException exception) {
                LOG.warn("Invalid input for String: {}", (Object)string, (Object)exception);
            }
        }
        return result;
    }

    private static int checkIntegerFormat(String string) {
        int result = 0;
        if (StringUtils.isNotBlank((CharSequence)string)) {
            try {
                result = Integer.parseInt(string);
            }
            catch (RuntimeException exception) {
                LOG.warn("Invalid input for String: {}", (Object)string, (Object)exception);
            }
        }
        return result;
    }

    private static RedmineIssueModel convertToRedmineIssueModel(IssueModel issue) {
        if (issue instanceof RedmineIssueModel) {
            return (RedmineIssueModel)issue;
        }
        throw new IllegalArgumentException("Illegal model instance class: " + issue.getClass().getName());
    }

    public List<String> getAssignableMembers() throws KlarosServiceException {
        try {
            List projectMembers = this.manager.getProjectManager().getProjectMembers(this.projectId);
            ArrayList<String> result = new ArrayList<String>(projectMembers.size());
            for (Membership membership : projectMembers) {
                result.add(membership.getUserName());
            }
            return result;
        }
        catch (RedmineException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
    }

    public List<String> getCategories() throws KlarosServiceException {
        try {
            List categories = this.manager.getIssueManager().getCategories(this.projectId);
            ArrayList<String> result = new ArrayList<String>(categories.size());
            for (IssueCategory category : categories) {
                result.add(category.getName());
            }
            return result;
        }
        catch (RedmineException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
    }

    public List<String> getTrackers() throws KlarosServiceException {
        try {
            Collection trackers = this.manager.getProjectManager().getProjectByKey(this.projectKey).getTrackers();
            ArrayList<String> result = new ArrayList<String>(trackers.size());
            for (Tracker tracker : trackers) {
                result.add(tracker.getName());
            }
            return result;
        }
        catch (RedmineException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
    }

    public List<String> getVersions() throws KlarosServiceException {
        try {
            List versions = this.manager.getProjectManager().getVersions(this.projectId);
            ArrayList<String> result = new ArrayList<String>(versions.size());
            for (Version version : versions) {
                result.add(version.getName());
            }
            return result;
        }
        catch (RedmineException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
    }

    public List<String> getComponents() throws KlarosServiceException {
        return this.getCategories();
    }

    public List<String> getPriorities() throws KlarosServiceException {
        try {
            List issuePriorities = this.manager.getIssueManager().getIssuePriorities();
            ArrayList<String> result = new ArrayList<String>(issuePriorities.size());
            for (IssuePriority priority : issuePriorities) {
                result.add(priority.getName());
            }
            return result;
        }
        catch (RedmineException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
    }

    public List<String> getStatuses() throws KlarosServiceException {
        try {
            List issueStatuses = this.manager.getIssueManager().getStatuses();
            ArrayList<String> result = new ArrayList<String>(issueStatuses.size());
            for (IssueStatus status : issueStatuses) {
                result.add(status.getName());
            }
            return result;
        }
        catch (RedmineException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
    }

    public boolean login(String loginUsername, String loginPassword) throws KlarosServiceException {
        boolean result = false;
        this.manager = RedmineManagerFactory.createWithUserAuth((String)this.url, (String)loginUsername, (String)loginPassword);
        try {
            Project projectByKey = this.manager.getProjectManager().getProjectByKey(this.projectKey);
            this.projectId = projectByKey.getId();
            result = true;
        }
        catch (NotFoundException | RedmineAuthenticationException e) {
            LOG.debug(MSG_SWALLOWING_EXCEPTION, e);
            result = false;
        }
        catch (RedmineException e) {
            throw new KlarosServiceException((Throwable)e);
        }
        return result;
    }

    public void logout() {
    }

    public void terminate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String checkConnection() {
        String result = null;
        try {
            this.manager = RedmineManagerFactory.createWithUserAuth((String)this.url, (String)UUID.randomUUID().toString(), (String)UUID.randomUUID().toString());
            this.manager.getProjectManager().getProjectByKey(this.projectKey);
        }
        catch (RedmineAuthenticationException e) {
            LOG.debug(PROCRESSING_MESSAGE, (Throwable)e);
        }
        catch (RedmineException e) {
            LOG.debug(PROCRESSING_MESSAGE, (Throwable)e);
            if (e.getCause() instanceof RedmineException) {
                RedmineException cause = (RedmineException)e.getCause();
                result = cause.getMessage();
            } else {
                result = e.getCause() instanceof RedmineInternalError ? e.getCause().getMessage() : e.getMessage();
            }
        }
        catch (RuntimeException e) {
            LOG.debug(PROCRESSING_MESSAGE, (Throwable)e);
            result = e.getMessage();
        }
        finally {
            this.logout();
        }
        return result;
    }

    public boolean checkAuthentication(String username, String password) throws KlarosServiceException {
        boolean result = false;
        try {
            this.manager = RedmineManagerFactory.createWithUserAuth((String)this.url, (String)username, (String)password);
            this.manager.getUserManager().getCurrentUser();
            result = true;
        }
        catch (RedmineAuthenticationException e) {
            LOG.debug(MSG_SWALLOWING_EXCEPTION, (Throwable)e);
            return false;
        }
        catch (RedmineException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
        return result;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public Map<String, IssueCustomField> getCustomFields(String trackerType) throws KlarosServiceException {
        Map<String, IssueCustomField> result = trackerType != null && this.customFieldsPerTracker.get(trackerType) != null ? this.customFieldsPerTracker.get(trackerType) : Collections.emptyMap();
        return result;
    }

    public void initializeCustomFields(String adminUsername, String adminPassword) throws KlarosServiceException {
        try {
            RedmineManager administratorManager = RedmineManagerFactory.createWithUserAuth((String)this.url, (String)adminUsername, (String)adminPassword);
            List fields = administratorManager.getCustomFieldManager().getCustomFieldDefinitions();
            this.customFieldsPerTracker.clear();
            this.customFieldDefinitions.clear();
            for (Tracker tracker : administratorManager.getProjectManager().getProjectByKey(this.projectKey).getTrackers()) {
                this.customFieldsPerTracker.put(tracker.getName(), new HashMap());
            }
            for (CustomFieldDefinition field : fields) {
                MylynIssueCustomField mylynIssueCustomField = new MylynIssueCustomField(Integer.toString(field.getId()), field.getName(), field.getName(), MylynIssueCustomFieldType.fromRedmine(field.getFieldFormat(), field.isMultiple()), this.getPossibleValues(field), field.getDefaultValue(), !field.isRequired());
                for (Tracker tracker : field.getTrackers()) {
                    if (!this.customFieldsPerTracker.containsKey(tracker.getName())) continue;
                    this.customFieldsPerTracker.get(tracker.getName()).put(mylynIssueCustomField.getId(), mylynIssueCustomField);
                }
                this.customFieldDefinitions.put(field.getId(), field);
            }
        }
        catch (RedmineException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
    }

    private List<String> getPossibleValues(CustomFieldDefinition field) throws KlarosServiceException {
        ArrayList<String> result = new ArrayList<String>();
        switch (field.getFieldFormat()) {
            case "list": {
                if (!field.isRequired()) {
                    result.add("");
                }
                result.addAll(field.getPossibleValues());
                break;
            }
            case "user": {
                if (!field.isMultiple()) {
                    result.add("");
                }
                try {
                    result.addAll(this.getAssignableMembers());
                }
                catch (KlarosServiceException | RuntimeException e) {
                    LOG.debug(MSG_SWALLOWING_EXCEPTION, e);
                    LOG.warn(e.getMessage());
                }
                break;
            }
            case "version": {
                if (!field.isMultiple()) {
                    result.add("");
                }
                try {
                    result.addAll(this.getVersions());
                }
                catch (KlarosServiceException | RuntimeException e) {
                    LOG.debug(MSG_SWALLOWING_EXCEPTION, e);
                    LOG.warn(e.getMessage());
                }
                break;
            }
            default: {
                result.addAll(field.getPossibleValues());
            }
        }
        return result;
    }

    public RedmineIssueModel createNewIssue(String type) throws KlarosServiceException {
        try {
            Issue issue = new Issue(this.manager.getTransport(), this.projectId);
            for (Tracker tracker : this.manager.getIssueManager().getTrackers()) {
                if (!tracker.getName().equals(type)) continue;
                issue.setTracker(tracker);
                break;
            }
            return this.buildIssue(issue);
        }
        catch (RedmineException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
    }

    private RedmineIssueModel buildIssue(Issue issue) throws KlarosServiceException {
        try {
            String trackerName = issue.getTracker().getName();
            return new RedmineIssueModel(issue, this.loadCustomFieldAttributes(issue, this.getCustomFields(trackerName)), this.getCustomFields(trackerName));
        }
        catch (RedmineException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
    }

    public String getBrowseIssueUrl(String id) {
        return this.getServiceType().getBrowseIssueUrl(this.getRepositoryUrl(), id);
    }

    public IssueManagementServiceType getServiceType() {
        return IssueManagementServiceType.REDMINE;
    }

    protected Map<String, IssueCustomAttribute> loadCustomFieldAttributes(Issue issue, Map<String, IssueCustomField> customFields) throws RedmineException {
        HashMap<String, IssueCustomAttribute> result = new HashMap<String, IssueCustomAttribute>();
        for (CustomField customField : issue.getCustomFields()) {
            String id = customField.getId().toString();
            for (IssueCustomField field : customFields.values()) {
                if (!field.getId().equals(id)) continue;
                String value = this.convertValue(customField, this.customFieldDefinitions.get(customField.getId()));
                List<String> values = this.convertValues(customField, this.customFieldDefinitions.get(customField.getId()));
                RedmineMylynIssueCustomAttribute attribute = new RedmineMylynIssueCustomAttribute(field.getId(), customFields.get(field.getId()).getDescription(), value, values, customFields.get(field.getId()).getFieldType(), field.isOptional());
                result.put(field.getId(), attribute);
            }
        }
        return result;
    }

    public final String convertValue(CustomField customField, CustomFieldDefinition customFieldDefinition) throws RedmineException {
        String result = customField.getValue();
        block5 : switch (customFieldDefinition.getFieldFormat()) {
            case "date": {
                result = RedmineMylynIssueCustomAttribute.toKlarosDate(customField.getValue());
                break;
            }
            case "user": {
                List projectMembers = this.manager.getProjectManager().getProjectMembers(this.projectId);
                for (Membership projectMember : projectMembers) {
                    if (!projectMember.getUserId().toString().equals(customField.getValue())) continue;
                    result = projectMember.getUserName();
                    break block5;
                }
                break;
            }
            case "version": {
                List versions = this.manager.getProjectManager().getVersions(this.projectId);
                for (Version version : versions) {
                    if (!version.getId().toString().equals(customField.getValue())) continue;
                    result = version.getName();
                    break block5;
                }
                break;
            }
        }
        return result;
    }

    public final List<String> convertValues(CustomField customField, CustomFieldDefinition customFieldDefinition) throws RedmineException {
        ArrayList<String> result = new ArrayList<String>();
        switch (customFieldDefinition.getFieldFormat()) {
            case "user": {
                List projectMembers = this.manager.getProjectManager().getProjectMembers(this.projectId);
                for (Membership projectMember : projectMembers) {
                    for (String value : customField.getValues()) {
                        if (!projectMember.getUserId().toString().equals(value)) continue;
                        result.add(projectMember.getUserName());
                    }
                }
                break;
            }
            case "version": {
                List versions = this.manager.getProjectManager().getVersions(this.projectId);
                for (Version version : versions) {
                    for (String value : customField.getValues()) {
                        if (!version.getId().toString().equals(value)) continue;
                        result.add(version.getName());
                    }
                }
                break;
            }
            default: {
                result.addAll(customField.getValues());
            }
        }
        return result;
    }

    public String checkUrl() {
        return this.checkUrl(this.getRepositoryUrl(), this.getServiceType().getContentPattern());
    }

    public boolean isProjectValid() {
        boolean result;
        try {
            result = this.hasProject(this.getProjectKey());
        }
        catch (KlarosServiceException e) {
            LOG.debug("Exception indicates unavailable project", (Throwable)e);
            result = false;
        }
        return result;
    }

    public Map<String, IssueModel> getIssues(Set<String> ids) throws KlarosServiceException {
        HashMap result = Maps.newHashMapWithExpectedSize((int)ids.size());
        for (String issueId : ids) {
            try {
                result.put(issueId, this.getIssue(issueId));
            }
            catch (KlarosServiceException | RuntimeException e) {
                LOG.debug(UNABLE_TO_RETRIEVE_ISSUE, e);
            }
        }
        return result;
    }

    public String createIssue(IssueModel issueModel) throws KlarosServiceException {
        Issue issue = this.storeIssue(issueModel);
        try {
            return issue.create(new RequestParam[0]).getId().toString();
        }
        catch (RedmineException e) {
            throw new KlarosServiceException((Throwable)e);
        }
    }

    public String updateIssue(IssueModel issueModel) throws KlarosServiceException {
        Issue issue = this.storeIssue(issueModel);
        try {
            issue.update(new RequestParam[0]);
            return issue.getId().toString();
        }
        catch (RedmineException e) {
            throw new KlarosServiceException((Throwable)e);
        }
    }

    public boolean hasProject(String key) throws KlarosServiceException {
        try {
            return this.manager.getProjectManager().getProjectByKey(key) != null;
        }
        catch (RedmineException e) {
            LOG.debug("Ignoring exception", (Throwable)e);
            return false;
        }
    }

    public String getRepositoryUrl() {
        return this.url;
    }
}

