/*
 * Decompiled with CFR 0.152.
 */
package de.verit.klaros.service.issuemanagement.mylyn.mantis;

import com.itsolut.mantis.core.IMantisClient;
import com.itsolut.mantis.core.IMantisClientManager;
import com.itsolut.mantis.core.MantisCache;
import com.itsolut.mantis.core.MantisCacheData;
import com.itsolut.mantis.core.StandaloneMantisRepositoryConnector;
import com.itsolut.mantis.core.exception.MantisException;
import com.itsolut.mantis.core.exception.MantisLocalException;
import com.itsolut.mantis.core.exception.MantisRemoteException;
import com.itsolut.mantis.core.exception.TicketNotFoundException;
import com.itsolut.mantis.core.model.MantisCustomField;
import com.itsolut.mantis.core.model.MantisETA;
import com.itsolut.mantis.core.model.MantisPriority;
import com.itsolut.mantis.core.model.MantisProject;
import com.itsolut.mantis.core.model.MantisProjectCategory;
import com.itsolut.mantis.core.model.MantisProjection;
import com.itsolut.mantis.core.model.MantisReproducibility;
import com.itsolut.mantis.core.model.MantisResolution;
import com.itsolut.mantis.core.model.MantisSeverity;
import com.itsolut.mantis.core.model.MantisTicket;
import com.itsolut.mantis.core.model.MantisTicketStatus;
import com.itsolut.mantis.core.model.MantisUser;
import com.itsolut.mantis.core.model.MantisVersion;
import de.verit.klaros.exception.KlarosServiceException;
import de.verit.klaros.service.issuemanagement.IssueCustomAttribute;
import de.verit.klaros.service.issuemanagement.IssueCustomField;
import de.verit.klaros.service.issuemanagement.IssueManagementServiceType;
import de.verit.klaros.service.issuemanagement.IssueModel;
import de.verit.klaros.service.issuemanagement.mylyn.MylynIssueCustomAttribute;
import de.verit.klaros.service.issuemanagement.mylyn.MylynIssueCustomField;
import de.verit.klaros.service.issuemanagement.mylyn.MylynIssueCustomFieldType;
import de.verit.klaros.service.issuemanagement.mylyn.MylynIssueManagementService;
import de.verit.klaros.service.issuemanagement.mylyn.mantis.MantisIssueModel;
import de.verit.klaros.util.ListUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MantisIssueManagementService
extends MylynIssueManagementService {
    private static final Logger LOG = LoggerFactory.getLogger(MantisIssueManagementService.class);
    private static final String URL_SEPARATOR = "/";
    private static final String DEFAULT_MANTIS_SOAP_POSTFIX = "api/soap/mantisconnect.php";
    private final StandaloneMantisRepositoryConnector connector = new StandaloneMantisRepositoryConnector();
    private final String project;

    public MantisIssueManagementService(String url, String project) {
        super("mantis", url);
        this.project = project;
    }

    @Override
    protected String getMylynRepositoryUrl(String url) {
        StringBuilder result = new StringBuilder(url);
        if (StringUtils.isNotBlank((CharSequence)url) && !url.endsWith(DEFAULT_MANTIS_SOAP_POSTFIX)) {
            if (!url.endsWith(URL_SEPARATOR)) {
                result.append(URL_SEPARATOR);
            }
            result.append(DEFAULT_MANTIS_SOAP_POSTFIX);
        }
        return result.toString();
    }

    public String getProject() {
        return this.project;
    }

    public List<String> getAllProjects() throws KlarosServiceException {
        try {
            List mantisProjects = this.getCacheData().getProjects();
            ArrayList<String> results = new ArrayList<String>(mantisProjects.size());
            for (MantisProject mantisProject : mantisProjects) {
                results.add(mantisProject.getName());
            }
            return results;
        }
        catch (MantisException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
    }

    public List<String> getAllProjectKeys() throws KlarosServiceException {
        try {
            List mantisProjects = this.getCacheData().getProjects();
            ArrayList<String> results = new ArrayList<String>(mantisProjects.size());
            for (MantisProject mantisProject : mantisProjects) {
                results.add(Integer.toString(mantisProject.getValue()));
            }
            return results;
        }
        catch (MantisException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
    }

    public IssueModel getIssue(String issueId) throws KlarosServiceException {
        try {
            TaskData taskData = this.getConnector().getTaskData(this.getRepository(), issueId, Policy.monitorFor(null));
            return this.buildIssue(taskData);
        }
        catch (CoreException e) {
            throw new KlarosServiceException(e.getStatus().getMessage(), this.stripCoreException(e));
        }
        catch (NumberFormatException e) {
            throw new KlarosServiceException((Throwable)e);
        }
    }

    @Override
    public AbstractRepositoryConnector getConnector() {
        return this.connector;
    }

    StandaloneMantisRepositoryConnector getMantisConnector() {
        return (StandaloneMantisRepositoryConnector)this.getConnector();
    }

    TaskRepository getMantisRepository() {
        return this.getRepository();
    }

    @Override
    protected TaskData readTaskData(String taskId) throws CoreException {
        return this.getMantisConnector().getTaskData(this.getRepository(), taskId, Policy.monitorFor(null));
    }

    @Override
    public String storeIssue(IssueModel issue, TaskData data) throws KlarosServiceException {
        if (!(issue instanceof MantisIssueModel)) {
            throw new IllegalArgumentException("Illegal model instance class: " + issue.getClass().getName());
        }
        MantisIssueModel model = (MantisIssueModel)issue;
        HashSet<TaskAttribute> oldAttributes = new HashSet<TaskAttribute>();
        TaskAttribute dummy = data.getRoot().createAttribute(MantisTicket.Key.SUMMARY.getKey());
        dummy.getMetaData().setType(MantisTicket.Key.SUMMARY.name());
        oldAttributes.add(dummy);
        try {
            MantisReproducibility[] mantisReproducibilities;
            MantisResolution[] mantiResolutions;
            MantisTicketStatus[] mantisTicketStatus;
            MantisUser[] mantisUsers;
            MantisCache cache = this.getCache();
            MantisIssueManagementService.mapTaskAttribute(data, MantisTicket.Key.PROJECT, this.project);
            MantisIssueManagementService.mapTaskAttribute(data, MantisTicket.Key.PROJECTION, Integer.toString(cache.getDefaultProjection().getValue()));
            MantisIssueManagementService.mapTaskAttribute(data, MantisTicket.Key.ETA, Integer.toString(cache.getDefaultEta().getValue()));
            MantisIssueManagementService.mapTaskAttribute(data, MantisTicket.Key.VIEW_STATE, Integer.toString(cache.getDefaultViewState().getValue()));
            MantisIssueManagementService.mapTaskAttribute(data, MantisTicket.Key.CATEOGRY, model.getCategory());
            MantisIssueManagementService.mapTaskAttribute(data, MantisTicket.Key.PRIORITY, Integer.toString(this.getPriorityValue(model.getPriority())));
            MantisIssueManagementService.mapTaskAttribute(data, MantisTicket.Key.SEVERITY, Integer.toString(this.getSeverityValue(model.getSeverity())));
            MantisIssueManagementService.mapTaskAttribute(data, MantisTicket.Key.DESCRIPTION, model.getDescription());
            MantisIssueManagementService.mapTaskAttribute(data, MantisTicket.Key.SUMMARY, model.getSummary());
            MantisIssueManagementService.mapTaskAttribute(data, MantisTicket.Key.STEPS_TO_REPRODUCE, model.getStepsToReproduce());
            MantisIssueManagementService.mapTaskAttribute(data, MantisTicket.Key.ADDITIONAL_INFO, model.getAdditionalInformation());
            for (MantisUser mantisUser : mantisUsers = cache.getUsersByProjectName(this.project, Policy.monitorFor(null))) {
                if (!mantisUser.getKey().equals(model.getAssignedTo())) continue;
                MantisIssueManagementService.mapTaskAttribute(data, MantisTicket.Key.ASSIGNED_TO, model.getAssignedTo());
                break;
            }
            for (MantisTicketStatus status : mantisTicketStatus = cache.getTicketStatus()) {
                if (!status.getName().equals(model.getStatus())) continue;
                MantisIssueManagementService.mapTaskAttribute(data, MantisTicket.Key.STATUS, Integer.toString(status.getValue()));
            }
            for (MantisResolution mantiResolution : mantiResolutions = cache.getTicketResolutions()) {
                if (!mantiResolution.getName().equals(model.getResolution())) continue;
                MantisIssueManagementService.mapTaskAttribute(data, MantisTicket.Key.RESOLUTION, Integer.toString(mantiResolution.getValue()));
            }
            for (MantisReproducibility reproducibility : mantisReproducibilities = cache.getReproducibility()) {
                if (!reproducibility.getName().equals(model.getReproducibility())) continue;
                MantisIssueManagementService.mapTaskAttribute(data, MantisTicket.Key.REPRODUCIBILITY, Integer.toString(reproducibility.getValue()));
            }
            MantisVersion[] mantisVersions = cache.getVersionsByProjectName(this.project);
            for (MantisVersion mantisVersion : mantisVersions) {
                if (mantisVersion.getName().equals(model.getProductVersion())) {
                    MantisIssueManagementService.mapTaskAttribute(data, MantisTicket.Key.VERSION, mantisVersion.getName());
                    continue;
                }
                if (mantisVersion.getName().equals(model.getTargetVersion())) {
                    MantisIssueManagementService.mapTaskAttribute(data, MantisTicket.Key.TARGET_VERSION, mantisVersion.getName());
                    continue;
                }
                if (!mantisVersion.getName().equals(model.getFixedInVersion())) continue;
                MantisIssueManagementService.mapTaskAttribute(data, MantisTicket.Key.FIXED_IN, mantisVersion.getName());
            }
            for (IssueCustomAttribute customAttribute : model.getCustomFieldAttributes().values()) {
                for (IssueCustomField field : this.getCustomFields(null).values()) {
                    String value;
                    if (!field.getId().equals(customAttribute.getId())) continue;
                    TaskAttribute customTaskAttribute = new TaskAttribute(data.getRoot(), field.getName());
                    if (customAttribute.getValues() != null) {
                        data.getAttributeMapper().setValues(customTaskAttribute, MantisIssueManagementService.joinValues(customAttribute.getValues()));
                        continue;
                    }
                    if (MylynIssueCustomFieldType.DATE.getCode() == field.getFieldType().getCode()) {
                        if (StringUtils.isNotBlank((CharSequence)customAttribute.getValue())) {
                            try {
                                Date date = new SimpleDateFormat("dd.MM.yyyy").parse(customAttribute.getValue());
                                value = Long.toString(date.getTime());
                            }
                            catch (ParseException e) {
                                value = "";
                            }
                        } else {
                            value = "";
                        }
                    } else {
                        value = StringUtils.defaultString((String)customAttribute.getValue());
                    }
                    data.getAttributeMapper().setValue(customTaskAttribute, value);
                }
            }
            RepositoryResponse response = this.getTaskDataHandler().postTaskData(this.getRepository(), data, oldAttributes, Policy.monitorFor(null));
            return response.getTaskId();
        }
        catch (CoreException e) {
            throw new KlarosServiceException(e.getStatus().getMessage(), this.stripCoreException(e));
        }
        catch (MantisException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
    }

    private static void mapTaskAttribute(TaskData data, MantisTicket.Key attribute, String value) {
        if (value != null) {
            TaskAttribute status = data.getRoot().createAttribute(attribute.getKey());
            status.getMetaData().setType(attribute.name());
            data.getAttributeMapper().setValue(status, value);
        }
    }

    public List<String> getEtas() throws KlarosServiceException {
        try {
            MantisETA[] mantisEtas = this.getCache().getETA();
            ArrayList<String> results = new ArrayList<String>(mantisEtas.length);
            for (MantisETA eta : mantisEtas) {
                results.add(eta.getName());
            }
            return results;
        }
        catch (MantisException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
    }

    public List<String> getSeverities() throws KlarosServiceException {
        try {
            MantisSeverity[] mantisSeverities = this.getCache().getSeverities();
            ArrayList<String> results = new ArrayList<String>(mantisSeverities.length);
            for (MantisSeverity severity : mantisSeverities) {
                results.add(severity.getName());
            }
            return results;
        }
        catch (MantisException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
    }

    public int getSeverityValue(String severityName) throws KlarosServiceException {
        try {
            MantisSeverity[] mantisSeverities;
            for (MantisSeverity severity : mantisSeverities = this.getCache().getSeverities()) {
                if (!severity.getName().equals(severityName)) continue;
                return severity.getValue();
            }
            return -1;
        }
        catch (MantisException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
    }

    public List<String> getPriorities() throws KlarosServiceException {
        try {
            MantisPriority[] mantisPriorities = this.getCache().getPriorities();
            ArrayList<String> results = new ArrayList<String>(mantisPriorities.length);
            for (MantisPriority priority : mantisPriorities) {
                results.add(priority.getName());
            }
            return results;
        }
        catch (MantisException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
    }

    public int getPriorityValue(String priorityName) throws KlarosServiceException {
        try {
            MantisPriority[] mantisPriorities;
            for (MantisPriority priority : mantisPriorities = this.getCache().getPriorities()) {
                if (!priority.getName().equals(priorityName)) continue;
                return priority.getValue();
            }
            return -1;
        }
        catch (MantisException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
    }

    public List<String> getProjections() throws KlarosServiceException {
        try {
            MantisProjection[] mantisProjections = this.getCache().getProjection();
            ArrayList<String> results = new ArrayList<String>(mantisProjections.length);
            for (MantisProjection projection : mantisProjections) {
                results.add(projection.getName());
            }
            return results;
        }
        catch (MantisException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
    }

    public List<String> getReproducibilities() throws KlarosServiceException {
        try {
            MantisReproducibility[] mantisReproducibilities = this.getCache().getReproducibility();
            ArrayList<String> results = new ArrayList<String>(mantisReproducibilities.length);
            for (MantisReproducibility reproducibilities : mantisReproducibilities) {
                results.add(reproducibilities.getName());
            }
            return results;
        }
        catch (MantisException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
    }

    public List<String> getResolutions() throws KlarosServiceException {
        try {
            MantisResolution[] mantisResolutions = this.getCache().getTicketResolutions();
            ArrayList<String> results = new ArrayList<String>(mantisResolutions.length);
            for (MantisResolution resolution : mantisResolutions) {
                results.add(resolution.getName());
            }
            return results;
        }
        catch (MantisException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
    }

    public int getResolutionValue(String resolutionName) throws KlarosServiceException {
        try {
            MantisResolution[] mantisResolutions;
            for (MantisResolution resolution : mantisResolutions = this.getCache().getTicketResolutions()) {
                if (!resolution.getName().equals(resolutionName)) continue;
                return resolution.getValue();
            }
            return -1;
        }
        catch (MantisException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
    }

    private MantisCacheData getCacheData() throws MantisException {
        this.getMantisConnector().getClientManager().getRepository(this.getRepository()).getCache(Policy.monitorFor(null));
        return this.getMantisConnector().getClientManager().getRepository(this.getRepository()).getCacheData();
    }

    private MantisCache getCache() throws MantisException {
        return this.getMantisConnector().getClientManager().getRepository(this.getRepository()).getCache(Policy.monitorFor(null));
    }

    public void terminate() {
    }

    @Override
    public boolean login(String loginUsername, String loginPassword) throws KlarosServiceException {
        boolean result;
        try {
            IMantisClientManager manager = this.getMantisConnector().getClientManager();
            AuthenticationCredentials credentials = new AuthenticationCredentials(loginUsername, loginPassword);
            this.getRepository().setCredentials(AuthenticationType.REPOSITORY, credentials, false);
            IMantisClient client = manager.getRepository(this.getRepository());
            client.getCacheData();
            result = true;
        }
        catch (MantisLocalException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
        catch (MantisException e) {
            LOG.debug("Ignoring exception", (Throwable)e);
            result = false;
        }
        return result;
    }

    public String checkConnection() {
        String result = null;
        try {
            this.login(UUID.randomUUID().toString(), UUID.randomUUID().toString());
            this.getPriorities();
        }
        catch (KlarosServiceException e) {
            result = e.getMessage().contains("User not found") || e.getMessage().contains("Access denied") ? null : e.getMessage();
        }
        return result;
    }

    public List<String> getComponents() throws KlarosServiceException {
        return new ArrayList<String>();
    }

    public List<String> getStatuses() throws KlarosServiceException {
        try {
            MantisTicketStatus[] mantisTicketStatuses = this.getCache().getTicketStatus();
            ArrayList<String> results = new ArrayList<String>(mantisTicketStatuses.length);
            for (MantisTicketStatus ticketStatus : mantisTicketStatuses) {
                results.add(ticketStatus.getName());
            }
            return results;
        }
        catch (MantisException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
    }

    public int getStatusValue(String status) throws KlarosServiceException {
        try {
            MantisTicketStatus[] mantisTicketStatuses;
            for (MantisTicketStatus ticketStatus : mantisTicketStatuses = this.getCache().getTicketStatus()) {
                if (!ticketStatus.getName().equals(status)) continue;
                return ticketStatus.getValue();
            }
            return -1;
        }
        catch (MantisException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
    }

    public List<String> getCategories() throws KlarosServiceException {
        try {
            List mantisCategories = this.getCache().getProjectCategories(this.project);
            ArrayList<String> results = new ArrayList<String>(mantisCategories.size());
            for (MantisProjectCategory category : mantisCategories) {
                results.add(category.getName());
            }
            return results;
        }
        catch (MantisException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
    }

    public List<String> getVersions() throws KlarosServiceException {
        try {
            MantisVersion[] mantisVersions = this.getCache().getVersionsByProjectName(this.project);
            ArrayList<String> results = new ArrayList<String>(mantisVersions.length);
            for (MantisVersion version : mantisVersions) {
                results.add(version.getName());
            }
            return results;
        }
        catch (MantisException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
    }

    public List<String> getUsers() throws KlarosServiceException {
        try {
            MantisUser[] mantisUsers = this.getCache().getUsersByProjectName(this.project, Policy.monitorFor(null));
            HashMap<String, MantisUser> uniqueUsers = new HashMap<String, MantisUser>();
            for (MantisUser user : mantisUsers) {
                if (uniqueUsers.containsKey(user.getKey())) continue;
                uniqueUsers.put(user.getKey(), user);
            }
            ArrayList<String> results = new ArrayList<String>(uniqueUsers.size());
            for (MantisUser mantisUser : uniqueUsers.values()) {
                results.add(mantisUser.getKey());
            }
            return results;
        }
        catch (MantisException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
    }

    public boolean checkAuthentication(String username, String password) throws KlarosServiceException {
        block7: {
            try {
                MantisCacheData cacheData;
                block8: {
                    if (!this.login(username, password)) break block7;
                    cacheData = null;
                    try {
                        cacheData = this.getCacheData();
                    }
                    catch (MantisRemoteException e) {
                        this.logout();
                        if (StringUtils.containsIgnoreCase((CharSequence)e.getMessage(), (CharSequence)"Access Denied") || StringUtils.containsIgnoreCase((CharSequence)e.getMessage(), (CharSequence)"User not found")) break block8;
                        throw new KlarosServiceException((Throwable)e);
                    }
                }
                if (cacheData == null) break block7;
                try {
                    this.getConnector().getTaskData(this.getRepository(), Integer.toString(Integer.MAX_VALUE), Policy.monitorFor(null));
                }
                catch (CoreException e) {
                    if (e.getMessage().startsWith("Ticket download from") || e.getCause() instanceof TicketNotFoundException) {
                        LOG.debug("Handling exception", (Throwable)e);
                        return this.getAllProjects().contains(this.getProjectKey()) && this.canQuery() && this.canCreateNewTask();
                    }
                    LOG.debug("Ignoring exception", (Throwable)e);
                }
                this.logout();
            }
            catch (MantisException | RuntimeException e) {
                this.logout();
                throw new KlarosServiceException(e);
            }
        }
        return false;
    }

    public String getProjectKey() {
        return this.project;
    }

    @Override
    public boolean hasProject(String name) throws KlarosServiceException {
        List<String> projects = this.getAllProjects();
        return projects.contains(name);
    }

    public Map<String, IssueCustomField> getCustomFields(String ignoredTrackerType) throws KlarosServiceException {
        HashMap<String, IssueCustomField> result = new HashMap<String, IssueCustomField>();
        try {
            List fields = this.getCacheData().getCustomFieldsByProjectId().get((Object)this.getCache().getProjectId(this.project));
            for (MantisCustomField field : fields) {
                List possibleValues = field.getPossibleValues() != null ? ListUtil.getList((Object[])field.getPossibleValues()) : null;
                MylynIssueCustomField mylynIssueCustomField = new MylynIssueCustomField(Integer.toString(field.getId()), field.getName(), field.getName(), MylynIssueCustomFieldType.fromMantis(field.getType()), possibleValues, field.getDefaultValue(), true);
                result.put(mylynIssueCustomField.getName(), mylynIssueCustomField);
            }
        }
        catch (MantisException e) {
            throw new KlarosServiceException((Throwable)e);
        }
        return result;
    }

    public MantisIssueModel createNewIssue(String type) throws KlarosServiceException {
        return this.buildIssue(this.createNewTaskData());
    }

    public MantisIssueModel buildIssue(TaskData taskData) throws KlarosServiceException {
        Map<String, IssueCustomField> customFields = this.getCustomFields(null);
        MantisIssueModel result = new MantisIssueModel(this.getConnector().getTaskMapping(taskData), this.loadCustomFieldAttributes(this.getConnector().getTaskMapping(taskData), customFields), customFields, taskData);
        HashMap<String, IssueCustomAttribute> validCustomFields = new HashMap<String, IssueCustomAttribute>();
        Map customFieldAttributes = result.getCustomFieldAttributes();
        block0: for (IssueCustomAttribute customAttribute : customFieldAttributes.values()) {
            for (IssueCustomField customField : customFields.values()) {
                if (!customField.getId().equals(customAttribute.getId())) continue;
                validCustomFields.put(customField.getName(), customAttribute);
                continue block0;
            }
        }
        customFieldAttributes.clear();
        customFieldAttributes.putAll(validCustomFields);
        return result;
    }

    public String getBrowseIssueUrl(String id) {
        return this.getServiceType().getBrowseIssueUrl(this.getRepositoryUrl(), id);
    }

    public IssueManagementServiceType getServiceType() {
        return IssueManagementServiceType.MANTIS;
    }

    @Override
    protected ITaskMapping getInitialTaskMapping() {
        return new TaskMapping(){

            public String getProduct() {
                return MantisIssueManagementService.this.project;
            }
        };
    }

    @Override
    protected Map<String, IssueCustomAttribute> loadCustomFieldAttributes(ITaskMapping taskMapping, Map<String, IssueCustomField> customFields) {
        HashMap<String, IssueCustomAttribute> result = new HashMap<String, IssueCustomAttribute>();
        for (Map.Entry entry : taskMapping.getTaskData().getRoot().getAttributes().entrySet()) {
            List<String> values;
            TaskAttribute taskAttribute = (TaskAttribute)entry.getValue();
            if (!customFields.containsKey(taskAttribute.getId())) continue;
            IssueCustomField issueCustomField = customFields.get(taskAttribute.getId());
            String type = taskAttribute.getMetaData().getValue("task.meta.type");
            List<String> list = values = "multiSelect".equals(type) ? MantisIssueManagementService.splitValues(taskAttribute.getValues()) : null;
            String value = MylynIssueCustomFieldType.DATE.getCode() == issueCustomField.getFieldType().getCode() ? (StringUtils.isNotBlank((CharSequence)taskAttribute.getValue()) ? new SimpleDateFormat("dd.MM.yyyy").format(new Date(Long.parseLong(taskAttribute.getValue()))) : "") : taskAttribute.getValue();
            MylynIssueCustomAttribute attribute = new MylynIssueCustomAttribute(issueCustomField.getId(), issueCustomField.getName(), value, values, issueCustomField.getFieldType(), issueCustomField.isOptional());
            result.put(attribute.getId(), attribute);
        }
        return result;
    }

    private static List<String> splitValues(List<String> values) {
        ArrayList<String> result = new ArrayList<String>();
        if (values != null && values.size() == 1) {
            result.addAll(ListUtil.getList((Object[])values.get(0).split("\\|")));
        }
        return result;
    }

    private static List<String> joinValues(List<String> values) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(StringUtils.join(values, (String)"|"));
        return result;
    }
}

