/*
 * Decompiled with CFR 0.152.
 */
package de.verit.klaros.service.issuemanagement.mylyn.jira;

import com.atlassian.connector.eclipse.internal.jira.core.JiraAttribute;
import de.verit.klaros.service.issuemanagement.IssueCustomAttribute;
import de.verit.klaros.service.issuemanagement.IssueCustomField;
import de.verit.klaros.service.issuemanagement.IssueManagementServiceType;
import de.verit.klaros.service.issuemanagement.mylyn.MylynIssueModel;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class JiraIssueModel
extends MylynIssueModel {
    private static final long serialVersionUID = -8911777301029214499L;
    private String key;
    private String project;
    private String type;
    private Date dueDate;
    private String environment;
    private List<String> fixVersions;
    private List<String> affectedVersions;
    private List<String> components;

    public JiraIssueModel(ITaskMapping taskMapping, Map<String, IssueCustomAttribute> customFieldAttributes, Map<String, IssueCustomField> customFields, TaskData taskData) {
        super(taskMapping, customFieldAttributes, customFields);
        TaskAttribute componentsAttribute;
        TaskAttribute fixVersionsAttribute;
        TaskAttribute affectedVersionsAttribute;
        TaskAttribute environmentAttribute;
        this.project = taskMapping.getProduct();
        this.type = taskMapping.getTaskKind();
        this.key = taskMapping.getTaskKey();
        Date date = taskMapping.getDueDate();
        if (date != null) {
            this.dueDate = new Date(date.getTime());
        }
        if ((environmentAttribute = taskData.getRoot().getAttribute(JiraAttribute.ENVIRONMENT.id())) != null) {
            this.environment = environmentAttribute.getValue();
        }
        if ((affectedVersionsAttribute = taskData.getRoot().getAttribute(JiraAttribute.AFFECTSVERSIONS.id())) != null) {
            Map options = taskData.getAttributeMapper().getOptions(affectedVersionsAttribute);
            ArrayList<String> versions = new ArrayList<String>(affectedVersionsAttribute.getValues().size());
            for (Object versionId : affectedVersionsAttribute.getValues()) {
                versions.add((String)options.get(versionId));
            }
            this.affectedVersions = new ArrayList<String>(versions);
        }
        if ((fixVersionsAttribute = taskData.getRoot().getAttribute(JiraAttribute.FIXVERSIONS.id())) != null) {
            Map options = taskData.getAttributeMapper().getOptions(fixVersionsAttribute);
            ArrayList<String> versions = new ArrayList<String>(fixVersionsAttribute.getValues().size());
            for (String versionId : fixVersionsAttribute.getValues()) {
                versions.add((String)options.get(versionId));
            }
            this.fixVersions = new ArrayList<String>(versions);
        }
        if ((componentsAttribute = taskData.getRoot().getAttribute(JiraAttribute.COMPONENTS.id())) != null) {
            Map options = taskData.getAttributeMapper().getOptions(componentsAttribute);
            ArrayList<String> componentNames = new ArrayList<String>(componentsAttribute.getValues().size());
            for (String componentId : componentsAttribute.getValues()) {
                componentNames.add((String)options.get(componentId));
            }
            this.components = new ArrayList<String>(componentNames);
        }
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getProject() {
        return this.project;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Date getDueDate() {
        if (this.dueDate != null) {
            return new Date(this.dueDate.getTime());
        }
        return null;
    }

    public void setDueDate(Date date) {
        if (date != null) {
            this.dueDate = new Date(date.getTime());
        }
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public List<String> getAffectedVersions() {
        return new ArrayList<String>(this.affectedVersions);
    }

    public void setAffectedVersions(List<String> affectedVersions) {
        this.affectedVersions = new ArrayList<String>(affectedVersions);
    }

    public List<String> getFixVersions() {
        return new ArrayList<String>(this.fixVersions);
    }

    public void setFixVersions(List<String> fixVersions) {
        this.fixVersions = new ArrayList<String>(fixVersions);
    }

    public List<String> getComponents() {
        return new ArrayList<String>(this.components);
    }

    public void setComponents(List<String> values) {
        this.components = new ArrayList<String>(values);
    }

    public IssueManagementServiceType getServiceType() {
        return IssueManagementServiceType.JIRA;
    }
}

