/*
 * Decompiled with CFR 0.152.
 */
package de.verit.klaros.service.issuemanagement.mylyn.gitlab;

import de.verit.klaros.service.issuemanagement.IssueCustomAttribute;
import de.verit.klaros.service.issuemanagement.IssueCustomField;
import de.verit.klaros.service.issuemanagement.IssueManagementServiceType;
import de.verit.klaros.service.issuemanagement.mylyn.MylynIssueComment;
import de.verit.klaros.service.issuemanagement.mylyn.MylynIssueModel;
import de.verit.klaros.util.ListUtil;
import de.weingardt.mylyn.gitlab.core.GitlabAction;
import de.weingardt.mylyn.gitlab.core.GitlabAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskCommentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class GitLabIssueModel
extends MylynIssueModel {
    private static final long serialVersionUID = -8073659842163679479L;
    private String assignee;
    private List<String> labels;
    private String milestone;
    private String action;
    private List<MylynIssueComment> comments;

    public GitLabIssueModel(ITaskMapping taskMapping, Map<String, IssueCustomAttribute> customFieldAttributes, Map<String, IssueCustomField> customFields, TaskData taskData) {
        super(taskMapping, customFieldAttributes, customFields);
        TaskAttribute labelsAttribute;
        TaskAttribute assigneeAttribute = taskData.getRoot().getAttribute(GitlabAttribute.ASSIGNEE.getTaskKey());
        if (assigneeAttribute != null) {
            this.assignee = assigneeAttribute.getValue();
        }
        this.labels = (labelsAttribute = taskData.getRoot().getAttribute(GitlabAttribute.LABELS.getTaskKey())) != null ? GitLabIssueModel.splitValues(labelsAttribute.getValue()) : new ArrayList<String>();
        TaskAttribute milestoneAttribute = taskData.getRoot().getAttribute(GitlabAttribute.MILESTONE.getTaskKey());
        if (milestoneAttribute != null) {
            this.milestone = milestoneAttribute.getValue();
        }
        this.comments = new ArrayList<MylynIssueComment>();
        int i = 0;
        TaskAttribute comment = null;
        do {
            if ((comment = taskData.getRoot().getAttribute("task.common.comment-" + (i + 1))) != null) {
                TaskCommentMapper cmapper = TaskCommentMapper.createFrom((TaskAttribute)comment);
                this.comments.add(new MylynIssueComment(cmapper));
            }
            ++i;
        } while (comment != null);
        Collections.sort(this.comments, new Comparator<MylynIssueComment>(){

            @Override
            public int compare(MylynIssueComment o1, MylynIssueComment o2) {
                return o1.getCount().compareTo(o2.getCount());
            }
        });
    }

    private static List<String> splitValues(String value) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(ListUtil.getList((Object[])value.split(",")));
        return result;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public String getMilestone() {
        return this.milestone;
    }

    public void setMilestone(String value) {
        this.milestone = value;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public final void setStatus(String status) {
        if (status == null || this.getStatus() == null || status.equals(this.getStatus())) {
            this.action = GitlabAction.LEAVE.label;
        } else if ("opened".equals(this.getStatus())) {
            this.action = GitlabAction.CLOSE.label;
        } else if ("closed".equals(this.getStatus())) {
            this.action = GitlabAction.REOPEN.label;
        }
        super.setStatus(status);
    }

    public List<MylynIssueComment> getComments() {
        return this.comments;
    }

    public void setComments(List<MylynIssueComment> comments) {
        this.comments = comments;
    }

    public IssueManagementServiceType getServiceType() {
        return IssueManagementServiceType.GITLAB;
    }
}

