/*
 * Decompiled with CFR 0.152.
 */
package de.verit.klaros.service.issuemanagement.mylyn.github;

import de.verit.klaros.service.issuemanagement.IssueCustomAttribute;
import de.verit.klaros.service.issuemanagement.IssueCustomField;
import de.verit.klaros.service.issuemanagement.IssueManagementServiceType;
import de.verit.klaros.service.issuemanagement.mylyn.MylynIssueModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.mylyn.internal.github.core.issue.IssueAttribute;
import org.eclipse.mylyn.internal.github.core.issue.IssueOperation;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class GitHubIssueModel
extends MylynIssueModel {
    private static final long serialVersionUID = -8073659842163679479L;
    private String assignee;
    private List<String> labels;
    private String milestone;
    private String operation;

    public GitHubIssueModel(ITaskMapping taskMapping, Map<String, IssueCustomAttribute> customFieldAttributes, Map<String, IssueCustomField> customFields, TaskData taskData) {
        super(taskMapping, customFieldAttributes, customFields);
        TaskAttribute labelsAttribute;
        TaskAttribute assigneeAttribute = taskData.getRoot().getAttribute(IssueAttribute.ASSIGNEE.getMetadata().getId());
        if (assigneeAttribute != null) {
            this.assignee = assigneeAttribute.getValue();
        }
        this.labels = (labelsAttribute = taskData.getRoot().getAttribute(IssueAttribute.LABELS.getMetadata().getId())) != null ? new ArrayList<String>(labelsAttribute.getValues()) : new ArrayList<String>();
        TaskAttribute milestoneAttribute = taskData.getRoot().getAttribute(IssueAttribute.MILESTONE.getMetadata().getId());
        if (milestoneAttribute != null) {
            this.milestone = (String)milestoneAttribute.getOptions().get(milestoneAttribute.getValue());
        }
        this.operation = IssueOperation.LEAVE.getId();
    }

    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public String getMilestone() {
        return this.milestone;
    }

    public void setMilestone(String value) {
        this.milestone = value;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public final void setStatus(String status) {
        if (status == null || this.getStatus() == null || status.equals(this.getStatus())) {
            this.operation = IssueOperation.LEAVE.getId();
        } else if ("open".equals(this.getStatus())) {
            this.operation = IssueOperation.CLOSE.getId();
        } else if ("closed".equals(this.getStatus())) {
            this.operation = IssueOperation.REOPEN.getId();
        }
        super.setStatus(status);
    }

    public IssueManagementServiceType getServiceType() {
        return IssueManagementServiceType.GITHUB;
    }
}

