/*
 * Decompiled with CFR 0.152.
 */
package de.verit.klaros.service.issuemanagement.mylyn.github;

import de.verit.klaros.exception.KlarosServiceException;
import de.verit.klaros.service.issuemanagement.IssueCustomAttribute;
import de.verit.klaros.service.issuemanagement.IssueCustomField;
import de.verit.klaros.service.issuemanagement.IssueManagementServiceType;
import de.verit.klaros.service.issuemanagement.IssueModel;
import de.verit.klaros.service.issuemanagement.mylyn.MylynIssueManagementService;
import de.verit.klaros.service.issuemanagement.mylyn.github.GitHubIssueModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egit.github.core.Label;
import org.eclipse.egit.github.core.Milestone;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.internal.github.core.GitHub;
import org.eclipse.mylyn.internal.github.core.issue.IssueAttribute;
import org.eclipse.mylyn.internal.github.core.issue.IssueConnector;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubIssueManagementService
extends MylynIssueManagementService {
    private static final Logger LOG = LoggerFactory.getLogger(GitHubIssueManagementService.class);
    private final IssueConnector connector = new IssueConnector();

    public GitHubIssueManagementService(String url) {
        super("github", url);
    }

    public IssueModel getIssue(String issueId) throws KlarosServiceException {
        try {
            TaskData taskData = this.getConnector().getTaskData(this.getRepository(), issueId, Policy.monitorFor(null));
            return this.buildIssue(taskData);
        }
        catch (CoreException e) {
            throw new KlarosServiceException(e.getStatus().getMessage(), this.stripCoreException(e));
        }
        catch (RuntimeException e) {
            throw new KlarosServiceException((Throwable)e);
        }
    }

    @Override
    public AbstractRepositoryConnector getConnector() {
        return this.connector;
    }

    IssueConnector getGitHubConnector() {
        return (IssueConnector)this.getConnector();
    }

    TaskRepository getGitHubRepository() {
        return this.getRepository();
    }

    @Override
    protected TaskData readTaskData(String taskId) throws CoreException {
        return this.getGitHubConnector().getTaskData(this.getRepository(), taskId, Policy.monitorFor(null));
    }

    @Override
    public String storeIssue(IssueModel issue, TaskData data) throws KlarosServiceException {
        if (!(issue instanceof GitHubIssueModel)) {
            throw new IllegalArgumentException("Illegal model instance class: " + issue.getClass().getName());
        }
        GitHubIssueModel model = (GitHubIssueModel)issue;
        try {
            HashSet oldAttributes = new HashSet(data.getRoot().getAttributes().values());
            this.setTaskDataValue(model.getOperation(), "task.common.operation", data);
            if (data.isNew()) {
                this.setTaskDataValue("open", IssueAttribute.STATUS.getMetadata().getId(), data);
            } else {
                this.setTaskDataValue(model.getStatus(), IssueAttribute.STATUS.getMetadata().getId(), data);
            }
            this.setTaskDataValue(model.getDescription(), IssueAttribute.BODY.getMetadata().getId(), data);
            this.setTaskDataValue(model.getSummary(), IssueAttribute.TITLE.getMetadata().getId(), data);
            this.setTaskDataValue(model.getAssignee(), IssueAttribute.ASSIGNEE.getMetadata().getId(), data);
            this.setMappedTaskDataValues(model.getLabels(), IssueAttribute.LABELS.getMetadata().getId(), data);
            this.setMappedTaskDataValue(model.getMilestone() == null ? "" : model.getMilestone(), IssueAttribute.MILESTONE.getMetadata().getId(), data);
            this.addCustomAttributes(data, model);
            RepositoryResponse response = this.getTaskDataHandler().postTaskData(this.getRepository(), data, oldAttributes, Policy.monitorFor(null));
            return response.getTaskId();
        }
        catch (CoreException e) {
            throw new KlarosServiceException(e.getStatus().getMessage(), this.stripCoreException(e));
        }
        catch (RuntimeException e) {
            throw new KlarosServiceException((Throwable)e);
        }
    }

    public void terminate() {
    }

    @Override
    public boolean login(String loginUsername, String loginPassword) throws KlarosServiceException {
        boolean result = false;
        try {
            AuthenticationCredentials credentials = new AuthenticationCredentials(loginUsername, loginPassword);
            this.getRepository().setCredentials(AuthenticationType.REPOSITORY, credentials, false);
            this.getGitHubConnector().refreshMilestones(this.getRepository());
            result = true;
        }
        catch (CoreException e) {
            throw new KlarosServiceException(e.getStatus().getMessage(), this.stripCoreException(e));
        }
        catch (RuntimeException e) {
            throw new KlarosServiceException((Throwable)e);
        }
        return result;
    }

    public String checkConnection() {
        String result = null;
        try {
            if (GitHub.getRepository((String)this.getRepositoryUrl()) != null) {
                this.login(UUID.randomUUID().toString(), UUID.randomUUID().toString());
                this.getMilestones();
            } else {
                result = "GitHub repository could not be found";
            }
        }
        catch (KlarosServiceException e) {
            if (StringUtils.containsIgnoreCase((CharSequence)e.getMessage(), (CharSequence)"Access Denied") || StringUtils.containsIgnoreCase((CharSequence)e.getMessage(), (CharSequence)"Bad credentials")) {
                result = null;
                LOG.debug("Connection found, ignoring exception", (Throwable)e);
            } else {
                result = e.getMessage();
                LOG.debug("", (Throwable)e);
            }
        }
        catch (RuntimeException e) {
            LOG.debug("Ignoring exception", (Throwable)e);
            result = e.getMessage();
        }
        return result;
    }

    public List<String> getMilestones() throws KlarosServiceException {
        try {
            List milestones = this.getGitHubConnector().refreshMilestones(this.getRepository());
            ArrayList<String> results = new ArrayList<String>(milestones.size());
            results.add("");
            for (Milestone milestone : milestones) {
                results.add(milestone.getTitle());
            }
            return results;
        }
        catch (CoreException e) {
            throw new KlarosServiceException(e.getStatus().getMessage(), this.stripCoreException(e));
        }
        catch (RuntimeException e) {
            throw new KlarosServiceException((Throwable)e);
        }
    }

    public List<String> getLabels() throws KlarosServiceException {
        try {
            List labels = this.getGitHubConnector().refreshLabels(this.getRepository());
            ArrayList<String> results = new ArrayList<String>(labels.size());
            for (Label label : labels) {
                results.add(label.getName());
            }
            return results;
        }
        catch (CoreException e) {
            throw new KlarosServiceException(e.getStatus().getMessage(), this.stripCoreException(e));
        }
        catch (RuntimeException e) {
            throw new KlarosServiceException((Throwable)e);
        }
    }

    public boolean checkAuthentication(String username, String password) throws KlarosServiceException {
        block3: {
            try {
                if (this.login(username, password)) {
                    return this.probeUnknownIssue();
                }
            }
            catch (RuntimeException e) {
                this.logout();
                if (StringUtils.containsIgnoreCase((CharSequence)e.getMessage(), (CharSequence)"Access Denied") || StringUtils.containsIgnoreCase((CharSequence)e.getMessage(), (CharSequence)"Bad credentials")) break block3;
                throw new KlarosServiceException((Throwable)e);
            }
        }
        return false;
    }

    private boolean probeUnknownIssue() throws KlarosServiceException {
        try {
            this.getConnector().getTaskData(this.getRepository(), Integer.toString(Integer.MAX_VALUE), Policy.monitorFor(null));
        }
        catch (RuntimeException | CoreException e) {
            if (StringUtils.containsIgnoreCase((CharSequence)e.getMessage(), (CharSequence)"Not Found")) {
                return true;
            }
            this.logout();
            throw new KlarosServiceException(e);
        }
        return false;
    }

    public List<String> getAllProjects() throws KlarosServiceException {
        return Collections.emptyList();
    }

    public List<String> getAllProjectKeys() throws KlarosServiceException {
        return Collections.emptyList();
    }

    public String getProjectKey() {
        return null;
    }

    @Override
    public boolean hasProject(String name) throws KlarosServiceException {
        return true;
    }

    public Map<String, IssueCustomField> getCustomFields(String ignoredTrackerType) throws KlarosServiceException {
        return new HashMap<String, IssueCustomField>();
    }

    public List<String> getComponents() throws KlarosServiceException {
        return new ArrayList<String>();
    }

    public GitHubIssueModel createNewIssue(String type) throws KlarosServiceException {
        return this.buildIssue(this.createNewTaskData());
    }

    public GitHubIssueModel buildIssue(TaskData taskData) throws KlarosServiceException {
        GitHubIssueModel result = new GitHubIssueModel(this.connector.getTaskMapping(taskData), this.loadCustomFieldAttributes(this.connector.getTaskMapping(taskData), this.getCustomFields(null)), this.getCustomFields(null), taskData);
        HashMap<String, IssueCustomAttribute> validCustomFields = new HashMap<String, IssueCustomAttribute>();
        for (String customFieldName : this.getCustomFields(null).keySet()) {
            if (result.getCustomFieldAttributes().get(customFieldName) == null) continue;
            validCustomFields.put(customFieldName, (IssueCustomAttribute)result.getCustomFieldAttributes().get(customFieldName));
        }
        result.getCustomFieldAttributes().clear();
        result.getCustomFieldAttributes().putAll(validCustomFields);
        return result;
    }

    public String getBrowseIssueUrl(String id) {
        return this.getServiceType().getBrowseIssueUrl(this.getRepositoryUrl(), id);
    }

    public IssueManagementServiceType getServiceType() {
        return IssueManagementServiceType.GITHUB;
    }

    public List<String> getStatuses() throws KlarosServiceException {
        ArrayList<String> result = new ArrayList<String>();
        result.add("open");
        result.add("closed");
        return result;
    }

    public List<String> getPriorities() throws KlarosServiceException {
        return new ArrayList<String>();
    }

    @Override
    protected ITaskMapping getInitialTaskMapping() {
        return null;
    }

    @Override
    protected Map<String, IssueCustomAttribute> loadCustomFieldAttributes(ITaskMapping taskMapping, Map<String, IssueCustomField> customFields) {
        return new HashMap<String, IssueCustomAttribute>();
    }
}

