/*
 * Decompiled with CFR 0.152.
 */
package de.verit.klaros.service.issuemanagement.mylyn.bugzilla;

import de.verit.klaros.service.issuemanagement.IssueCustomAttribute;
import de.verit.klaros.service.issuemanagement.IssueCustomField;
import de.verit.klaros.service.issuemanagement.IssueManagementServiceType;
import de.verit.klaros.service.issuemanagement.mylyn.MylynIssueModel;
import java.util.Map;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class BugzillaIssueModel
extends MylynIssueModel {
    private static final long serialVersionUID = 3274192842803341767L;
    private String severity;
    private String version;
    private String keywords;
    private String operatingSystem;
    private String platform;
    private String milestone;
    private String dependsOn;
    private String blocked;
    private String url;
    private String component;

    public BugzillaIssueModel(ITaskMapping taskMapping, Map<String, IssueCustomAttribute> customFieldAttributes, Map<String, IssueCustomField> customFields, TaskData taskData) {
        super(taskMapping, customFieldAttributes, customFields);
        TaskAttribute componentAttribute;
        TaskAttribute resolutionAttribute;
        TaskAttribute urlAttribute;
        TaskAttribute blockedAttribute;
        TaskAttribute dependsOnAttribute;
        TaskAttribute milestoneAttribute;
        TaskAttribute platformAttribute;
        TaskAttribute operatingSystemAttribute;
        this.setSeverity(taskMapping.getSeverity());
        this.setVersion(taskMapping.getVersion());
        TaskAttribute keywordAttribute = taskData.getRoot().getAttribute(BugzillaAttribute.KEYWORDS.getKey());
        if (keywordAttribute != null) {
            this.keywords = keywordAttribute.getValue();
        }
        if ((operatingSystemAttribute = taskData.getRoot().getAttribute(BugzillaAttribute.OP_SYS.getKey())) != null) {
            this.operatingSystem = operatingSystemAttribute.getValue();
        }
        if ((platformAttribute = taskData.getRoot().getAttribute(BugzillaAttribute.REP_PLATFORM.getKey())) != null) {
            this.platform = platformAttribute.getValue();
        }
        if ((milestoneAttribute = taskData.getRoot().getAttribute(BugzillaAttribute.TARGET_MILESTONE.getKey())) != null) {
            this.milestone = milestoneAttribute.getValue();
        }
        if ((dependsOnAttribute = taskData.getRoot().getAttribute(BugzillaAttribute.DEPENDSON.getKey())) != null) {
            this.dependsOn = dependsOnAttribute.getValue();
        }
        if ((blockedAttribute = taskData.getRoot().getAttribute(BugzillaAttribute.BLOCKED.getKey())) != null) {
            this.blocked = blockedAttribute.getValue();
        }
        if ((urlAttribute = taskData.getRoot().getAttribute(BugzillaAttribute.BUG_FILE_LOC.getKey())) != null) {
            this.url = urlAttribute.getValue();
        }
        if ((resolutionAttribute = taskData.getRoot().getAttribute(BugzillaAttribute.RESOLUTION.getKey())) != null) {
            this.setResolution(resolutionAttribute.getValue());
        }
        if ((componentAttribute = taskData.getRoot().getAttribute(BugzillaAttribute.COMPONENT.getKey())) != null) {
            this.component = componentAttribute.getValue();
        }
    }

    public final String getSeverity() {
        return this.severity;
    }

    public final void setSeverity(String severity) {
        this.severity = severity;
    }

    public final String getVersion() {
        return this.version;
    }

    public final void setVersion(String version) {
        this.version = version;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public void setOperatingSystem(String operatingSystem) {
        this.operatingSystem = operatingSystem;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setMilestone(String milestone) {
        this.milestone = milestone;
    }

    public String getMilestone() {
        return this.milestone;
    }

    public void setDependsOn(String dependsOn) {
        this.dependsOn = dependsOn;
    }

    public String getDependsOn() {
        return this.dependsOn;
    }

    public void setBlocked(String blocked) {
        this.blocked = blocked;
    }

    public String getBlocked() {
        return this.blocked;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public String getComponent() {
        return this.component;
    }

    public IssueManagementServiceType getServiceType() {
        return IssueManagementServiceType.BUGZILLA;
    }
}

