/*
 * Decompiled with CFR 0.152.
 */
package de.verit.klaros.service.issuemanagement.mylyn;

import com.google.common.collect.Maps;
import de.verit.klaros.exception.KlarosServiceException;
import de.verit.klaros.service.connection.BaseExternalService;
import de.verit.klaros.service.issuemanagement.IssueCustomAttribute;
import de.verit.klaros.service.issuemanagement.IssueCustomField;
import de.verit.klaros.service.issuemanagement.IssueManagementService;
import de.verit.klaros.service.issuemanagement.IssueModel;
import de.verit.klaros.service.issuemanagement.mylyn.MylynIssueModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MylynIssueManagementService
extends BaseExternalService
implements IssueManagementService {
    protected static final String FAILED_WHILE_RETRIEVING_REPOSITORY_INFORMATION = "' failed while retrieving repository information";
    protected static final String FAILS_WITH_EXCEPTION = "' fails with exception: ";
    protected static final String FAILS_SILENTLY_WITH_EXCEPTION = "' fails silently with exception: ";
    protected static final String FAILS_WITH_MESSAGE = " fails with message: ";
    protected static final String YIELDS_SUCCESS = "' yields success: ";
    protected static final String CHECKING_CONNECTION_WITH_URL = "Checking connection with URL '";
    protected static final String CHECKING_AUTHENTICATION_FOR_USER_NAME = "Checking authentication for user name '";
    protected static final String LOGIN_ATTEMPT_WITH_USER_NAME = "Login attempt with user name '";
    protected static final String UNABLE_TO_RETRIEVE_ISSUE = "Unable to retrieve issue";
    protected static final String UNABLE_TO_MAP_VALUE = "Unable to map value ";
    private static final Logger LOG = LoggerFactory.getLogger(MylynIssueManagementService.class);
    private final TaskRepository repository;
    private final String repositoryUrl;

    protected MylynIssueManagementService(String connectorKind, String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
        this.repository = new TaskRepository(connectorKind, this.getMylynRepositoryUrl(repositoryUrl));
    }

    protected String getMylynRepositoryUrl(String url) {
        return url;
    }

    protected final TaskRepository getRepository() {
        return this.repository;
    }

    protected TaskData getTaskData(IssueModel issue) throws CoreException {
        return this.getConnector().getTaskData(this.getRepository(), issue.getId(), Policy.monitorFor(null));
    }

    protected abstract AbstractRepositoryConnector getConnector();

    public boolean login(String loginUsername, String loginPassword) throws KlarosServiceException {
        AuthenticationCredentials credentials = new AuthenticationCredentials(loginUsername, loginPassword);
        this.repository.setCredentials(AuthenticationType.REPOSITORY, credentials, false);
        return true;
    }

    public void logout() {
        this.repository.setCredentials(AuthenticationType.REPOSITORY, null, false);
        this.repository.flushAuthenticationCredentials();
    }

    public String checkUrl() {
        return this.checkUrl(this.getRepositoryUrl(), this.getServiceType().getContentPattern());
    }

    protected String getMappedTaskDataValue(String key, String id, TaskData data) throws KlarosServiceException {
        TaskAttribute attribute = data.getRoot().createAttribute(id);
        Map options = data.getAttributeMapper().getOptions(attribute);
        if (options.isEmpty()) {
            throw new KlarosServiceException("No options defined for attribute: " + id);
        }
        return (String)options.get(key);
    }

    protected void setTaskDataValue(String value, String id, TaskData data) throws KlarosServiceException {
        TaskAttribute attribute = data.getRoot().getAttribute(id);
        if (attribute == null) {
            attribute = data.getRoot().createAttribute(id);
        }
        attribute.setValue(value);
    }

    protected void setMappedTaskDataValue(String value, String id, TaskData data) throws KlarosServiceException {
        if (value != null) {
            TaskAttribute attribute = data.getRoot().getAttribute(id);
            if (attribute != null) {
                Map options = data.getAttributeMapper().getOptions(attribute);
                if (options.isEmpty()) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error("No options defined for attribute: {}", (Object)id);
                    }
                    attribute.setValue("");
                } else {
                    for (Map.Entry entry : options.entrySet()) {
                        if (!((String)entry.getValue()).equals(value)) continue;
                        attribute.setValue((String)entry.getKey());
                        return;
                    }
                    attribute.setValue("");
                }
            } else {
                throw new KlarosServiceException(UNABLE_TO_MAP_VALUE + value + " for unknown attribute id " + id);
            }
        }
    }

    protected void setMappedTaskDataValues(List<String> values, String id, TaskData data) throws KlarosServiceException {
        TaskAttribute attribute = data.getRoot().getAttribute(id);
        Map options = data.getAttributeMapper().getOptions(attribute);
        if (options.isEmpty()) {
            if (LOG.isErrorEnabled()) {
                LOG.error("No options defined for attribute: {}", (Object)id);
            }
        } else {
            ArrayList<String> results = new ArrayList<String>();
            for (String value : values) {
                boolean found = false;
                for (Map.Entry entry : options.entrySet()) {
                    if (!((String)entry.getValue()).equals(value)) continue;
                    results.add((String)entry.getKey());
                    found = true;
                }
                if (found) continue;
                throw new KlarosServiceException(UNABLE_TO_MAP_VALUE + value + " for option value " + id);
            }
            attribute.setValues(results);
        }
    }

    protected abstract TaskData readTaskData(String var1) throws CoreException;

    public String createIssue(IssueModel issue) throws KlarosServiceException {
        AbstractTaskDataHandler taskDataHandler = this.getTaskDataHandler();
        TaskData data = new TaskData(taskDataHandler.getAttributeMapper(this.getRepository()), this.getRepository().getConnectorKind(), this.getRepository().getUrl(), "");
        try {
            taskDataHandler.initializeTaskData(this.getRepository(), data, this.getInitialTaskMapping(), Policy.monitorFor(null));
        }
        catch (RuntimeException | CoreException e) {
            throw new KlarosServiceException(e);
        }
        return this.storeIssue(issue, data);
    }

    protected abstract ITaskMapping getInitialTaskMapping();

    protected AbstractTaskDataHandler getTaskDataHandler() {
        return this.getConnector().getTaskDataHandler();
    }

    protected abstract Map<String, IssueCustomAttribute> loadCustomFieldAttributes(ITaskMapping var1, Map<String, IssueCustomField> var2);

    public String updateIssue(IssueModel issue) throws KlarosServiceException {
        try {
            TaskData data = this.readTaskData(issue.getId());
            return this.storeIssue(issue, data);
        }
        catch (RuntimeException | CoreException e) {
            throw new KlarosServiceException(e);
        }
    }

    protected abstract String storeIssue(IssueModel var1, TaskData var2) throws KlarosServiceException;

    public boolean hasProject(String key) throws KlarosServiceException {
        List projectKeys = this.getAllProjectKeys();
        return projectKeys.contains(key);
    }

    protected boolean canQuery() {
        return this.getConnector().canQuery(this.getRepository());
    }

    protected boolean canCreateNewTask() {
        return this.getConnector().canCreateNewTask(this.getRepository());
    }

    protected boolean canCreateTaskFromKey() {
        return this.getConnector().canCreateTaskFromKey(this.getRepository());
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    protected TaskAttribute buildCustomTaskAttribute(TaskData data, IssueCustomAttribute customAttribute) throws KlarosServiceException {
        return new TaskAttribute(data.getRoot(), customAttribute.getId());
    }

    protected TaskData createNewTaskData() {
        return new TaskData(this.getTaskDataHandler().getAttributeMapper(this.getRepository()), this.getConnector().getConnectorKind(), this.getRepositoryUrl(), "");
    }

    protected void addCustomAttributes(TaskData data, MylynIssueModel model) throws KlarosServiceException {
        for (IssueCustomAttribute customAttribute : model.getCustomFieldAttributes().values()) {
            TaskAttribute customTaskAttribute = this.buildCustomTaskAttribute(data, customAttribute);
            if (customAttribute.getValue() != null) {
                data.getAttributeMapper().setValue(customTaskAttribute, customAttribute.getValue());
                continue;
            }
            if (customAttribute.getValues() == null) continue;
            data.getAttributeMapper().setValues(customTaskAttribute, customAttribute.getValues());
        }
    }

    protected Throwable stripCoreException(CoreException e) {
        Throwable result;
        IStatus status = e.getStatus();
        if (status instanceof RepositoryStatus) {
            String message = ((RepositoryStatus)status).getHtmlMessage();
            result = new KlarosServiceException(message, (Throwable)e);
        } else {
            result = e.getCause() != null ? (e.getCause() instanceof CoreException ? this.stripCoreException((CoreException)e.getCause()) : e.getCause()) : e;
        }
        return result;
    }

    protected abstract IssueModel buildIssue(TaskData var1) throws KlarosServiceException;

    public Map<String, IssueModel> getIssues(Set<String> issueIds) throws KlarosServiceException {
        final HashMap result = Maps.newHashMapWithExpectedSize((int)issueIds.size());
        try {
            if (this.getTaskDataHandler().canGetMultiTaskData(this.getRepository())) {
                TaskDataCollector collector = new TaskDataCollector(){

                    public void accept(TaskData taskData) {
                        this.addTaskDataIfPresent(taskData, result);
                    }

                    private void addTaskDataIfPresent(TaskData taskData, Map<String, IssueModel> result2) {
                        try {
                            if (taskData != null) {
                                IssueModel issue = MylynIssueManagementService.this.buildIssue(taskData);
                                result2.put(taskData.getTaskId(), issue);
                            }
                        }
                        catch (KlarosServiceException | RuntimeException e) {
                            LOG.error(MylynIssueManagementService.UNABLE_TO_RETRIEVE_ISSUE, e);
                        }
                    }
                };
                this.getTaskDataHandler().getMultiTaskData(this.getRepository(), new HashSet<String>(issueIds), collector, Policy.monitorFor(null));
            } else {
                for (String issueId : issueIds) {
                    this.addIssue(result, issueId);
                }
            }
        }
        catch (CoreException e) {
            throw new KlarosServiceException(e.getStatus().getMessage(), this.stripCoreException(e));
        }
        catch (NumberFormatException e) {
            throw new KlarosServiceException((Throwable)e);
        }
        return result;
    }

    private void addIssue(Map<String, IssueModel> result, String issueId) {
        try {
            result.put(issueId, this.getIssue(issueId));
        }
        catch (KlarosServiceException | RuntimeException e) {
            LOG.debug(UNABLE_TO_RETRIEVE_ISSUE, e);
        }
    }

    public boolean isProjectValid() {
        boolean result;
        if (this.getServiceType().isProjectRequired()) {
            try {
                result = this.hasProject(this.getProjectKey());
            }
            catch (KlarosServiceException e) {
                LOG.debug("Exception indicates unavailable project", (Throwable)e);
                result = false;
            }
        } else {
            result = true;
        }
        return result;
    }
}

