/*
 * Decompiled with CFR 0.152.
 */
package de.verit.klaros.service.issuemanagement.mylyn;

import com.itsolut.mantis.core.model.MantisCustomFieldType;
import de.verit.klaros.service.issuemanagement.IssueCustomFieldType;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaCustomField;

public enum MylynIssueCustomFieldType implements IssueCustomFieldType
{
    UNKNOWN(0),
    FREE_TEXT(1),
    DROP_DOWN(2),
    MULTIPLE_SELECTION(3),
    LARGE_TEXT(4),
    DATE_TIME(5),
    CHECKBOX(6),
    CHECKBOXES(7),
    RADIO(8),
    DATE(9),
    AUTO_COMPLETE(10);

    private static final Map<Integer, MylynIssueCustomFieldType> ENUM_MAP;
    private final int code;

    private MylynIssueCustomFieldType(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static MylynIssueCustomFieldType valueOf(int value) {
        return ENUM_MAP.get(value);
    }

    private static int parseInt(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public String toString() {
        String result;
        switch (this) {
            case CHECKBOX: {
                result = "Checkbox";
                break;
            }
            case CHECKBOXES: {
                result = "Checkboxes";
                break;
            }
            case DATE_TIME: {
                result = "Date/Time";
                break;
            }
            case DROP_DOWN: {
                result = "Drop Down";
                break;
            }
            case LARGE_TEXT: {
                result = "Large Text";
                break;
            }
            case MULTIPLE_SELECTION: {
                result = "Multiple-Selection Box";
                break;
            }
            case RADIO: {
                result = "Radio";
                break;
            }
            case AUTO_COMPLETE: {
                result = "Autocomplete";
                break;
            }
            case DATE: {
                result = "Date";
                break;
            }
            case FREE_TEXT: {
                result = "Free Text";
                break;
            }
            default: {
                result = "Unknown";
            }
        }
        return result;
    }

    public static MylynIssueCustomFieldType convert(String change) {
        return ENUM_MAP.get(MylynIssueCustomFieldType.parseInt(change));
    }

    public static MylynIssueCustomFieldType fromBugzilla(BugzillaCustomField.FieldType bugzillaFieldType) {
        MylynIssueCustomFieldType result;
        switch (bugzillaFieldType) {
            case DropDown: {
                result = DROP_DOWN;
                break;
            }
            case MultipleSelection: {
                result = MULTIPLE_SELECTION;
                break;
            }
            case LargeText: {
                result = LARGE_TEXT;
                break;
            }
            case DateTime: {
                result = DATE_TIME;
                break;
            }
            default: {
                result = FREE_TEXT;
            }
        }
        return result;
    }

    public static MylynIssueCustomFieldType fromTrac(String tracFieldType) {
        MylynIssueCustomFieldType result;
        String value;
        switch (value = tracFieldType.toLowerCase(Locale.US)) {
            case "checkbox": {
                result = CHECKBOX;
                break;
            }
            case "radio": {
                result = RADIO;
                break;
            }
            case "date": {
                result = DATE_TIME;
                break;
            }
            case "longtext": 
            case "longrichtext": {
                result = LARGE_TEXT;
                break;
            }
            case "select": 
            case "singleselect": 
            case "person": {
                result = DROP_DOWN;
                break;
            }
            default: {
                result = FREE_TEXT;
            }
        }
        return result;
    }

    public static MylynIssueCustomFieldType fromMantis(MantisCustomFieldType mantisFieldType) {
        MylynIssueCustomFieldType result;
        switch (mantisFieldType) {
            case CHECKBOX: {
                result = CHECKBOXES;
                break;
            }
            case MULTILIST: {
                result = MULTIPLE_SELECTION;
                break;
            }
            case DATE: {
                result = DATE;
                break;
            }
            case ENUM: 
            case LIST: {
                result = DROP_DOWN;
                break;
            }
            case RADIO: {
                result = RADIO;
                break;
            }
            case TEXTAREA: {
                result = LARGE_TEXT;
                break;
            }
            default: {
                result = FREE_TEXT;
            }
        }
        return result;
    }

    public static MylynIssueCustomFieldType fromRedmine(String redmineFieldFormat, boolean multiple) {
        MylynIssueCustomFieldType result;
        switch (redmineFieldFormat) {
            case "bool": {
                result = CHECKBOX;
                break;
            }
            case "date": {
                result = DATE;
                break;
            }
            case "text": {
                result = LARGE_TEXT;
                break;
            }
            case "enumeration": {
                result = DROP_DOWN;
                break;
            }
            case "list": 
            case "user": 
            case "version": {
                result = multiple ? MULTIPLE_SELECTION : DROP_DOWN;
                break;
            }
            default: {
                result = FREE_TEXT;
            }
        }
        return result;
    }

    public static MylynIssueCustomFieldType fromJira(String jiraFieldType) {
        MylynIssueCustomFieldType result = FREE_TEXT;
        return result;
    }

    public boolean isMultiple() {
        return this.getCode() == MylynIssueCustomFieldType.MULTIPLE_SELECTION.code;
    }

    static {
        ENUM_MAP = new HashMap<Integer, MylynIssueCustomFieldType>();
        for (MylynIssueCustomFieldType element : EnumSet.allOf(MylynIssueCustomFieldType.class)) {
            ENUM_MAP.put(element.getCode(), element);
        }
    }
}

