/*
 * Decompiled with CFR 0.152.
 */
package de.verit.klaros.service.issuemanagement.mylyn;

import de.verit.klaros.service.issuemanagement.IssueCustomField;
import de.verit.klaros.service.issuemanagement.mylyn.MylynIssueCustomAttribute;
import de.verit.klaros.service.issuemanagement.mylyn.MylynIssueCustomFieldType;
import java.util.List;

public class MylynIssueCustomField
implements IssueCustomField {
    private static final long serialVersionUID = 8268371206426652131L;
    private final String id;
    private final String name;
    private final String description;
    private final List<String> options;
    private final String defaultValue;
    private final MylynIssueCustomFieldType fieldType;
    private final boolean optional;

    public MylynIssueCustomField(String id, String description, String name, MylynIssueCustomFieldType type, List<String> options, String defaultValue, boolean optional) {
        this.id = id;
        this.description = description;
        this.name = name;
        this.fieldType = type;
        this.options = options;
        this.defaultValue = defaultValue;
        this.optional = optional;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getOptions() {
        return this.options;
    }

    public void addOption(String option) {
        this.options.add(option);
    }

    public MylynIssueCustomFieldType getFieldType() {
        return this.fieldType;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getId() {
        return this.id;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public MylynIssueCustomAttribute createAttribute(String value) {
        return new MylynIssueCustomAttribute(this.id, this.name, value != null ? value : this.defaultValue, null, this.fieldType, this.optional);
    }

    public MylynIssueCustomAttribute createAttribute(List<String> values) {
        return new MylynIssueCustomAttribute(this.id, this.name, null, values, this.fieldType, this.optional);
    }
}

