/*
 * Decompiled with CFR 0.152.
 */
package de.verit.klaros.service.issuemanagement.connection;

import de.verit.klaros.exception.KlarosServiceException;
import de.verit.klaros.service.connection.BaseExternalServiceConnection;
import de.verit.klaros.service.connection.ExternalService;
import de.verit.klaros.service.connection.ExternalServiceConnectionStatus;
import de.verit.klaros.service.credential.ExternalServiceCredential;
import de.verit.klaros.service.issuemanagement.IssueCustomField;
import de.verit.klaros.service.issuemanagement.IssueManagementService;
import de.verit.klaros.service.issuemanagement.IssueManagementServiceType;
import de.verit.klaros.service.issuemanagement.IssueModel;
import de.verit.klaros.service.issuemanagement.connection.IssueManagementConnection;
import de.verit.klaros.service.issuemanagement.jira.JiraRestIssueManagementService;
import de.verit.klaros.service.issuemanagement.mylyn.MylynIssueManagementService;
import de.verit.klaros.service.issuemanagement.mylyn.bugzilla.BugzillaIssueManagementService;
import de.verit.klaros.service.issuemanagement.mylyn.github.GitHubIssueManagementService;
import de.verit.klaros.service.issuemanagement.mylyn.gitlab.GitLabIssueManagementService;
import de.verit.klaros.service.issuemanagement.mylyn.jira.JiraIssueManagementService;
import de.verit.klaros.service.issuemanagement.mylyn.mantis.MantisIssueManagementService;
import de.verit.klaros.service.issuemanagement.mylyn.trac.TracIssueManagementService;
import de.verit.klaros.service.issuemanagement.redmine.RedmineIssueManagementService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueManagementConnectionImpl
extends BaseExternalServiceConnection
implements IssueManagementConnection {
    private static final long serialVersionUID = -5193520210251218494L;
    private static final Logger LOG = LoggerFactory.getLogger(IssueManagementConnectionImpl.class);

    public IssueManagementConnectionImpl(IssueManagementService service, ExternalServiceCredential initialAuthentication) {
        super((ExternalService)service, initialAuthentication);
    }

    public final ExternalServiceConnectionStatus connectService(ExternalServiceCredential authentication) {
        super.connectService(authentication);
        return this.getConnectionStatus();
    }

    @Override
    public IssueManagementService getIssueManagementService() {
        return (IssueManagementService)super.getService();
    }

    public boolean login(String loginUsername, String loginPassword) throws KlarosServiceException {
        boolean result = this.getIssueManagementService().login(loginUsername, loginPassword);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Logging in with username '{}' success: {}", (Object)loginUsername, (Object)result);
        }
        this.setConnectionStatusAuthenticated();
        return result;
    }

    public void logout() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Logging out");
        }
        this.getIssueManagementService().logout();
        this.setConnectionStatusConnected();
    }

    public void terminate() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Terminating");
        }
        this.getIssueManagementService().terminate();
        this.setConnectionStatusTerminated();
    }

    public IssueModel getIssueWithoutRetry(String id) throws KlarosServiceException {
        return this.getIssueManagementService().getIssue(id);
    }

    public IssueModel getIssue(String id) throws KlarosServiceException {
        IssueModel issueModel = null;
        try {
            issueModel = this.getIssueWithoutRetry(id);
        }
        catch (KlarosServiceException e) {
            LOG.debug("Error in method getIssue: Re-authenticate and try again ... ", (Throwable)e);
            this.reconnectService();
            issueModel = this.getIssueWithoutRetry(id);
        }
        return issueModel;
    }

    public String createIssue(IssueModel issue) throws KlarosServiceException {
        String issueID = null;
        try {
            issueID = this.getIssueManagementService().createIssue(issue);
        }
        catch (KlarosServiceException e) {
            LOG.debug("Error in method createIssue: Re-authenticate and try again ... ", (Throwable)e);
            this.reconnectService();
            issueID = this.getIssueManagementService().createIssue(issue);
        }
        return issueID;
    }

    public IssueModel createNewIssue(String type) throws KlarosServiceException {
        return this.getIssueManagementService().createNewIssue(type);
    }

    public String updateIssue(IssueModel issue) throws KlarosServiceException {
        String issueID = null;
        try {
            issueID = this.getIssueManagementService().updateIssue(issue);
        }
        catch (KlarosServiceException e) {
            LOG.debug("Error in method updateIssue: Re-authenticate and try again ... ", (Throwable)e);
            this.reconnectService();
            issueID = this.getIssueManagementService().updateIssue(issue);
        }
        return issueID;
    }

    public List<String> getAllProjects() throws KlarosServiceException {
        List projects = null;
        try {
            projects = this.getIssueManagementService().getAllProjects();
        }
        catch (KlarosServiceException e) {
            LOG.debug("Error in method getAllProjects: Re-authenticate and try again ... ", (Throwable)e);
            this.reconnectService();
            projects = this.getIssueManagementService().getAllProjects();
        }
        return projects;
    }

    public List<String> getAllProjectKeys() throws KlarosServiceException {
        List projectkeys = null;
        try {
            projectkeys = this.getIssueManagementService().getAllProjectKeys();
        }
        catch (KlarosServiceException e) {
            LOG.debug("Error in method getAllProjectKeys: Re-authenticate and try again ... ", (Throwable)e);
            this.reconnectService();
            projectkeys = this.getIssueManagementService().getAllProjectKeys();
        }
        return projectkeys;
    }

    public List<String> getPriorities() throws KlarosServiceException {
        List priorities;
        try {
            priorities = this.getIssueManagementService().getPriorities();
        }
        catch (KlarosServiceException e) {
            LOG.debug("Error in method getPriorities: Re-authenticate and try again ... ", (Throwable)e);
            this.reconnectService();
            priorities = this.getIssueManagementService().getPriorities();
        }
        return priorities;
    }

    private List<String> getCategoriesWithoutRetry() throws KlarosServiceException {
        List<String> categories;
        if (this.getServiceType().isRedmine()) {
            categories = ((RedmineIssueManagementService)this.getService()).getCategories();
            categories.add(null);
        } else {
            categories = this.getServiceType().isMantis() ? ((MantisIssueManagementService)this.getService()).getCategories() : new ArrayList<String>();
        }
        return categories;
    }

    @Override
    public List<String> getCategories() throws KlarosServiceException {
        List<String> categories;
        try {
            categories = this.getCategoriesWithoutRetry();
        }
        catch (KlarosServiceException e) {
            LOG.debug("Error in method getCategories: Re-authenticate and try again ... ", (Throwable)e);
            this.reconnectService();
            categories = this.getCategoriesWithoutRetry();
        }
        return categories;
    }

    public List<String> getSeveritiesWithoutRetry() throws KlarosServiceException {
        List<String> result = this.getServiceType().isBugzilla() ? ((BugzillaIssueManagementService)this.getService()).getSeverities() : (this.getServiceType().isMantis() ? ((MantisIssueManagementService)this.getService()).getSeverities() : new ArrayList<String>());
        return result;
    }

    @Override
    public List<String> getSeverities() throws KlarosServiceException {
        List<String> severities;
        try {
            severities = this.getSeveritiesWithoutRetry();
        }
        catch (KlarosServiceException e) {
            LOG.debug("Error in method getSeverities: Re-authenticate and try again ... ", (Throwable)e);
            this.reconnectService();
            severities = this.getSeveritiesWithoutRetry();
        }
        return severities;
    }

    public List<String> getReproducibilitysWithoutRetry() throws KlarosServiceException {
        List<Object> result = this.getServiceType().isMantis() ? ((MantisIssueManagementService)this.getService()).getReproducibilities() : new ArrayList();
        return result;
    }

    @Override
    public List<String> getReproducibilities() throws KlarosServiceException {
        List<String> reproducibilitys;
        try {
            reproducibilitys = this.getReproducibilitysWithoutRetry();
        }
        catch (KlarosServiceException e) {
            LOG.debug("Error in method getReproducibilitys: Re-authenticate and try again ... ", (Throwable)e);
            this.reconnectService();
            reproducibilitys = this.getReproducibilitysWithoutRetry();
        }
        return reproducibilitys;
    }

    public List<String> getOperatingSystemsWithoutRetry() throws KlarosServiceException {
        List<Object> result = this.getServiceType().isBugzilla() ? ((BugzillaIssueManagementService)this.getService()).getOperatingSystems() : new ArrayList();
        return result;
    }

    @Override
    public List<String> getOperatingSystems() throws KlarosServiceException {
        List<String> operatingSystems;
        try {
            operatingSystems = this.getOperatingSystemsWithoutRetry();
        }
        catch (KlarosServiceException e) {
            LOG.debug("Error in method getOperatingSystems: Re-authenticate and try again ... ", (Throwable)e);
            this.reconnectService();
            operatingSystems = this.getOperatingSystemsWithoutRetry();
        }
        return operatingSystems;
    }

    public List<String> getPlatformsWithoutRetry() throws KlarosServiceException {
        List<Object> result = this.getServiceType().isBugzilla() ? ((BugzillaIssueManagementService)this.getService()).getPlatforms() : new ArrayList();
        return result;
    }

    @Override
    public List<String> getPlatforms() throws KlarosServiceException {
        List<String> platforms;
        try {
            platforms = this.getPlatformsWithoutRetry();
        }
        catch (KlarosServiceException e) {
            LOG.debug("Error in method getPlatforms: Re-authenticate and try again ... ", (Throwable)e);
            this.reconnectService();
            platforms = this.getPlatformsWithoutRetry();
        }
        return platforms;
    }

    public List<String> getAssigneesWithoutRetry() throws KlarosServiceException {
        ArrayList<String> result = new ArrayList<String>();
        if (this.getServiceType().isGitLab()) {
            result.add(null);
            result.addAll(((GitLabIssueManagementService)this.getService()).getAssignableMembers());
        } else if (this.getServiceType().isRedmine()) {
            result.add(null);
            result.addAll(((RedmineIssueManagementService)this.getService()).getAssignableMembers());
        } else if (this.getServiceType().isMantis()) {
            result.add(null);
            result.addAll(((MantisIssueManagementService)this.getService()).getUsers());
        }
        return result;
    }

    @Override
    public List<String> getAssignees() throws KlarosServiceException {
        List<String> assignees;
        try {
            assignees = this.getAssigneesWithoutRetry();
        }
        catch (KlarosServiceException e) {
            LOG.debug("Error in method getAssignees: Re-authenticate and try again ... ", (Throwable)e);
            this.reconnectService();
            assignees = this.getAssigneesWithoutRetry();
        }
        return assignees;
    }

    public List<String> getVersionsWithoutRetry() throws KlarosServiceException {
        List<String> result;
        if (this.getServiceType().isJira()) {
            result = ((JiraIssueManagementService)this.getService()).getVersions();
        } else if (this.getServiceType().isJiraRest()) {
            result = ((JiraRestIssueManagementService)this.getService()).getVersions();
        } else if (this.getServiceType().isTrac()) {
            result = ((TracIssueManagementService)this.getService()).getVersions();
        } else if (this.getServiceType().isRedmine()) {
            result = ((RedmineIssueManagementService)this.getService()).getVersions();
            result.add(0, "");
        } else {
            result = this.getServiceType().isBugzilla() ? ((BugzillaIssueManagementService)this.getService()).getVersions() : (this.getServiceType().isMantis() ? ((MantisIssueManagementService)this.getService()).getVersions() : new ArrayList<String>());
        }
        return result;
    }

    @Override
    public List<String> getVersions() throws KlarosServiceException {
        List<String> versions;
        try {
            versions = this.getVersionsWithoutRetry();
        }
        catch (KlarosServiceException e) {
            LOG.debug("Error in method getVersions: Re-authenticate and try again ... ", (Throwable)e);
            this.reconnectService();
            versions = this.getVersionsWithoutRetry();
        }
        return versions;
    }

    public List<String> getComponentsWithoutRetry() throws KlarosServiceException {
        List<String> result = this.getServiceType().isJira() ? ((JiraIssueManagementService)this.getService()).getComponents() : (this.getServiceType().isJiraRest() ? ((JiraRestIssueManagementService)this.getService()).getComponents() : (this.getServiceType().isBugzilla() ? ((BugzillaIssueManagementService)this.getService()).getComponents() : new ArrayList<String>()));
        return result;
    }

    public List<String> getComponents() throws KlarosServiceException {
        List<String> components;
        try {
            components = this.getComponentsWithoutRetry();
        }
        catch (KlarosServiceException e) {
            LOG.debug("Error in method getComponents: Re-authenticate and try again ... ", (Throwable)e);
            this.reconnectService();
            components = this.getComponentsWithoutRetry();
        }
        return components;
    }

    public List<String> getStatusesWithoutRetry() throws KlarosServiceException {
        List<Object> result = this.getServiceType().isGitHub() || this.getServiceType().isGitLab() || this.getServiceType().isMantis() || this.getServiceType().isBugzilla() ? ((MylynIssueManagementService)this.getService()).getStatuses() : (this.getServiceType().isRedmine() ? ((RedmineIssueManagementService)this.getService()).getStatuses() : new ArrayList());
        return result;
    }

    public List<String> getStatuses() throws KlarosServiceException {
        List<String> statuses;
        try {
            statuses = this.getStatusesWithoutRetry();
        }
        catch (KlarosServiceException e) {
            LOG.debug("Error in method getStatuses: Re-authenticate and try again ... ", (Throwable)e);
            this.reconnectService();
            statuses = this.getStatusesWithoutRetry();
        }
        return statuses;
    }

    public List<String> getResolutionsWithoutRetry() throws KlarosServiceException {
        List<String> result = this.getServiceType().isMantis() ? ((MantisIssueManagementService)this.getService()).getResolutions() : (this.getServiceType().isBugzilla() ? ((BugzillaIssueManagementService)this.getService()).getResolutions() : new ArrayList<String>());
        return result;
    }

    @Override
    public List<String> getResolutions() throws KlarosServiceException {
        List<String> resolutions;
        try {
            resolutions = this.getResolutionsWithoutRetry();
        }
        catch (KlarosServiceException e) {
            LOG.debug("Error in method getResolutions: Re-authenticate and try again ... ", (Throwable)e);
            this.reconnectService();
            resolutions = this.getResolutionsWithoutRetry();
        }
        return resolutions;
    }

    public List<String> getTypesWithoutRetry() throws KlarosServiceException {
        List<String> result = this.getServiceType().isJira() ? ((JiraIssueManagementService)this.getService()).getTypes() : (this.getServiceType().isJiraRest() ? ((JiraRestIssueManagementService)this.getService()).getTypes() : (this.getServiceType().isTrac() ? ((TracIssueManagementService)this.getService()).getTypes() : (this.getServiceType().isRedmine() ? ((RedmineIssueManagementService)this.getService()).getTrackers() : new ArrayList<String>())));
        return result;
    }

    @Override
    public List<String> getTypes() throws KlarosServiceException {
        List<String> types;
        try {
            types = this.getTypesWithoutRetry();
        }
        catch (KlarosServiceException e) {
            LOG.debug("Error in method getTypes: Re-authenticate and try again ... ", (Throwable)e);
            this.reconnectService();
            types = this.getTypesWithoutRetry();
        }
        return types;
    }

    public List<String> getMilestonesWithoutRetry() throws KlarosServiceException {
        List<String> result = this.getServiceType().isGitHub() ? ((GitHubIssueManagementService)this.getService()).getMilestones() : (this.getServiceType().isGitLab() ? ((GitLabIssueManagementService)this.getService()).getMilestones() : (this.getServiceType().isTrac() ? ((TracIssueManagementService)this.getService()).getMilestones() : (this.getServiceType().isBugzilla() ? ((BugzillaIssueManagementService)this.getService()).getTargetMilestones() : new ArrayList<String>())));
        return result;
    }

    @Override
    public List<String> getMilestones() throws KlarosServiceException {
        List<String> milestones;
        try {
            milestones = this.getMilestonesWithoutRetry();
        }
        catch (KlarosServiceException e) {
            LOG.debug("Error in method getMilestones: Re-authenticate and try again ... ", (Throwable)e);
            this.reconnectService();
            milestones = this.getMilestonesWithoutRetry();
        }
        return milestones;
    }

    public String getProjectKey() {
        return this.getIssueManagementService().getProjectKey();
    }

    public boolean hasProject(String key) throws KlarosServiceException {
        boolean hasProject = false;
        try {
            hasProject = this.getIssueManagementService().hasProject(key);
        }
        catch (KlarosServiceException e) {
            LOG.debug("Error in method hasProject: Re-authenticate and try again ... ", (Throwable)e);
            this.reconnectService();
            hasProject = this.getIssueManagementService().hasProject(key);
        }
        return hasProject;
    }

    public Map<String, IssueCustomField> getCustomFields(String trackerType) throws KlarosServiceException {
        return this.getIssueManagementService().getCustomFields(trackerType);
    }

    public Map<String, IssueModel> getIssues(Set<String> ids) throws KlarosServiceException {
        return this.getIssueManagementService().getIssues(ids);
    }

    public String getBrowseIssueUrl(String id) {
        return this.getIssueManagementService().getBrowseIssueUrl(id);
    }

    public String getRepositoryUrl() {
        return this.getIssueManagementService().getRepositoryUrl();
    }

    public IssueManagementServiceType getServiceType() {
        return this.getIssueManagementService().getServiceType();
    }

    public String checkUrl() {
        return this.getIssueManagementService().checkUrl();
    }

    public String checkConnection() {
        return this.getIssueManagementService().checkConnection();
    }

    public boolean checkAuthentication(String username, String password) throws KlarosServiceException {
        return this.getIssueManagementService().checkAuthentication(username, password);
    }

    public boolean isProjectValid() {
        return this.getService().isProjectValid();
    }

    public boolean isUserNamePasswordAuthenticationSupported() {
        return this.getIssueManagementService().getServiceType().isUserNamePasswordAuthenticationSupported();
    }

    public boolean isTokenAuthenticationSupported() {
        return this.getIssueManagementService().getServiceType().isTokenAuthenticationSupported();
    }

    public boolean initializeWithAdminCredentials(String username, String password) {
        boolean result = false;
        if (IssueManagementServiceType.REDMINE == this.getServiceType()) {
            try {
                ((RedmineIssueManagementService)this.getService()).initializeCustomFields(username, password);
                result = true;
            }
            catch (KlarosServiceException | RuntimeException e) {
                LOG.error("Unable to initialize service", e);
            }
        } else {
            result = true;
        }
        return result;
    }
}

