/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.async;

import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.jira.rest.client.api.MyPermissionsRestClient;
import com.atlassian.jira.rest.client.api.domain.Permissions;
import com.atlassian.jira.rest.client.api.domain.input.MyPermissionsInput;
import com.atlassian.jira.rest.client.internal.async.AsynchronousMyPermissionsRestClient;
import com.atlassian.jira.rest.client.internal.json.JsonParser;
import com.atlassian.jira.rest.client.internal.json.PermissionsJsonParser;
import io.atlassian.util.concurrent.Promise;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;

public class ExtendedMyPermissionsRestClient
extends AsynchronousMyPermissionsRestClient
implements MyPermissionsRestClient {
    private static final String URI_PREFIX = "mypermissions";
    private final PermissionsJsonParser permissionsJsonParser = new PermissionsJsonParser();
    private URI baseUri;
    private String permissions;

    public ExtendedMyPermissionsRestClient(URI baseUri, HttpClient client, String permissions) {
        super(baseUri, client);
        this.baseUri = baseUri;
        this.permissions = permissions;
    }

    public Promise<Permissions> getMyPermissions(MyPermissionsInput permissionInput) {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.baseUri).path(URI_PREFIX);
        this.addContextParams(uriBuilder, permissionInput);
        return this.getAndParse(uriBuilder.build(new Object[0]), (JsonParser)this.permissionsJsonParser);
    }

    private UriBuilder addContextParams(UriBuilder uriBuilder, MyPermissionsInput permissionInput) {
        if (permissionInput != null) {
            if (permissionInput.getProjectKey() != null) {
                uriBuilder.queryParam("projectKey", new Object[]{permissionInput.getProjectKey()});
            }
            if (permissionInput.getProjectId() != null) {
                uriBuilder.queryParam("projectId", new Object[]{permissionInput.getProjectId()});
            }
            if (permissionInput.getIssueKey() != null) {
                uriBuilder.queryParam("issueKey", new Object[]{permissionInput.getIssueKey()});
            }
            if (permissionInput.getIssueId() != null) {
                uriBuilder.queryParam("issueId", new Object[]{permissionInput.getIssueId()});
            }
            if (this.permissions != null) {
                uriBuilder.queryParam("permissions", new Object[]{this.permissions});
            }
        }
        return uriBuilder;
    }
}

