/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.core;

import com.atlassian.connector.eclipse.internal.jira.core.model.ServerInfo;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraClient;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraClientData;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraException;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraLocalConfiguration;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;

public class KlarosJiraClientManager {
    public static final String CONFIGURATION_DATA_FILENAME = "repositoryConfigurations";
    public static final int CONFIGURATION_DATA_VERSION = 1;
    private final Map<String, JiraClient> clientByUrl = new HashMap<String, JiraClient>();
    private final Map<String, JiraClientData> clientDataByUrl = new HashMap<String, JiraClientData>();

    protected void start() {
    }

    protected void stop() {
    }

    public ServerInfo validateConnection(AbstractWebLocation location, JiraLocalConfiguration configuration, IProgressMonitor monitor) throws JiraException {
        JiraClient client = this.createClient(location, configuration);
        return client.getServerInfo(monitor);
    }

    public JiraClient getClient(String url) {
        return this.clientByUrl.get(url);
    }

    public JiraClient[] getAllClients() {
        return this.clientByUrl.values().toArray(new JiraClient[this.clientByUrl.size()]);
    }

    private JiraClient createClient(AbstractWebLocation location, JiraLocalConfiguration configuration) {
        return new JiraClient(location, configuration);
    }

    public JiraClient addClient(String session, AbstractWebLocation location, JiraLocalConfiguration configuration) {
        String key = session + ":" + location.getUrl();
        if (this.clientByUrl.containsKey(key)) {
            throw new RuntimeException("A client with that name already exists");
        }
        JiraClient client = this.createClient(location, configuration);
        JiraClientData data = this.clientDataByUrl.get(key);
        if (data != null) {
            client.getCache().setData(data);
        }
        this.clientByUrl.put(key, client);
        return client;
    }

    public void refreshClient() {
    }

    public void removeClient(JiraClient client, boolean clearData) {
        if (clearData) {
            this.clientDataByUrl.remove(client.getBaseUrl());
        } else {
            this.clientDataByUrl.put(client.getBaseUrl(), client.getCache().getData());
        }
        this.clientByUrl.remove(client.getBaseUrl());
    }

    public void removeClient(String key) {
        this.clientDataByUrl.remove(key);
        this.clientByUrl.remove(key);
    }

    public void removeAllClients(boolean clearData) {
        if (clearData) {
            this.clientDataByUrl.clear();
        }
        this.clientByUrl.clear();
    }
}

