/*
 * Decompiled with CFR 0.152.
 */
package de.verit.klaros.service.issuemanagement.redmine;

import de.verit.klaros.service.issuemanagement.IssueCustomFieldType;
import de.verit.klaros.service.issuemanagement.mylyn.MylynIssueCustomAttribute;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedmineMylynIssueCustomAttribute
extends MylynIssueCustomAttribute
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(RedmineMylynIssueCustomAttribute.class);
    private static final long serialVersionUID = 7608201746861771794L;
    private static final String REDMINE_DATE_FORMAT = "yyyy-MM-dd";
    private static final String KLAROS_DATE_FORMAT = "dd.MM.yyyy";

    public RedmineMylynIssueCustomAttribute(String id, String label, String value, List<String> values, IssueCustomFieldType type, boolean optional) {
        super(id, label, value, values, type, optional);
    }

    public static final String toKlarosDate(String value) {
        String result = null;
        try {
            if (value != null) {
                result = new SimpleDateFormat(KLAROS_DATE_FORMAT).format(new SimpleDateFormat(REDMINE_DATE_FORMAT).parse(value));
            }
        }
        catch (ParseException e) {
            result = null;
        }
        return result;
    }

    public static final String toRedmineDate(String value) {
        String result = null;
        try {
            if (value != null) {
                result = new SimpleDateFormat(REDMINE_DATE_FORMAT).format(new SimpleDateFormat(KLAROS_DATE_FORMAT).parse(value));
            }
        }
        catch (ParseException e) {
            result = null;
        }
        return result;
    }

    @Override
    public Date getDateValue() {
        Date result = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)this.getValue())) {
                result = new SimpleDateFormat(KLAROS_DATE_FORMAT).parse(this.getValue());
            }
        }
        catch (ParseException e) {
            LOG.warn("", (Throwable)e);
        }
        return result;
    }

    @Override
    public void setDateValue(Date dateValue) {
        if (dateValue != null) {
            this.setValue(new SimpleDateFormat(KLAROS_DATE_FORMAT).format(dateValue));
        } else {
            this.setValue(null);
        }
    }
}

