/*
 * Decompiled with CFR 0.152.
 */
package de.verit.klaros.service.issuemanagement.mylyn.trac;

import de.verit.klaros.exception.KlarosServiceException;
import de.verit.klaros.service.issuemanagement.IssueCustomAttribute;
import de.verit.klaros.service.issuemanagement.IssueCustomField;
import de.verit.klaros.service.issuemanagement.IssueManagementServiceType;
import de.verit.klaros.service.issuemanagement.IssueModel;
import de.verit.klaros.service.issuemanagement.mylyn.MylynIssueCustomAttribute;
import de.verit.klaros.service.issuemanagement.mylyn.MylynIssueCustomField;
import de.verit.klaros.service.issuemanagement.mylyn.MylynIssueCustomFieldType;
import de.verit.klaros.service.issuemanagement.mylyn.MylynIssueManagementService;
import de.verit.klaros.service.issuemanagement.mylyn.trac.KlarosTracRepositoryConnector;
import de.verit.klaros.service.issuemanagement.mylyn.trac.TracIssueModel;
import de.verit.klaros.util.ListUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.internal.trac.core.TracAttribute;
import org.eclipse.mylyn.internal.trac.core.TracAttributeMapper;
import org.eclipse.mylyn.internal.trac.core.client.ITracClient;
import org.eclipse.mylyn.internal.trac.core.client.TracException;
import org.eclipse.mylyn.internal.trac.core.client.TracLoginException;
import org.eclipse.mylyn.internal.trac.core.client.TracRemoteException;
import org.eclipse.mylyn.internal.trac.core.model.TracTicketField;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracIssueManagementService
extends MylynIssueManagementService {
    private static final String FOUR_ARGS_STRING = "{}{}{}{}";
    private static final String THREE_ARGS_STRING = "{}{}{}";
    private static final Logger LOG = LoggerFactory.getLogger(TracIssueManagementService.class);
    private final KlarosTracRepositoryConnector connector;

    public TracIssueManagementService(String session, String url, String version) {
        super("trac", url);
        this.getRepository().setVersion(version);
        this.connector = new KlarosTracRepositoryConnector(session);
    }

    private ITracClient getClient(boolean requireInitialization) throws TracException {
        ITracClient client = this.connector.getKlarosClientManager().getTracClient(this.getRepository());
        if (requireInitialization && !client.hasAttributes()) {
            client.updateAttributes(Policy.monitorFor(null), false);
        }
        return client;
    }

    public IssueModel getIssue(String issueId) throws KlarosServiceException {
        try {
            TaskData taskData = this.connector.getTaskData(this.getRepository(), issueId, Policy.monitorFor(null));
            return this.buildIssue(taskData);
        }
        catch (CoreException e) {
            throw new KlarosServiceException(e.getStatus().getMessage(), this.stripCoreException(e));
        }
        catch (RuntimeException e) {
            throw new KlarosServiceException((Throwable)e);
        }
    }

    @Override
    protected AbstractRepositoryConnector getConnector() {
        return this.connector;
    }

    public List<String> getAllProjects() throws KlarosServiceException {
        return Collections.emptyList();
    }

    public List<String> getAllProjectKeys() throws KlarosServiceException {
        return Collections.emptyList();
    }

    @Override
    protected TaskData readTaskData(String taskId) throws CoreException {
        return this.connector.getTaskData(this.getRepository(), taskId, Policy.monitorFor(null));
    }

    @Override
    public String storeIssue(IssueModel issue, TaskData data) throws KlarosServiceException {
        if (!(issue instanceof TracIssueModel)) {
            throw new IllegalArgumentException("Illegal model instance class: " + issue.getClass().getName());
        }
        TracIssueModel model = (TracIssueModel)issue;
        HashSet attributes = new HashSet();
        data.getAttributeMapper().setValue(data.getRoot().createAttribute(TracAttribute.TYPE.getTracKey()), model.getType());
        if (model.getPriority() != null) {
            data.getAttributeMapper().setValue(data.getRoot().createAttribute(TracAttribute.PRIORITY.getTracKey()), model.getPriority());
        }
        if (model.getResolution() != null) {
            data.getAttributeMapper().setValue(data.getRoot().createAttribute(TracAttribute.RESOLUTION.getTracKey()), model.getResolution());
        }
        if (model.getMilestone() != null) {
            data.getAttributeMapper().setValue(data.getRoot().createAttribute(TracAttribute.MILESTONE.getTracKey()), model.getMilestone());
        }
        if (model.getKeywords() != null) {
            data.getAttributeMapper().setValue(data.getRoot().createAttribute(TracAttribute.KEYWORDS.getTracKey()), model.getKeywords());
        }
        if (model.getOwner() != null) {
            data.getAttributeMapper().setValue(data.getRoot().createAttribute(TracAttribute.OWNER.getTracKey()), model.getOwner());
        }
        if (model.getSummary() != null) {
            data.getAttributeMapper().setValue(data.getRoot().createAttribute(TracAttribute.SUMMARY.getTracKey()), model.getSummary());
        }
        if (model.getStatus() != null) {
            data.getAttributeMapper().setValue(data.getRoot().createAttribute(TracAttribute.STATUS.getTracKey()), model.getStatus());
        }
        if (model.getDescription() != null) {
            data.getAttributeMapper().setValue(data.getRoot().createAttribute(TracAttribute.DESCRIPTION.getTracKey()), model.getDescription());
        }
        if (model.getComponent() != null) {
            data.getAttributeMapper().setValue(data.getRoot().createAttribute(TracAttribute.COMPONENT.getTracKey()), model.getComponent());
        }
        if (model.getVersion() != null) {
            data.getAttributeMapper().setValue(data.getRoot().createAttribute(TracAttribute.VERSION.getTracKey()), model.getVersion());
        }
        if (model.getCreationDate() != null) {
            data.getAttributeMapper().setDateValue(data.getRoot().createAttribute(TracAttribute.TIME.getTracKey()), model.getCreationDate());
        } else {
            data.getAttributeMapper().setDateValue(data.getRoot().createAttribute(TracAttribute.TIME.getTracKey()), new Date());
        }
        this.addCustomAttributes(data, model);
        try {
            RepositoryResponse response = this.getTaskDataHandler().postTaskData(this.getRepository(), data, attributes, Policy.monitorFor(null));
            return response.getTaskId();
        }
        catch (CoreException e) {
            throw new KlarosServiceException(e.getStatus().getMessage(), this.stripCoreException(e));
        }
        catch (RuntimeException e) {
            throw new KlarosServiceException((Throwable)e);
        }
    }

    private List<String> getRepositoryOptionValues(TracAttribute attribute) throws KlarosServiceException {
        try {
            ArrayList<String> result = new ArrayList<String>();
            Map<String, String> repositoryOptions = this.getRepositoryOptions(attribute);
            if (repositoryOptions != null) {
                result.addAll(repositoryOptions.values());
            }
            return result;
        }
        catch (RuntimeException | TracException e) {
            throw new KlarosServiceException(e);
        }
    }

    private Map<String, String> getRepositoryOptions(TracAttribute attribute) throws TracException {
        return TracAttributeMapper.getRepositoryOptions((ITracClient)this.getClient(false), (String)attribute.getTracKey());
    }

    public List<String> getTypes() throws KlarosServiceException {
        return this.getRepositoryOptionValues(TracAttribute.TYPE);
    }

    public List<String> getResolutions() throws KlarosServiceException {
        return this.getRepositoryOptionValues(TracAttribute.RESOLUTION);
    }

    public List<String> getMilestones() throws KlarosServiceException {
        return this.getRepositoryOptionValues(TracAttribute.MILESTONE);
    }

    public List<String> getComponents() throws KlarosServiceException {
        return this.getRepositoryOptionValues(TracAttribute.COMPONENT);
    }

    public List<String> getVersions() throws KlarosServiceException {
        return this.getRepositoryOptionValues(TracAttribute.VERSION);
    }

    public List<String> getPriorities() throws KlarosServiceException {
        return this.getRepositoryOptionValues(TracAttribute.PRIORITY);
    }

    public List<String> getStatuses() throws KlarosServiceException {
        return this.getRepositoryOptionValues(TracAttribute.STATUS);
    }

    @Override
    public boolean login(String loginUsername, String loginPassword) throws KlarosServiceException {
        boolean success = false;
        if (super.login(loginUsername, loginPassword)) {
            try {
                if (this.getClient(true).validate(Policy.monitorFor(null)) != null) {
                    success = true;
                } else {
                    LOG.debug(THREE_ARGS_STRING, new Object[]{"Login attempt with user name '", loginUsername, "' failed while retrieving repository information"});
                }
            }
            catch (TracLoginException e) {
                LOG.debug(THREE_ARGS_STRING, new Object[]{"Login attempt with user name '", loginUsername, "' fails silently with exception: ", e});
                ((KlarosTracRepositoryConnector)this.getConnector()).getClientManager().repositoryRemoved(this.getRepository());
            }
            catch (RuntimeException | TracRemoteException e) {
                throw new KlarosServiceException(e);
            }
            catch (TracException e) {
                ((KlarosTracRepositoryConnector)this.getConnector()).getClientManager().repositoryRemoved(this.getRepository());
                throw new KlarosServiceException((Throwable)e);
            }
        }
        LOG.debug(FOUR_ARGS_STRING, new Object[]{"Login attempt with user name '", loginUsername, "' yields success: ", success});
        return success;
    }

    @Override
    public void logout() {
        ((KlarosTracRepositoryConnector)this.getConnector()).getClientManager().repositoryRemoved(this.getRepository());
        this.getRepository().setCredentials(AuthenticationType.HTTP, null, false);
        super.logout();
    }

    public void terminate() {
        this.logout();
    }

    public String checkConnection() {
        String result = null;
        try {
            this.login(UUID.randomUUID().toString(), UUID.randomUUID().toString());
        }
        catch (KlarosServiceException | RuntimeException e) {
            LOG.debug("Handling exception", e);
            if (e.getCause() != null) {
                if (!(e.getCause() instanceof TracLoginException) && !(e.getCause() instanceof TracRemoteException)) {
                    result = e.getCause().getMessage();
                }
            } else {
                result = e.getMessage();
            }
        }
        finally {
            this.logout();
        }
        LOG.debug("{}{}' {}{}", new Object[]{"Checking connection with URL '", this.getRepository().getUrl(), " fails with message: ", result});
        return result;
    }

    public boolean checkAuthentication(String username, String password) throws KlarosServiceException {
        try {
            if (this.login(username, password)) {
                if (this.getClient(false).validate(Policy.monitorFor(null)) != null) {
                    try {
                        this.getConnector().getTaskData(this.getRepository(), Integer.toString(Integer.MAX_VALUE), Policy.monitorFor(null));
                    }
                    catch (CoreException e) {
                        LOG.debug("Handling exception", (Throwable)e);
                        if (e.getMessage().contains("Ticket 2147483647 does not exist")) {
                            boolean result = this.canQuery() && this.canCreateNewTask();
                            LOG.debug(FOUR_ARGS_STRING, new Object[]{"Checking authentication for user name '", username, "' yields success: ", result});
                            return result;
                        }
                        LOG.debug("Trying to get the ticket with the ID 2147483647 didn't throw the expected exception message 'Ticket 2147483647 does not exist'", (Throwable)e);
                    }
                } else {
                    LOG.debug(THREE_ARGS_STRING, new Object[]{"Checking authentication for user name '", username, "' failed while retrieving repository information"});
                }
            } else {
                LOG.debug("{}{}' FAILED", (Object)"Checking authentication for user name '", (Object)username);
            }
        }
        catch (KlarosServiceException | RuntimeException e) {
            String msg = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            if (!(e.getCause() instanceof TracRemoteException)) {
                LOG.debug(FOUR_ARGS_STRING, new Object[]{"Checking authentication for user name '", username, "' fails with exception: ", msg});
                throw new KlarosServiceException(e);
            }
            LOG.debug(FOUR_ARGS_STRING, new Object[]{"Checking authentication for user name '", username, "' fails silently with exception: ", msg});
        }
        catch (TracLoginException | TracRemoteException e) {
            LOG.debug(FOUR_ARGS_STRING, new Object[]{"Checking authentication for user name '", username, "' fails silently with exception: ", e});
        }
        catch (TracException e) {
            throw new KlarosServiceException((Throwable)e);
        }
        return false;
    }

    public String getProjectKey() {
        return null;
    }

    @Override
    public boolean hasProject(String key) throws KlarosServiceException {
        return true;
    }

    public Map<String, IssueCustomField> getCustomFields(String taskType) throws KlarosServiceException {
        HashMap<String, IssueCustomField> result = new HashMap<String, IssueCustomField>();
        try {
            TracTicketField[] tracTicketFields = this.getClient(false).getTicketFields();
            if (tracTicketFields != null) {
                for (TracTicketField field : tracTicketFields) {
                    if (!field.isCustom()) continue;
                    MylynIssueCustomField mylynIssueCustomField = new MylynIssueCustomField(field.getName(), field.getLabel(), field.getName(), MylynIssueCustomFieldType.fromTrac(field.getType().toString()), field.getOptions() != null ? ListUtil.getList((Object[])field.getOptions()) : new ArrayList(), field.getDefaultValue(), field.isOptional());
                    result.put(mylynIssueCustomField.getId(), mylynIssueCustomField);
                }
            }
        }
        catch (RuntimeException | TracException e) {
            throw new KlarosServiceException(e);
        }
        return result;
    }

    public TracIssueModel createNewIssue(String type) throws KlarosServiceException {
        TaskData newTaskData = this.createNewTaskData();
        newTaskData.getAttributeMapper().setValue(newTaskData.getRoot().createAttribute(TracAttribute.TYPE.getTracKey()), type);
        return this.buildIssue(newTaskData);
    }

    protected TracIssueModel buildIssue(TaskData taskData) throws KlarosServiceException {
        return new TracIssueModel(this.getConnector().getTaskMapping(taskData), this.loadCustomFieldAttributes(this.getConnector().getTaskMapping(taskData), this.getCustomFields(null)), this.getCustomFields(null), taskData);
    }

    public String getBrowseIssueUrl(String id) {
        return this.getServiceType().getBrowseIssueUrl(this.getRepositoryUrl(), id);
    }

    public IssueManagementServiceType getServiceType() {
        return IssueManagementServiceType.TRAC;
    }

    @Override
    protected ITaskMapping getInitialTaskMapping() {
        return null;
    }

    @Override
    protected Map<String, IssueCustomAttribute> loadCustomFieldAttributes(ITaskMapping taskMapping, Map<String, IssueCustomField> customFields) {
        HashMap<String, IssueCustomAttribute> result = new HashMap<String, IssueCustomAttribute>();
        for (Map.Entry entry : taskMapping.getTaskData().getRoot().getAttributes().entrySet()) {
            TaskAttribute attribute = (TaskAttribute)entry.getValue();
            String type = attribute.getMetaData().getValue("task.meta.type");
            IssueCustomField customField = customFields.get(attribute.getId());
            if (customField == null || "operation".equals(type)) continue;
            MylynIssueCustomAttribute field = new MylynIssueCustomAttribute(attribute.getId(), customField.getDescription(), attribute.getValue(), attribute.getValues(), MylynIssueCustomFieldType.fromTrac(type), customField.isOptional());
            result.put(field.getId(), field);
        }
        return result;
    }
}

