/*
 * Decompiled with CFR 0.152.
 */
package de.verit.klaros.service.issuemanagement.mylyn.trac;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.internal.trac.core.TracClientFactory;
import org.eclipse.mylyn.internal.trac.core.TracClientManager;
import org.eclipse.mylyn.internal.trac.core.client.ITracClient;
import org.eclipse.mylyn.internal.trac.core.client.TracClientData;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskRepositoryLocationFactory;

public class KlarosTracClientManager
extends TracClientManager {
    private final Map<String, ITracClient> clientByUrl = new HashMap<String, ITracClient>();
    private final Map<String, TracClientData> clientDataByUrl = new HashMap<String, TracClientData>();
    private String sessionName;

    public KlarosTracClientManager(String session, TaskRepositoryLocationFactory taskRepositoryLocationFactory) {
        super(null, taskRepositoryLocationFactory);
        this.sessionName = session;
    }

    public synchronized ITracClient getTracClient(TaskRepository taskRepository) {
        String effectiveURL = this.sessionName + ":" + taskRepository.getRepositoryUrl();
        ITracClient repository = this.clientByUrl.get(effectiveURL);
        if (repository == null) {
            AbstractWebLocation location = this.getTaskRepositoryLocationFactory().createWebLocation(taskRepository);
            repository = TracClientFactory.createClient((AbstractWebLocation)location, (ITracClient.Version)ITracClient.Version.fromVersion((String)taskRepository.getVersion()));
            this.clientByUrl.put(effectiveURL, repository);
            TracClientData data = this.clientDataByUrl.get(effectiveURL);
            if (data == null) {
                data = new TracClientData();
                this.clientDataByUrl.put(effectiveURL, data);
            }
            repository.setData(data);
        }
        return repository;
    }

    public void repositoriesRead() {
    }

    public synchronized void repositoryAdded(TaskRepository repository) {
        this.removeClient(repository);
        String effectiveURL = this.sessionName + ":" + repository.getRepositoryUrl();
        this.clientDataByUrl.remove(effectiveURL);
    }

    public void clearClients() {
        this.clientByUrl.clear();
    }

    private synchronized void removeClient(TaskRepository repository) {
        String effectiveURL = this.sessionName + ":" + repository.getRepositoryUrl();
        this.clientByUrl.remove(effectiveURL);
    }

    public synchronized void repositoryRemoved(TaskRepository repository) {
        this.removeClient(repository);
        String effectiveURL = this.sessionName + ":" + repository.getRepositoryUrl();
        this.clientDataByUrl.remove(effectiveURL);
    }

    public synchronized void repositorySettingsChanged(TaskRepository repository) {
        this.removeClient(repository);
        String effectiveURL = this.sessionName + ":" + repository.getRepositoryUrl();
        this.clientDataByUrl.remove(effectiveURL);
    }

    public void readCache() {
    }

    public void writeCache() {
    }
}

