/*
 * Decompiled with CFR 0.152.
 */
package de.verit.klaros.service.issuemanagement.mylyn.mantis;

import com.itsolut.mantis.core.model.MantisTicket;
import de.verit.klaros.service.issuemanagement.IssueCustomAttribute;
import de.verit.klaros.service.issuemanagement.IssueCustomField;
import de.verit.klaros.service.issuemanagement.IssueManagementServiceType;
import de.verit.klaros.service.issuemanagement.mylyn.MylynIssueModel;
import java.util.Map;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class MantisIssueModel
extends MylynIssueModel {
    private static final long serialVersionUID = -756098685186898781L;
    private String category;
    private String severity;
    private String reproducibility;
    private String additionalInformation;
    private String assignedTo;
    private String productVersion;
    private String targetVersion;
    private String fixedInVersion;
    private String stepsToReproduce;

    public MantisIssueModel(ITaskMapping taskMapping, Map<String, IssueCustomAttribute> customFieldAttributes, Map<String, IssueCustomField> customFields, TaskData taskData) {
        super(taskMapping, customFieldAttributes, customFields);
        TaskAttribute stepsToReproduceAttribute;
        TaskAttribute fixedInVersionAttribute;
        TaskAttribute targetVersionAttribute;
        TaskAttribute productVersionAttribute;
        TaskAttribute assignedToAttribute;
        TaskAttribute additionalInformationAttribute;
        TaskAttribute reproducibilityAttribute;
        TaskAttribute categoryAttribute = taskData.getRoot().getAttribute(MantisTicket.Key.CATEOGRY.getKey());
        if (categoryAttribute != null) {
            this.category = categoryAttribute.getValue();
        }
        if ((reproducibilityAttribute = taskData.getRoot().getAttribute(MantisTicket.Key.REPRODUCIBILITY.getKey())) != null) {
            this.reproducibility = reproducibilityAttribute.getOption(reproducibilityAttribute.getValue());
        }
        if ((additionalInformationAttribute = taskData.getRoot().getAttribute(MantisTicket.Key.ADDITIONAL_INFO.getKey())) != null) {
            this.additionalInformation = additionalInformationAttribute.getValue();
        }
        if ((assignedToAttribute = taskData.getRoot().getAttribute(MantisTicket.Key.ASSIGNED_TO.getKey())) != null) {
            this.assignedTo = assignedToAttribute.getValue();
        }
        if ((productVersionAttribute = taskData.getRoot().getAttribute(MantisTicket.Key.VERSION.getKey())) != null) {
            this.productVersion = productVersionAttribute.getValue();
        }
        if ((targetVersionAttribute = taskData.getRoot().getAttribute(MantisTicket.Key.TARGET_VERSION.getKey())) != null) {
            this.targetVersion = targetVersionAttribute.getValue();
        }
        if ((fixedInVersionAttribute = taskData.getRoot().getAttribute(MantisTicket.Key.FIXED_IN.getKey())) != null) {
            this.fixedInVersion = fixedInVersionAttribute.getValue();
        }
        if ((stepsToReproduceAttribute = taskData.getRoot().getAttribute(MantisTicket.Key.STEPS_TO_REPRODUCE.getKey())) != null) {
            this.stepsToReproduce = stepsToReproduceAttribute.getValue();
        }
        this.setSeverity(taskMapping.getSeverity());
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getCategory() {
        return this.category;
    }

    public final String getSeverity() {
        return this.severity;
    }

    public final void setSeverity(String severity) {
        this.severity = severity;
    }

    public void setReproducibility(String reproducibility) {
        this.reproducibility = reproducibility;
    }

    public String getReproducibility() {
        return this.reproducibility;
    }

    public String getAdditionalInformation() {
        return this.additionalInformation;
    }

    public void setAdditionalInformation(String additionalInformation) {
        this.additionalInformation = additionalInformation;
    }

    public String getAssignedTo() {
        return this.assignedTo;
    }

    public void setAssignedTo(String assignedTo) {
        this.assignedTo = assignedTo;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public String getTargetVersion() {
        return this.targetVersion;
    }

    public void setTargetVersion(String targetVersion) {
        this.targetVersion = targetVersion;
    }

    public String getFixedInVersion() {
        return this.fixedInVersion;
    }

    public void setFixedInVersion(String fixedInVersion) {
        this.fixedInVersion = fixedInVersion;
    }

    public String getStepsToReproduce() {
        return this.stepsToReproduce;
    }

    public void setStepsToReproduce(String stepsToReproduce) {
        this.stepsToReproduce = stepsToReproduce;
    }

    public IssueManagementServiceType getServiceType() {
        return IssueManagementServiceType.MANTIS;
    }
}

