/*
 * Decompiled with CFR 0.152.
 */
package de.verit.klaros.service.issuemanagement.mylyn.jira;

import com.atlassian.connector.eclipse.internal.jira.core.JiraAttribute;
import com.atlassian.connector.eclipse.internal.jira.core.KlarosJiraClientFactory;
import com.atlassian.connector.eclipse.internal.jira.core.KlarosJiraRepositoryConnector;
import com.atlassian.connector.eclipse.internal.jira.core.KlarosJiraTaskDataHandler;
import com.atlassian.connector.eclipse.internal.jira.core.model.Component;
import com.atlassian.connector.eclipse.internal.jira.core.model.CustomField;
import com.atlassian.connector.eclipse.internal.jira.core.model.IssueType;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraIssue;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraStatus;
import com.atlassian.connector.eclipse.internal.jira.core.model.Priority;
import com.atlassian.connector.eclipse.internal.jira.core.model.Project;
import com.atlassian.connector.eclipse.internal.jira.core.model.Resolution;
import com.atlassian.connector.eclipse.internal.jira.core.model.Version;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraAuthenticationException;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraClient;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraClientCache;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraException;
import de.verit.klaros.exception.KlarosServiceException;
import de.verit.klaros.service.issuemanagement.IssueCustomAttribute;
import de.verit.klaros.service.issuemanagement.IssueCustomField;
import de.verit.klaros.service.issuemanagement.IssueManagementServiceType;
import de.verit.klaros.service.issuemanagement.IssueModel;
import de.verit.klaros.service.issuemanagement.mylyn.MylynIssueCustomAttribute;
import de.verit.klaros.service.issuemanagement.mylyn.MylynIssueCustomField;
import de.verit.klaros.service.issuemanagement.mylyn.MylynIssueCustomFieldType;
import de.verit.klaros.service.issuemanagement.mylyn.MylynIssueManagementService;
import de.verit.klaros.service.issuemanagement.mylyn.jira.JiraIssueModel;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskMapping;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraIssueManagementService
extends MylynIssueManagementService {
    private static final Logger LOG = LoggerFactory.getLogger(JiraIssueManagementService.class);
    private final KlarosJiraRepositoryConnector connector;
    private JiraClient client;
    private final String key;
    private final String session;

    public JiraIssueManagementService(String session, String url, String projectKey) {
        super("jira", url);
        this.session = session;
        this.connector = new KlarosJiraRepositoryConnector(session);
        this.client = KlarosJiraClientFactory.getDefault().getJiraClient(session, this.getRepository());
        this.key = projectKey;
    }

    @Override
    public boolean login(String loginUsername, String loginPassword) throws KlarosServiceException {
        boolean result = false;
        try {
            this.client = KlarosJiraClientFactory.getDefault().getJiraClient(this.session, this.getRepository());
            super.login(loginUsername, loginPassword);
            this.client.getCache().refreshServerInfo(Policy.monitorFor(null));
            result = true;
        }
        catch (JiraException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
        return result;
    }

    @Override
    public void logout() {
        super.logout();
        this.terminate();
    }

    public void terminate() {
        this.client.purgeSession();
        KlarosJiraClientFactory.getDefault().repositoryRemoved(this.session, this.getRepository());
    }

    public IssueModel getIssue(String issueId) throws KlarosServiceException {
        JiraIssueModel issue = null;
        try {
            TaskData taskData = this.connector.getTaskData(this.getRepository(), issueId, Policy.monitorFor(null));
            issue = this.buildIssue(taskData);
        }
        catch (CoreException e) {
            throw new KlarosServiceException(e.getStatus().getMessage(), this.stripCoreException(e));
        }
        catch (RuntimeException e) {
            throw new KlarosServiceException((Throwable)e);
        }
        return issue;
    }

    public IssueModel getIssueByKey(String issueKey) throws KlarosServiceException {
        try {
            JiraIssue jiraIssue = this.client.getIssueByKey(issueKey, Policy.monitorFor(null));
            if (jiraIssue != null) {
                TaskData taskData = this.getJiraTaskDataHandler().createTaskData(this.getRepository(), this.client, jiraIssue, null, Policy.monitorFor(null));
                return new JiraIssueModel((ITaskMapping)this.connector.getTaskMapping(taskData), this.loadCustomFieldAttributes((ITaskMapping)this.connector.getTaskMapping(taskData), this.getCustomFields(null)), this.getCustomFields(null), taskData);
            }
            throw new CoreException((IStatus)new Status(4, "com.atlassian.connector.eclipse.internal.jira.core", 0, "JIRA ticket not found: " + issueKey, null));
        }
        catch (CoreException e) {
            throw new KlarosServiceException(e.getStatus().getMessage(), this.stripCoreException(e));
        }
        catch (JiraException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
    }

    private KlarosJiraTaskDataHandler getJiraTaskDataHandler() {
        return this.connector.getTaskDataHandler();
    }

    public List<String> getAllProjects() throws KlarosServiceException {
        try {
            this.client.getCache().refreshDetails(Policy.monitorFor(null));
        }
        catch (JiraException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
        Project[] projects = this.client.getCache().getProjects();
        ArrayList<String> projectIds = new ArrayList<String>(projects.length);
        for (Project project : projects) {
            projectIds.add(project.getName());
        }
        return projectIds;
    }

    public List<String> getAllProjectKeys() throws KlarosServiceException {
        try {
            this.client.getCache().refreshDetails(Policy.monitorFor(null));
        }
        catch (JiraException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
        Project[] projects = this.client.getCache().getProjects();
        ArrayList<String> projectIds = new ArrayList<String>(projects.length);
        for (Project project : projects) {
            projectIds.add(project.getKey());
        }
        return projectIds;
    }

    @Override
    public AbstractRepositoryConnector getConnector() {
        return this.connector;
    }

    @Override
    protected TaskData readTaskData(String taskId) throws CoreException {
        TaskData taskData = this.connector.getTaskData(this.getRepository(), taskId, Policy.monitorFor(null));
        taskData.getRoot().removeAttribute("attribute.jira.read-only");
        return taskData;
    }

    @Override
    protected String storeIssue(IssueModel issue, TaskData data) throws KlarosServiceException {
        if (!(issue instanceof JiraIssueModel)) {
            throw new IllegalArgumentException("Illegal model instance class: " + issue.getClass().getName());
        }
        JiraIssueModel model = (JiraIssueModel)issue;
        try {
            this.getProject();
            HashSet<TaskAttribute> attributes = new HashSet<TaskAttribute>();
            data.getAttributeMapper().setValue(data.getRoot().createAttribute(JiraAttribute.PROJECT.id()), this.getProjectId());
            this.setMappedTaskDataValue(model.getType(), JiraAttribute.TYPE.id(), data);
            this.setMappedTaskDataValues(model.getComponents(), JiraAttribute.COMPONENTS.id(), data);
            this.setMappedTaskDataValue(model.getPriority(), JiraAttribute.PRIORITY.id(), data);
            if (model.getResolution() != null && model.getResolution().length() > 0) {
                this.setMappedTaskDataValue(model.getResolution(), JiraAttribute.RESOLUTION.id(), data);
            }
            this.setMappedTaskDataValues(model.getFixVersions(), JiraAttribute.FIXVERSIONS.id(), data);
            this.setMappedTaskDataValues(model.getAffectedVersions(), JiraAttribute.AFFECTSVERSIONS.id(), data);
            data.getAttributeMapper().setValue(data.getRoot().createAttribute(JiraAttribute.ENVIRONMENT.id()), model.getEnvironment());
            if (model.getOwner() != null) {
                data.getAttributeMapper().setValue(data.getRoot().createAttribute(JiraAttribute.USER_ASSIGNED.id()), model.getOwner());
            }
            data.getAttributeMapper().setValue(data.getRoot().createAttribute(JiraAttribute.SUMMARY.id()), model.getSummary());
            data.getAttributeMapper().setValue(data.getRoot().createAttribute(JiraAttribute.STATUS.id()), model.getStatus());
            data.getAttributeMapper().setValue(data.getRoot().createAttribute(JiraAttribute.DESCRIPTION.id()), model.getDescription());
            data.getAttributeMapper().setDateValue(data.getRoot().createAttribute(JiraAttribute.DUE_DATE.id()), model.getDueDate());
            if (model.getCreationDate() != null) {
                data.getAttributeMapper().setDateValue(data.getRoot().createAttribute(JiraAttribute.CREATION_DATE.id()), model.getCreationDate());
            } else {
                data.getAttributeMapper().setDateValue(data.getRoot().createAttribute(JiraAttribute.CREATION_DATE.id()), new Date());
            }
            this.addCustomAttributes(data, model);
            RepositoryResponse response = this.getJiraTaskDataHandler().postTaskData(this.getRepository(), data, attributes, Policy.monitorFor(null));
            return response.getTaskId();
        }
        catch (CoreException e) {
            throw new KlarosServiceException(e.getStatus().getMessage(), this.stripCoreException(e));
        }
        catch (JiraException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
    }

    public List<String> getComponents() throws KlarosServiceException {
        try {
            Project project = this.getProject();
            ArrayList<String> result = new ArrayList<String>(project.getComponents().length);
            for (Component component : project.getComponents()) {
                result.add(component.getName());
            }
            return result;
        }
        catch (JiraException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
    }

    public List<String> getPriorities() throws KlarosServiceException {
        try {
            Priority[] priorities = this.getClientCache().getPriorities();
            ArrayList<String> result = new ArrayList<String>(priorities.length);
            for (Priority priority : priorities) {
                result.add(priority.getName());
            }
            return result;
        }
        catch (JiraException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
    }

    public List<String> getResolutions() throws KlarosServiceException {
        try {
            Resolution[] resolutions = this.getClientCache().getResolutions();
            ArrayList<String> result = new ArrayList<String>(resolutions.length);
            for (Resolution resolution : resolutions) {
                result.add(resolution.getName());
            }
            return result;
        }
        catch (JiraException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
    }

    public List<String> getStatuses() throws KlarosServiceException {
        try {
            JiraStatus[] statuses = this.getClientCache().getStatuses();
            ArrayList<String> result = new ArrayList<String>(statuses.length);
            for (JiraStatus status : statuses) {
                result.add(status.getName());
            }
            return result;
        }
        catch (JiraException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
    }

    public List<String> getTypes() throws KlarosServiceException {
        try {
            IssueType[] issueTypes = this.getProject().getIssueTypes();
            ArrayList<String> result = new ArrayList<String>(issueTypes.length);
            for (IssueType type : issueTypes) {
                if (type.isSubTaskType()) continue;
                result.add(type.getName());
            }
            return result;
        }
        catch (JiraException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
    }

    public List<String> getVersions() throws KlarosServiceException {
        try {
            Version[] versions = this.getProject().getVersions();
            ArrayList<String> result = new ArrayList<String>(versions.length);
            for (Version version : versions) {
                result.add(version.getName());
            }
            return result;
        }
        catch (JiraException | RuntimeException e) {
            throw new KlarosServiceException(e);
        }
    }

    private String getProjectId() throws JiraException, KlarosServiceException {
        Project project = this.getClientCache().getProjectByKey(this.key);
        if (project == null) {
            throw new KlarosServiceException("Project key not found: " + this.key);
        }
        return project.getId();
    }

    private Project getProject() throws JiraException, KlarosServiceException {
        Project project = this.client.getCache().getProjectByKey(this.key);
        if (project == null || !project.hasDetails()) {
            project = this.client.getCache().refreshProjectDetails(this.getProjectId(), null);
        }
        return project;
    }

    private JiraClientCache getClientCache() throws JiraException {
        if (!this.client.getCache().hasDetails()) {
            this.client.getCache().refreshDetails(null);
        }
        return this.client.getCache();
    }

    public String checkConnection() {
        String result = null;
        try {
            this.login(UUID.randomUUID().toString(), UUID.randomUUID().toString());
            this.getAllProjects();
        }
        catch (KlarosServiceException exception) {
            if (!(exception.getCause() instanceof JiraAuthenticationException)) {
                result = exception.getCause().toString();
            } else {
                LOG.debug("Ignoring exception, everything is ok, since we provided wrong credentials", (Throwable)exception);
            }
        }
        catch (RuntimeException e) {
            LOG.debug("Ignoring exception", (Throwable)e);
            result = e.getMessage();
        }
        finally {
            this.logout();
        }
        return result;
    }

    public boolean checkAuthentication(String username, String password) throws KlarosServiceException {
        boolean result = false;
        try {
            this.logout();
            if (this.login(username, password)) {
                if (this.getClientCache() != null) {
                    result = this.getAllProjectKeys().contains(this.getProjectKey());
                } else {
                    this.logout();
                }
            } else {
                this.logout();
            }
        }
        catch (KlarosServiceException e) {
            if (e.getCause() instanceof JiraAuthenticationException) {
                this.logout();
            }
            this.logout();
            throw new KlarosServiceException((Throwable)e);
        }
        catch (JiraAuthenticationException e) {
            this.logout();
        }
        catch (JiraException | RuntimeException e) {
            this.logout();
            throw new KlarosServiceException(e);
        }
        return result;
    }

    public String getProjectKey() {
        return this.key;
    }

    public Map<String, IssueCustomField> getCustomFields(String taskType) throws KlarosServiceException {
        HashMap<String, IssueCustomField> result = new HashMap<String, IssueCustomField>();
        TaskData data = new TaskData(this.getJiraTaskDataHandler().getAttributeMapper(this.getRepository()), this.getRepository().getConnectorKind(), this.getRepository().getUrl(), "");
        for (TaskAttribute attribute : data.getRoot().getAttributes().values()) {
            if (!attribute.getId().startsWith("attribute.jira.custom::")) continue;
            String id = attribute.getId().substring("attribute.jira.custom::".length());
            String type = attribute.getMetaData().getValue("type");
            CustomField field = new CustomField(id, type, "", attribute.getValues());
            MylynIssueCustomField mylynIssueCustomField = new MylynIssueCustomField(field.getId(), field.getName(), field.getName(), MylynIssueCustomFieldType.fromJira(field.getKey()), field.getValues(), null, false);
            result.put(mylynIssueCustomField.getId(), mylynIssueCustomField);
        }
        return result;
    }

    public JiraIssueModel createNewIssue(String type) throws KlarosServiceException {
        TaskData newTaskData = this.createNewTaskData();
        this.setTaskDataValue(type, JiraAttribute.TYPE.id(), newTaskData);
        return this.buildIssue(newTaskData);
    }

    protected JiraIssueModel buildIssue(TaskData taskData) throws KlarosServiceException {
        return new JiraIssueModel((ITaskMapping)this.connector.getTaskMapping(taskData), this.loadCustomFieldAttributes((ITaskMapping)this.connector.getTaskMapping(taskData), this.getCustomFields(null)), this.getCustomFields(null), taskData);
    }

    public String getBrowseIssueUrl(String id) {
        return this.getServiceType().getBrowseIssueUrl(this.getRepositoryUrl(), id);
    }

    public IssueManagementServiceType getServiceType() {
        return IssueManagementServiceType.JIRA;
    }

    @Override
    protected ITaskMapping getInitialTaskMapping() {
        return new TaskMapping(){

            public String getProduct() {
                return JiraIssueManagementService.this.key;
            }
        };
    }

    @Override
    protected Map<String, IssueCustomAttribute> loadCustomFieldAttributes(ITaskMapping taskMapping, Map<String, IssueCustomField> customFields) {
        HashMap<String, IssueCustomAttribute> result = new HashMap<String, IssueCustomAttribute>();
        for (Map.Entry entry : taskMapping.getTaskData().getRoot().getAttributes().entrySet()) {
            TaskAttribute attribute = (TaskAttribute)entry.getValue();
            if (!customFields.containsKey(attribute.getId())) continue;
            MylynIssueCustomAttribute field = new MylynIssueCustomAttribute(attribute.getId(), attribute.getMetaData().getLabel(), attribute.getValue(), attribute.getValues(), MylynIssueCustomFieldType.fromJira(attribute.getMetaData().getType()), customFields.get(attribute.getId()).isOptional());
            result.put(field.getId(), field);
        }
        return result;
    }
}

