/*
 * Decompiled with CFR 0.152.
 */
package de.verit.klaros.service.issuemanagement.mylyn.gitlab;

import de.verit.klaros.exception.KlarosServiceException;
import de.verit.klaros.service.issuemanagement.IssueCustomAttribute;
import de.verit.klaros.service.issuemanagement.IssueCustomField;
import de.verit.klaros.service.issuemanagement.IssueManagementServiceType;
import de.verit.klaros.service.issuemanagement.IssueModel;
import de.verit.klaros.service.issuemanagement.mylyn.MylynIssueManagementService;
import de.verit.klaros.service.issuemanagement.mylyn.gitlab.GitLabIssueModel;
import de.weingardt.mylyn.gitlab.core.ConnectionManager;
import de.weingardt.mylyn.gitlab.core.GitlabAttribute;
import de.weingardt.mylyn.gitlab.core.GitlabConnection;
import de.weingardt.mylyn.gitlab.core.GitlabConnector;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.gitlab.api.GitlabAPI;
import org.gitlab.api.models.GitlabMilestone;
import org.gitlab.api.models.GitlabProjectMember;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitLabIssueManagementService
extends MylynIssueManagementService {
    private static final Logger LOG = LoggerFactory.getLogger(GitLabIssueManagementService.class);
    private final GitlabConnector connector = new GitlabConnector();

    public GitLabIssueManagementService(String url) {
        super("gitlab", url);
    }

    public IssueModel getIssue(String issueId) throws KlarosServiceException {
        try {
            TaskData taskData = this.getConnector().getTaskData(this.getRepository(), issueId, Policy.monitorFor(null));
            return this.buildIssue(taskData);
        }
        catch (CoreException e) {
            throw new KlarosServiceException(e.getStatus().getMessage(), this.stripCoreException(e));
        }
        catch (RuntimeException e) {
            throw new KlarosServiceException((Throwable)e);
        }
    }

    @Override
    public AbstractRepositoryConnector getConnector() {
        return this.connector;
    }

    GitlabConnector getGitLabConnector() {
        return (GitlabConnector)this.getConnector();
    }

    TaskRepository getGitLabRepository() {
        return this.getRepository();
    }

    @Override
    protected TaskData readTaskData(String taskId) throws CoreException {
        return this.getGitLabConnector().getTaskData(this.getRepository(), taskId, Policy.monitorFor(null));
    }

    @Override
    public String storeIssue(IssueModel issue, TaskData data) throws KlarosServiceException {
        if (!(issue instanceof GitLabIssueModel)) {
            throw new IllegalArgumentException("Illegal model instance class: " + issue.getClass().getName());
        }
        GitLabIssueModel model = (GitLabIssueModel)issue;
        try {
            HashSet oldAttributes = new HashSet(data.getRoot().getAttributes().values());
            this.setTaskDataValue(model.getAction(), "task.common.operation", data);
            if (!data.isNew()) {
                this.setTaskDataValue(model.getStatus(), GitlabAttribute.STATUS.getTaskKey(), data);
            }
            this.setTaskDataValue(model.getDescription(), GitlabAttribute.BODY.getTaskKey(), data);
            this.setTaskDataValue(model.getSummary(), GitlabAttribute.TITLE.getTaskKey(), data);
            this.setTaskDataValue(model.getAssignee() == null ? "" : model.getAssignee(), GitlabAttribute.ASSIGNEE.getTaskKey(), data);
            this.setTaskDataValue(StringUtils.join(model.getLabels(), (String)","), GitlabAttribute.LABELS.getTaskKey(), data);
            this.setTaskDataValue(model.getMilestone() == null ? "" : model.getMilestone(), GitlabAttribute.MILESTONE.getTaskKey(), data);
            this.addCustomAttributes(data, model);
            RepositoryResponse response = this.getTaskDataHandler().postTaskData(this.getRepository(), data, oldAttributes, Policy.monitorFor(null));
            return response.getTaskId();
        }
        catch (CoreException e) {
            throw new KlarosServiceException(e.getStatus().getMessage(), this.stripCoreException(e));
        }
        catch (RuntimeException e) {
            throw new KlarosServiceException((Throwable)e);
        }
    }

    public void terminate() {
    }

    @Override
    public boolean login(String loginUsername, String loginPassword) throws KlarosServiceException {
        try {
            AuthenticationCredentials credentials = new AuthenticationCredentials(loginUsername, loginPassword);
            this.getRepository().setCredentials(AuthenticationType.REPOSITORY, credentials, false);
            this.getRepository().setProperty("usePrivateToken", Boolean.TRUE.toString());
            this.getRepository().setProperty("gitlabBaseUrl", "");
            return ConnectionManager.get((TaskRepository)this.getRepository()).getMilestones() != null;
        }
        catch (CoreException e) {
            throw new KlarosServiceException(e.getStatus().getMessage(), this.stripCoreException(e));
        }
        catch (RuntimeException e) {
            throw new KlarosServiceException((Throwable)e);
        }
    }

    public String checkConnection() {
        String result;
        block2: {
            result = null;
            try {
                AuthenticationCredentials credentials = new AuthenticationCredentials("", "");
                this.getRepository().setCredentials(AuthenticationType.REPOSITORY, credentials, false);
                this.getGitLabRepository().setProperty("usePrivateToken", Boolean.TRUE.toString());
                this.getGitLabRepository().setProperty("gitlabBaseUrl", "");
                GitlabConnector.validate((TaskRepository)this.getGitLabRepository());
            }
            catch (RuntimeException | CoreException e) {
                LOG.debug("Ignoring exception", e);
                this.logout();
                if (StringUtils.containsIgnoreCase((CharSequence)e.getMessage(), (CharSequence)"insufficient access rights")) break block2;
                result = e.getMessage();
            }
        }
        return result;
    }

    public List<String> getAssignableMembers() throws KlarosServiceException {
        try {
            List members = ConnectionManager.get((TaskRepository)this.getRepository()).getProjectMembers();
            ArrayList<String> results = new ArrayList<String>(members.size());
            for (GitlabProjectMember member : members) {
                results.add(member.getName());
            }
            results.sort((o1, o2) -> o1.compareTo((String)o2));
            return results;
        }
        catch (CoreException e) {
            throw new KlarosServiceException(e.getStatus().getMessage(), this.stripCoreException(e));
        }
        catch (RuntimeException e) {
            throw new KlarosServiceException((Throwable)e);
        }
    }

    public List<String> getMilestones() throws KlarosServiceException {
        try {
            List milestones = ConnectionManager.get((TaskRepository)this.getRepository()).getMilestones();
            ArrayList<String> results = new ArrayList<String>(milestones.size());
            results.add("");
            for (GitlabMilestone milestone : milestones) {
                results.add(milestone.getTitle());
            }
            return results;
        }
        catch (CoreException e) {
            throw new KlarosServiceException(e.getStatus().getMessage(), this.stripCoreException(e));
        }
        catch (RuntimeException e) {
            throw new KlarosServiceException((Throwable)e);
        }
    }

    public boolean checkAuthentication(String username, String password) throws KlarosServiceException {
        block3: {
            try {
                if (this.login(username, password)) {
                    return this.probeUnknownIssue();
                }
            }
            catch (RuntimeException e) {
                this.logout();
                if (StringUtils.containsIgnoreCase((CharSequence)e.getMessage(), (CharSequence)"Access Denied") || StringUtils.containsIgnoreCase((CharSequence)e.getMessage(), (CharSequence)"Bad credentials")) break block3;
                throw new KlarosServiceException((Throwable)e);
            }
        }
        return false;
    }

    private boolean probeUnknownIssue() throws KlarosServiceException {
        try {
            GitlabConnection connection = ConnectionManager.get((TaskRepository)this.getRepository());
            GitlabAPI api = connection.api();
            api.getIssue((Serializable)connection.project.getId(), Integer.valueOf(Integer.MAX_VALUE));
        }
        catch (FileNotFoundException e) {
            if (StringUtils.containsIgnoreCase((CharSequence)e.getMessage(), (CharSequence)Integer.toString(Integer.MAX_VALUE))) {
                return true;
            }
            this.logout();
            throw new KlarosServiceException((Throwable)e);
        }
        catch (IOException | RuntimeException | CoreException e) {
            this.logout();
            throw new KlarosServiceException(e);
        }
        return false;
    }

    public List<String> getAllProjects() throws KlarosServiceException {
        return Collections.emptyList();
    }

    public List<String> getAllProjectKeys() throws KlarosServiceException {
        return Collections.emptyList();
    }

    public String getProjectKey() {
        return null;
    }

    @Override
    public boolean hasProject(String name) throws KlarosServiceException {
        return true;
    }

    public Map<String, IssueCustomField> getCustomFields(String ignoredTrackerType) throws KlarosServiceException {
        return new HashMap<String, IssueCustomField>();
    }

    public List<String> getComponents() throws KlarosServiceException {
        return new ArrayList<String>();
    }

    public GitLabIssueModel createNewIssue(String type) throws KlarosServiceException {
        return this.buildIssue(this.createNewTaskData());
    }

    public GitLabIssueModel buildIssue(TaskData taskData) throws KlarosServiceException {
        GitLabIssueModel result = new GitLabIssueModel(this.connector.getTaskMapping(taskData), this.loadCustomFieldAttributes(this.connector.getTaskMapping(taskData), this.getCustomFields(null)), this.getCustomFields(null), taskData);
        HashMap<String, IssueCustomAttribute> validCustomFields = new HashMap<String, IssueCustomAttribute>();
        for (String customFieldName : this.getCustomFields(null).keySet()) {
            if (result.getCustomFieldAttributes().get(customFieldName) == null) continue;
            validCustomFields.put(customFieldName, (IssueCustomAttribute)result.getCustomFieldAttributes().get(customFieldName));
        }
        result.getCustomFieldAttributes().clear();
        result.getCustomFieldAttributes().putAll(validCustomFields);
        return result;
    }

    public String getBrowseIssueUrl(String id) {
        return this.getServiceType().getBrowseIssueUrl(this.getRepositoryUrl(), id);
    }

    public IssueManagementServiceType getServiceType() {
        return IssueManagementServiceType.GITLAB;
    }

    public List<String> getStatuses() throws KlarosServiceException {
        ArrayList<String> result = new ArrayList<String>();
        result.add("opened");
        result.add("closed");
        return result;
    }

    public List<String> getPriorities() throws KlarosServiceException {
        return new ArrayList<String>();
    }

    @Override
    protected ITaskMapping getInitialTaskMapping() {
        return null;
    }

    @Override
    protected Map<String, IssueCustomAttribute> loadCustomFieldAttributes(ITaskMapping taskMapping, Map<String, IssueCustomField> customFields) {
        return new HashMap<String, IssueCustomAttribute>();
    }
}

