/*
 * Decompiled with CFR 0.152.
 */
package de.verit.klaros.service.issuemanagement.mylyn.bugzilla;

import com.google.common.collect.Maps;
import de.verit.klaros.exception.KlarosServiceException;
import de.verit.klaros.service.issuemanagement.IssueCustomAttribute;
import de.verit.klaros.service.issuemanagement.IssueCustomField;
import de.verit.klaros.service.issuemanagement.IssueManagementServiceType;
import de.verit.klaros.service.issuemanagement.IssueModel;
import de.verit.klaros.service.issuemanagement.mylyn.MylynIssueCustomAttribute;
import de.verit.klaros.service.issuemanagement.mylyn.MylynIssueCustomField;
import de.verit.klaros.service.issuemanagement.mylyn.MylynIssueCustomFieldType;
import de.verit.klaros.service.issuemanagement.mylyn.MylynIssueManagementService;
import de.verit.klaros.service.issuemanagement.mylyn.bugzilla.BugzillaIssueModel;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClient;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClientManager;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaCustomField;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryLocation;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.TaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BugzillaIssueManagementService
extends MylynIssueManagementService {
    private static final Logger LOG = LoggerFactory.getLogger(BugzillaIssueManagementService.class);
    private static final String VALIDATION_FAILED_MSG_1 = "The username or password you entered is not valid.";
    private static final String VALIDATION_FAILED_MSG_2 = "invalid username or password";
    private static final String VALIDATION_FAILED_MSG_3 = "invalid login or password";
    private static final int AUTH_ERROR = 3;
    private final BugzillaRepositoryConnector connector = new BugzillaRepositoryConnector();
    private final String product;

    public BugzillaIssueManagementService(String url, String product) {
        super("bugzilla", url);
        this.product = product;
    }

    public String getProduct() {
        return this.product;
    }

    public List<String> getAllProjects() throws KlarosServiceException {
        return this.getRepositoryConfiguration().getProducts();
    }

    public List<String> getAllProjectKeys() throws KlarosServiceException {
        return this.getRepositoryConfiguration().getProducts();
    }

    public IssueModel getIssue(String issueId) throws KlarosServiceException {
        try {
            TaskData taskData = this.getBugzillaConnector().getTaskData(this.getRepository(), issueId, Policy.monitorFor(null));
            return this.buildIssue(taskData);
        }
        catch (CoreException e) {
            throw new KlarosServiceException(e.getStatus().getMessage(), this.stripCoreException(e));
        }
        catch (RuntimeException e) {
            throw new KlarosServiceException((Throwable)e);
        }
    }

    @Override
    protected AbstractRepositoryConnector getConnector() {
        return this.connector;
    }

    public BugzillaRepositoryConnector getBugzillaConnector() {
        return (BugzillaRepositoryConnector)this.getConnector();
    }

    @Override
    protected TaskData readTaskData(String taskId) throws CoreException {
        return this.getBugzillaConnector().getTaskData(this.getRepository(), taskId, Policy.monitorFor(null));
    }

    @Override
    public String storeIssue(IssueModel issue, TaskData data) throws KlarosServiceException {
        if (!(issue instanceof BugzillaIssueModel)) {
            throw new IllegalArgumentException("Illegal model instance class: " + issue.getClass().getName());
        }
        BugzillaIssueModel model = (BugzillaIssueModel)issue;
        HashSet attributes = new HashSet();
        try {
            BugzillaIssueManagementService.mapTaskAttribute(data, BugzillaAttribute.PRODUCT, this.product);
            BugzillaIssueManagementService.mapTaskAttribute(data, BugzillaAttribute.RESOLUTION, model.getResolution());
            BugzillaIssueManagementService.mapTaskAttribute(data, BugzillaAttribute.BLOCKED, model.getBlocked());
            BugzillaIssueManagementService.mapTaskAttribute(data, BugzillaAttribute.COMPONENT, model.getComponent());
            BugzillaIssueManagementService.mapTaskAttribute(data, BugzillaAttribute.DEPENDSON, model.getDependsOn());
            BugzillaIssueManagementService.mapTaskAttribute(data, BugzillaAttribute.DESC, model.getDescription());
            BugzillaIssueManagementService.mapTaskAttribute(data, BugzillaAttribute.ID, model.getId());
            BugzillaIssueManagementService.mapTaskAttribute(data, BugzillaAttribute.TARGET_MILESTONE, model.getMilestone());
            BugzillaIssueManagementService.mapTaskAttribute(data, BugzillaAttribute.OP_SYS, model.getOperatingSystem());
            BugzillaIssueManagementService.mapTaskAttribute(data, BugzillaAttribute.ASSIGNED_TO, model.getOwner());
            BugzillaIssueManagementService.mapTaskAttribute(data, BugzillaAttribute.REP_PLATFORM, model.getPlatform());
            BugzillaIssueManagementService.mapTaskAttribute(data, BugzillaAttribute.PRIORITY, model.getPriority());
            BugzillaIssueManagementService.mapTaskAttribute(data, BugzillaAttribute.RESOLUTION, model.getResolution());
            BugzillaIssueManagementService.mapTaskAttribute(data, BugzillaAttribute.BUG_SEVERITY, model.getSeverity());
            BugzillaIssueManagementService.mapTaskAttribute(data, BugzillaAttribute.BUG_STATUS, model.getStatus());
            BugzillaIssueManagementService.mapTaskAttribute(data, BugzillaAttribute.SHORT_DESC, model.getSummary());
            BugzillaIssueManagementService.mapTaskAttribute(data, BugzillaAttribute.BUG_FILE_LOC, model.getUrl());
            BugzillaIssueManagementService.mapTaskAttribute(data, BugzillaAttribute.VERSION, model.getVersion());
            this.addCustomAttributes(data, model);
            RepositoryResponse response = this.getTaskDataHandler().postTaskData(this.getRepository(), data, attributes, Policy.monitorFor(null));
            return response.getTaskId();
        }
        catch (CoreException e) {
            IStatus status = e.getStatus();
            if (status instanceof RepositoryStatus) {
                String message = ((RepositoryStatus)status).getMessage();
                throw new KlarosServiceException(message, (Throwable)e);
            }
            throw new KlarosServiceException(e.getStatus().getMessage(), this.stripCoreException(e));
        }
        catch (RuntimeException e) {
            throw new KlarosServiceException((Throwable)e);
        }
    }

    private static void mapTaskAttribute(TaskData data, BugzillaAttribute attribute, String value) {
        if (value != null) {
            TaskAttribute status = data.getRoot().createAttribute(attribute.getKey());
            status.getMetaData().setType(attribute.getType());
            data.getAttributeMapper().setValue(status, value);
        }
    }

    public List<String> getResolutions() throws KlarosServiceException {
        return this.getRepositoryConfiguration().getOptionValues(BugzillaAttribute.RESOLUTION);
    }

    public List<String> getSeverities() throws KlarosServiceException {
        return this.getRepositoryConfiguration().getSeverities();
    }

    public List<String> getComponents() throws KlarosServiceException {
        return this.getRepositoryConfiguration().getComponents(this.getProduct());
    }

    public List<String> getPriorities() throws KlarosServiceException {
        return this.getRepositoryConfiguration().getPriorities();
    }

    public List<String> getStatuses() throws KlarosServiceException {
        return this.getRepositoryConfiguration().getOptionValues(BugzillaAttribute.BUG_STATUS);
    }

    public List<String> getVersions() throws KlarosServiceException {
        return this.getRepositoryConfiguration().getVersions();
    }

    public List<String> getKeywords() throws KlarosServiceException {
        return this.getRepositoryConfiguration().getKeywords();
    }

    public List<String> getOperatingSystems() throws KlarosServiceException {
        return this.getRepositoryConfiguration().getOSs();
    }

    public List<String> getPlatforms() throws KlarosServiceException {
        return this.getRepositoryConfiguration().getPlatforms();
    }

    public List<String> getTargetMilestones() throws KlarosServiceException {
        return this.getRepositoryConfiguration().getTargetMilestones(this.getProduct());
    }

    public String getDefaultMilestones() throws KlarosServiceException {
        return this.getRepositoryConfiguration().getDefaultMilestones(this.getProduct());
    }

    private RepositoryConfiguration getRepositoryConfiguration() throws KlarosServiceException {
        RepositoryConfiguration result = null;
        try {
            result = this.getBugzillaConnector().getRepositoryConfiguration(this.getRepository().getUrl()) == null ? this.getBugzillaConnector().getRepositoryConfiguration(this.getRepository(), true, Policy.monitorFor(null)) : this.getBugzillaConnector().getRepositoryConfiguration(this.getRepository().getUrl());
        }
        catch (CoreException e) {
            throw new KlarosServiceException(e.getStatus().getMessage(), this.stripCoreException(e));
        }
        catch (RuntimeException e) {
            throw new KlarosServiceException((Throwable)e);
        }
        if (result != null) {
            return result;
        }
        throw new KlarosServiceException("Unable to retrieve the repository configuration.");
    }

    public void terminate() {
    }

    @Override
    public boolean login(String loginUsername, String loginPassword) throws KlarosServiceException {
        boolean result;
        try {
            this.getBugzillaConnector().getRepositoryConfiguration(this.getRepository(), true, Policy.monitorFor(null));
            AuthenticationCredentials credentials = new AuthenticationCredentials(loginUsername, loginPassword);
            this.getRepository().setCredentials(AuthenticationType.REPOSITORY, credentials, false);
            BugzillaClientManager manager = this.getBugzillaConnector().getClientManager();
            BugzillaClient client = manager.getClient(this.getRepository(), Policy.monitorFor(null));
            client.authenticate(Policy.monitorFor(null));
            client.getRepositoryConfiguration(Policy.monitorFor(null), null);
            result = true;
        }
        catch (CoreException e) {
            CoreException innerException;
            Throwable cause = e.getCause();
            if (cause instanceof CoreException ? (innerException = (CoreException)cause).getStatus().getCode() != 3 : e.getStatus().getCode() != 3) {
                throw new KlarosServiceException((Throwable)e);
            }
            result = false;
        }
        catch (IOException e) {
            LOG.debug("Ignoring", (Throwable)e);
            result = false;
        }
        catch (RuntimeException e) {
            throw new KlarosServiceException((Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String checkConnection() {
        String result = null;
        try {
            this.getBugzillaConnector().getRepositoryConfiguration(this.getRepository(), true, Policy.monitorFor(null));
            AuthenticationCredentials credentials = new AuthenticationCredentials(UUID.randomUUID().toString(), UUID.randomUUID().toString());
            this.getRepository().setCredentials(AuthenticationType.REPOSITORY, credentials, false);
            BugzillaClient client = new BugzillaClient((AbstractWebLocation)new TaskRepositoryLocation(this.getRepository()), this.getRepository(), this.getBugzillaConnector());
            client.authenticate(Policy.monitorFor(null));
            client.getRepositoryConfiguration(Policy.monitorFor(null), null);
        }
        catch (CoreException e) {
            LOG.debug("Handling core exception", (Throwable)e);
            if (e.getCause() != null) {
                if (e.getCause() instanceof CoreException) {
                    CoreException innerException = (CoreException)e.getCause();
                    if (!(innerException.getMessage().contains(VALIDATION_FAILED_MSG_1) || e.getMessage().contains(VALIDATION_FAILED_MSG_2) || e.getMessage().contains(VALIDATION_FAILED_MSG_3))) {
                        result = e.getCause().getMessage();
                    }
                } else {
                    result = e.getCause().getMessage();
                }
            } else if (!(e.getMessage().contains(VALIDATION_FAILED_MSG_1) || e.getMessage().contains(VALIDATION_FAILED_MSG_2) || e.getMessage().contains(VALIDATION_FAILED_MSG_3))) {
                result = e.getMessage();
            }
        }
        catch (IOException | RuntimeException e) {
            LOG.debug("Ignoring exception", (Throwable)e);
            result = e.getMessage();
        }
        finally {
            this.logout();
        }
        return result;
    }

    public boolean checkAuthentication(String username, String password) throws KlarosServiceException {
        try {
            this.logout();
            TaskRepository repository = this.getRepository();
            repository.setCredentials(AuthenticationType.REPOSITORY, new AuthenticationCredentials(username, password), false);
            BugzillaClient client = new BugzillaClient((AbstractWebLocation)new TaskRepositoryLocation(repository), repository, this.getBugzillaConnector());
            client.authenticate(Policy.monitorFor(null));
            return true;
        }
        catch (CoreException e) {
            if (!(e.getMessage().contains(VALIDATION_FAILED_MSG_1) || e.getMessage().contains(VALIDATION_FAILED_MSG_2) || e.getMessage().contains(VALIDATION_FAILED_MSG_3))) {
                throw new KlarosServiceException((Throwable)e);
            }
        }
        catch (RuntimeException | MalformedURLException e) {
            this.logout();
            throw new KlarosServiceException((Throwable)e);
        }
        return false;
    }

    public String getProjectKey() {
        return this.getProduct();
    }

    public Map<String, IssueCustomField> getCustomFields(String ignoredTrackerType) throws KlarosServiceException {
        List bugzillaCustomFields = this.getRepositoryConfiguration().getCustomFields();
        HashMap result = Maps.newHashMapWithExpectedSize((int)bugzillaCustomFields.size());
        for (BugzillaCustomField field : bugzillaCustomFields) {
            MylynIssueCustomField mylynIssueCustomField = new MylynIssueCustomField(field.getName(), field.getDescription(), field.getName(), MylynIssueCustomFieldType.fromBugzilla(field.getFieldType()), field.getOptions(), null, field.isEnterBug());
            result.put(mylynIssueCustomField.getId(), mylynIssueCustomField);
        }
        return result;
    }

    public BugzillaIssueModel createNewIssue(String type) throws KlarosServiceException {
        return new BugzillaIssueModel(this.getInitialTaskMapping(), this.loadCustomFieldAttributes(this.getInitialTaskMapping(), this.getCustomFields(null)), this.getCustomFields(null), this.createNewTaskData());
    }

    protected BugzillaIssueModel buildIssue(TaskData taskData) throws KlarosServiceException {
        return new BugzillaIssueModel((ITaskMapping)this.connector.getTaskMapping(taskData), this.loadCustomFieldAttributes((ITaskMapping)this.connector.getTaskMapping(taskData), this.getCustomFields(null)), this.getCustomFields(null), taskData);
    }

    public String getBrowseIssueUrl(String id) {
        return this.getServiceType().getBrowseIssueUrl(this.getRepositoryUrl(), id);
    }

    public IssueManagementServiceType getServiceType() {
        return IssueManagementServiceType.BUGZILLA;
    }

    @Override
    protected ITaskMapping getInitialTaskMapping() {
        return new TaskMapping(){

            public String getProduct() {
                return BugzillaIssueManagementService.this.product;
            }
        };
    }

    @Override
    protected Map<String, IssueCustomAttribute> loadCustomFieldAttributes(ITaskMapping taskMapping, Map<String, IssueCustomField> customFields) {
        HashMap<String, IssueCustomAttribute> result = new HashMap<String, IssueCustomAttribute>();
        if (taskMapping.getTaskData() != null) {
            for (Map.Entry entry : taskMapping.getTaskData().getRoot().getAttributes().entrySet()) {
                TaskAttribute attribute = (TaskAttribute)entry.getValue();
                if (!attribute.getId().startsWith("cf_")) continue;
                MylynIssueCustomAttribute field = new MylynIssueCustomAttribute(attribute.getId(), attribute.getMetaData().getLabel(), attribute.getValue(), attribute.getValues(), MylynIssueCustomFieldType.fromBugzilla(BugzillaCustomField.FieldType.convert((String)attribute.getMetaData().getType())), customFields.get(attribute.getId()).isOptional());
                result.put(field.getId(), field);
            }
        }
        return result;
    }
}

