/*
 * Decompiled with CFR 0.152.
 */
package de.verit.klaros.service.issuemanagement.mylyn;

import de.verit.klaros.service.issuemanagement.IssueCustomAttribute;
import de.verit.klaros.service.issuemanagement.IssueCustomFieldType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MylynIssueCustomAttribute
implements IssueCustomAttribute {
    public static final String DATE_TIME_PATTERN = "dd.MM.yyyy HH:mm";
    public static final String DATE_PATTERN = "dd.MM.yyyy";
    private static final long serialVersionUID = -1889577346287745577L;
    private static final Logger LOG = LoggerFactory.getLogger(MylynIssueCustomAttribute.class);
    private final String id;
    private final String label;
    private String value;
    private List<String> values;
    private final IssueCustomFieldType type;
    private final boolean optional;

    public MylynIssueCustomAttribute(String id, String label, String value, List<String> values, IssueCustomFieldType type, boolean optional) {
        this.id = id;
        this.label = label;
        this.value = value;
        this.values = values;
        this.type = type;
        this.optional = optional;
    }

    public IssueCustomFieldType getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getValue() {
        return this.value;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public Boolean getBooleanValue() {
        return Boolean.valueOf(this.value);
    }

    public void setBooleanValue(Boolean boolValue) {
        this.value = boolValue.toString();
    }

    public Date getDateValue() {
        Date result = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)this.value)) {
                result = new SimpleDateFormat(DATE_PATTERN).parse(this.value);
            }
        }
        catch (ParseException e) {
            LOG.warn("", (Throwable)e);
        }
        return result;
    }

    public void setDateValue(Date dateValue) {
        this.value = dateValue != null ? new SimpleDateFormat(DATE_PATTERN).format(dateValue) : null;
    }

    public Date getDateTimeValue() {
        Date result = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)this.value)) {
                result = new SimpleDateFormat(DATE_TIME_PATTERN).parse(this.value);
            }
        }
        catch (ParseException e) {
            LOG.warn("", (Throwable)e);
        }
        return result;
    }

    public void setDateTimeValue(Date dateValue) {
        this.value = dateValue != null ? new SimpleDateFormat(DATE_TIME_PATTERN).format(dateValue) : null;
    }

    public boolean isOptional() {
        return this.optional;
    }
}

