/*
 * Decompiled with CFR 0.152.
 */
package de.verit.klaros.service.issuemanagement.jira;

import com.atlassian.jira.rest.client.api.domain.BasicComponent;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.IssueField;
import com.atlassian.jira.rest.client.api.domain.Version;
import de.verit.klaros.service.issuemanagement.BaseIssueModel;
import de.verit.klaros.service.issuemanagement.IssueCustomAttribute;
import de.verit.klaros.service.issuemanagement.IssueCustomField;
import de.verit.klaros.service.issuemanagement.IssueManagementServiceType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.codehaus.jettison.json.JSONObject;
import org.joda.time.DateTime;

public class JiraRestIssueModel
extends BaseIssueModel
implements Serializable {
    private static final long serialVersionUID = 8253805305517458055L;
    private String key;
    private String project;
    private String type;
    private Date dueDate;
    private String environment;
    private List<String> fixVersions;
    private List<String> affectedVersions;
    private List<String> components;
    private String parent;

    public JiraRestIssueModel(Issue issue, Map<String, IssueCustomAttribute> customFieldAttributes, Map<String, IssueCustomField> customFields) {
        super(customFieldAttributes, customFields);
        DateTime lastChangedDateTime;
        IssueField environmentField;
        this.project = issue.getProject().getKey();
        this.type = issue.getIssueType().getName();
        this.key = issue.getKey();
        DateTime dueDateTime = issue.getDueDate();
        if (dueDateTime != null) {
            this.dueDate = new Date(dueDateTime.toDate().getTime());
        }
        if ((environmentField = issue.getFieldByName("environment")) != null) {
            this.environment = (String)environmentField.getValue();
        }
        this.affectedVersions = new ArrayList<String>();
        if (issue.getAffectedVersions() != null) {
            for (Version version : issue.getAffectedVersions()) {
                this.affectedVersions.add(version.getName());
            }
        }
        if (issue.getFixVersions() != null) {
            this.fixVersions = new ArrayList<String>();
            for (Version version : issue.getFixVersions()) {
                this.fixVersions.add(version.getName());
            }
        }
        this.components = new ArrayList<String>();
        for (BasicComponent component : issue.getComponents()) {
            this.components.add(component.getName());
        }
        this.setId(issue.getKey());
        if (issue.getAssignee() != null) {
            if (issue.getAssignee().getName() != null) {
                this.setOwner(issue.getAssignee().getName());
            } else {
                this.setOwner(issue.getAssignee().getAccountId());
            }
        } else {
            this.setOwner(null);
        }
        if (issue.getReporter() != null) {
            if (issue.getReporter().getName() != null) {
                this.setReporter(issue.getReporter().getName());
            } else {
                this.setReporter(issue.getReporter().getAccountId());
            }
        } else {
            this.setOwner(null);
        }
        this.setPriority(issue.getPriority() != null ? issue.getPriority().getName() : null);
        this.setResolution(issue.getResolution() != null ? issue.getResolution().getName() : null);
        this.setStatus(issue.getStatus() != null ? issue.getStatus().getName() : null);
        this.setSummary(issue.getSummary());
        this.setDescription(issue.getDescription());
        DateTime creationDateTime = issue.getCreationDate();
        if (creationDateTime != null) {
            this.setCreationDate(new Date(creationDateTime.toDate().getTime()));
        }
        if ((lastChangedDateTime = issue.getUpdateDate()) != null) {
            this.setLastChanged(new Date(lastChangedDateTime.toDate().getTime()));
        }
        if (issue.getIssueType().isSubtask()) {
            IssueField parentField = issue.getField("parent");
            this.parent = ((JSONObject)parentField.getValue()).optString("key");
        }
    }

    public JiraRestIssueModel(String projectKey, String type, Map<String, IssueCustomAttribute> customFieldAttributes, Map<String, IssueCustomField> customFields) {
        super(customFieldAttributes, customFields);
        this.project = projectKey;
        this.type = type;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getProject() {
        return this.project;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Date getDueDate() {
        if (this.dueDate != null) {
            return new Date(this.dueDate.getTime());
        }
        return null;
    }

    public void setDueDate(Date date) {
        if (date != null) {
            this.dueDate = new Date(date.getTime());
        }
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public List<String> getAffectedVersions() {
        return new ArrayList<String>(this.affectedVersions);
    }

    public void setAffectedVersions(List<String> affectedVersions) {
        this.affectedVersions = new ArrayList<String>(affectedVersions);
    }

    public List<String> getFixVersions() {
        return new ArrayList<String>(this.fixVersions);
    }

    public void setFixVersions(List<String> fixVersions) {
        this.fixVersions = new ArrayList<String>(fixVersions);
    }

    public List<String> getComponents() {
        return new ArrayList<String>(this.components);
    }

    public void setComponents(List<String> values) {
        this.components = new ArrayList<String>(values);
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public IssueManagementServiceType getServiceType() {
        return IssueManagementServiceType.JIRA_REST;
    }
}

