/*
 * Decompiled with CFR 0.152.
 */
package de.verit.klaros.service.issuemanagement.jira;

import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.HttpStatus;
import com.atlassian.httpclient.api.Response;
import com.atlassian.jira.rest.client.api.AuthenticationHandler;
import com.atlassian.jira.rest.client.api.GetCreateIssueMetadataOptions;
import com.atlassian.jira.rest.client.api.GetCreateIssueMetadataOptionsBuilder;
import com.atlassian.jira.rest.client.api.IssueRestClient;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.JiraRestClientFactory;
import com.atlassian.jira.rest.client.api.NamedEntity;
import com.atlassian.jira.rest.client.api.RestClientException;
import com.atlassian.jira.rest.client.api.domain.Attachment;
import com.atlassian.jira.rest.client.api.domain.BasicComponent;
import com.atlassian.jira.rest.client.api.domain.BasicIssue;
import com.atlassian.jira.rest.client.api.domain.BasicPriority;
import com.atlassian.jira.rest.client.api.domain.BasicProject;
import com.atlassian.jira.rest.client.api.domain.CimFieldInfo;
import com.atlassian.jira.rest.client.api.domain.CimIssueType;
import com.atlassian.jira.rest.client.api.domain.CimProject;
import com.atlassian.jira.rest.client.api.domain.CustomFieldOption;
import com.atlassian.jira.rest.client.api.domain.FieldSchema;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.IssueField;
import com.atlassian.jira.rest.client.api.domain.IssueFieldId;
import com.atlassian.jira.rest.client.api.domain.IssueType;
import com.atlassian.jira.rest.client.api.domain.Permissions;
import com.atlassian.jira.rest.client.api.domain.Priority;
import com.atlassian.jira.rest.client.api.domain.Project;
import com.atlassian.jira.rest.client.api.domain.Resolution;
import com.atlassian.jira.rest.client.api.domain.SearchResult;
import com.atlassian.jira.rest.client.api.domain.Status;
import com.atlassian.jira.rest.client.api.domain.Version;
import com.atlassian.jira.rest.client.api.domain.input.CannotTransformValueException;
import com.atlassian.jira.rest.client.api.domain.input.ComplexIssueInputFieldValue;
import com.atlassian.jira.rest.client.api.domain.input.FieldInput;
import com.atlassian.jira.rest.client.api.domain.input.IssueInput;
import com.atlassian.jira.rest.client.api.domain.input.IssueInputBuilder;
import com.atlassian.jira.rest.client.api.domain.input.MyPermissionsInput;
import com.atlassian.jira.rest.client.auth.BasicHttpAuthenticationHandler;
import com.atlassian.jira.rest.client.internal.async.AsynchronousExtendedIssueRestClient;
import com.atlassian.jira.rest.client.internal.async.AsynchronousHttpClientFactory;
import com.atlassian.jira.rest.client.internal.async.AsynchronousJiraRestClientFactory;
import com.atlassian.jira.rest.client.internal.async.DisposableHttpClient;
import com.atlassian.jira.rest.client.internal.async.ExtendedAsynchronousSearchRestClient;
import com.atlassian.jira.rest.client.internal.async.ExtendedMyPermissionsRestClient;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import de.verit.klaros.exception.KlarosImpossibleRuntimeException;
import de.verit.klaros.exception.KlarosServiceException;
import de.verit.klaros.service.connection.BaseExternalService;
import de.verit.klaros.service.issuemanagement.IssueCustomAttribute;
import de.verit.klaros.service.issuemanagement.IssueCustomField;
import de.verit.klaros.service.issuemanagement.IssueManagementService;
import de.verit.klaros.service.issuemanagement.IssueManagementServiceType;
import de.verit.klaros.service.issuemanagement.IssueModel;
import de.verit.klaros.service.issuemanagement.jira.JiraRestIssueModel;
import de.verit.klaros.service.issuemanagement.mylyn.MylynIssueCustomAttribute;
import de.verit.klaros.service.issuemanagement.mylyn.MylynIssueCustomField;
import de.verit.klaros.service.issuemanagement.mylyn.MylynIssueCustomFieldType;
import de.verit.klaros.util.ListUtil;
import de.verit.klaros.util.URLUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraRestIssueManagementService
extends BaseExternalService
implements IssueManagementService {
    protected static final String SCHEMA_TYPE_ARRAY = "array";
    protected static final String SCHEMA_TYPE_STRING = "string";
    protected static final String SCHEMA_TYPE_DATE = "date";
    private static final String CUSTOMFIELD_START = "customfield_";
    private static final String UNSUPPORTED_VERSION_SUB_TYPE_ENCOUNTERED_SKIPPING = "Unsupported version sub-type encountered, skipping: {}/{}";
    private static final String UNSUPPORTED_DATE_SUB_TYPE_ENCOUNTERED_SKIPPING = "Unsupported date sub-type encountered, skipping: {}/{}";
    private static final String UNSUPPORTED_USER_SUB_TYPE_ENCOUNTERED_SKIPPING = "Unsupported user sub-type encountered, skipping: {}/{}";
    private static final String UNSUPPORTED_ANY_SUB_TYPE_DETECTED = "Unsupported any sub-type encountered, skipping: {}/{}";
    private static final String UNSUPPORTED_VERSION_SUB_TYPE_DETECTED = "Unsupported version sub-type encountered, skipping: {}/{}";
    private static final String UNSUPPORTED_STRING_SUB_TYPE_DETECTED = "Unsupported string sub-type encountered, skipping: {}/{}";
    private static final String UNSUPPORTED_NUMBER_SUB_TYPE_DETECTED = "Unsupported number sub-type encountered, skipping: {}/{}";
    private static final String UNSUPPORTED_OPTION_SUB_TYPE_DETECTED = "Unsupported option sub-type encountered, skipping: {}/{}";
    private static final String UNSUPPORTED_GROUP_SUB_TYPE_DETECTED = "Unsupported group sub-type encountered, skipping: {}/{}";
    private static final String UNSUPPORTED_PROJECT_SUB_TYPE_DETECTED = "Unsupported project sub-type encountered, skipping: {}/{}";
    private static final String UNSUPPORTED_OPTION_WITH_CHILD_SUB_TYPE_DETECTED = "Unsupported option-with-child sub-type encountered, skipping: {}/{}";
    private static final String UNSUPPORTED_DATE_TIME_SUB_TYPE_DETECTED = "Unsupported date-time sub-type encountered, skipping: {}/{}";
    private static final String UNSUPPORTED_ARRAY_SUB_TYPE_DETECTED = "Unsupported array sub-type encountered, skipping: {}/{}";
    private static final String UNSUPPORTED_SLA_SUB_TYPE_DETECTED = "Unsupported servicelevelagreement sub-type encountered, skipping: {}/{}";
    private static final String UNSUPPORTED_CRT_SUB_TYPE_DETECTED = "Unsupported customerrequesttype sub-type encountered, skipping: {}/{}";
    private static final String MSG_UNSUPPORTED_ARRAY_SUB_TYPE_ENCOUNTERED = "Unsupported array sub-type encountered, skipping: {}/{}";
    private static final String MSG_UNSUPPORTED_CUSTOM_TYPE_ENCOUNTERED = "Unsupported custom type encountered, skipping: {} of {} {}";
    private static final String UNSUPPORTED_CUSTOM_TYPE = "Unsupported custom type {}/{}";
    private static final String INVALID_JSON_OBJECT = "Invalid JSONObject";
    private static final String INVALID_DATE_RECEIVED = "Invalid date received";
    private static final String DATE_TIME_FORMAT_KLAROS = "dd.MM.yyyy HH:mm";
    private static final String DATE_TIME_FORMAT_JIRA = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final String DATE_FORMAT_KLAROS = "dd.MM.yyyy";
    private static final String DATE_FORMAT_JIRA = "yyyy-MM-dd";
    private static final String SCHEMA_TYPE_NUMBER = "number";
    private static final String SCHEMA_TYPE_CUSTOMERREQUESTTYPE = "sd-customerrequesttype";
    private static final String SCHEMA_TYPE_SERVICELEVELAGREEMENT = "sd-servicelevelagreement";
    private static final String SCHEMA_TYPE_DATETIME = "datetime";
    private static final String SCHEMA_TYPE_USER = "user";
    private static final String SCHEMA_TYPE_OPTION = "option";
    private static final String SCHEMA_TYPE_VERSION = "version";
    private static final String SCHEMA_TYPE_GROUP = "group";
    private static final String SCHEMA_TYPE_PROJECT = "project";
    private static final String SCHEMA_TYPE_ANY = "any";
    private static final String SCHEMA_TYPE_OPTIONWITHCHILD = "option-with-child";
    private static final String SCHEMA_CUSTOM_TYPE_LABELS = "labels";
    private static final String SCHEMA_CUSTOM_TYPE_CASCADINGSELECT = "cascadingselect";
    private static final String SCHEMA_CUSTOM_TYPE_MULTICHECKBOXES = "multicheckboxes";
    private static final String SCHEMA_CUSTOM_TYPE_MULTISELECT = "multiselect";
    private static final String SCHEMA_CUSTOM_TYPE_STRING = "string";
    private static final String SCHEMA_CUSTOM_TYPE_TEXTFIELD = "textfield";
    private static final String SCHEMA_CUSTOM_TYPE_RADIOBUTTONS = "radiobuttons";
    private static final String SCHEMA_CUSTOM_TYPE_MULTIGROUPPICKER = "multigrouppicker";
    private static final String SCHEMA_CUSTOM_TYPE_MULTIUSERPICKER = "multiuserpicker";
    private static final String SCHEMA_CUSTOM_TYPE_MULTIVERSION = "multiversion";
    private static final String SCHEMA_CUSTOM_TYPE_EPICNAME = "gh-epic-label";
    private static final String SCHEMA_CUSTOM_TYPE_HIDDENJOBSWITCH = "hiddenjobswitch";
    private static final String SCHEMA_CUSTOM_TYPE_READONLYFIELD = "readonlyfield";
    private static final String SCHEMA_CUSTOM_TYPE_URL = "url";
    private static final String SCHEMA_CUSTOM_TYPE_DATETIMEPICKER = "datetimepicker";
    private static final String SCHEMA_CUSTOM_TYPE_TEXTAREA = "textarea";
    private static final String SCHEMA_CUSTOM_TYPE_DATEPICKER = "datepicker";
    private static final String SCHEMA_CUSTOM_TYPE_FLOAT = "float";
    private static final String SCHEMA_CUSTOM_TYPE_VERSIONPICKER = "versionpicker";
    private static final String SCHEMA_CUSTOM_TYPE_GROUPPICKER = "grouppicker";
    private static final String SCHEMA_CUSTOM_TYPE_USERPICKER = "userpicker";
    private static final String SCHEMA_CUSTOM_TYPE_TIMEINSTATUS = "timeinstatus";
    private static final String SCHEMA_CUSTOM_TYPE_FIRSTRESPONSEDATE = "firstresponsedate";
    private static final String SCHEMA_CUSTOM_TYPE_LEXORANK = "gh-lexo-rank";
    private static final String SCHEMA_CUSTOM_TYPE_SELECT = "select";
    private static final String SCHEMA_CUSTOM_TYPE_GLOBALRANK = "globalrank";
    private static final String SCHEMA_CUSTOM_TYPE_JOBCHECKBOX = "jobcheckbox";
    private static final String SCHEMA_CUSTOM_TYPE_RELEASEDVERSIONHISTORY = "greenhopper-releasedmultiversionhistory";
    private static final String SCHEMA_CUSTOM_TYPE_EPICLINK = "gh-epic-link";
    private static final String SCHEMA_CUSTOM_TYPE_EPICSTATUS = "gh-epic-status";
    private static final String SCHEMA_CUSTOM_TYPE_SPRINT = "gh-sprint";
    private static final String SCHEMA_CUSTOM_TYPE_REQUESTPARTICIPANTS = "sd-request-participants";
    private static final String SCHEMA_CUSTOM_TYPE_CUSTOMERORGANIZATIONS = "sd-customer-organizations";
    private static final String SCHEMA_CUSTOM_TYPE_REQUESTFEEDBACKDATE = "sd-request-feedback-date";
    private static final String SCHEMA_CUSTOM_TYPE_REQUESTFEEDBACK = "sd-request-feedback";
    private static final String SCHEMA_CUSTOM_TYPE_APPROVALS = "sd-approvals";
    private static final String SCHEMA_CUSTOM_TYPE_EPICCOLOR = "gh-epic-color";
    private static final String SCHEMA_CUSTOM_TYPE_VPORIGIN = "vp-origin";
    private static final String SCHEMA_CUSTOM_TYPE_SLAFIELD = "sd-sla-field";
    private static final String USERPICKER_SUGGESTIONS_PATH = "/rest/api/latest/groupuserpicker";
    private static final String ASSIGNABLE_USER_SEARCH_PATH = "/rest/api/latest/user/assignable/search";
    private static final String ALL_BOARDS_PATH = "/rest/agile/1.0/board";
    private static final String SPRINTS = "/sprint";
    private static final int MAX_RESULTS = 1000;
    private static final Logger LOG = LoggerFactory.getLogger(JiraRestIssueManagementService.class);
    private static final Pattern ATTACHMENT_ID_PATTERN = Pattern.compile("(?:attachment\\/)([1-9]\\d+)(?:\\/)");
    private final JiraRestClientFactory factory = new AsynchronousJiraRestClientFactory();
    private JiraRestClient restClient;
    private DisposableHttpClient httpClient;
    private AsynchronousExtendedIssueRestClient issueRestClient;
    private final String url;
    private final String projectKey;
    private Project project;
    private ExtendedAsynchronousSearchRestClient searchClient;
    private final Map<String, String> autoCompleteCustomfields = new HashMap<String, String>();
    private final List<String> subtaskTypes;
    private final List<String> sprintNames;
    private final List<String> sprintIds;

    public JiraRestIssueManagementService(String url, String projectKey) {
        this.url = url;
        this.projectKey = projectKey;
        this.subtaskTypes = new ArrayList<String>();
        this.sprintNames = new ArrayList<String>();
        this.sprintIds = new ArrayList<String>();
    }

    public String checkUrl() {
        String result = this.checkUrl(this.getRepositoryUrl(), this.getServiceType().getContentPattern());
        if (StringUtils.isBlank((CharSequence)result)) {
            return this.checkConnection();
        }
        return result;
    }

    public String checkConnection() {
        try {
            this.login(UUID.randomUUID().toString(), UUID.randomUUID().toString());
        }
        catch (KlarosServiceException | RuntimeException e) {
            LOG.debug("Ignoring exception during checkConnection(): ", e);
            if (e.getCause() != null && !e.getCause().toString().contains("401") && !e.getCause().toString().contains("403")) {
                String string = e.getCause().toString();
                return string;
            }
        }
        finally {
            this.logout();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkAuthentication(String username, String password) throws KlarosServiceException {
        boolean result;
        block38: {
            DisposableHttpClient permissionClient = null;
            result = false;
            try (JiraRestClient tmpClient = this.factory.createWithBasicHttpAuthentication(new URI(this.url), username, password);){
                permissionClient = new AsynchronousHttpClientFactory().createClient(new URI(this.url), (AuthenticationHandler)new BasicHttpAuthenticationHandler(username, password));
                URI tmpUri = new URI(this.url);
                StringBuilder path = new StringBuilder(tmpUri.getPath());
                path.append("/rest/api/latest");
                URI resultUri = new URI(tmpUri.getScheme(), null, tmpUri.getHost(), tmpUri.getPort(), path.toString(), path.toString(), null);
                ExtendedMyPermissionsRestClient permissionRestClient = new ExtendedMyPermissionsRestClient(resultUri, (HttpClient)permissionClient, "BROWSE_PROJECTS");
                Permissions permissions = (Permissions)permissionRestClient.getMyPermissions(MyPermissionsInput.withProject((String)this.projectKey)).claim();
                if (!permissions.havePermission("BROWSE_PROJECTS")) {
                    throw new KlarosServiceException("Missing browse permissions to access project " + this.projectKey);
                }
                result = true;
                tmpClient.getProjectClient().getProject(this.projectKey).claim();
            }
            catch (RestClientException e) {
                if (e.getStatusCode().isPresent() && (HttpStatus.FORBIDDEN.code == (Integer)e.getStatusCode().get() || HttpStatus.UNAUTHORIZED.code == (Integer)e.getStatusCode().get()) || !e.getStatusCode().isPresent()) {
                    LOG.warn("Authorization failed for user {} accessing project {} at {}", new Object[]{username, this.projectKey, this.url});
                    LOG.debug(e.getMessage());
                    break block38;
                }
                if (e.getStatusCode().isPresent() && (Integer)e.getStatusCode().get() == HttpStatus.NOT_FOUND.code) {
                    if (!e.getMessage().contains("with key")) {
                        throw new KlarosServiceException("Unable to find the Jira REST Service interface", (Throwable)e);
                    }
                    try {
                        JiraRestClient tmpClient2 = this.factory.createWithBasicHttpAuthentication(new URI(this.url), username, password);
                        try {
                            ArrayList<String> allProjectNames = new ArrayList<String>();
                            for (BasicProject basicProject : (Iterable)tmpClient2.getProjectClient().getAllProjects().claim()) {
                                allProjectNames.add(basicProject.getName());
                            }
                            if (allProjectNames.contains(this.projectKey)) {
                                ArrayList<String> allProjectKeys = new ArrayList<String>();
                                for (BasicProject basicProject : (Iterable)tmpClient2.getProjectClient().getAllProjects().claim()) {
                                    allProjectKeys.add(basicProject.getKey());
                                }
                                if (allProjectNames.indexOf(this.projectKey) >= 0) {
                                    throw new KlarosServiceException("'" + this.projectKey + "' is not a valid project key, did you mean '" + (String)allProjectKeys.get(allProjectNames.indexOf(this.projectKey)) + "'?");
                                }
                                throw new KlarosServiceException("Missing browse permissions to access project " + this.projectKey);
                            }
                            throw new KlarosServiceException("Missing browse permissions to access project " + this.projectKey);
                        }
                        catch (Throwable throwable) {
                            if (tmpClient2 != null) {
                                try {
                                    tmpClient2.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException | RuntimeException | URISyntaxException ex) {
                        LOG.debug("Missing browse permissions to access project {}", (Object)this.projectKey, (Object)ex);
                        throw new KlarosServiceException("Missing browse permissions to access project " + this.projectKey);
                    }
                }
                throw new KlarosServiceException((Throwable)e);
            }
            catch (RuntimeException | URISyntaxException e) {
                throw new KlarosServiceException((Throwable)e);
            }
            catch (IOException e) {
                LOG.debug("Error auto closing", (Throwable)e);
            }
            finally {
                if (permissionClient != null) {
                    try {
                        permissionClient.destroy();
                    }
                    catch (Exception e) {
                        LOG.debug("Error destroying permissionClient", (Throwable)e);
                    }
                }
            }
        }
        return result;
    }

    public boolean login(String loginUsername, String loginPassword) throws KlarosServiceException {
        try {
            this.closeClient();
            this.restClient = this.factory.createWithBasicHttpAuthentication(new URI(this.url), loginUsername, loginPassword);
            this.project = (Project)this.restClient.getProjectClient().getProject(this.projectKey).claim();
            this.httpClient = new AsynchronousHttpClientFactory().createClient(new URI(this.url), (AuthenticationHandler)new BasicHttpAuthenticationHandler(loginUsername, loginPassword));
            this.issueRestClient = new AsynchronousExtendedIssueRestClient(new URI(this.url), (HttpClient)this.httpClient, this.restClient.getSessionClient(), this.restClient.getMetadataClient());
            this.searchClient = new ExtendedAsynchronousSearchRestClient(new URI(this.url), (HttpClient)this.httpClient);
            this.refreshSprints(this.getAllJiraBoards());
        }
        catch (RestClientException e) {
            if (e.getStatusCode().isPresent() && (Integer)e.getStatusCode().get() == HttpStatus.UNAUTHORIZED.code) {
                return false;
            }
            if (e.getStatusCode().isPresent() && (Integer)e.getStatusCode().get() == HttpStatus.NOT_FOUND.code) {
                throw new KlarosServiceException("Unable to find  the Jira REST Service interface", (Throwable)e);
            }
            throw new KlarosServiceException((Throwable)e);
        }
        catch (RuntimeException | URISyntaxException e) {
            throw new KlarosServiceException((Throwable)e);
        }
        return true;
    }

    private void closeClient() {
        if (this.restClient != null) {
            try {
                this.restClient.close();
            }
            catch (IOException | RuntimeException e) {
                LOG.debug("Ignoring exception on close", (Throwable)e);
            }
            finally {
                this.restClient = null;
            }
        }
    }

    public void logout() {
    }

    public void terminate() {
        try {
            if (this.restClient != null) {
                this.restClient.close();
            }
            if (this.httpClient != null) {
                this.httpClient.destroy();
            }
        }
        catch (Exception e) {
            LOG.debug("Ignoring exception", (Throwable)e);
        }
    }

    public List<String> getMatchingJiraObjects(String match, String schemaCustomType) {
        ArrayList<String> matchingItems = new ArrayList<String>();
        try {
            URI pickerUri = new URI(this.url);
            StringBuilder path = new StringBuilder(URLUtil.removeUnnecessarySlashes((URI)pickerUri));
            path.append(USERPICKER_SUGGESTIONS_PATH);
            StringBuilder query = new StringBuilder("query=");
            query.append(match);
            URI resultUri = new URI(pickerUri.getScheme(), null, pickerUri.getHost(), pickerUri.getPort(), path.toString(), query.toString(), null);
            Response response = (Response)this.httpClient.newRequest(resultUri.toString()).get().claim();
            StringBuilder builder = new StringBuilder();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getEntityStream(), StandardCharsets.UTF_8));
            String line = bufferedReader.readLine();
            while (line != null) {
                builder.append(line).append('\n');
                line = bufferedReader.readLine();
            }
            bufferedReader.close();
            JSONObject jsonObject = new JSONObject(builder.toString());
            switch (schemaCustomType) {
                case "userpicker": {
                    JSONObject jsonUserObj = jsonObject.getJSONObject("users");
                    JSONArray jsonUserArray = jsonUserObj.getJSONArray("users");
                    for (int i = 0; i < jsonUserArray.length(); ++i) {
                        matchingItems.add(jsonUserArray.getJSONObject(i).getString("key"));
                    }
                    break;
                }
                case "grouppicker": {
                    JSONObject jsonGroupObj = jsonObject.getJSONObject("groups");
                    JSONArray jsonGroupArray = jsonGroupObj.getJSONArray("groups");
                    for (int i = 0; i < jsonGroupArray.length(); ++i) {
                        matchingItems.add(jsonGroupArray.getJSONObject(i).getString("name"));
                    }
                    break;
                }
            }
        }
        catch (IOException | RuntimeException | URISyntaxException | JSONException e) {
            LOG.error("", e);
        }
        return matchingItems;
    }

    public List<String> getAllJiraBoards() {
        ArrayList<String> boards = new ArrayList<String>();
        try {
            URI pickerUri = new URI(this.url);
            StringBuilder path = new StringBuilder(URLUtil.removeUnnecessarySlashes((URI)pickerUri));
            path.append(ALL_BOARDS_PATH);
            URI resultUri = new URI(pickerUri.getScheme(), null, pickerUri.getHost(), pickerUri.getPort(), path.toString(), null, null);
            if (this.httpClient != null) {
                Response response = (Response)this.httpClient.newRequest(resultUri.toString()).get().claim();
                StringBuilder builder = new StringBuilder();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getEntityStream(), response.getContentCharset()));
                String line = bufferedReader.readLine();
                while (line != null) {
                    builder.append(line).append('\n');
                    line = bufferedReader.readLine();
                }
                bufferedReader.close();
                JSONObject jsonObject = new JSONObject(builder.toString());
                if (jsonObject.has("values")) {
                    JSONArray jsonArray = jsonObject.getJSONArray("values");
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        boards.add(jsonArray.getJSONObject(i).getString("id"));
                    }
                }
            }
        }
        catch (IOException | RuntimeException | URISyntaxException | JSONException e) {
            LOG.error("", e);
        }
        return boards;
    }

    protected void refreshSprints(Iterable<String> boardIds) {
        this.sprintIds.clear();
        this.sprintIds.add("");
        this.sprintNames.clear();
        this.sprintNames.add("");
        for (String boardId : boardIds) {
            try {
                URI pickerUri = new URI(this.url);
                StringBuilder path = new StringBuilder(URLUtil.removeUnnecessarySlashes((URI)pickerUri));
                path.append(ALL_BOARDS_PATH).append('/').append(boardId).append(SPRINTS);
                URI resultUri = new URI(pickerUri.getScheme(), null, pickerUri.getHost(), pickerUri.getPort(), path.toString(), null, null);
                if (this.httpClient == null) continue;
                Response response = (Response)this.httpClient.newRequest(resultUri.toString()).get().claim();
                StringBuilder builder = new StringBuilder();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getEntityStream(), StandardCharsets.UTF_8));
                String line = bufferedReader.readLine();
                while (line != null) {
                    builder.append(line).append('\n');
                    line = bufferedReader.readLine();
                }
                bufferedReader.close();
                JSONObject jsonObject = new JSONObject(builder.toString());
                if (!jsonObject.has("values")) continue;
                JSONArray jsonArray = jsonObject.getJSONArray("values");
                for (int i = 0; i < jsonArray.length(); ++i) {
                    String sprintId = jsonArray.getJSONObject(i).getString("id");
                    if (this.sprintIds.contains(sprintId)) continue;
                    this.sprintIds.add(sprintId);
                    String sprintName = jsonArray.getJSONObject(i).getString("name");
                    this.sprintNames.add(sprintName);
                }
            }
            catch (IOException | RuntimeException | URISyntaxException | JSONException e) {
                LOG.error("", e);
            }
        }
    }

    public Map<String, String> getAssignableUsers() {
        HashMap<String, String> assignableUsers = new HashMap<String, String>();
        try {
            URI pickerUri = new URI(this.url);
            StringBuilder path = new StringBuilder(pickerUri.getPath());
            path.append(ASSIGNABLE_USER_SEARCH_PATH);
            StringBuilder query = new StringBuilder("project=");
            query.append(this.projectKey);
            URI resultUri = new URI(pickerUri.getScheme(), null, pickerUri.getHost(), pickerUri.getPort(), path.toString(), query.toString(), null);
            if (this.httpClient != null) {
                Response response = (Response)this.httpClient.newRequest(resultUri.toString()).get().claim();
                StringBuilder builder = new StringBuilder();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getEntityStream()));
                String line = bufferedReader.readLine();
                while (line != null) {
                    builder.append(line).append('\n');
                    line = bufferedReader.readLine();
                }
                bufferedReader.close();
                JSONArray jsonArray = new JSONArray(builder.toString());
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    if (!"true".equals(jsonObject.getString("active"))) continue;
                    if (jsonObject.has("name")) {
                        assignableUsers.put(jsonObject.getString("displayName"), jsonObject.getString("name"));
                        continue;
                    }
                    assignableUsers.put(jsonObject.getString("displayName"), jsonObject.getString("accountId"));
                }
            }
        }
        catch (IOException | RuntimeException | URISyntaxException | JSONException e) {
            LOG.error("", e);
        }
        return assignableUsers;
    }

    public IssueModel getIssue(String id) throws KlarosServiceException {
        if (this.restClient == null) {
            throw new KlarosServiceException("Rest client not initialized");
        }
        this.refreshSprints(this.getAllJiraBoards());
        try {
            Issue issue = (Issue)this.restClient.getIssueClient().getIssue(id, (Iterable)ListUtil.getList((Object[])new IssueRestClient.Expandos[]{IssueRestClient.Expandos.SCHEMA})).claim();
            return new JiraRestIssueModel(issue, this.loadFieldAttributes(issue), this.getCustomFields(issue.getIssueType().getName()));
        }
        catch (RuntimeException e) {
            throw new KlarosServiceException((Throwable)e);
        }
    }

    public Map<String, IssueModel> getIssues(Set<String> ids) throws KlarosServiceException {
        if (this.getRestClient() == null) {
            throw new KlarosServiceException("Rest client not initialized");
        }
        this.refreshSprints(this.getAllJiraBoards());
        HashMap<String, IssueModel> result = new HashMap<String, IssueModel>();
        String jqlQuery = this.buildJqlInStatement(ids);
        int startAt = 0;
        boolean hasResults = true;
        while (hasResults) {
            Iterator issues;
            try {
                issues = ((SearchResult)this.searchClient.searchJql(jqlQuery, 1000, startAt, null).claim()).getIssues().iterator();
            }
            catch (RestClientException exception) {
                LOG.warn("RestClientException occured. It is most likely that the JQL query validation failed. Either the user used for synchronization has insufficient permission or at least one queried issue has been deleted. Trying again with validation turned off...", (Throwable)exception);
                this.searchClient.setValidateQuery(false);
                issues = ((SearchResult)this.searchClient.searchJql(jqlQuery, 1000, startAt, null).claim()).getIssues().iterator();
                this.searchClient.setValidateQuery(true);
            }
            if (!issues.hasNext()) {
                hasResults = false;
            }
            while (issues.hasNext()) {
                Issue issue = (Issue)issues.next();
                JiraRestIssueModel issueModel = new JiraRestIssueModel(issue, this.loadFieldAttributes(issue), this.getCustomFields(issue.getIssueType().getName()));
                result.put(issue.getKey(), (IssueModel)issueModel);
            }
            startAt += 1000;
        }
        return result;
    }

    protected String buildJqlInStatement(Collection<String> ids) {
        StringBuilder jqlBuilder = new StringBuilder("id IN (");
        Iterator<String> iterator = ids.iterator();
        while (iterator.hasNext()) {
            String id = iterator.next();
            jqlBuilder.append('\"').append(id).append('\"');
            if (!iterator.hasNext()) continue;
            jqlBuilder.append(", ");
        }
        jqlBuilder.append(')');
        return jqlBuilder.toString();
    }

    public String createIssue(IssueModel issue) throws KlarosServiceException {
        try {
            return ((BasicIssue)this.restClient.getIssueClient().createIssue(this.toIssueInput((JiraRestIssueModel)issue)).claim()).getKey();
        }
        catch (RuntimeException e) {
            throw new KlarosServiceException((Throwable)e);
        }
    }

    private IssueInput toIssueInput(JiraRestIssueModel issue) {
        Map fields;
        IssueInputBuilder builder = new IssueInputBuilder(this.projectKey, this.mapType(issue.getType()).getId());
        if (issue.getId() != null) {
            fields = (Map)this.issueRestClient.getEditIssueMetadata(issue.getId()).claim();
        } else {
            List<CimFieldInfo> fieldInfos = this.getFieldInfos((Optional<String>)Optional.of((Object)issue.getType()), false);
            fields = Maps.newHashMapWithExpectedSize((int)fieldInfos.size());
            for (CimFieldInfo cimFieldInfo : fieldInfos) {
                fields.put(cimFieldInfo.getId(), cimFieldInfo);
            }
        }
        if (fields.containsKey("versions")) {
            builder.setAffectedVersions(this.mapVersions(issue.getAffectedVersions()));
        }
        if (fields.containsKey("assignee") && issue.getOwner() != null) {
            builder.setFieldInput(new FieldInput(IssueFieldId.ASSIGNEE_FIELD, (Object)ComplexIssueInputFieldValue.with((String)"id", (Object)issue.getOwner())));
            builder.setFieldInput(new FieldInput(IssueFieldId.ASSIGNEE_FIELD, (Object)ComplexIssueInputFieldValue.with((String)"name", (Object)issue.getOwner())));
        }
        if (fields.containsKey("components")) {
            builder.setComponents(this.mapComponents(issue.getComponents()));
        }
        if (fields.containsKey("description")) {
            builder.setDescription(issue.getDescription());
        }
        if (fields.containsKey("duedate")) {
            builder.setDueDate(new DateTime((Object)issue.getDueDate()));
        }
        if (fields.containsKey("environment")) {
            builder.setFieldValue("environment", (Object)issue.getEnvironment());
        }
        if (fields.containsKey("fixVersions")) {
            builder.setFixVersions(this.mapVersions(issue.getFixVersions()));
        }
        builder.setIssueType(this.mapType(issue.getType()));
        if (fields.containsKey("priority")) {
            builder.setPriority(this.mapPriority(issue.getPriority()));
        }
        if (fields.containsKey("summary")) {
            builder.setSummary(issue.getSummary());
        }
        if (fields.containsKey("parent")) {
            HashMap<String, String> parent = new HashMap<String, String>();
            parent.put("key", issue.getParent());
            builder.setFieldValue("parent", new ComplexIssueInputFieldValue(parent));
        }
        builder.setProjectKey(this.projectKey);
        this.buildCustomFieldIssueInput(builder, issue, fields);
        return builder.build();
    }

    private void buildCustomFieldIssueInput(IssueInputBuilder builder, JiraRestIssueModel issue, Map<String, CimFieldInfo> fields) {
        boolean isSubtask = this.subtaskTypes.contains(issue.getType());
        block98: for (IssueCustomAttribute attribute : issue.getCustomFieldAttributes().values()) {
            CimFieldInfo cimFieldInfo = fields.get(attribute.getId());
            FieldSchema schema = cimFieldInfo.getSchema();
            String schemaType = schema.getType();
            String schemaCustomType = schema.getCustom().substring(schema.getCustom().lastIndexOf(58) + 1);
            block19 : switch (schemaType) {
                case "array": {
                    switch (schemaCustomType) {
                        case "multicheckboxes": 
                        case "multiselect": 
                        case "multiversion": {
                            List<Object> options = JiraRestIssueManagementService.getSelectedOptions(attribute, cimFieldInfo);
                            builder.setFieldValue(attribute.getId(), options);
                            break;
                        }
                        case "labels": {
                            List labels = ListUtil.getList((Object[])attribute.getValue().split(" "));
                            builder.setFieldValue(attribute.getId(), (Object)labels);
                            break;
                        }
                        case "gh-sprint": {
                            if (isSubtask) continue block98;
                            if (StringUtils.isNotBlank((CharSequence)attribute.getValue())) {
                                try {
                                    builder.setFieldValue(attribute.getId(), (Object)Double.valueOf(this.sprintIds.get(this.sprintNames.indexOf(attribute.getValue()))));
                                }
                                catch (NumberFormatException e) {
                                    builder.setFieldValue(attribute.getId(), null);
                                }
                                break;
                            }
                            builder.setFieldValue(attribute.getId(), null);
                            break;
                        }
                        default: {
                            LOG.warn("Unsupported array sub-type encountered, skipping: {}/{}", (Object)schemaType, (Object)schemaCustomType);
                            break;
                        }
                    }
                    continue block98;
                }
                case "option-with-child": {
                    LOG.warn(UNSUPPORTED_OPTION_WITH_CHILD_SUB_TYPE_DETECTED, (Object)schemaType, (Object)schemaCustomType);
                    break;
                }
                case "date": {
                    switch (schemaCustomType) {
                        case "datepicker": {
                            if (!StringUtils.isNotBlank((CharSequence)attribute.getValue())) continue block98;
                            builder.setFieldValue(attribute.getId(), (Object)JiraRestIssueManagementService.toJiraDateFormat(attribute.getValue()));
                            break;
                        }
                        default: {
                            LOG.warn(UNSUPPORTED_DATE_SUB_TYPE_ENCOUNTERED_SKIPPING, (Object)schemaType, (Object)schemaCustomType);
                            break;
                        }
                    }
                    continue block98;
                }
                case "datetime": {
                    switch (schemaCustomType) {
                        case "firstresponsedate": {
                            break;
                        }
                        case "datetime": 
                        case "datetimepicker": {
                            if (!StringUtils.isNotBlank((CharSequence)attribute.getValue())) continue block98;
                            builder.setFieldValue(attribute.getId(), (Object)JiraRestIssueManagementService.toJiraDateTimeFormat(attribute.getValue()));
                            break;
                        }
                        default: {
                            LOG.warn(UNSUPPORTED_DATE_TIME_SUB_TYPE_DETECTED, (Object)schemaType, (Object)schemaCustomType);
                            break;
                        }
                    }
                    continue block98;
                }
                case "string": {
                    switch (schemaCustomType) {
                        default: 
                    }
                    builder.setFieldValue(attribute.getId(), (Object)attribute.getValue());
                    break;
                }
                case "number": {
                    if (!StringUtils.isNotBlank((CharSequence)attribute.getValue())) continue block98;
                    try {
                        builder.setFieldValue(attribute.getId(), (Object)Double.valueOf(attribute.getValue()));
                    }
                    catch (NumberFormatException e) {
                        builder.setFieldValue(attribute.getId(), null);
                    }
                    break;
                }
                case "version": {
                    CustomFieldOption customFieldOption;
                    switch (schemaCustomType) {
                        default: 
                    }
                    if (cimFieldInfo.getAllowedValues() == null) continue block98;
                    for (Object option : cimFieldInfo.getAllowedValues()) {
                        if (!(option instanceof CustomFieldOption) || !(customFieldOption = (CustomFieldOption)option).getValue().equals(attribute.getValue())) continue;
                        builder.setFieldValue(attribute.getId(), (Object)customFieldOption);
                        break block19;
                    }
                    continue block98;
                }
                case "option": 
                case "project": 
                case "group": {
                    CustomFieldOption customFieldOption;
                    block79 : switch (schemaCustomType) {
                        case "grouppicker": {
                            if (!StringUtils.isNotBlank((CharSequence)attribute.getValue())) continue block98;
                            builder.setFieldValue(attribute.getId(), ComplexIssueInputFieldValue.with((String)"name", (Object)attribute.getValue()));
                            break;
                        }
                        default: {
                            if (cimFieldInfo.getAllowedValues() == null) continue block98;
                            for (Object option : cimFieldInfo.getAllowedValues()) {
                                if (!(option instanceof CustomFieldOption) || !(customFieldOption = (CustomFieldOption)option).getValue().equals(attribute.getValue())) continue;
                                builder.setFieldValue(attribute.getId(), (Object)customFieldOption);
                                break block79;
                            }
                            continue block98;
                        }
                    }
                    {
                        continue block98;
                        break;
                    }
                }
                case "user": {
                    CustomFieldOption customFieldOption;
                    block85 : switch (schemaCustomType) {
                        case "userpicker": {
                            if (!StringUtils.isNotBlank((CharSequence)attribute.getValue())) continue block98;
                            builder.setFieldValue(attribute.getId(), ComplexIssueInputFieldValue.with((String)"key", (Object)attribute.getValue()));
                            break;
                        }
                        default: {
                            if (cimFieldInfo.getAllowedValues() == null) continue block98;
                            for (Object option : cimFieldInfo.getAllowedValues()) {
                                if (!(option instanceof CustomFieldOption) || !(customFieldOption = (CustomFieldOption)option).getValue().equals(attribute.getValue())) continue;
                                builder.setFieldValue(attribute.getId(), (Object)customFieldOption);
                                break block85;
                            }
                            continue block98;
                        }
                    }
                    {
                        continue block98;
                        break;
                    }
                }
                case "sd-customerrequesttype": {
                    LOG.warn(UNSUPPORTED_CRT_SUB_TYPE_DETECTED, (Object)schemaType, (Object)schemaCustomType);
                    break;
                }
                case "sd-servicelevelagreement": {
                    LOG.warn(UNSUPPORTED_SLA_SUB_TYPE_DETECTED, (Object)schemaType, (Object)schemaCustomType);
                    break;
                }
                case "any": {
                    CustomFieldOption customFieldOption;
                    block91 : switch (schemaCustomType) {
                        case "gh-epic-link": {
                            if (cimFieldInfo.getAllowedValues() == null) continue block98;
                            for (Object option : cimFieldInfo.getAllowedValues()) {
                                if (option instanceof CustomFieldOption) {
                                    customFieldOption = (CustomFieldOption)option;
                                    if (!customFieldOption.getValue().equals(attribute.getValue())) continue;
                                    builder.setFieldValue(attribute.getId(), (Object)customFieldOption);
                                    break block91;
                                }
                                if (option instanceof JSONObject) {
                                    JSONObject jSonOption = (JSONObject)option;
                                    try {
                                        if (!jSonOption.get("value").equals(attribute.getValue())) continue;
                                        builder.setFieldValue(attribute.getId(), (Object)jSonOption);
                                        break block91;
                                    }
                                    catch (CannotTransformValueException e) {
                                        LOG.warn("Transformer cannot transform given value", (Throwable)e);
                                        continue;
                                    }
                                    catch (JSONException e) {
                                        LOG.warn("Key not found", (Throwable)e);
                                        continue;
                                    }
                                }
                                builder.setFieldValue(attribute.getId(), (Object)attribute.getValue());
                                break block91;
                            }
                            continue block98;
                        }
                        default: {
                            LOG.warn(UNSUPPORTED_ANY_SUB_TYPE_DETECTED, (Object)schemaType, (Object)schemaCustomType);
                            break;
                        }
                    }
                    continue block98;
                }
                default: {
                    LOG.warn(UNSUPPORTED_CUSTOM_TYPE, (Object)schemaType, (Object)schemaCustomType);
                }
            }
        }
    }

    private static List<Object> getSelectedOptions(IssueCustomAttribute attribute, CimFieldInfo cimFieldInfo) {
        ArrayList<Object> options = new ArrayList<Object>();
        if (attribute.getValues() != null) {
            block0: for (String value : attribute.getValues()) {
                if (cimFieldInfo.getAllowedValues() == null) continue;
                for (Object option : cimFieldInfo.getAllowedValues()) {
                    if (option instanceof CustomFieldOption) {
                        CustomFieldOption customFieldOption = (CustomFieldOption)option;
                        if (!customFieldOption.getValue().equals(value)) continue;
                        options.add(customFieldOption);
                        continue block0;
                    }
                    if (option instanceof NamedEntity) {
                        NamedEntity namedEntity = (NamedEntity)option;
                        if (!namedEntity.getName().equals(value)) continue;
                        options.add(namedEntity);
                        continue block0;
                    }
                    LOG.warn("Unsupported option in cimFieldInfo.getAllowedValues() encountered: {}", option);
                }
            }
        }
        return options;
    }

    private BasicPriority mapPriority(String priorityName) {
        for (Priority priority : (Iterable)this.restClient.getMetadataClient().getPriorities().claim()) {
            if (!priority.getName().equals(priorityName)) continue;
            return priority;
        }
        return null;
    }

    private Iterable<BasicComponent> mapComponents(List<String> componentNames) {
        ArrayList<BasicComponent> result = new ArrayList<BasicComponent>();
        for (String componentName : componentNames) {
            for (BasicComponent component : this.project.getComponents()) {
                if (!component.getName().equals(componentName)) continue;
                result.add(component);
            }
        }
        return result;
    }

    private IssueType mapType(String typeName) {
        for (IssueType type : this.project.getIssueTypes()) {
            if (!type.getName().equals(typeName)) continue;
            return type;
        }
        throw new KlarosImpossibleRuntimeException("No mapping available for issue type: " + typeName);
    }

    private List<Version> mapVersions(List<String> versions) {
        ArrayList<Version> result = new ArrayList<Version>();
        for (String versionName : versions) {
            for (Version version : this.project.getVersions()) {
                if (!version.getName().equals(versionName)) continue;
                result.add(version);
            }
        }
        return result;
    }

    public IssueModel createNewIssue(String type) throws KlarosServiceException {
        this.refreshSprints(this.getAllJiraBoards());
        return new JiraRestIssueModel(this.projectKey, type, new HashMap<String, IssueCustomAttribute>(), this.getCustomFields(type));
    }

    public String updateIssue(IssueModel issue) throws KlarosServiceException {
        try {
            this.restClient.getIssueClient().updateIssue(issue.getId(), this.toIssueInput((JiraRestIssueModel)issue)).claim();
            return issue.getId();
        }
        catch (RuntimeException e) {
            throw new KlarosServiceException((Throwable)e);
        }
    }

    protected Map<String, IssueCustomAttribute> loadFieldAttributes(Issue issue) {
        if (this.issueRestClient == null) {
            throw new KlarosImpossibleRuntimeException("issueRestClient is null! Login before synchronizing");
        }
        Map fields = (Map)this.issueRestClient.getEditIssueMetadata(issue.getKey()).claim();
        HashMap<String, IssueCustomAttribute> result = new HashMap<String, IssueCustomAttribute>();
        for (IssueField field : issue.getFields()) {
            CimFieldInfo cimFieldInfo;
            FieldSchema schema;
            if (!field.getId().startsWith(CUSTOMFIELD_START) || !fields.containsKey(field.getId()) || !(schema = (cimFieldInfo = (CimFieldInfo)fields.get(field.getId())).getSchema()).isCustom() || !this.isPropertyLinkable(schema.getCustom().substring(schema.getCustom().lastIndexOf(58) + 1))) continue;
            String value = this.parseCustomFieldValue(field, cimFieldInfo);
            List<String> values = JiraRestIssueManagementService.parseCustomFieldValues(field, cimFieldInfo);
            IssueCustomField customField = this.parseCustomField(cimFieldInfo);
            MylynIssueCustomAttribute attribute = new MylynIssueCustomAttribute(field.getId(), field.getName(), value, values, customField.getFieldType(), !cimFieldInfo.isRequired());
            result.put(field.getId(), attribute);
        }
        return result;
    }

    protected String parseCustomFieldValue(IssueField field, CimFieldInfo cimFieldInfo) {
        String result;
        FieldSchema schema = cimFieldInfo.getSchema();
        String schemaType = schema.getType();
        String schemaCustomType = schema.getCustom().substring(schema.getCustom().lastIndexOf(58) + 1);
        Object value = field.getValue() == null ? "" : field.getValue();
        LOG.info("Parsing custom field type {}: {} -> {}\n{}", new Object[]{schemaType, schemaCustomType, value.getClass().getName(), value});
        block16 : switch (schemaType) {
            case "array": {
                switch (schemaCustomType) {
                    case "gh-sprint": {
                        result = this.sprintsFromJSONArray(value);
                        break block16;
                    }
                    case "labels": {
                        result = JiraRestIssueManagementService.labelsFromJSONArray(value);
                        break block16;
                    }
                }
                result = "";
                break;
            }
            case "user": {
                result = JiraRestIssueManagementService.valueFromJSONObject(value);
                break;
            }
            case "date": {
                switch (schemaCustomType) {
                    case "datepicker": {
                        result = JiraRestIssueManagementService.fromJiraDateFormat(value.toString());
                        break block16;
                    }
                }
                LOG.warn(UNSUPPORTED_DATE_SUB_TYPE_ENCOUNTERED_SKIPPING, (Object)schemaType, (Object)schemaCustomType);
                result = JiraRestIssueManagementService.fromJiraDateFormat(value.toString());
                break;
            }
            case "datetime": {
                switch (schemaCustomType) {
                    case "firstresponsedate": {
                        result = JiraRestIssueManagementService.fromJiraDateFormat(field.getValue().toString());
                        break block16;
                    }
                    case "datetime": 
                    case "datetimepicker": {
                        result = JiraRestIssueManagementService.fromJiraDateTimeFormat(value.toString());
                        break block16;
                    }
                }
                LOG.warn(UNSUPPORTED_DATE_TIME_SUB_TYPE_DETECTED, (Object)schemaType, (Object)schemaCustomType);
                result = JiraRestIssueManagementService.fromJiraDateFormat(value.toString());
                break;
            }
            case "string": {
                switch (schemaCustomType) {
                    case "string": 
                    case "textfield": 
                    case "gh-epic-label": 
                    case "url": 
                    case "textarea": 
                    case "gh-epic-color": {
                        result = value.toString();
                        break block16;
                    }
                }
                LOG.warn(UNSUPPORTED_STRING_SUB_TYPE_DETECTED, (Object)schemaType, (Object)schemaCustomType);
                result = value.toString();
                break;
            }
            case "number": {
                result = value.toString();
                break;
            }
            case "option": {
                switch (schemaCustomType) {
                    case "radiobuttons": 
                    case "select": 
                    case "gh-epic-status": {
                        result = JiraRestIssueManagementService.valueFromJSONObject(value);
                        break block16;
                    }
                }
                LOG.warn(UNSUPPORTED_OPTION_SUB_TYPE_DETECTED, (Object)schemaType, (Object)schemaCustomType);
                result = value.toString();
                break;
            }
            case "version": {
                switch (schemaCustomType) {
                    case "versionpicker": {
                        result = JiraRestIssueManagementService.valueFromJSONObject(value);
                        break block16;
                    }
                    case "version": {
                        result = field.getValue().toString();
                        break block16;
                    }
                }
                LOG.warn("Unsupported version sub-type encountered, skipping: {}/{}", (Object)schemaType, (Object)schemaCustomType);
                result = value.toString();
                break;
            }
            case "project": {
                switch (schemaCustomType) {
                    case "project": {
                        result = JiraRestIssueManagementService.valueFromJSONObject(value);
                        break block16;
                    }
                }
                LOG.warn(UNSUPPORTED_PROJECT_SUB_TYPE_DETECTED, (Object)schemaType, (Object)schemaCustomType);
                result = value.toString();
                break;
            }
            case "group": {
                switch (schemaCustomType) {
                    case "grouppicker": {
                        result = JiraRestIssueManagementService.valueFromJSONObject(value);
                        break block16;
                    }
                }
                LOG.warn(UNSUPPORTED_GROUP_SUB_TYPE_DETECTED, (Object)schemaType, (Object)schemaCustomType);
                result = value.toString();
                break;
            }
            case "any": {
                switch (schemaCustomType) {
                    case "gh-epic-link": {
                        result = field.getValue().toString();
                        break block16;
                    }
                }
                LOG.warn(UNSUPPORTED_ANY_SUB_TYPE_DETECTED, (Object)schemaType, (Object)schemaCustomType);
                result = value.toString();
                break;
            }
            case "sd-customerrequesttype": {
                LOG.warn(UNSUPPORTED_CRT_SUB_TYPE_DETECTED, (Object)schemaType, (Object)schemaCustomType);
                result = field.getValue().toString();
                break;
            }
            case "sd-servicelevelagreement": {
                LOG.warn(UNSUPPORTED_SLA_SUB_TYPE_DETECTED, (Object)schemaType, (Object)schemaCustomType);
                result = field.getValue().toString();
                break;
            }
            case "option-with-child": {
                LOG.warn(UNSUPPORTED_OPTION_WITH_CHILD_SUB_TYPE_DETECTED, (Object)schemaType, (Object)schemaCustomType);
                result = field.getValue().toString();
                break;
            }
            default: {
                LOG.warn(MSG_UNSUPPORTED_CUSTOM_TYPE_ENCOUNTERED, new Object[]{schemaType, field.getId(), schemaCustomType});
                result = value.toString();
            }
        }
        return result;
    }

    protected static List<String> parseCustomFieldValues(IssueField field, CimFieldInfo cimFieldInfo) {
        ArrayList<String> results = new ArrayList<String>();
        FieldSchema schema = cimFieldInfo.getSchema();
        String schemaType = schema.getType();
        String schemaCustomType = schema.getCustom().substring(schema.getCustom().lastIndexOf(58) + 1);
        LOG.info("Parsing custom field type {}: {} -> {}\n{}", new Object[]{schemaType, schemaCustomType, field.getValue().getClass().getName(), field.getValue()});
        block14 : switch (schemaType) {
            case "array": {
                switch (schemaCustomType) {
                    case "multicheckboxes": 
                    case "multiselect": 
                    case "multiversion": {
                        results.addAll(JiraRestIssueManagementService.valuesFromJSONArray(field.getValue()));
                        break block14;
                    }
                    case "gh-sprint": 
                    case "labels": {
                        break block14;
                    }
                }
                LOG.warn("Unsupported array sub-type encountered, skipping: {}/{}", (Object)schemaType, (Object)schemaCustomType);
                break;
            }
            case "option-with-child": {
                LOG.warn(UNSUPPORTED_OPTION_WITH_CHILD_SUB_TYPE_DETECTED, (Object)schemaType, (Object)schemaCustomType);
                results.addAll(JiraRestIssueManagementService.valuesFromJSONArray(field.getValue()));
                break;
            }
            case "user": 
            case "date": 
            case "datetime": 
            case "string": 
            case "number": 
            case "group": 
            case "option": 
            case "version": 
            case "project": 
            case "any": {
                break;
            }
            default: {
                LOG.warn(MSG_UNSUPPORTED_CUSTOM_TYPE_ENCOUNTERED, new Object[]{schemaType, field.getId(), schemaCustomType});
            }
        }
        return results;
    }

    private static String valueFromJSONObject(Object value) {
        String result = "";
        try {
            result = value instanceof JSONObject ? (((JSONObject)value).has("value") ? ((JSONObject)value).getString("value") : ((JSONObject)value).getString("name")) : value.toString();
        }
        catch (JSONException e) {
            LOG.error(INVALID_JSON_OBJECT, (Throwable)e);
        }
        return result;
    }

    protected static List<String> valuesFromJSONArray(Object values) {
        ArrayList<String> results = new ArrayList<String>();
        if (values instanceof JSONArray) {
            for (int i = 0; i < ((JSONArray)values).length(); ++i) {
                JSONArray optJSONArray = ((JSONArray)values).optJSONArray(i);
                JSONObject optJsonObject = ((JSONArray)values).optJSONObject(i);
                String string = ((JSONArray)values).optString(i);
                if (optJSONArray != null) {
                    results.add(JiraRestIssueManagementService.valuesFromJSONArray(optJSONArray).toString());
                    continue;
                }
                if (optJsonObject != null) {
                    results.add(JiraRestIssueManagementService.valueFromJSONObject(optJsonObject));
                    continue;
                }
                if (string == null) continue;
                results.add(string);
            }
        }
        return results;
    }

    protected static String labelsFromJSONArray(Object values) {
        StringBuilder result = new StringBuilder();
        try {
            if (values instanceof JSONArray) {
                JSONArray jsonArray = (JSONArray)values;
                for (int i = 0; i < jsonArray.length(); ++i) {
                    result.append(jsonArray.getString(i)).append(' ');
                }
            }
        }
        catch (JSONException e) {
            LOG.error(INVALID_JSON_OBJECT, (Throwable)e);
        }
        return result.toString().trim();
    }

    private String sprintsFromJSONArray(Object values) {
        StringBuilder sprintId = new StringBuilder();
        if (values instanceof JSONArray) {
            try {
                JSONArray jsonArray = (JSONArray)values;
                String id = "id=";
                for (int i = 0; i < jsonArray.length(); ++i) {
                    String array = jsonArray.getString(i);
                    int idIndex = array.indexOf("id=");
                    sprintId.append(array.substring(idIndex + "id=".length(), array.indexOf(44, idIndex)));
                }
            }
            catch (JSONException e) {
                LOG.error(INVALID_JSON_OBJECT, (Throwable)e);
            }
        } else {
            return "";
        }
        return this.sprintNames.get(this.sprintIds.indexOf(sprintId.toString().trim()));
    }

    private static String fromJiraDateTimeFormat(String value) {
        String result = "";
        try {
            if (StringUtils.isNotBlank((CharSequence)value)) {
                Date date = new SimpleDateFormat(DATE_TIME_FORMAT_JIRA).parse(value);
                result = new SimpleDateFormat(DATE_TIME_FORMAT_KLAROS).format(date);
            }
        }
        catch (ParseException e) {
            LOG.error(INVALID_DATE_RECEIVED, (Throwable)e);
        }
        return result;
    }

    private static String toJiraDateTimeFormat(String value) {
        String result = "";
        try {
            if (StringUtils.isNotBlank((CharSequence)value)) {
                Date date = new SimpleDateFormat(DATE_TIME_FORMAT_KLAROS).parse(value);
                result = new SimpleDateFormat(DATE_TIME_FORMAT_JIRA).format(date);
            }
        }
        catch (ParseException e) {
            LOG.error(INVALID_DATE_RECEIVED, (Throwable)e);
        }
        return result;
    }

    private static String fromJiraDateFormat(String value) {
        String result = "";
        try {
            if (StringUtils.isNotBlank((CharSequence)value)) {
                Date date = new SimpleDateFormat(DATE_FORMAT_JIRA).parse(value);
                result = new SimpleDateFormat(DATE_FORMAT_KLAROS).format(date);
            }
        }
        catch (ParseException e) {
            LOG.error(INVALID_DATE_RECEIVED, (Throwable)e);
        }
        return result;
    }

    private static String toJiraDateFormat(String value) {
        String result = "";
        try {
            if (StringUtils.isNotBlank((CharSequence)value)) {
                Date date = new SimpleDateFormat(DATE_FORMAT_KLAROS).parse(value);
                result = new SimpleDateFormat(DATE_FORMAT_JIRA).format(date);
            }
        }
        catch (ParseException e) {
            LOG.error(INVALID_DATE_RECEIVED, (Throwable)e);
        }
        return result;
    }

    public List<String> getAllProjects() throws KlarosServiceException {
        try {
            ArrayList<String> result = new ArrayList<String>();
            for (BasicProject basicProject : (Iterable)this.restClient.getProjectClient().getAllProjects().claim()) {
                result.add(basicProject.getName());
            }
            return result;
        }
        catch (RuntimeException e) {
            throw new KlarosServiceException((Throwable)e);
        }
    }

    public List<String> getAllProjectKeys() throws KlarosServiceException {
        try {
            ArrayList<String> result = new ArrayList<String>();
            for (BasicProject basicProject : (Iterable)this.restClient.getProjectClient().getAllProjects().claim()) {
                result.add(basicProject.getKey());
            }
            return result;
        }
        catch (RuntimeException e) {
            throw new KlarosServiceException((Throwable)e);
        }
    }

    public List<String> getComponents() throws KlarosServiceException {
        try {
            ArrayList<String> result = new ArrayList<String>();
            for (BasicComponent component : this.getProject().getComponents()) {
                result.add(component.getName());
            }
            return result;
        }
        catch (RuntimeException e) {
            throw new KlarosServiceException((Throwable)e);
        }
    }

    public List<String> getPriorities() throws KlarosServiceException {
        try {
            ArrayList<String> result = new ArrayList<String>();
            for (Priority priority : (Iterable)this.restClient.getMetadataClient().getPriorities().claim()) {
                result.add(priority.getName());
            }
            return result;
        }
        catch (RuntimeException e) {
            throw new KlarosServiceException((Throwable)e);
        }
    }

    public List<String> getStatuses() throws KlarosServiceException {
        try {
            ArrayList<String> result = new ArrayList<String>();
            for (Status status : (Iterable)this.restClient.getMetadataClient().getStatuses().claim()) {
                result.add(status.getName());
            }
            return result;
        }
        catch (RuntimeException e) {
            throw new KlarosServiceException((Throwable)e);
        }
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public boolean hasProject(String key) {
        boolean result = false;
        try {
            Project p;
            if (this.restClient != null && (p = (Project)this.restClient.getProjectClient().getProject(key).claim()) != null) {
                this.project.getComponents();
                result = true;
            }
        }
        catch (RuntimeException e) {
            LOG.debug("Error claiming project {}", (Object)key, (Object)e);
        }
        return result;
    }

    public Map<String, IssueCustomField> getCustomFields(String type) throws KlarosServiceException {
        this.autoCompleteCustomfields.clear();
        List<CimFieldInfo> fieldInfos = this.getFieldInfos((Optional<String>)Optional.fromNullable((Object)type), true);
        HashMap result = Maps.newHashMapWithExpectedSize((int)fieldInfos.size());
        for (CimFieldInfo cimFieldInfo : fieldInfos) {
            result.put(cimFieldInfo.getId(), this.parseCustomField(cimFieldInfo));
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<CimFieldInfo> getFieldInfos(Optional<String> type, boolean customOnly) {
        GetCreateIssueMetadataOptionsBuilder builder;
        ArrayList<CimFieldInfo> result = new ArrayList<CimFieldInfo>();
        if (type.isPresent()) {
            Long typeId = this.resolveIssueTypeIdFromName((String)type.get());
            if (typeId == null) return result;
            builder = new GetCreateIssueMetadataOptionsBuilder().withProjectKeys(new String[]{this.projectKey}).withIssueTypeIds(new Long[]{typeId}).withExpandedIssueTypesFields();
        } else {
            builder = new GetCreateIssueMetadataOptionsBuilder().withProjectKeys(new String[]{this.projectKey}).withExpandedIssueTypesFields();
        }
        GetCreateIssueMetadataOptions metaDataOptions = builder.build();
        if (this.restClient == null) return result;
        Iterable cimProjects = (Iterable)this.restClient.getIssueClient().getCreateIssueMetadata(metaDataOptions).claim();
        for (CimProject cimProject : cimProjects) {
            for (CimIssueType issueType : cimProject.getIssueTypes()) {
                for (CimFieldInfo cimFieldInfo : issueType.getFields().values()) {
                    if (result.contains(cimFieldInfo)) continue;
                    if (cimFieldInfo.getSchema().isCustom()) {
                        if (!this.isPropertyLinkable(cimFieldInfo.getSchema().getCustom().substring(cimFieldInfo.getSchema().getCustom().lastIndexOf(58) + 1))) continue;
                        result.add(cimFieldInfo);
                        continue;
                    }
                    if (customOnly) continue;
                    result.add(cimFieldInfo);
                }
            }
        }
        return result;
    }

    private Long resolveIssueTypeIdFromName(String name) {
        for (IssueType type : this.getProject().getIssueTypes()) {
            if (!name.equals(type.getName())) continue;
            return type.getId();
        }
        return null;
    }

    protected IssueCustomField parseCustomField(CimFieldInfo cimFieldInfo) {
        ArrayList<Object> options;
        MylynIssueCustomFieldType fieldType;
        FieldSchema schema = cimFieldInfo.getSchema();
        String schemaType = schema.getType();
        String schemaCustomType = schema.getCustom().substring(schema.getCustom().lastIndexOf(58) + 1);
        LOG.debug("Parsing custom field type {}: {} -> {}", new Object[]{schemaType, schemaCustomType, schema.getItems()});
        block17 : switch (schemaType) {
            case "array": {
                switch (schemaCustomType) {
                    case "multicheckboxes": {
                        fieldType = MylynIssueCustomFieldType.CHECKBOXES;
                        break block17;
                    }
                    case "multiselect": 
                    case "multiversion": {
                        fieldType = MylynIssueCustomFieldType.MULTIPLE_SELECTION;
                        break block17;
                    }
                    case "labels": {
                        fieldType = MylynIssueCustomFieldType.FREE_TEXT;
                        break block17;
                    }
                    case "gh-sprint": {
                        fieldType = MylynIssueCustomFieldType.DROP_DOWN;
                        break block17;
                    }
                }
                LOG.warn("Unsupported array sub-type encountered, skipping: {}/{}", (Object)schemaType, (Object)schemaCustomType);
                fieldType = MylynIssueCustomFieldType.LARGE_TEXT;
                break;
            }
            case "user": {
                switch (schemaCustomType) {
                    case "userpicker": {
                        fieldType = MylynIssueCustomFieldType.AUTO_COMPLETE;
                        this.autoCompleteCustomfields.put(CUSTOMFIELD_START + schema.getCustomId(), schemaCustomType);
                        break block17;
                    }
                }
                LOG.warn(UNSUPPORTED_USER_SUB_TYPE_ENCOUNTERED_SKIPPING, (Object)schemaType, (Object)schemaCustomType);
                fieldType = MylynIssueCustomFieldType.LARGE_TEXT;
                break;
            }
            case "date": {
                switch (schemaCustomType) {
                    case "datepicker": {
                        fieldType = MylynIssueCustomFieldType.DATE;
                        break block17;
                    }
                }
                LOG.warn(UNSUPPORTED_DATE_SUB_TYPE_ENCOUNTERED_SKIPPING, (Object)schemaType, (Object)schemaCustomType);
                fieldType = MylynIssueCustomFieldType.LARGE_TEXT;
                break;
            }
            case "datetime": {
                switch (schemaCustomType) {
                    case "firstresponsedate": {
                        fieldType = MylynIssueCustomFieldType.UNKNOWN;
                        break block17;
                    }
                    case "datetime": 
                    case "datetimepicker": {
                        fieldType = MylynIssueCustomFieldType.DATE_TIME;
                        break block17;
                    }
                }
                LOG.warn(UNSUPPORTED_DATE_TIME_SUB_TYPE_DETECTED, (Object)schemaType, (Object)schemaCustomType);
                fieldType = MylynIssueCustomFieldType.LARGE_TEXT;
                break;
            }
            case "string": {
                switch (schemaCustomType) {
                    case "textarea": {
                        fieldType = MylynIssueCustomFieldType.LARGE_TEXT;
                        break block17;
                    }
                    case "string": 
                    case "textfield": 
                    case "gh-epic-label": 
                    case "url": 
                    case "gh-epic-color": {
                        fieldType = MylynIssueCustomFieldType.FREE_TEXT;
                        break block17;
                    }
                }
                LOG.warn(UNSUPPORTED_STRING_SUB_TYPE_DETECTED, (Object)schemaType, (Object)schemaCustomType);
                fieldType = MylynIssueCustomFieldType.LARGE_TEXT;
                break;
            }
            case "number": {
                switch (schemaCustomType) {
                    case "float": {
                        fieldType = MylynIssueCustomFieldType.FREE_TEXT;
                        break block17;
                    }
                }
                LOG.warn(UNSUPPORTED_NUMBER_SUB_TYPE_DETECTED, (Object)schemaType, (Object)schemaCustomType);
                fieldType = MylynIssueCustomFieldType.LARGE_TEXT;
                break;
            }
            case "option": {
                switch (schemaCustomType) {
                    case "gh-epic-status": 
                    case "select": {
                        fieldType = MylynIssueCustomFieldType.DROP_DOWN;
                        break block17;
                    }
                    case "radiobuttons": {
                        fieldType = MylynIssueCustomFieldType.RADIO;
                        break block17;
                    }
                }
                LOG.warn(UNSUPPORTED_OPTION_SUB_TYPE_DETECTED, (Object)schemaType, (Object)schemaCustomType);
                fieldType = MylynIssueCustomFieldType.LARGE_TEXT;
                break;
            }
            case "group": {
                switch (schemaCustomType) {
                    case "grouppicker": {
                        fieldType = MylynIssueCustomFieldType.AUTO_COMPLETE;
                        this.autoCompleteCustomfields.put(CUSTOMFIELD_START + schema.getCustomId(), schemaCustomType);
                        break block17;
                    }
                }
                LOG.warn(UNSUPPORTED_GROUP_SUB_TYPE_DETECTED, (Object)schemaType, (Object)schemaCustomType);
                fieldType = MylynIssueCustomFieldType.LARGE_TEXT;
                break;
            }
            case "project": {
                switch (schemaCustomType) {
                    case "project": {
                        fieldType = MylynIssueCustomFieldType.DROP_DOWN;
                        break block17;
                    }
                }
                LOG.warn(UNSUPPORTED_PROJECT_SUB_TYPE_DETECTED, (Object)schemaType, (Object)schemaCustomType);
                fieldType = MylynIssueCustomFieldType.LARGE_TEXT;
                break;
            }
            case "option-with-child": {
                LOG.warn(UNSUPPORTED_OPTION_WITH_CHILD_SUB_TYPE_DETECTED, (Object)schemaType, (Object)schemaCustomType);
                fieldType = MylynIssueCustomFieldType.LARGE_TEXT;
                break;
            }
            case "version": {
                switch (schemaCustomType) {
                    case "versionpicker": 
                    case "version": {
                        fieldType = MylynIssueCustomFieldType.DROP_DOWN;
                        break block17;
                    }
                }
                LOG.warn("Unsupported version sub-type encountered, skipping: {}/{}", (Object)schemaType, (Object)schemaCustomType);
                fieldType = MylynIssueCustomFieldType.LARGE_TEXT;
                break;
            }
            case "any": {
                switch (schemaCustomType) {
                    case "gh-epic-link": {
                        fieldType = MylynIssueCustomFieldType.FREE_TEXT;
                        break block17;
                    }
                }
                LOG.warn(UNSUPPORTED_ANY_SUB_TYPE_DETECTED, (Object)schemaType, (Object)schemaCustomType);
                fieldType = MylynIssueCustomFieldType.LARGE_TEXT;
                break;
            }
            case "sd-customerrequesttype": {
                LOG.warn(UNSUPPORTED_CRT_SUB_TYPE_DETECTED, (Object)schemaType, (Object)schemaCustomType);
                fieldType = MylynIssueCustomFieldType.LARGE_TEXT;
                break;
            }
            case "sd-servicelevelagreement": {
                LOG.warn(UNSUPPORTED_SLA_SUB_TYPE_DETECTED, (Object)schemaType, (Object)schemaCustomType);
                fieldType = MylynIssueCustomFieldType.LARGE_TEXT;
                break;
            }
            default: {
                LOG.warn(MSG_UNSUPPORTED_CUSTOM_TYPE_ENCOUNTERED, new Object[]{schemaType, CUSTOMFIELD_START + schema.getCustomId(), schemaCustomType});
                fieldType = MylynIssueCustomFieldType.LARGE_TEXT;
            }
        }
        if (cimFieldInfo.getAllowedValues() != null) {
            options = new ArrayList();
            for (Object option : cimFieldInfo.getAllowedValues()) {
                if (option instanceof NamedEntity) {
                    options.add(((NamedEntity)option).getName());
                    continue;
                }
                if (option instanceof CustomFieldOption) {
                    options.add(((CustomFieldOption)option).getValue());
                    continue;
                }
                if (option instanceof JSONObject) {
                    try {
                        options.add(((JSONObject)option).getString("value"));
                    }
                    catch (JSONException e) {
                        LOG.warn("Key not found", (Throwable)e);
                    }
                    continue;
                }
                LOG.warn("Unsupported allowed option class detected: {}", (Object)option.getClass().getName());
                options.add(option.toString());
            }
        } else {
            options = SCHEMA_CUSTOM_TYPE_SPRINT.equals(schemaCustomType) ? new ArrayList<String>(this.sprintNames) : null;
        }
        return new MylynIssueCustomField(cimFieldInfo.getId(), cimFieldInfo.getName(), cimFieldInfo.getName(), fieldType, options, "", !cimFieldInfo.isRequired());
    }

    protected boolean isPropertyLinkable(String propertyId) {
        boolean result;
        switch (propertyId) {
            case "multigrouppicker": 
            case "multiuserpicker": 
            case "sd-request-participants": 
            case "sd-customer-organizations": {
                LOG.info("Unsupported array sub-type encountered, skipping: {}/{}", (Object)SCHEMA_TYPE_ARRAY, (Object)propertyId);
                result = false;
                break;
            }
            case "sd-request-feedback-date": {
                LOG.info(UNSUPPORTED_DATE_TIME_SUB_TYPE_DETECTED, (Object)SCHEMA_TYPE_DATETIME, (Object)propertyId);
                result = false;
                break;
            }
            case "hiddenjobswitch": 
            case "jobcheckbox": 
            case "readonlyfield": {
                LOG.info(UNSUPPORTED_STRING_SUB_TYPE_DETECTED, (Object)"string", (Object)propertyId);
                result = false;
                break;
            }
            case "cascadingselect": {
                LOG.info(UNSUPPORTED_OPTION_WITH_CHILD_SUB_TYPE_DETECTED, (Object)SCHEMA_TYPE_OPTIONWITHCHILD, (Object)propertyId);
                result = false;
                break;
            }
            case "greenhopper-releasedmultiversionhistory": {
                LOG.info("Unsupported version sub-type encountered, skipping: {}/{}", (Object)SCHEMA_TYPE_VERSION, (Object)propertyId);
                result = false;
                break;
            }
            case "sd-request-feedback": 
            case "timeinstatus": 
            case "gh-lexo-rank": 
            case "globalrank": 
            case "sd-approvals": {
                LOG.info(UNSUPPORTED_ANY_SUB_TYPE_DETECTED, (Object)SCHEMA_TYPE_ANY, (Object)propertyId);
                result = false;
                break;
            }
            case "vp-origin": {
                LOG.info(UNSUPPORTED_CRT_SUB_TYPE_DETECTED, (Object)SCHEMA_TYPE_CUSTOMERREQUESTTYPE, (Object)propertyId);
                result = false;
                break;
            }
            case "sd-sla-field": {
                LOG.info(UNSUPPORTED_SLA_SUB_TYPE_DETECTED, (Object)SCHEMA_TYPE_SERVICELEVELAGREEMENT, (Object)propertyId);
                result = false;
                break;
            }
            default: {
                result = true;
            }
        }
        return result;
    }

    public String getBrowseIssueUrl(String id) {
        return this.getServiceType().getBrowseIssueUrl(this.url, id);
    }

    public String getRepositoryUrl() {
        return this.url;
    }

    public IssueManagementServiceType getServiceType() {
        return IssueManagementServiceType.JIRA_REST;
    }

    public List<String> getResolutions() throws KlarosServiceException {
        try {
            ArrayList<String> result = new ArrayList<String>();
            if (this.restClient != null) {
                for (Resolution resolution : (Iterable)this.restClient.getMetadataClient().getResolutions().claim()) {
                    result.add(resolution.getName());
                }
            }
            return result;
        }
        catch (RuntimeException e) {
            throw new KlarosServiceException((Throwable)e);
        }
    }

    public List<String> getTypes() throws KlarosServiceException {
        try {
            ArrayList<String> result = new ArrayList<String>();
            for (IssueType type : this.getProject().getIssueTypes()) {
                if (type.isSubtask()) {
                    this.subtaskTypes.add(type.getName());
                }
                result.add(type.getName());
            }
            Collections.sort(result);
            return result;
        }
        catch (RuntimeException e) {
            throw new KlarosServiceException((Throwable)e);
        }
    }

    public List<String> getSubtaskTypes() {
        return this.subtaskTypes;
    }

    public List<String> getVersions() throws KlarosServiceException {
        try {
            ArrayList<String> result = new ArrayList<String>();
            for (Version version : this.getProject().getVersions()) {
                result.add(version.getName());
            }
            return result;
        }
        catch (RuntimeException e) {
            throw new KlarosServiceException((Throwable)e);
        }
    }

    protected Project getProject() {
        return this.project;
    }

    public boolean isProjectValid() {
        return this.hasProject(this.getProjectKey());
    }

    protected JiraRestClient getRestClient() {
        return this.restClient;
    }

    protected Map<String, Pair<String, byte[]>> getAttachments(Issue issue) throws KlarosServiceException {
        HashMap<String, Pair<String, byte[]>> result = new HashMap<String, Pair<String, byte[]>>();
        if (this.restClient != null && issue.getAttachments() != null) {
            for (Attachment attachment : issue.getAttachments()) {
                try (InputStream attachmentInputStream = (InputStream)this.restClient.getIssueClient().getAttachment(attachment.getContentUri()).claim();){
                    result.put(JiraRestIssueManagementService.getId(attachment), (Pair<String, byte[]>)Pair.of((Object)attachment.getFilename(), (Object)IOUtils.toByteArray((InputStream)attachmentInputStream)));
                }
                catch (RestClientException | IOException e) {
                    LOG.error("Unable to retrieve attachment", e);
                }
            }
        }
        return result;
    }

    private static String getId(Attachment attachment) throws KlarosServiceException {
        String uri = attachment.getContentUri().toString();
        Matcher matcher = ATTACHMENT_ID_PATTERN.matcher(uri);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new KlarosServiceException("Could not parse JIRA issue URI for an attachment id: " + uri);
    }

    public AsynchronousExtendedIssueRestClient getIssueRestClient() {
        return this.issueRestClient;
    }

    public void setIssueRestClient(AsynchronousExtendedIssueRestClient issueRestClient) {
        this.issueRestClient = issueRestClient;
    }

    public ExtendedAsynchronousSearchRestClient getSearchClient() {
        return this.searchClient;
    }

    public boolean isUserpicker(IssueCustomAttribute attribute) {
        if (this.autoCompleteCustomfields.containsKey(attribute.getId())) {
            return SCHEMA_CUSTOM_TYPE_USERPICKER.equals(this.autoCompleteCustomfields.get(attribute.getId()));
        }
        return false;
    }

    public boolean isGrouppicker(IssueCustomAttribute attribute) {
        if (this.autoCompleteCustomfields.containsKey(attribute.getId())) {
            return SCHEMA_CUSTOM_TYPE_GROUPPICKER.equals(this.autoCompleteCustomfields.get(attribute.getId()));
        }
        return false;
    }
}

