/*
 * Decompiled with CFR 0.152.
 */
package de.verit.klaros.service.issuemanagement.connection;

import de.verit.klaros.service.connection.BaseExternalService;
import de.verit.klaros.service.credential.ExternalServiceCredential;
import de.verit.klaros.service.issuemanagement.IssueManagementService;
import de.verit.klaros.service.issuemanagement.IssueManagementServiceType;
import de.verit.klaros.service.issuemanagement.connection.IssueManagementConnection;
import de.verit.klaros.service.issuemanagement.connection.IssueManagementConnectionImpl;
import de.verit.klaros.service.issuemanagement.jira.JiraRestIssueManagementService;
import de.verit.klaros.service.issuemanagement.mylyn.bugzilla.BugzillaIssueManagementService;
import de.verit.klaros.service.issuemanagement.mylyn.github.GitHubIssueManagementService;
import de.verit.klaros.service.issuemanagement.mylyn.gitlab.GitLabIssueManagementService;
import de.verit.klaros.service.issuemanagement.mylyn.jira.JiraIssueManagementService;
import de.verit.klaros.service.issuemanagement.mylyn.mantis.MantisIssueManagementService;
import de.verit.klaros.service.issuemanagement.mylyn.trac.TracIssueManagementService;
import de.verit.klaros.service.issuemanagement.redmine.RedmineIssueManagementService;
import org.eclipse.mylyn.internal.trac.core.client.ITracClient;

public final class IssueManagementConnectionFactory {
    protected IssueManagementConnectionFactory() {
    }

    public static IssueManagementConnection createConnection(IssueManagementServiceType type, String url, String projectKey, String session, ExternalServiceCredential initialAuthentication) {
        return new IssueManagementConnectionImpl(IssueManagementConnectionFactory.getService(type, url, projectKey, session), initialAuthentication);
    }

    private static IssueManagementService getService(IssueManagementServiceType type, String url, String projectKey, String session) {
        BaseExternalService service;
        switch (type) {
            case BUGZILLA: {
                service = new BugzillaIssueManagementService(url, projectKey);
                break;
            }
            case JIRA: {
                service = new JiraIssueManagementService(session, url, projectKey);
                break;
            }
            case JIRA_REST: {
                service = new JiraRestIssueManagementService(url, projectKey);
                break;
            }
            case REDMINE: {
                service = new RedmineIssueManagementService(url, projectKey);
                break;
            }
            case TRAC: {
                service = new TracIssueManagementService(session, url, ITracClient.Version.XML_RPC.name());
                break;
            }
            case MANTIS: {
                service = new MantisIssueManagementService(url, projectKey);
                break;
            }
            case GITHUB: {
                service = new GitHubIssueManagementService(url);
                break;
            }
            case GITLAB: {
                service = new GitLabIssueManagementService(url);
                break;
            }
            default: {
                service = null;
            }
        }
        return service;
    }
}

