/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.core;

import com.atlassian.connector.eclipse.internal.jira.core.JiraAttribute;
import com.atlassian.connector.eclipse.internal.jira.core.JiraAttributeMapper;
import com.atlassian.connector.eclipse.internal.jira.core.JiraFieldType;
import com.atlassian.connector.eclipse.internal.jira.core.JiraTaskMapper;
import com.atlassian.connector.eclipse.internal.jira.core.KlarosJiraClientFactory;
import com.atlassian.connector.eclipse.internal.jira.core.KlarosJiraCorePlugin;
import com.atlassian.connector.eclipse.internal.jira.core.KlarosJiraRepositoryConnector;
import com.atlassian.connector.eclipse.internal.jira.core.Messages;
import com.atlassian.connector.eclipse.internal.jira.core.WorkLogConverter;
import com.atlassian.connector.eclipse.internal.jira.core.html.HTML2TextReader;
import com.atlassian.connector.eclipse.internal.jira.core.model.Attachment;
import com.atlassian.connector.eclipse.internal.jira.core.model.Comment;
import com.atlassian.connector.eclipse.internal.jira.core.model.Component;
import com.atlassian.connector.eclipse.internal.jira.core.model.CustomField;
import com.atlassian.connector.eclipse.internal.jira.core.model.IssueField;
import com.atlassian.connector.eclipse.internal.jira.core.model.IssueLink;
import com.atlassian.connector.eclipse.internal.jira.core.model.IssueType;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraAction;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraIssue;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraStatus;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraVersion;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraWorkLog;
import com.atlassian.connector.eclipse.internal.jira.core.model.Priority;
import com.atlassian.connector.eclipse.internal.jira.core.model.Project;
import com.atlassian.connector.eclipse.internal.jira.core.model.ProjectRole;
import com.atlassian.connector.eclipse.internal.jira.core.model.Resolution;
import com.atlassian.connector.eclipse.internal.jira.core.model.SecurityLevel;
import com.atlassian.connector.eclipse.internal.jira.core.model.Subtask;
import com.atlassian.connector.eclipse.internal.jira.core.model.User;
import com.atlassian.connector.eclipse.internal.jira.core.model.Version;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraClient;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraException;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraInsufficientPermissionException;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraServiceUnavailableException;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraTimeFormat;
import com.atlassian.connector.eclipse.internal.jira.core.util.JiraUtil;
import com.atlassian.connector.eclipse.internal.jira.core.wsdl.beans.RemoteIssue;
import de.verit.klaros.util.ListUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.CallSite;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMetaData;
import org.eclipse.mylyn.tasks.core.data.TaskCommentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskOperation;
import org.eclipse.osgi.util.NLS;

public class KlarosJiraTaskDataHandler
extends AbstractTaskDataHandler {
    private static final String CONTEXT_ATTACHEMENT_FILENAME = "mylyn-context.zip";
    private static final String CONTEXT_ATTACHEMENT_FILENAME_LEGACY = "mylar-context.zip";
    private static final String CONTEXT_ATTACHMENT_DESCRIPTION = "mylyn/context/zip";
    private static final String CONTEXT_ATTACHMENT_DESCRIPTION_LEGACY = "mylar/context/zip";
    private static final boolean TRACE_ENABLED = Boolean.valueOf(Platform.getDebugOption((String)"com.atlassian.connector.eclipse.jira.core/debug/dataHandler"));
    private static final String REASSIGN_OPERATION = "reassign";
    public static final String STOP_PROGRESS_OPERATION = "301";
    public static final String START_PROGRESS_OPERATION = "4";
    public static final Object IN_PROGRESS_STATUS = "3";
    public static final Object OPEN_STATUS = "1";
    public static final Object REOPEN_STATUS = "4";
    private static final String LEAVE_OPERATION = "leave";
    private static final JiraVersion TASK_DATA_VERSION_1_0 = new JiraVersion("1.0");
    private static final JiraVersion TASK_DATA_VERSION_2_0 = new JiraVersion("2.0");
    private static final JiraVersion TASK_DATA_VERSION_2_2 = new JiraVersion("2.2");
    private static final JiraVersion TASK_DATA_VERSION_CURRENT = new JiraVersion("3.0");
    private final KlarosJiraClientFactory clientFactory;
    private String sessionName;

    public KlarosJiraTaskDataHandler(KlarosJiraClientFactory clientFactory, String sessionName) {
        this.clientFactory = clientFactory;
        this.sessionName = sessionName;
    }

    public TaskData getTaskData(TaskRepository repository, String taskId, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            JiraIssue jiraIssue;
            monitor.beginTask(Messages.JiraTaskDataHandler_Getting_task, -1);
            JiraClient client = this.clientFactory.getJiraClient(this.sessionName, repository);
            if (!client.getCache().hasDetails()) {
                client.getCache().refreshDetails(monitor);
            }
            if ((jiraIssue = this.getJiraIssue(client, taskId, repository.getRepositoryUrl(), monitor)) != null) {
                TaskData taskData = this.createTaskData(repository, client, jiraIssue, null, monitor);
                return taskData;
            }
            try {
                throw new CoreException((IStatus)new Status(4, "com.atlassian.connector.eclipse.internal.jira.core", 0, "JIRA ticket not found: " + taskId, null));
            }
            catch (JiraException e) {
                IStatus status = KlarosJiraCorePlugin.toStatus(repository, e);
                KlarosJiraTaskDataHandler.trace(status);
                throw new CoreException(status);
            }
        }
        finally {
            monitor.done();
        }
    }

    private JiraIssue getJiraIssue(JiraClient client, String taskId, String repositoryUrl, IProgressMonitor monitor) throws CoreException, JiraException {
        try {
            int id = Integer.parseInt(taskId);
            String issueKey = client.getKeyFromId("" + id, monitor);
            return client.getIssueByKey(issueKey, monitor);
        }
        catch (NumberFormatException e) {
            return client.getIssueByKey(taskId, monitor);
        }
    }

    public TaskData createTaskData(TaskRepository repository, JiraClient client, JiraIssue jiraIssue, TaskData oldTaskData, IProgressMonitor monitor) throws JiraException {
        return this.createTaskData(repository, client, jiraIssue, oldTaskData, false, monitor);
    }

    public TaskData createTaskData(TaskRepository repository, JiraClient client, JiraIssue jiraIssue, TaskData oldTaskData, boolean forceCache, IProgressMonitor monitor) throws JiraException {
        TaskData data = new TaskData(this.getAttributeMapper(repository), "jira", repository.getRepositoryUrl(), jiraIssue.getId());
        this.initializeTaskData(repository, data, client, jiraIssue.getProject(), monitor);
        this.updateTaskData(data, jiraIssue, client, oldTaskData, forceCache, monitor);
        this.addOperations(data, jiraIssue, client, oldTaskData, forceCache, monitor);
        return data;
    }

    private Project ensureProjectHasDetails(JiraClient client, TaskRepository repository, Project project, IProgressMonitor monitor) throws JiraException {
        if (!project.hasDetails()) {
            client.getCache().refreshProjectDetails(project.getId(), monitor);
            return client.getCache().getProjectById(project.getId());
        }
        return project;
    }

    public void initializeTaskData(TaskRepository repository, TaskData data, JiraClient client, Project project, IProgressMonitor monitor) throws JiraException {
        SecurityLevel[] securityLevels;
        Project[] jiraProjects;
        project = this.ensureProjectHasDetails(client, repository, project, monitor);
        data.setVersion(TASK_DATA_VERSION_CURRENT.toString());
        this.createAttribute(data, JiraAttribute.CREATION_DATE);
        TaskAttribute summaryAttribute = this.createAttribute(data, JiraAttribute.SUMMARY);
        summaryAttribute.getMetaData().setType("shortRichText");
        TaskAttribute descriptionAttribute = this.createAttribute(data, JiraAttribute.DESCRIPTION);
        descriptionAttribute.getMetaData().setType("longRichText");
        this.createAttribute(data, JiraAttribute.STATUS);
        this.createAttribute(data, JiraAttribute.ISSUE_KEY);
        this.createAttribute(data, JiraAttribute.TASK_URL);
        this.createAttribute(data, JiraAttribute.USER_ASSIGNED);
        this.createAttribute(data, JiraAttribute.USER_REPORTER);
        this.createAttribute(data, JiraAttribute.MODIFICATION_DATE);
        TaskAttribute projectAttribute = this.createAttribute(data, JiraAttribute.PROJECT);
        for (Project jiraProject : jiraProjects = client.getCache().getProjects()) {
            projectAttribute.putOption(jiraProject.getId(), jiraProject.getName());
        }
        projectAttribute.setValue(project.getId());
        TaskAttribute resolutions = this.createAttribute(data, JiraAttribute.RESOLUTION);
        Resolution[] jiraResolutions = client.getCache().getResolutions();
        if (jiraResolutions.length > 0) {
            for (Resolution resolution : jiraResolutions) {
                resolutions.putOption(resolution.getId(), resolution.getName());
            }
        } else {
            resolutions.putOption("1", "Fixed");
            resolutions.putOption("2", "Won't Fix");
            resolutions.putOption("3", "Duplicate");
            resolutions.putOption(START_PROGRESS_OPERATION, "Incomplete");
            resolutions.putOption("5", "Cannot Reproduce");
        }
        TaskAttribute priorities = this.createAttribute(data, JiraAttribute.PRIORITY);
        Priority[] jiraPriorities = client.getCache().getPriorities();
        for (int i = 0; i < jiraPriorities.length; ++i) {
            Priority priority = jiraPriorities[i];
            priorities.putOption(priority.getId(), priority.getName());
            if (i != jiraPriorities.length / 2) continue;
            priorities.setValue(priority.getId());
        }
        TaskAttribute types = this.createAttribute(data, JiraAttribute.TYPE);
        IssueType[] jiraIssueTypes = project.getIssueTypes();
        if (jiraIssueTypes == null) {
            jiraIssueTypes = client.getCache().getIssueTypes();
        }
        for (int i = 0; i < jiraIssueTypes.length; ++i) {
            Version[] type = jiraIssueTypes[i];
            if (type.isSubTaskType()) continue;
            types.putOption(type.getId(), type.getName());
            if (i != 0) continue;
            types.setValue(type.getId());
        }
        this.createAttribute(data, JiraAttribute.PARENT_KEY);
        this.createAttribute(data, JiraAttribute.PARENT_ID);
        this.createAttribute(data, JiraAttribute.DUE_DATE);
        this.createAttribute(data, JiraAttribute.ESTIMATE);
        if (!data.isNew()) {
            this.createAttribute(data, JiraAttribute.ACTUAL);
            this.createAttribute(data, JiraAttribute.INITIAL_ESTIMATE);
        }
        TaskAttribute affectsVersions = this.createAttribute(data, JiraAttribute.AFFECTSVERSIONS);
        for (Version version : project.getVersions()) {
            affectsVersions.putOption(version.getId(), version.getName());
        }
        TaskAttribute components = this.createAttribute(data, JiraAttribute.COMPONENTS);
        for (Component component : project.getComponents()) {
            components.putOption(component.getId(), component.getName());
        }
        TaskAttribute fixVersions = this.createAttribute(data, JiraAttribute.FIXVERSIONS);
        for (Version version : project.getVersions()) {
            fixVersions.putOption(version.getId(), version.getName());
        }
        TaskAttribute env = this.createAttribute(data, JiraAttribute.ENVIRONMENT);
        env.getMetaData().setType("longRichText");
        if (!data.isNew()) {
            TaskAttribute commentAttribute = this.createAttribute(data, JiraAttribute.COMMENT_NEW);
            commentAttribute.getMetaData().setType("longRichText");
        }
        if ((securityLevels = project.getSecurityLevels()) != null) {
            TaskAttribute securityLevelAttribute = this.createAttribute(data, JiraAttribute.SECURITY_LEVEL);
            for (SecurityLevel securityLevel : securityLevels) {
                securityLevelAttribute.putOption(securityLevel.getId(), securityLevel.getName());
            }
            securityLevelAttribute.setValue(SecurityLevel.NONE.getId());
        }
        data.getRoot().createAttribute("attribute.jira.worklog.new");
        TaskAttribute projectRoles = this.createAttribute(data, JiraAttribute.PROJECT_ROLES);
        projectRoles.putOption("All Users", "All Users");
        ProjectRole[] projectRoleArray = client.getCache().getProjectRoles();
        if (projectRoleArray != null) {
            for (ProjectRole projectRole : projectRoleArray) {
                projectRoles.putOption(projectRole.getName(), projectRole.getName());
            }
        }
        this.createAttribute(data, JiraAttribute.VOTES);
    }

    public TaskAttribute createAttribute(TaskData data, JiraAttribute key) {
        TaskAttribute attribute = data.getRoot().createAttribute(key.id());
        attribute.getMetaData().defaults().setReadOnly(key.isReadOnly()).setKind(key.getKind()).setLabel(key.getName()).setType(key.getType().getTaskType()).putValue("type", key.getType().getKey());
        return attribute;
    }

    private void updateTaskData(TaskData data, JiraIssue jiraIssue, JiraClient client, TaskData oldTaskData, boolean forceCache, IProgressMonitor monitor) throws JiraException {
        IssueType issueType;
        IssueLink[] issueLinks;
        String parentKey = jiraIssue.getParentKey();
        if (parentKey != null) {
            this.setAttributeValue(data, JiraAttribute.PARENT_KEY, parentKey);
        } else {
            this.removeAttribute(data, JiraAttribute.PARENT_KEY);
        }
        String parentId = jiraIssue.getParentId();
        if (parentId != null) {
            this.setAttributeValue(data, JiraAttribute.PARENT_ID, parentId);
        } else {
            this.removeAttribute(data, JiraAttribute.PARENT_ID);
        }
        Subtask[] subtasks = jiraIssue.getSubtasks();
        if (subtasks != null && subtasks.length > 0) {
            this.createAttribute(data, JiraAttribute.SUBTASK_IDS);
            this.createAttribute(data, JiraAttribute.SUBTASK_KEYS);
            for (Subtask subtask : subtasks) {
                this.addAttributeValue(data, JiraAttribute.SUBTASK_IDS, subtask.getIssueId());
                this.addAttributeValue(data, JiraAttribute.SUBTASK_KEYS, subtask.getIssueKey());
            }
        }
        if ((issueLinks = jiraIssue.getIssueLinks()) != null && issueLinks.length > 0) {
            HashMap<CallSite, TaskAttribute> links = new HashMap<CallSite, TaskAttribute>();
            for (IssueLink link : issueLinks) {
                String desc;
                String key;
                if (link.getInwardDescription() == null) {
                    key = link.getLinkTypeId() + "outward";
                    desc = link.getOutwardDescription();
                } else {
                    key = link.getLinkTypeId() + "inward";
                    desc = link.getInwardDescription();
                }
                String label = this.capitalize(desc) + ":";
                TaskAttribute attribute = (TaskAttribute)links.get(key);
                if (attribute == null) {
                    attribute = data.getRoot().createAttribute("attribute.jira.link::" + key);
                    attribute.getMetaData().setKind("task.common.kind.default").setLabel(label).setType(JiraFieldType.ISSUELINKS.getTaskType()).putValue("type", JiraFieldType.ISSUELINKS.getKey());
                    links.put((CallSite)((Object)key), attribute);
                }
                attribute.addValue(link.getIssueKey());
                if (link.getInwardDescription() == null) continue;
                attribute = data.getRoot().getMappedAttribute(JiraAttribute.LINKED_IDS.id());
                if (attribute == null) {
                    attribute = this.createAttribute(data, JiraAttribute.LINKED_IDS);
                }
                this.addAttributeValue(data, JiraAttribute.LINKED_IDS, link.getIssueId());
            }
        }
        this.setAttributeValue(data, JiraAttribute.CREATION_DATE, JiraUtil.dateToString((Date)jiraIssue.getCreated()));
        this.setAttributeValue(data, JiraAttribute.SUMMARY, jiraIssue.getSummary());
        this.setAttributeValue(data, JiraAttribute.DESCRIPTION, jiraIssue.getDescription());
        this.setAttributeValue(data, JiraAttribute.ISSUE_KEY, jiraIssue.getKey());
        this.setAttributeValue(data, JiraAttribute.TASK_URL, jiraIssue.getUrl());
        this.setAttributeValue(data, JiraAttribute.RESOLUTION, jiraIssue.getResolution() == null ? "" : jiraIssue.getResolution().getId());
        this.setAttributeValue(data, JiraAttribute.MODIFICATION_DATE, JiraUtil.dateToString((Date)jiraIssue.getUpdated()));
        this.setAttributeValue(data, JiraAttribute.USER_ASSIGNED, KlarosJiraTaskDataHandler.getPerson(data, client, jiraIssue.getAssignee(), jiraIssue.getAssigneeName()));
        this.setAttributeValue(data, JiraAttribute.USER_REPORTER, KlarosJiraTaskDataHandler.getPerson(data, client, jiraIssue.getReporter(), jiraIssue.getReporterName()));
        this.setAttributeValue(data, JiraAttribute.PROJECT, jiraIssue.getProject().getId());
        if (jiraIssue.getStatus() != null) {
            TaskAttribute attribute = data.getRoot().getAttribute(JiraAttribute.STATUS.id());
            attribute.putOption(jiraIssue.getStatus().getId(), jiraIssue.getStatus().getName());
            attribute.setValue(jiraIssue.getStatus().getId());
        }
        if (jiraIssue.getPriority() != null) {
            this.setAttributeValue(data, JiraAttribute.PRIORITY, jiraIssue.getPriority().getId());
        } else {
            this.removeAttribute(data, JiraAttribute.PRIORITY);
        }
        SecurityLevel securityLevel = jiraIssue.getSecurityLevel();
        if (securityLevel != null) {
            TaskAttribute attribute = data.getRoot().getAttribute(JiraAttribute.SECURITY_LEVEL.id());
            if (attribute == null) {
                attribute = this.createAttribute(data, JiraAttribute.SECURITY_LEVEL);
                attribute.getMetaData().setReadOnly(true);
            }
            if (!attribute.getOptions().containsKey(securityLevel.getId())) {
                attribute.putOption(securityLevel.getId(), securityLevel.getName());
            }
            attribute.setValue(securityLevel.getId());
        }
        if ((issueType = jiraIssue.getType()) != null) {
            TaskAttribute attribute = this.setAttributeValue(data, JiraAttribute.TYPE, issueType.getId());
            if (issueType.isSubTaskType()) {
                attribute.getMetaData().setReadOnly(true).putValue("isSubtaskType", Boolean.toString(true));
                attribute.clearOptions();
                attribute.putOption(issueType.getId(), issueType.getName());
            }
        } else {
            this.removeAttribute(data, JiraAttribute.TYPE);
        }
        if (jiraIssue.getActual() > 0L) {
            this.setAttributeValue(data, JiraAttribute.INITIAL_ESTIMATE, "" + jiraIssue.getInitialEstimate());
        } else {
            this.removeAttribute(data, JiraAttribute.INITIAL_ESTIMATE);
        }
        this.setAttributeValue(data, JiraAttribute.ESTIMATE, "" + jiraIssue.getEstimate());
        this.setAttributeValue(data, JiraAttribute.ACTUAL, "" + jiraIssue.getActual());
        if (jiraIssue.getDue() != null) {
            this.setAttributeValue(data, JiraAttribute.DUE_DATE, JiraUtil.dateToString((Date)jiraIssue.getDue()));
        } else if (!jiraIssue.hasDueDate()) {
            this.removeAttribute(data, JiraAttribute.DUE_DATE);
        }
        if (jiraIssue.getComponents() != null) {
            for (Component component : jiraIssue.getComponents()) {
                this.addAttributeValue(data, JiraAttribute.COMPONENTS, component.getId());
            }
        }
        if (jiraIssue.getReportedVersions() != null) {
            for (Version version : jiraIssue.getReportedVersions()) {
                this.addAttributeValue(data, JiraAttribute.AFFECTSVERSIONS, version.getId());
            }
        }
        if (jiraIssue.getFixVersions() != null) {
            for (Version version : jiraIssue.getFixVersions()) {
                this.addAttributeValue(data, JiraAttribute.FIXVERSIONS, version.getId());
            }
        }
        if (jiraIssue.getEnvironment() != null) {
            this.setAttributeValue(data, JiraAttribute.ENVIRONMENT, jiraIssue.getEnvironment());
        } else {
            this.removeAttribute(data, JiraAttribute.ENVIRONMENT);
        }
        if (jiraIssue.getVotes() > 0) {
            this.setAttributeValue(data, JiraAttribute.VOTES, Integer.toString(jiraIssue.getVotes()));
        } else {
            this.removeAttribute(data, JiraAttribute.VOTES);
        }
        this.addAttributeValue(data, JiraAttribute.PROJECT_ROLES, "All Users");
        this.addComments(data, jiraIssue, client);
        this.addAttachments(data, jiraIssue, client);
        this.addCustomFields(data, jiraIssue);
        this.addWorklog(data, jiraIssue, client, oldTaskData, forceCache, monitor);
        this.updateMarkup(data, jiraIssue, client, oldTaskData, forceCache, monitor);
        HashSet<String> editableKeys = this.getEditableKeys(data, jiraIssue, client, oldTaskData, forceCache, monitor);
        this.updateProperties(data, editableKeys);
    }

    public static IRepositoryPerson getPerson(TaskData data, JiraClient client, String userId, String fullName) {
        if (userId == null || "-1".equals(userId)) {
            userId = "";
        }
        User user = fullName != null ? client.getCache().putUser(userId, fullName) : client.getCache().getUser(userId);
        IRepositoryPerson person = data.getAttributeMapper().getTaskRepository().createPerson(userId);
        if (user != null) {
            person.setName(user.getFullName());
        }
        return person;
    }

    private void addComments(TaskData data, JiraIssue jiraIssue, JiraClient client) {
        int i = 1;
        List comments = ListUtil.getList((Object[])jiraIssue.getComments());
        Collections.sort(comments, new CommentDateComparator());
        for (Comment comment : comments) {
            TaskAttribute attribute = data.getRoot().createAttribute("task.common.comment-" + i);
            TaskCommentMapper taskComment = TaskCommentMapper.createFrom((TaskAttribute)attribute);
            taskComment.setAuthor(KlarosJiraTaskDataHandler.getPerson(data, client, comment.getAuthor(), null));
            taskComment.setNumber(Integer.valueOf(i));
            String commentText = comment.getComment();
            if (comment.isMarkupDetected()) {
                commentText = KlarosJiraTaskDataHandler.stripTags(commentText);
            }
            taskComment.setText(commentText);
            taskComment.setCreationDate(comment.getCreated());
            taskComment.applyTo(attribute);
            if (comment.getRoleLevel() != null) {
                TaskAttribute level = attribute.createAttribute("task.common.comment.level");
                level.setValue(comment.getRoleLevel());
            }
            ++i;
        }
    }

    private void addAttachments(TaskData data, JiraIssue jiraIssue, JiraClient client) {
        int i = 1;
        for (Attachment attachment : jiraIssue.getAttachments()) {
            TaskAttribute attribute = data.getRoot().createAttribute("task.common.attachment-" + i);
            TaskAttachmentMapper taskAttachment = TaskAttachmentMapper.createFrom((TaskAttribute)attribute);
            taskAttachment.setAttachmentId(attachment.getId());
            taskAttachment.setAuthor(KlarosJiraTaskDataHandler.getPerson(data, client, attachment.getAuthor(), null));
            taskAttachment.setFileName(attachment.getName());
            if (CONTEXT_ATTACHEMENT_FILENAME.equals(attachment.getName())) {
                taskAttachment.setDescription(CONTEXT_ATTACHMENT_DESCRIPTION);
            } else if (CONTEXT_ATTACHEMENT_FILENAME_LEGACY.equals(attachment.getName())) {
                taskAttachment.setDescription(CONTEXT_ATTACHMENT_DESCRIPTION_LEGACY);
            } else {
                taskAttachment.setDescription(attachment.getName());
            }
            taskAttachment.setLength(Long.valueOf(attachment.getSize()));
            taskAttachment.setCreationDate(attachment.getCreated());
            taskAttachment.setUrl(client.getBaseUrl() + "/secure/attachment/" + attachment.getId() + "/" + attachment.getName());
            taskAttachment.applyTo(attribute);
            ++i;
        }
    }

    private void addCustomFields(TaskData data, JiraIssue jiraIssue) {
        for (CustomField field : jiraIssue.getCustomFields()) {
            String mappedKey = this.mapCommonAttributeKey(field.getId());
            String name = field.getName() + ":";
            String kind = JiraAttribute.valueById((String)mappedKey).getKind();
            String type = field.getKey();
            String taskType = JiraFieldType.fromKey((String)type).getTaskType();
            if (taskType == null && type != null && type.startsWith("com.atlassian.jira.toolkit")) {
                taskType = "shortText";
            }
            TaskAttribute attribute = data.getRoot().createAttribute(mappedKey);
            attribute.getMetaData().defaults().setKind(kind).setLabel(name).setReadOnly(field.isReadOnly()).setType(taskType).putValue("type", type);
            for (String value : field.getValues()) {
                attribute.addValue(value);
            }
        }
    }

    private HashSet<String> getEditableKeys(TaskData data, JiraIssue jiraIssue, JiraClient client, TaskData oldTaskData, boolean forceCache, IProgressMonitor monitor) throws JiraException {
        HashSet<String> editableKeys = new HashSet<String>();
        if (!KlarosJiraRepositoryConnector.isClosed(jiraIssue)) {
            if (this.useCachedInformation(jiraIssue, oldTaskData, forceCache)) {
                if (oldTaskData == null) {
                    data.setPartial(true);
                    return editableKeys;
                }
                for (TaskAttribute attribute : oldTaskData.getRoot().getAttributes().values()) {
                    if (attribute.getMetaData().isReadOnly()) continue;
                    editableKeys.add(attribute.getId());
                }
                TaskAttribute attribute = oldTaskData.getRoot().getAttribute("attribute.jira.read-only");
                if (attribute != null) {
                    data.getRoot().deepAddCopy(attribute);
                }
            } else {
                try {
                    IssueField[] editableAttributes = client.getEditableAttributes(jiraIssue.getKey(), monitor);
                    if (editableAttributes != null) {
                        for (IssueField field : editableAttributes) {
                            editableKeys.add(this.mapCommonAttributeKey(field.getId()));
                        }
                    }
                }
                catch (JiraInsufficientPermissionException e) {
                    KlarosJiraTaskDataHandler.trace((Exception)((Object)e));
                    data.getRoot().createAttribute("attribute.jira.read-only");
                }
            }
        }
        return editableKeys;
    }

    private void updateProperties(TaskData data, HashSet<String> editableKeys) {
        for (TaskAttribute attribute : data.getRoot().getAttributes().values()) {
            TaskAttributeMetaData properties = attribute.getMetaData();
            boolean editable = editableKeys.contains(attribute.getId().toLowerCase());
            if (editable && (attribute.getId().startsWith("attribute.jira.custom::") || !JiraAttribute.valueById((String)attribute.getId()).isHidden())) {
                properties.setKind("task.common.kind.default");
            }
            if ("task.common.comment.new".equals(attribute.getId()) || "task.common.resolution".equals(attribute.getId()) || "task.common.user.assigned".equals(attribute.getId()) || JiraAttribute.PROJECT_ROLES.id().equals(attribute.getId())) {
                properties.setReadOnly(false);
                continue;
            }
            String key = properties.getValue("type");
            Map options = attribute.getOptions();
            if (JiraFieldType.SELECT.getKey().equals(key) && (options.isEmpty() || properties.isReadOnly())) {
                properties.setReadOnly(true);
                continue;
            }
            if (JiraFieldType.MULTISELECT.getKey().equals(key) && options.isEmpty()) {
                properties.setReadOnly(true);
                continue;
            }
            properties.setReadOnly(!editable);
        }
    }

    private void addAttributeValue(TaskData data, JiraAttribute key, String value) {
        data.getRoot().getAttribute(key.id()).addValue(value);
    }

    private TaskAttribute setAttributeValue(TaskData data, JiraAttribute key, String value) {
        TaskAttribute attribute = data.getRoot().getAttribute(key.id());
        if (value != null) {
            attribute.setValue(value);
        }
        return attribute;
    }

    private TaskAttribute setAttributeValue(TaskData data, JiraAttribute key, IRepositoryPerson person) {
        TaskAttribute attribute = data.getRoot().getAttribute(key.id());
        data.getAttributeMapper().setRepositoryPerson(attribute, person);
        return attribute;
    }

    private boolean useCachedInformation(JiraIssue issue, TaskData oldTaskData, boolean forceCache) {
        TaskAttribute attribute;
        if (forceCache) {
            return true;
        }
        if (oldTaskData != null && issue.getStatus() != null && (attribute = oldTaskData.getRoot().getMappedAttribute("task.common.status")) != null) {
            return attribute.getValue().equals(issue.getStatus().getId());
        }
        return false;
    }

    private void removeAttribute(TaskData data, JiraAttribute key) {
        data.getRoot().removeAttribute(key.id());
    }

    private String capitalize(String s) {
        char c;
        char uc;
        if (s.length() > 1 && (uc = Character.toUpperCase(c = s.charAt(0))) != c) {
            return uc + s.substring(1);
        }
        return s;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String stripTags(String text) {
        if (text == null || text.length() == 0) {
            return "";
        }
        try (StringReader stringReader = new StringReader(text);){
            int len;
            char[] chars;
            HTML2TextReader html2TextReader;
            block15: {
                String string;
                html2TextReader = new HTML2TextReader((Reader)stringReader);
                try {
                    chars = new char[text.length()];
                    len = html2TextReader.read(chars, 0, text.length());
                    if (len != -1) break block15;
                    string = "";
                }
                catch (Throwable throwable) {
                    try {
                        html2TextReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                html2TextReader.close();
                return string;
            }
            String string = new String(chars, 0, len);
            html2TextReader.close();
            return string;
        }
        catch (IOException e) {
            return text;
        }
    }

    private void updateMarkup(TaskData data, JiraIssue jiraIssue, JiraClient client, TaskData oldTaskData, boolean forceCache, IProgressMonitor monitor) throws JiraException {
        if (!jiraIssue.isMarkupDetected()) {
            return;
        }
        if (this.useCachedData(jiraIssue, oldTaskData, forceCache)) {
            if (oldTaskData == null) {
                data.setPartial(true);
                return;
            }
            if (data.getRoot().getAttribute("task.common.description") != null) {
                this.setAttributeValue(data, JiraAttribute.DESCRIPTION, KlarosJiraTaskDataHandler.getAttributeValue(oldTaskData, JiraAttribute.DESCRIPTION));
            }
            if (data.getRoot().getAttribute("attribute.jira.environment") != null) {
                this.setAttributeValue(data, JiraAttribute.ENVIRONMENT, KlarosJiraTaskDataHandler.getAttributeValue(oldTaskData, JiraAttribute.ENVIRONMENT));
            }
            for (CustomField field : jiraIssue.getCustomFields()) {
                if (!field.isMarkupDetected()) continue;
                String attributeId = this.mapCommonAttributeKey(field.getId());
                TaskAttribute oldAttribute = oldTaskData.getRoot().getAttribute(attributeId);
                if (oldAttribute == null) continue;
                TaskAttribute attribute = data.getRoot().getAttribute(attributeId);
                attribute.setValues(oldAttribute.getValues());
            }
            int i = 1;
            for (Comment comment : jiraIssue.getComments()) {
                if (comment.isMarkupDetected()) {
                    String attributeId = "task.common.comment-" + i;
                    TaskAttribute oldAttribute = oldTaskData.getRoot().getAttribute(attributeId);
                    if (oldAttribute != null) {
                        TaskCommentMapper oldComment = TaskCommentMapper.createFrom((TaskAttribute)oldAttribute);
                        TaskAttribute attribute = data.getRoot().getAttribute(attributeId);
                        TaskCommentMapper newComment = TaskCommentMapper.createFrom((TaskAttribute)attribute);
                        newComment.setText(oldComment.getText());
                        newComment.applyTo(attribute);
                    }
                }
                ++i;
            }
            return;
        }
        try {
            RemoteIssue remoteIssue = client.getSoapClient().getIssueByKey(jiraIssue.getKey(), monitor);
            if (data.getRoot().getAttribute("task.common.description") != null) {
                if (remoteIssue.getDescription() == null) {
                    this.setAttributeValue(data, JiraAttribute.DESCRIPTION, "");
                } else {
                    this.setAttributeValue(data, JiraAttribute.DESCRIPTION, remoteIssue.getDescription());
                }
            }
            if (data.getRoot().getAttribute("attribute.jira.environment") != null) {
                if (remoteIssue.getEnvironment() == null) {
                    this.setAttributeValue(data, JiraAttribute.ENVIRONMENT, "");
                } else {
                    this.setAttributeValue(data, JiraAttribute.ENVIRONMENT, remoteIssue.getEnvironment());
                }
            }
            Comment[] fields = remoteIssue.getCustomFieldValues();
            CustomField[] customFieldArray = jiraIssue.getCustomFields();
            int n = customFieldArray.length;
            block7: for (int comment = 0; comment < n; ++comment) {
                CustomField field = customFieldArray[comment];
                if (!field.isMarkupDetected()) continue;
                for (Comment remoteField : fields) {
                    if (!field.getId().equals(remoteField.getCustomfieldId())) continue;
                    String attributeId = this.mapCommonAttributeKey(field.getId());
                    TaskAttribute attribute = data.getRoot().getAttribute(attributeId);
                    if (attribute == null) continue block7;
                    attribute.setValues(ListUtil.getList((Object[])remoteField.getValues()));
                    continue block7;
                }
            }
        }
        catch (JiraInsufficientPermissionException e) {
            KlarosJiraTaskDataHandler.trace((Exception)((Object)e));
        }
        boolean retrieveComments = false;
        for (Comment comment : jiraIssue.getComments()) {
            if (!comment.isMarkupDetected()) continue;
            retrieveComments = true;
        }
        if (retrieveComments) {
            try {
                Comment[] remoteComments = client.getSoapClient().getComments(jiraIssue.getKey(), monitor);
                int i = 1;
                for (Comment remoteComment : remoteComments) {
                    String attributeId = "task.common.comment-" + i;
                    TaskAttribute attribute = data.getRoot().getAttribute(attributeId);
                    if (attribute != null) {
                        TaskCommentMapper comment = TaskCommentMapper.createFrom((TaskAttribute)attribute);
                        comment.setText(remoteComment.getComment());
                        comment.applyTo(attribute);
                    }
                    ++i;
                }
            }
            catch (JiraInsufficientPermissionException e) {
                KlarosJiraTaskDataHandler.trace((Exception)((Object)e));
            }
            catch (JiraServiceUnavailableException e) {
                if ("Invalid element in com.atlassian.connector.eclipse.internal.jira.core.wsdl.beans.RemoteComment - level".equals(e.getMessage())) {
                    KlarosJiraTaskDataHandler.trace((Exception)((Object)e));
                }
                throw e;
            }
        }
    }

    private boolean useCachedData(JiraIssue jiraIssue, TaskData oldTaskData, boolean forceCache) {
        if (forceCache) {
            return true;
        }
        return jiraIssue.getUpdated() != null && oldTaskData != null && jiraIssue.getUpdated().equals(KlarosJiraTaskDataHandler.getDateValue(oldTaskData, JiraAttribute.MODIFICATION_DATE));
    }

    private void addWorklog(TaskData data, JiraIssue jiraIssue, JiraClient client, TaskData oldTaskData, boolean forceCache, IProgressMonitor monitor) throws JiraException {
        if (this.useCachedData(jiraIssue, oldTaskData, forceCache) && this.useCachedInformation(jiraIssue, oldTaskData, forceCache)) {
            if (oldTaskData == null) {
                data.setPartial(true);
                return;
            }
            List attributes = oldTaskData.getAttributeMapper().getAttributesByType(oldTaskData, "jira.worklog");
            for (TaskAttribute taskAttribute : attributes) {
                data.getRoot().deepAddCopy(taskAttribute);
            }
            TaskAttribute attribute = oldTaskData.getRoot().getAttribute("attribute.jira.worklog-not-supported");
            if (attribute != null) {
                data.getRoot().deepAddCopy(attribute);
            }
            return;
        }
        try {
            JiraWorkLog[] remoteWorklogs = client.getWorklogs(jiraIssue.getKey(), monitor);
            if (remoteWorklogs != null) {
                int i = 1;
                for (JiraWorkLog remoteWorklog : remoteWorklogs) {
                    String attributeId = "attribute.jira.worklog--" + i;
                    TaskAttribute attribute = data.getRoot().createAttribute(attributeId);
                    attribute.getMetaData().setType("jira.worklog");
                    new WorkLogConverter().applyTo(remoteWorklog, attribute);
                    ++i;
                }
            } else {
                data.getRoot().createAttribute("attribute.jira.worklog-not-supported");
            }
        }
        catch (JiraInsufficientPermissionException e) {
            KlarosJiraTaskDataHandler.trace((Exception)((Object)e));
            data.getRoot().createAttribute("attribute.jira.worklog-not-supported");
        }
    }

    public void addOperations(TaskData data, JiraIssue issue, JiraClient client, TaskData oldTaskData, boolean forceCache, IProgressMonitor monitor) throws JiraException {
        if (this.useCachedInformation(issue, oldTaskData, forceCache)) {
            if (oldTaskData == null) {
                data.setPartial(true);
                return;
            }
            List attributes = oldTaskData.getAttributeMapper().getAttributesByType(oldTaskData, "operation");
            for (TaskAttribute taskAttribute : attributes) {
                data.getRoot().deepAddCopy(taskAttribute);
            }
            return;
        }
        JiraStatus status = issue.getStatus();
        String label = status != null ? NLS.bind((String)Messages.JiraTaskDataHandler_Leave_as_X, (Object)status.getName()) : Messages.JiraTaskDataHandler_Leave;
        TaskAttribute attribute = data.getRoot().createAttribute("task.common.operation-leave");
        TaskOperation.applyTo((TaskAttribute)attribute, (String)LEAVE_OPERATION, (String)label);
        attribute = data.getRoot().createAttribute("task.common.operation");
        TaskOperation.applyTo((TaskAttribute)attribute, (String)LEAVE_OPERATION, (String)label);
        JiraAction[] availableActions = client.getAvailableActions(issue.getKey(), monitor);
        if (availableActions != null) {
            for (JiraAction action : availableActions) {
                String[] fields;
                attribute = data.getRoot().createAttribute("task.common.operation-" + action.getId());
                TaskOperation.applyTo((TaskAttribute)attribute, (String)action.getId(), (String)action.getName());
                for (String field : fields = client.getActionFields(issue.getKey(), action.getId(), monitor)) {
                    if (!"task.common.resolution".equals(this.mapCommonAttributeKey(field))) continue;
                    attribute.getMetaData().putValue("task.meta.associated.attribute", "task.common.resolution");
                }
            }
        }
    }

    public RepositoryResponse postTaskData(TaskRepository repository, TaskData taskData, Set<TaskAttribute> changedAttributes, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            HashSet anythingElse;
            String commentVisibility;
            HashSet<String> changeIds;
            String newComment;
            String operationId;
            JiraIssue issue;
            JiraClient client;
            block25: {
                monitor.beginTask(Messages.JiraTaskDataHandler_Sending_task, -1);
                client = this.clientFactory.getJiraClient(this.sessionName, repository);
                if (client == null) {
                    throw new CoreException((IStatus)new Status(4, "com.atlassian.connector.eclipse.internal.jira.core", 4, "Unable to create Jira client", null));
                }
                try {
                    if (!client.getCache().hasDetails()) {
                        client.getCache().refreshDetails(monitor);
                    }
                    issue = KlarosJiraTaskDataHandler.buildJiraIssue(taskData);
                    if (taskData.isNew()) {
                        if ((issue = issue.getType().isSubTaskType() && issue.getParentId() != null ? client.createSubTask(issue, monitor) : client.createIssue(issue, monitor)) == null) {
                            throw new CoreException((IStatus)new Status(4, "com.atlassian.connector.eclipse.internal.jira.core", 0, "Could not create issue.", null));
                        }
                        if (taskData.getRoot().getAttribute("attribute.jira.worklog-not-supported") == null) {
                            this.postWorkLog(repository, client, taskData, issue, monitor);
                        }
                        RepositoryResponse repositoryResponse = new RepositoryResponse(RepositoryResponse.ResponseKind.TASK_CREATED, issue.getId());
                        return repositoryResponse;
                    }
                    operationId = this.getOperationId(taskData);
                    newComment = this.getNewComment(taskData);
                    changeIds = new HashSet<String>();
                    if (changedAttributes == null) break block25;
                }
                catch (JiraException e) {
                    IStatus status = KlarosJiraCorePlugin.toStatus(repository, e);
                    KlarosJiraTaskDataHandler.trace(status);
                    throw new CoreException(status);
                }
                for (TaskAttribute ta : changedAttributes) {
                    changeIds.add(ta.getId());
                }
            }
            Comment soapComment = null;
            TaskAttribute commentVisibilityAttribute = taskData.getRoot().getMappedAttribute(JiraAttribute.PROJECT_ROLES.id());
            if (commentVisibilityAttribute != null && !"All Users".equals(commentVisibility = commentVisibilityAttribute.getValue())) {
                changeIds.remove(JiraAttribute.PROJECT_ROLES.id());
                if (newComment != null && newComment.length() > 0) {
                    soapComment = new Comment();
                    soapComment.setComment(newComment);
                    soapComment.setRoleLevel(commentVisibility);
                    newComment = null;
                }
            }
            boolean handled = false;
            boolean advWorkflowHandled = false;
            if (!handled && changeIds.contains("task.common.user.assigned")) {
                anythingElse = new HashSet(changeIds);
                anythingElse.removeAll(ListUtil.getList((Object[])new String[]{"task.common.user.assigned", "task.common.comment.new"}));
                if (anythingElse.isEmpty()) {
                    client.assignIssueTo(issue, 4, this.getAssignee(taskData), newComment, monitor);
                    handled = true;
                }
            }
            if (!handled && changeIds.contains("task.common.operation")) {
                anythingElse = new HashSet(changeIds);
                anythingElse.removeAll(ListUtil.getList((Object[])new String[]{"task.common.operation", "task.common.comment.new"}));
                if (anythingElse.isEmpty()) {
                    client.advanceIssueWorkflow(issue, operationId, newComment, monitor);
                    handled = true;
                    advWorkflowHandled = true;
                }
            }
            if (!handled && STOP_PROGRESS_OPERATION.equals(operationId)) {
                client.advanceIssueWorkflow(issue, operationId, null, monitor);
                advWorkflowHandled = true;
            }
            if (!(handled || KlarosJiraRepositoryConnector.isClosed(issue) || taskData.getRoot().getMappedAttribute("attribute.jira.read-only") != null || changeIds.equals(Collections.singleton("task.common.comment.new")) || STOP_PROGRESS_OPERATION.equals(operationId) && changeIds.equals(Collections.singleton("task.common.operation")))) {
                client.updateIssue(issue, newComment, monitor);
                handled = true;
            }
            if (!handled && newComment != null && newComment.length() > 0) {
                client.addCommentToIssue(issue.getKey(), newComment, monitor);
                handled = true;
            } else if (soapComment != null) {
                client.addCommentToIssue(issue.getKey(), soapComment, monitor);
                handled = true;
            }
            this.postWorkLog(repository, client, taskData, issue, monitor);
            if (!(advWorkflowHandled || LEAVE_OPERATION.equals(operationId) || REASSIGN_OPERATION.equals(operationId) || STOP_PROGRESS_OPERATION.equals(operationId))) {
                client.advanceIssueWorkflow(issue, operationId, null, monitor);
            }
            RepositoryResponse repositoryResponse = new RepositoryResponse(RepositoryResponse.ResponseKind.TASK_UPDATED, issue.getId());
            return repositoryResponse;
        }
        finally {
            monitor.done();
        }
    }

    private void postWorkLog(TaskRepository repository, JiraClient client, TaskData taskData, JiraIssue issue, IProgressMonitor monitor) throws JiraException {
        TaskAttribute submitFlagAttribute;
        TaskAttribute attribute = taskData.getRoot().getMappedAttribute("attribute.jira.worklog.new");
        if (attribute != null && (submitFlagAttribute = attribute.getAttribute("attribute.jira.worklog.new.submit.flag")) != null && submitFlagAttribute.getValue().equals(String.valueOf(true))) {
            JiraWorkLog log = new WorkLogConverter().createFrom(attribute);
            client.addWorkLog(issue.getKey(), log, monitor);
        }
    }

    private String getNewComment(TaskData taskData) {
        String newComment = "";
        TaskAttribute attribute = taskData.getRoot().getMappedAttribute("task.common.comment.new");
        if (attribute != null) {
            newComment = taskData.getAttributeMapper().getValue(attribute);
        }
        return newComment;
    }

    private String getAssignee(TaskData taskData) {
        String asignee = "";
        TaskAttribute attribute = taskData.getRoot().getMappedAttribute("task.common.user.assigned");
        if (attribute != null) {
            asignee = taskData.getAttributeMapper().getValue(attribute);
        }
        return asignee;
    }

    private String getOperationId(TaskData taskData) {
        String operationId = "";
        TaskAttribute attribute = taskData.getRoot().getMappedAttribute("task.common.operation");
        if (attribute != null) {
            operationId = taskData.getAttributeMapper().getValue(attribute);
        }
        if (operationId.length() == 0) {
            operationId = LEAVE_OPERATION;
        }
        return operationId;
    }

    public boolean initializeTaskData(TaskRepository repository, TaskData data, ITaskMapping initializationData, IProgressMonitor monitor) throws CoreException {
        Project project;
        if (initializationData == null) {
            return false;
        }
        String product = initializationData.getProduct();
        if (product == null) {
            return false;
        }
        JiraClient client = this.clientFactory.getJiraClient(this.sessionName, repository);
        if (!client.getCache().hasDetails()) {
            try {
                client.getCache().refreshDetails(monitor);
            }
            catch (JiraException ex) {
                IStatus status = KlarosJiraCorePlugin.toStatus(repository, ex);
                KlarosJiraTaskDataHandler.trace(status);
                throw new CoreException(status);
            }
        }
        if ((project = this.getProject(client, product)) == null) {
            return false;
        }
        if (!project.hasDetails()) {
            try {
                client.getCache().refreshProjectDetails(project.getId(), monitor);
            }
            catch (JiraException e) {
                IStatus status = KlarosJiraCorePlugin.toStatus(repository, e);
                KlarosJiraTaskDataHandler.trace(status);
                throw new CoreException(status);
            }
        }
        try {
            this.initializeTaskData(repository, data, client, project, monitor);
        }
        catch (JiraException e) {
            IStatus status = KlarosJiraCorePlugin.toStatus(repository, e);
            KlarosJiraTaskDataHandler.trace(status);
            throw new CoreException(status);
        }
        return true;
    }

    private Project getProject(JiraClient client, String product) {
        Project[] projects;
        for (Project project : projects = client.getCache().getProjects()) {
            if (!product.equals(project.getName()) && !product.equals(project.getKey())) continue;
            return project;
        }
        return null;
    }

    public boolean initializeSubTaskData(TaskRepository repository, TaskData taskData, TaskData parentTaskData, IProgressMonitor monitor) throws CoreException {
        try {
            IssueType[] jiraIssueTypes;
            TaskAttribute projectAttribute;
            monitor.beginTask(Messages.JiraTaskDataHandler_Creating_subtask, -1);
            JiraClient client = KlarosJiraClientFactory.getDefault().getJiraClient(this.sessionName, repository);
            if (!client.getCache().hasDetails()) {
                client.getCache().refreshDetails((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            if ((projectAttribute = parentTaskData.getRoot().getAttribute("task.common.product")) == null) {
                throw new CoreException((IStatus)new Status(4, "com.atlassian.connector.eclipse.internal.jira.core", 0, "The parent task does not have a valid project.", null));
            }
            Project project = client.getCache().getProjectById(projectAttribute.getValue());
            this.initializeTaskData(repository, taskData, client, project, monitor);
            new JiraTaskMapper(taskData).merge((ITaskMapping)new JiraTaskMapper(parentTaskData));
            taskData.getRoot().getAttribute(JiraAttribute.PROJECT.id()).setValue(project.getId());
            taskData.getRoot().getAttribute(JiraAttribute.DESCRIPTION.id()).setValue("");
            taskData.getRoot().getAttribute(JiraAttribute.SUMMARY.id()).setValue("");
            TaskAttribute typeAttribute = taskData.getRoot().getAttribute(JiraAttribute.TYPE.id());
            typeAttribute.clearOptions();
            for (IssueType type : jiraIssueTypes = client.getCache().getIssueTypes()) {
                if (!type.isSubTaskType()) continue;
                typeAttribute.putOption(type.getId(), type.getName());
            }
            Map options = typeAttribute.getOptions();
            if (options.isEmpty()) {
                throw new CoreException((IStatus)new Status(4, "com.atlassian.connector.eclipse.internal.jira.core", 0, "The repository does not support subtasks.", null));
            }
            if (options.size() == 1) {
                typeAttribute.getMetaData().setReadOnly(true);
            }
            typeAttribute.setValue((String)options.keySet().iterator().next());
            typeAttribute.getMetaData().putValue("isSubtaskType", Boolean.TRUE.toString());
            TaskAttribute attribute = taskData.getRoot().getAttribute(JiraAttribute.PARENT_ID.id());
            attribute.setValue(parentTaskData.getTaskId());
            attribute = taskData.getRoot().getAttribute(JiraAttribute.PARENT_KEY.id());
            attribute.setValue(parentTaskData.getRoot().getAttribute(JiraAttribute.ISSUE_KEY.id()).getValue());
            int n = 1;
            return n != 0;
        }
        catch (JiraException e) {
            IStatus status = KlarosJiraCorePlugin.toStatus(repository, e);
            KlarosJiraTaskDataHandler.trace(status);
            throw new CoreException(status);
        }
        finally {
            monitor.done();
        }
    }

    public boolean canInitializeSubTaskData(TaskRepository taskRepository, ITask task) {
        String value = task.getAttribute("isSubtaskType");
        return value == null ? true : !Boolean.parseBoolean(value);
    }

    public static JiraIssue buildJiraIssue(TaskData taskData) {
        TaskAttribute affectsVersionAttr;
        TaskAttribute fixVersionAttr;
        String estimate;
        String securityLevelId;
        JiraIssue issue = new JiraIssue();
        issue.setId(taskData.getTaskId());
        issue.setKey(KlarosJiraTaskDataHandler.getAttributeValue(taskData, JiraAttribute.ISSUE_KEY));
        issue.setSummary(KlarosJiraTaskDataHandler.getAttributeValue(taskData, JiraAttribute.SUMMARY));
        issue.setDescription(KlarosJiraTaskDataHandler.getAttributeValue(taskData, JiraAttribute.DESCRIPTION));
        issue.setDue(KlarosJiraTaskDataHandler.getDateValue(taskData, JiraAttribute.DUE_DATE));
        String parentId = KlarosJiraTaskDataHandler.getAttributeValue(taskData, JiraAttribute.PARENT_ID);
        if (parentId != null) {
            issue.setParentId(parentId);
        }
        if ((securityLevelId = KlarosJiraTaskDataHandler.getAttributeValue(taskData, JiraAttribute.SECURITY_LEVEL)) != null) {
            issue.setSecurityLevel(new SecurityLevel(securityLevelId));
        }
        if ((estimate = KlarosJiraTaskDataHandler.getAttributeValue(taskData, JiraAttribute.ESTIMATE)) != null) {
            try {
                issue.setEstimate(Long.parseLong(estimate));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((estimate = KlarosJiraTaskDataHandler.getAttributeValue(taskData, JiraAttribute.INITIAL_ESTIMATE)) != null) {
            try {
                issue.setInitialEstimate(Long.parseLong(estimate));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        issue.setProject(new Project(KlarosJiraTaskDataHandler.getAttributeValue(taskData, JiraAttribute.PROJECT)));
        TaskAttribute typeAttribute = KlarosJiraTaskDataHandler.getAttribute(taskData, JiraAttribute.TYPE);
        boolean subTaskType = typeAttribute != null ? KlarosJiraTaskDataHandler.hasSubTaskType(typeAttribute) : false;
        IssueType issueType = new IssueType(KlarosJiraTaskDataHandler.getAttributeValue(taskData, JiraAttribute.TYPE), subTaskType);
        issue.setType(issueType);
        issue.setStatus(new JiraStatus(KlarosJiraTaskDataHandler.getAttributeValue(taskData, JiraAttribute.STATUS)));
        TaskAttribute componentsAttribute = taskData.getRoot().getMappedAttribute("attribute.jira.components");
        if (componentsAttribute != null) {
            ArrayList<Component> components = new ArrayList<Component>();
            for (Object value : componentsAttribute.getValues()) {
                components.add(new Component((String)value));
            }
            issue.setComponents(components.toArray(new Component[components.size()]));
        }
        if ((fixVersionAttr = taskData.getRoot().getMappedAttribute("attribute.jira.fixversions")) != null) {
            ArrayList<Version> fixVersions = new ArrayList<Version>();
            for (Object value : fixVersionAttr.getValues()) {
                fixVersions.add(new Version((String)value));
            }
            issue.setFixVersions(fixVersions.toArray(new Version[fixVersions.size()]));
        }
        if ((affectsVersionAttr = taskData.getRoot().getMappedAttribute("attribute.jira.affectsversions")) != null) {
            ArrayList<Version> affectsVersions = new ArrayList<Version>();
            for (String value : affectsVersionAttr.getValues()) {
                affectsVersions.add(new Version(value));
            }
            issue.setReportedVersions(affectsVersions.toArray(new Version[affectsVersions.size()]));
        }
        issue.setReporter(KlarosJiraTaskDataHandler.getAttributeValue(taskData, JiraAttribute.USER_REPORTER));
        String assignee = KlarosJiraTaskDataHandler.getAttributeValue(taskData, JiraAttribute.USER_ASSIGNED);
        issue.setAssignee(KlarosJiraRepositoryConnector.getAssigneeFromAttribute(assignee));
        issue.setEnvironment(KlarosJiraTaskDataHandler.getAttributeValue(taskData, JiraAttribute.ENVIRONMENT));
        String priorityId = KlarosJiraTaskDataHandler.getAttributeValue(taskData, JiraAttribute.PRIORITY);
        if (priorityId != null) {
            issue.setPriority(new Priority(priorityId));
        }
        ArrayList<CustomField> customFields = new ArrayList<CustomField>();
        for (TaskAttribute attribute : taskData.getRoot().getAttributes().values()) {
            if (!attribute.getId().startsWith("attribute.jira.custom::")) continue;
            String id = attribute.getId().substring("attribute.jira.custom::".length());
            String type = attribute.getMetaData().getValue("type");
            CustomField field = new CustomField(id, type, "", attribute.getValues());
            customFields.add(field);
        }
        issue.setCustomFields(customFields.toArray(new CustomField[customFields.size()]));
        String resolutionId = KlarosJiraTaskDataHandler.getAttributeValue(taskData, JiraAttribute.RESOLUTION);
        if (resolutionId != null) {
            issue.setResolution(new Resolution(resolutionId));
        }
        return issue;
    }

    public static boolean hasSubTaskType(TaskAttribute typeAttribute) {
        return Boolean.parseBoolean(typeAttribute.getMetaData().getValue("isSubtaskType"));
    }

    private static TaskAttribute getAttribute(TaskData taskData, JiraAttribute key) {
        return taskData.getRoot().getAttribute(key.id());
    }

    private static String getAttributeValue(TaskData taskData, JiraAttribute key) {
        TaskAttribute attribute = taskData.getRoot().getAttribute(key.id());
        return attribute != null ? attribute.getValue() : null;
    }

    private static Date getDateValue(TaskData data, JiraAttribute key) {
        TaskAttribute attribute = data.getRoot().getAttribute(key.id());
        return attribute != null ? data.getAttributeMapper().getDateValue(attribute) : null;
    }

    private static void trace(IStatus status) {
        if (TRACE_ENABLED) {
            StatusHandler.log((IStatus)status);
        }
    }

    private static void trace(Exception e) {
        if (TRACE_ENABLED) {
            StatusHandler.log((IStatus)new Status(4, "com.atlassian.connector.eclipse.internal.jira.core", "Error receiving infromation from JIRA", (Throwable)e));
        }
    }

    public TaskAttributeMapper getAttributeMapper(TaskRepository taskRepository) {
        JiraClient client = this.clientFactory.getJiraClient(this.sessionName, taskRepository);
        return new JiraAttributeMapper(taskRepository, client);
    }

    public void migrateTaskData(TaskRepository taskRepository, TaskData taskData) {
        JiraVersion version;
        block20: {
            String taskDataVersion = taskData.getVersion();
            version = new JiraVersion(taskDataVersion != null ? taskDataVersion : "0.0");
            if (version.isSmallerOrEquals(TASK_DATA_VERSION_1_0)) {
                for (Object attribute : taskData.getRoot().getAttributes().values()) {
                    Object key2;
                    if ("task.common.product".equals(attribute.getId())) {
                        String projectName = attribute.getValue();
                        Map options = taskData.getAttributeMapper().getOptions((TaskAttribute)attribute);
                        for (Object key2 : options.keySet()) {
                            String value = (String)options.get(key2);
                            if (projectName.equals(value)) {
                                attribute.setValue((String)key2);
                            }
                            attribute.putOption((String)key2, value);
                        }
                        continue;
                    }
                    if ("task.common.user.assigned".equals(attribute.getId())) {
                        attribute.getMetaData().setReadOnly(false);
                        continue;
                    }
                    JiraFieldType type = JiraFieldType.fromKey((String)attribute.getMetaData().getValue("type"));
                    if (JiraFieldType.SELECT != type && JiraFieldType.MULTISELECT != type || attribute.getOptions().isEmpty()) continue;
                    HashSet values = new HashSet(attribute.getValues());
                    attribute.clearValues();
                    Map options = attribute.getOptions();
                    key2 = options.keySet().iterator();
                    while (key2.hasNext()) {
                        String key3 = (String)key2.next();
                        if (!values.contains(options.get(key3))) continue;
                        attribute.addValue(key3);
                    }
                }
            }
            if (!version.isSmallerOrEquals(TASK_DATA_VERSION_2_0)) break block20;
            ArrayList attributes = new ArrayList(taskData.getRoot().getAttributes().values());
            for (TaskAttribute attribute : attributes) {
                block22: {
                    block21: {
                        if (!attribute.getId().startsWith("task.common.operation-")) break block21;
                        if (attribute.getValue().equals(REASSIGN_OPERATION)) {
                            taskData.getRoot().removeAttribute(attribute.getId());
                            continue;
                        }
                        TaskAttribute associatedAttribute = taskData.getAttributeMapper().getAssoctiatedAttribute(attribute);
                        if (associatedAttribute == null || !associatedAttribute.getId().equals("resolution")) break block22;
                        TaskAttribute resolutionAttribute = taskData.getRoot().getAttribute(JiraAttribute.RESOLUTION.id());
                        if (resolutionAttribute != null) {
                            Map options = associatedAttribute.getOptions();
                            for (String key : options.keySet()) {
                                resolutionAttribute.putOption(key, (String)options.get(key));
                            }
                            resolutionAttribute.getMetaData().setType("singleSelect");
                            resolutionAttribute.getMetaData().setReadOnly(false);
                        }
                        attribute.getMetaData().putValue("task.meta.associated.attribute", JiraAttribute.RESOLUTION.id());
                        attribute.removeAttribute(associatedAttribute.getId());
                        break block22;
                    }
                    if (attribute.getId().equals(JiraAttribute.TYPE.id()) && attribute.getOptions().isEmpty()) {
                        JiraClient client = this.clientFactory.getJiraClient(this.sessionName, taskRepository);
                        IssueType[] jiraIssueTypes = client.getCache().getIssueTypes();
                        for (IssueType type : jiraIssueTypes) {
                            if (!attribute.getValue().equals(type.getName())) continue;
                            attribute.putOption(type.getId(), type.getName());
                            attribute.setValue(type.getId());
                            break;
                        }
                    }
                }
                attribute.getMetaData().setType(this.getType(attribute));
            }
        }
        if (version.isSmallerOrEquals(TASK_DATA_VERSION_2_2)) {
            for (Object attribute : taskData.getRoot().getAttributes().values()) {
                String value;
                JiraTimeFormat format = new JiraTimeFormat();
                if (!KlarosJiraTaskDataHandler.isTimeSpanAttribute((TaskAttribute)attribute) || (value = attribute.getValue()).length() <= 0) continue;
                try {
                    Long.parseLong(value);
                }
                catch (NumberFormatException e) {
                    try {
                        attribute.setValue(String.valueOf(format.parse(value)));
                    }
                    catch (ParseException e1) {
                        attribute.setValue("");
                    }
                }
            }
        }
        if (version.isSmallerOrEquals(TASK_DATA_VERSION_CURRENT)) {
            taskData.setVersion(TASK_DATA_VERSION_CURRENT.toString());
        }
    }

    public static boolean isTimeSpanAttribute(TaskAttribute attribute) {
        return JiraAttribute.INITIAL_ESTIMATE.id().equals(attribute.getId()) || JiraAttribute.ESTIMATE.id().equals(attribute.getId()) || JiraAttribute.ACTUAL.id().equals(attribute.getId());
    }

    private String getType(TaskAttribute taskAttribute) {
        if (JiraAttribute.DESCRIPTION.id().equals(taskAttribute.getId())) {
            return "longRichText";
        }
        if (JiraAttribute.COMMENT_NEW.id().equals(taskAttribute.getId())) {
            return "longRichText";
        }
        if (JiraAttribute.SUMMARY.id().equals(taskAttribute.getId())) {
            return "shortRichText";
        }
        if ("task.common.operation".equals(taskAttribute.getId()) || taskAttribute.getId().startsWith("task.common.operation-")) {
            return "operation";
        }
        if (taskAttribute.getId().startsWith("task.common.comment-")) {
            return "comment";
        }
        if (taskAttribute.getId().startsWith("task.common.attachment-")) {
            return "attachment";
        }
        JiraFieldType fieldType = null;
        if (JiraAttribute.CREATION_DATE.id().equals(taskAttribute.getId()) || JiraAttribute.DUE_DATE.id().equals(taskAttribute.getId()) || JiraAttribute.MODIFICATION_DATE.id().equals(taskAttribute.getId())) {
            fieldType = JiraFieldType.DATE;
            taskAttribute.getMetaData().putValue("type", fieldType.getKey());
        }
        if (fieldType == null) {
            fieldType = JiraFieldType.fromKey((String)taskAttribute.getMetaData().getValue("type"));
        }
        if (fieldType.getTaskType() != null) {
            return fieldType.getTaskType();
        }
        fieldType = JiraAttribute.valueById((String)taskAttribute.getId()).getType();
        if (fieldType.getTaskType() != null) {
            return fieldType.getTaskType();
        }
        String existingType = taskAttribute.getMetaData().getType();
        if (existingType != null) {
            return existingType;
        }
        return "shortText";
    }

    public String mapCommonAttributeKey(String key) {
        if ("summary".equals(key)) {
            return JiraAttribute.SUMMARY.id();
        }
        if ("description".equals(key)) {
            return JiraAttribute.DESCRIPTION.id();
        }
        if ("priority".equals(key)) {
            return JiraAttribute.PRIORITY.id();
        }
        if ("resolution".equals(key)) {
            return JiraAttribute.RESOLUTION.id();
        }
        if ("assignee".equals(key)) {
            return JiraAttribute.USER_ASSIGNED.id();
        }
        if ("environment".equals(key)) {
            return JiraAttribute.ENVIRONMENT.id();
        }
        if ("issuetype".equals(key)) {
            return JiraAttribute.TYPE.id();
        }
        if ("components".equals(key)) {
            return JiraAttribute.COMPONENTS.id();
        }
        if ("versions".equals(key)) {
            return JiraAttribute.AFFECTSVERSIONS.id();
        }
        if ("fixVersions".equals(key)) {
            return JiraAttribute.FIXVERSIONS.id();
        }
        if ("timetracking".equals(key)) {
            return JiraAttribute.ESTIMATE.id();
        }
        if ("duedate".equals(key)) {
            return JiraAttribute.DUE_DATE.id();
        }
        if (key.startsWith("issueLink")) {
            return "attribute.jira.link::" + key;
        }
        if (key.startsWith("customfield")) {
            return "attribute.jira.custom::" + key;
        }
        if ("security".equals(key)) {
            return JiraAttribute.SECURITY_LEVEL.id();
        }
        return key;
    }

    public static final class CommentDateComparator
    implements Comparator<Comment> {
        @Override
        public int compare(Comment o1, Comment o2) {
            return ObjectUtils.compare((Comparable)o1.getCreated(), (Comparable)o2.getCreated());
        }
    }
}

