/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.core;

import com.atlassian.connector.eclipse.internal.jira.core.KlarosJiraClientManager;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraVersion;
import com.atlassian.connector.eclipse.internal.jira.core.model.ServerInfo;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraClient;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraException;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraLocalConfiguration;
import com.atlassian.connector.eclipse.internal.jira.core.util.JiraUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.internal.tasks.core.IRepositoryChangeListener;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryChangeEvent;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryDelta;
import org.eclipse.mylyn.tasks.core.IRepositoryListener;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskRepositoryLocationFactory;

public class KlarosJiraClientFactory
implements IRepositoryListener,
IRepositoryChangeListener {
    private static KlarosJiraClientFactory instance = null;
    private KlarosJiraClientManager clientManager = null;
    private TaskRepositoryLocationFactory taskRepositoryLocationFactory = new TaskRepositoryLocationFactory();
    private boolean forceTaskRepositoryLocationFactory;

    private KlarosJiraClientFactory() {
        this.clientManager = new KlarosJiraClientManager();
    }

    public void clearClients() {
        this.clientManager.removeAllClients(false);
    }

    public void clearClientsAndConfigurationData() {
        this.clientManager.removeAllClients(true);
    }

    public synchronized JiraClient getJiraClient(String session, TaskRepository repository) {
        JiraClient client = this.clientManager.getClient(session + ":" + repository.getRepositoryUrl());
        if (client == null) {
            AbstractWebLocation location = this.taskRepositoryLocationFactory.createWebLocation(repository);
            client = this.clientManager.addClient(session, location, JiraUtil.getLocalConfiguration((TaskRepository)repository));
        }
        return client;
    }

    public synchronized void removeJiraClient(String session, TaskRepository repository) {
        this.clientManager.removeClient(session + ":" + repository.getRepositoryUrl());
    }

    public static synchronized KlarosJiraClientFactory getDefault() {
        if (instance == null) {
            instance = new KlarosJiraClientFactory();
        }
        return instance;
    }

    public synchronized void logOutFromAll() {
        JiraClient[] clients;
        for (JiraClient client : clients = this.clientManager.getAllClients()) {
            try {
                client.logout(null);
            }
            catch (JiraException jiraException) {
                // empty catch block
            }
        }
    }

    public void repositoriesRead() {
    }

    public synchronized void repositoryAdded(TaskRepository repository) {
        if (repository.getConnectorKind().equals("jira")) {
            assert (this.clientManager.getClient(repository.getRepositoryUrl()) == null);
            this.getJiraClient(repository);
        }
    }

    @Deprecated
    public synchronized void repositoryRemoved(TaskRepository repository) {
        JiraClient client;
        if (repository.getConnectorKind().equals("jira") && (client = this.clientManager.getClient(repository.getRepositoryUrl())) != null) {
            this.clientManager.removeClient(client, true);
        }
    }

    public synchronized void repositoryRemoved(String session, TaskRepository repository) {
        if (repository.getConnectorKind().equals("jira")) {
            this.removeJiraClient(session, repository);
        }
    }

    public synchronized void repositorySettingsChanged(TaskRepository repository) {
    }

    public synchronized void repositoryChanged(TaskRepositoryChangeEvent event) {
        JiraClient client;
        TaskRepository repository = event.getRepository();
        if (repository.getConnectorKind().equals("jira") && (client = this.clientManager.getClient(repository.getRepositoryUrl())) != null) {
            if (event.getDelta().getType() == TaskRepositoryDelta.Type.ALL) {
                client.purgeSession();
                this.updateClient(client, repository);
            } else if (event.getDelta().getType() == TaskRepositoryDelta.Type.CREDENTIALS || event.getDelta().getType() == TaskRepositoryDelta.Type.PROYX) {
                client.purgeSession();
            } else {
                this.updateClient(client, repository);
            }
        }
    }

    private void updateClient(JiraClient client, TaskRepository repository) {
        JiraLocalConfiguration configuration = JiraUtil.getLocalConfiguration((TaskRepository)repository);
        if (!configuration.equals((Object)client.getLocalConfiguration())) {
            client.setLocalConfiguration(configuration);
        }
    }

    public ServerInfo validateConnection(AbstractWebLocation location, IProgressMonitor monitor) throws JiraException {
        return this.validateConnection(location, new JiraLocalConfiguration(), monitor);
    }

    public ServerInfo validateConnection(AbstractWebLocation location, JiraLocalConfiguration configuration, IProgressMonitor monitor) throws JiraException {
        ServerInfo info = this.clientManager.validateConnection(location, configuration, monitor);
        JiraVersion serverVersion = new JiraVersion(info.getVersion());
        if (JiraVersion.MIN_VERSION.compareTo(serverVersion) > 0) {
            throw new JiraException("JIRA connector requires server " + JiraVersion.MIN_VERSION + " or later");
        }
        return info;
    }

    public TaskRepositoryLocationFactory getTaskRepositoryLocationFactory() {
        return this.taskRepositoryLocationFactory;
    }

    public void setTaskRepositoryLocationFactory(TaskRepositoryLocationFactory taskRepositoryLocationFactory, boolean force) {
        if (this.forceTaskRepositoryLocationFactory) {
            return;
        }
        this.forceTaskRepositoryLocationFactory = force;
        this.taskRepositoryLocationFactory = taskRepositoryLocationFactory;
    }

    public void repositoryUrlChanged(TaskRepository repository, String oldUrl) {
    }

    @Deprecated
    public JiraClient getJiraClient(TaskRepository repository) {
        throw new RuntimeException("Do not use this method, it is no longer usable!");
    }
}

