/*
MySQL Backup
Source Server Version: 5.1.42
Source Database: klaros
Date: 2010-02-02 12:39:55
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
--  Table structure for `kl_attachment`
-- ----------------------------
DROP TABLE IF EXISTS `kl_attachment`;
CREATE TABLE `kl_attachment` (
  `KL__ID` int(11) NOT NULL AUTO_INCREMENT,
  `FILE` longblob,
  `MIME_TYPE` varchar(128) DEFAULT NULL,
  `EXTENSION` varchar(16) DEFAULT NULL,
  `TEST_CASE_STEP_ID` int(11) DEFAULT NULL,
  PRIMARY KEY (`KL__ID`),
  KEY `FK11DF9AC1C6E882C6` (`TEST_CASE_STEP_ID`),
  CONSTRAINT `FK11DF9AC1C6E882C6` FOREIGN KEY (`TEST_CASE_STEP_ID`) REFERENCES `kl_test_case_step` (`KL__ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
--  Table structure for `kl_business_codes`
-- ----------------------------
DROP TABLE IF EXISTS `kl_business_codes`;
CREATE TABLE `kl_business_codes` (
  `KL__ID` int(11) NOT NULL AUTO_INCREMENT,
  `COUNT` int(11) NOT NULL,
  `DISCRIMINATOR` varchar(8) NOT NULL,
  `CLAZZ` varchar(128) NOT NULL,
  `CONFIG` int(11) DEFAULT NULL,
  PRIMARY KEY (`KL__ID`),
  KEY `FK3167B16561B887AC` (`CONFIG`),
  CONSTRAINT `FK3167B16561B887AC` FOREIGN KEY (`CONFIG`) REFERENCES `kl_cfg` (`KL__ID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

-- ----------------------------
--  Table structure for `kl_cfg`
-- ----------------------------
DROP TABLE IF EXISTS `kl_cfg`;
CREATE TABLE `kl_cfg` (
  `KL__ID` int(11) NOT NULL AUTO_INCREMENT,
  `NAME` varchar(100) DEFAULT NULL,
  `JIRA_PROJECT` varchar(100) DEFAULT NULL,
  `ENABLED` bit(1) NOT NULL,
  `DESCRIPTION` longtext,
  PRIMARY KEY (`KL__ID`),
  UNIQUE KEY `NAME` (`NAME`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

-- ----------------------------
--  Table structure for `kl_cfg_initial_states`
-- ----------------------------
DROP TABLE IF EXISTS `kl_cfg_initial_states`;
CREATE TABLE `kl_cfg_initial_states` (
  `CONFIG` int(11) NOT NULL,
  `elt` int(11) NOT NULL,
  `INITAL_STATE_OF_CLASS` varchar(255) NOT NULL,
  PRIMARY KEY (`CONFIG`,`INITAL_STATE_OF_CLASS`),
  KEY `FKA9707C761C46D26D` (`elt`),
  KEY `FKA9707C7661B887AC` (`CONFIG`),
  CONSTRAINT `FKA9707C761C46D26D` FOREIGN KEY (`elt`) REFERENCES `kl_cfg_state_def` (`KL__ID`),
  CONSTRAINT `FKA9707C7661B887AC` FOREIGN KEY (`CONFIG`) REFERENCES `kl_cfg` (`KL__ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
--  Table structure for `kl_cfg_property_def`
-- ----------------------------
DROP TABLE IF EXISTS `kl_cfg_property_def`;
CREATE TABLE `kl_cfg_property_def` (
  `KL__ID` int(11) NOT NULL AUTO_INCREMENT,
  `CLASS` varchar(255) DEFAULT NULL,
  `PROPERTY_NAME` longtext,
  `PROPERTY_TYPE` varchar(6) DEFAULT NULL,
  `XPATH` longtext,
  `MANDATORY` bit(1) DEFAULT NULL,
  `USER_DEFINED` bit(1) DEFAULT NULL,
  `CONFIG` int(11) DEFAULT NULL,
  PRIMARY KEY (`KL__ID`),
  KEY `FKA43CADB461B887AC` (`CONFIG`),
  CONSTRAINT `FKA43CADB461B887AC` FOREIGN KEY (`CONFIG`) REFERENCES `kl_cfg` (`KL__ID`)
) ENGINE=InnoDB AUTO_INCREMENT=123 DEFAULT CHARSET=latin1;

-- ----------------------------
--  Table structure for `kl_cfg_state_def`
-- ----------------------------
DROP TABLE IF EXISTS `kl_cfg_state_def`;
CREATE TABLE `kl_cfg_state_def` (
  `KL__ID` int(11) NOT NULL AUTO_INCREMENT,
  `NAME` varchar(128) DEFAULT NULL,
  `DESCRIPTION` longtext,
  `CLASS` longtext,
  `CONFIG` int(11) DEFAULT NULL,
  PRIMARY KEY (`KL__ID`),
  KEY `FK37913A7E61B887AC` (`CONFIG`),
  CONSTRAINT `FK37913A7E61B887AC` FOREIGN KEY (`CONFIG`) REFERENCES `kl_cfg` (`KL__ID`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;

-- ----------------------------
--  Table structure for `kl_cfg_transition_def`
-- ----------------------------
DROP TABLE IF EXISTS `kl_cfg_transition_def`;
CREATE TABLE `kl_cfg_transition_def` (
  `KL__ID` int(11) NOT NULL AUTO_INCREMENT,
  `END_STATE` int(11) DEFAULT NULL,
  `START_STATE` int(11) DEFAULT NULL,
  PRIMARY KEY (`KL__ID`),
  KEY `FK36428EF4C176E434` (`START_STATE`),
  KEY `FK36428EF4909CA9ED` (`END_STATE`),
  CONSTRAINT `FK36428EF4909CA9ED` FOREIGN KEY (`END_STATE`) REFERENCES `kl_cfg_state_def` (`KL__ID`),
  CONSTRAINT `FK36428EF4C176E434` FOREIGN KEY (`START_STATE`) REFERENCES `kl_cfg_state_def` (`KL__ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
--  Table structure for `kl_component`
-- ----------------------------
DROP TABLE IF EXISTS `kl_component`;
CREATE TABLE `kl_component` (
  `KL__ID` int(11) NOT NULL,
  PRIMARY KEY (`KL__ID`),
  KEY `FK6ED8AB7F122F8CCA` (`KL__ID`),
  CONSTRAINT `FK6ED8AB7F122F8CCA` FOREIGN KEY (`KL__ID`) REFERENCES `kl_item` (`KL__ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
--  Table structure for `kl_covers`
-- ----------------------------
DROP TABLE IF EXISTS `kl_covers`;
CREATE TABLE `kl_covers` (
  `TESTCASE` int(11) NOT NULL,
  `TESTREQUIREMENT` int(11) NOT NULL,
  PRIMARY KEY (`TESTCASE`,`TESTREQUIREMENT`),
  KEY `FK5F2BEC3AFD69FB36` (`TESTREQUIREMENT`),
  KEY `FK5F2BEC3A44FD59B0` (`TESTCASE`),
  CONSTRAINT `FK5F2BEC3A44FD59B0` FOREIGN KEY (`TESTCASE`) REFERENCES `kl_po` (`KL__ID`),
  CONSTRAINT `FK5F2BEC3AFD69FB36` FOREIGN KEY (`TESTREQUIREMENT`) REFERENCES `kl_po` (`KL__ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
--  Table structure for `kl_dashboard`
-- ----------------------------
DROP TABLE IF EXISTS `kl_dashboard`;
CREATE TABLE `kl_dashboard` (
  `KL__ID` int(11) NOT NULL AUTO_INCREMENT,
  `NAME` varchar(32) NOT NULL,
  `DESCRIPTION` longtext,
  `CREATOR` int(11) DEFAULT NULL,
  `LAST_EDITOR` int(11) DEFAULT NULL,
  `OWNER` int(11) DEFAULT NULL,
  `CREATED` datetime DEFAULT NULL,
  `LAST_UPDATED` datetime DEFAULT NULL,
  `SHARED` bit(1) NOT NULL,
  PRIMARY KEY (`KL__ID`),
  UNIQUE KEY `NAME` (`NAME`),
  KEY `FK83D47916E2C2010D` (`LAST_EDITOR`),
  KEY `FK83D47916BF7EEA03` (`CREATOR`),
  KEY `FK83D4791688845C8A` (`OWNER`),
  CONSTRAINT `FK83D4791688845C8A` FOREIGN KEY (`OWNER`) REFERENCES `kl_po` (`KL__ID`),
  CONSTRAINT `FK83D47916BF7EEA03` FOREIGN KEY (`CREATOR`) REFERENCES `kl_po` (`KL__ID`),
  CONSTRAINT `FK83D47916E2C2010D` FOREIGN KEY (`LAST_EDITOR`) REFERENCES `kl_po` (`KL__ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
--  Table structure for `kl_dashboard_report`
-- ----------------------------
DROP TABLE IF EXISTS `kl_dashboard_report`;
CREATE TABLE `kl_dashboard_report` (
  `KL__ID` int(11) NOT NULL AUTO_INCREMENT,
  `NAME` varchar(32) NOT NULL,
  `TYPE` longtext NOT NULL,
  `DASHBOARD` int(11) DEFAULT NULL,
  `ID` int(11) DEFAULT NULL,
  PRIMARY KEY (`KL__ID`),
  UNIQUE KEY `NAME` (`NAME`),
  KEY `FKD28A887D6BD53E9C` (`DASHBOARD`),
  CONSTRAINT `FKD28A887D6BD53E9C` FOREIGN KEY (`DASHBOARD`) REFERENCES `kl_dashboard` (`KL__ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
--  Table structure for `kl_db_revision`
-- ----------------------------
DROP TABLE IF EXISTS `kl_db_revision`;
CREATE TABLE `kl_db_revision` (
  `KL__ID` int(11) NOT NULL AUTO_INCREMENT,
  `REVISION` varchar(255) NOT NULL,
  `TIMESTAMP` datetime NOT NULL,
  `ACTIVE` bit(1) NOT NULL,
  PRIMARY KEY (`KL__ID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

-- ----------------------------
--  Table structure for `kl_detected_issues`
-- ----------------------------
DROP TABLE IF EXISTS `kl_detected_issues`;
CREATE TABLE `kl_detected_issues` (
  `Issue` int(11) NOT NULL,
  `TESTCASE` int(11) NOT NULL,
  `I` int(11) NOT NULL,
  PRIMARY KEY (`TESTCASE`,`I`),
  KEY `FK242BE439C9319526` (`Issue`),
  KEY `FK242BE43944FD59B0` (`TESTCASE`),
  CONSTRAINT `FK242BE43944FD59B0` FOREIGN KEY (`TESTCASE`) REFERENCES `kl_po` (`KL__ID`),
  CONSTRAINT `FK242BE439C9319526` FOREIGN KEY (`Issue`) REFERENCES `kl_issue` (`KL__ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
--  Table structure for `kl_external_link`
-- ----------------------------
DROP TABLE IF EXISTS `kl_external_link`;
CREATE TABLE `kl_external_link` (
  `KL__ID` int(11) NOT NULL AUTO_INCREMENT,
  `EXT_LINK_TYPE` varchar(255) NOT NULL,
  `REFERENCE` longtext NOT NULL,
  `EXTERNAL_TOOL` int(11) DEFAULT NULL,
  `LAST_MODIFIED` varchar(50) DEFAULT NULL,
  `REVISION` varchar(20) DEFAULT NULL,
  `AUTHOR` varchar(100) DEFAULT NULL,
  `NAME` varchar(200) DEFAULT NULL,
  `EXT_SERVER` int(11) DEFAULT NULL,
  `EXTERNAL_SERVER` int(11) DEFAULT NULL,
  PRIMARY KEY (`KL__ID`),
  KEY `FK4F701190AEC99831` (`EXTERNAL_SERVER`),
  KEY `FK4F701190EB8FC51B` (`EXT_SERVER`),
  KEY `FK4F701190C7FA7B9B` (`EXTERNAL_TOOL`),
  CONSTRAINT `FK4F701190AEC99831` FOREIGN KEY (`EXTERNAL_SERVER`) REFERENCES `kl_external_server` (`KL__ID`),
  CONSTRAINT `FK4F701190C7FA7B9B` FOREIGN KEY (`EXTERNAL_TOOL`) REFERENCES `kl_external_tool` (`KL__ID`),
  CONSTRAINT `FK4F701190EB8FC51B` FOREIGN KEY (`EXT_SERVER`) REFERENCES `kl_external_server` (`KL__ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
--  Table structure for `kl_external_server`
-- ----------------------------
DROP TABLE IF EXISTS `kl_external_server`;
CREATE TABLE `kl_external_server` (
  `KL__ID` int(11) NOT NULL AUTO_INCREMENT,
  `SERVER_TYPE` varchar(255) NOT NULL,
  `NAME` varchar(128) DEFAULT NULL,
  `DESCRIPTION` longtext,
  `URL` longtext,
  `ENABLED` bit(1) DEFAULT NULL,
  `TYPE` varchar(32) DEFAULT NULL,
  `VERSION` varchar(32) DEFAULT NULL,
  `PROJECT` varchar(128) DEFAULT NULL,
  `DEFAULT_SERVER` bit(1) DEFAULT b'0',
  PRIMARY KEY (`KL__ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
--  Table structure for `kl_external_tool`
-- ----------------------------
DROP TABLE IF EXISTS `kl_external_tool`;
CREATE TABLE `kl_external_tool` (
  `KL__ID` int(11) NOT NULL AUTO_INCREMENT,
  `EXT_TOOL_TYPE` varchar(255) NOT NULL,
  `TYPE` longtext,
  `TOOL_DESCRIPTION` longtext,
  `RETRIEVE_CMD` longtext,
  `WRITE_BACK_CMD` longtext,
  `LOCK_CMD` longtext,
  `UNLOCK_CMD` longtext,
  `HOST` longtext,
  `ROOT` longtext,
  `CVSROOT` longtext,
  PRIMARY KEY (`KL__ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
--  Table structure for `kl_implements`
-- ----------------------------
DROP TABLE IF EXISTS `kl_implements`;
CREATE TABLE `kl_implements` (
  `IMPLEMENTS` int(11) NOT NULL,
  `elt` int(11) NOT NULL,
  `IMPLEMENTED_IN` int(11) NOT NULL,
  PRIMARY KEY (`IMPLEMENTS`,`elt`),
  KEY `FK5058994EC0A2F8C5` (`elt`),
  KEY `FK5058994E557BFF9B` (`elt`),
  KEY `FK5058994EBA011470` (`IMPLEMENTED_IN`),
  KEY `FK5058994E8A11C7C8` (`IMPLEMENTS`),
  CONSTRAINT `FK5058994E557BFF9B` FOREIGN KEY (`elt`) REFERENCES `kl_item` (`KL__ID`),
  CONSTRAINT `FK5058994E8A11C7C8` FOREIGN KEY (`IMPLEMENTS`) REFERENCES `kl_po` (`KL__ID`),
  CONSTRAINT `FK5058994EBA011470` FOREIGN KEY (`IMPLEMENTED_IN`) REFERENCES `kl_item` (`KL__ID`),
  CONSTRAINT `FK5058994EC0A2F8C5` FOREIGN KEY (`elt`) REFERENCES `kl_po` (`KL__ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
--  Table structure for `kl_issue`
-- ----------------------------
DROP TABLE IF EXISTS `kl_issue`;
CREATE TABLE `kl_issue` (
  `KL__ID` int(11) NOT NULL AUTO_INCREMENT,
  `STATE` longtext,
  `OWNER` longtext,
  `DESCRIPTION` longtext,
  `SUBJECT` longtext,
  `EXT_Issue_ID` int(11) DEFAULT NULL,
  `RESOLVED_IN` int(11) DEFAULT NULL,
  `ACCEPTED_IN` int(11) DEFAULT NULL,
  PRIMARY KEY (`KL__ID`),
  UNIQUE KEY `EXT_Issue_ID` (`EXT_Issue_ID`),
  KEY `FKC999D05B350E02E4` (`RESOLVED_IN`),
  KEY `FKC999D05BF27075E1` (`EXT_Issue_ID`),
  KEY `FKC999D05BE667CCD5` (`ACCEPTED_IN`),
  CONSTRAINT `FKC999D05B350E02E4` FOREIGN KEY (`RESOLVED_IN`) REFERENCES `kl_po` (`KL__ID`),
  CONSTRAINT `FKC999D05BE667CCD5` FOREIGN KEY (`ACCEPTED_IN`) REFERENCES `kl_po` (`KL__ID`),
  CONSTRAINT `FKC999D05BF27075E1` FOREIGN KEY (`EXT_Issue_ID`) REFERENCES `kl_external_link` (`KL__ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
--  Table structure for `kl_item`
-- ----------------------------
DROP TABLE IF EXISTS `kl_item`;
CREATE TABLE `kl_item` (
  `KL__ID` int(11) NOT NULL AUTO_INCREMENT,
  `ITEM_TYPE` varchar(255) NOT NULL,
  `DESCRIPTION` longtext NOT NULL,
  `EXT_LINK` int(11) DEFAULT NULL,
  PRIMARY KEY (`KL__ID`),
  UNIQUE KEY `EXT_LINK` (`EXT_LINK`),
  KEY `FK680D7315B5232E2` (`EXT_LINK`),
  CONSTRAINT `FK680D7315B5232E2` FOREIGN KEY (`EXT_LINK`) REFERENCES `kl_external_link` (`KL__ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
--  Table structure for `kl_po`
-- ----------------------------
DROP TABLE IF EXISTS `kl_po`;
CREATE TABLE `kl_po` (
  `KL__ID` int(11) NOT NULL AUTO_INCREMENT,
  `CLASS` varchar(255) NOT NULL,
  `CONFIG` int(11) DEFAULT NULL,
  `NAME` longtext,
  `ENABLED` bit(1) NOT NULL,
  `ASSIGNEE` int(11) DEFAULT NULL,
  `CREATOR` int(11) DEFAULT NULL,
  `LAST_EDITOR` int(11) DEFAULT NULL,
  `CREATED` datetime DEFAULT NULL,
  `LAST_UPDATED` datetime DEFAULT NULL,
  `DEPTH` int(11) DEFAULT NULL,
  `FATHER` int(11) DEFAULT NULL,
  `REVISION_ID` varchar(30) DEFAULT NULL,
  `REVISION_TIMESTAMP` datetime DEFAULT NULL,
  `MODIFIED_BY` varchar(60) DEFAULT NULL,
  `REVISION_COMMENT` longtext,
  `TRUNK_ROOT` int(11) DEFAULT NULL,
  `ROOT` int(11) DEFAULT NULL,
  `SUCCESSOR` int(11) DEFAULT NULL,
  `BRANCH_ROOT` int(11) DEFAULT NULL,
  `VERSION` longtext,
  `EXTERNAL_IMPLEMENTATION_ID` int(11) DEFAULT NULL,
  `EXTERNAL_DESCRIPTION_ID` int(11) DEFAULT NULL,
  `STATE` int(11) DEFAULT NULL,
  `TEST_RUN` int(11) DEFAULT NULL,
  `TEST_SERIES_RESULT` int(11) DEFAULT NULL,
  `TESTCASE` int(11) DEFAULT NULL,
  `STATE_DEF` int(11) DEFAULT NULL,
  `ITEM_UNDER_TEST` int(11) DEFAULT NULL,
  `MEMBER_OF_GROUP` int(11) DEFAULT NULL,
  `RUN_ID` varchar(200) DEFAULT NULL,
  `Timestamp` datetime DEFAULT NULL,
  `SUT` int(11) DEFAULT NULL,
  `ENV` int(11) DEFAULT NULL,
  `TESTSERIES` int(11) DEFAULT NULL,
  `FORENAME` varchar(128) DEFAULT NULL,
  `USERNAME` varchar(128) DEFAULT NULL,
  `PWD` varchar(128) DEFAULT NULL,
  `ROLE` varchar(64) DEFAULT NULL,
  `EMAIL` longtext,
  PRIMARY KEY (`KL__ID`),
  UNIQUE KEY `SUCCESSOR` (`SUCCESSOR`),
  UNIQUE KEY `EXTERNAL_IMPLEMENTATION_ID` (`EXTERNAL_IMPLEMENTATION_ID`),
  UNIQUE KEY `EXTERNAL_DESCRIPTION_ID` (`EXTERNAL_DESCRIPTION_ID`),
  UNIQUE KEY `RUN_ID` (`RUN_ID`),
  KEY `FK444DD9D3218CC3E` (`TESTSERIES`),
  KEY `FK444DD9D66C6BC74` (`TRUNK_ROOT`),
  KEY `FK444DD9D83099946` (`BRANCH_ROOT`),
  KEY `FK444DD9DAF94A86B` (`TEST_RUN`),
  KEY `FK444DD9DBFE87933` (`ITEM_UNDER_TEST`),
  KEY `FK444DD9DF68DA90D` (`SUCCESSOR`),
  KEY `FK444DD9DBF7EEA03` (`CREATOR`),
  KEY `FK444DD9D22D00E51` (`STATE`),
  KEY `FK444DD9D6C2477A6` (`ASSIGNEE`),
  KEY `FK444DD9D9FF61117` (`STATE_DEF`),
  KEY `FK444DD9D44FD59B0` (`TESTCASE`),
  KEY `FK444DD9DC75FAD64` (`FATHER`),
  KEY `FK444DD9DE2C2010D` (`LAST_EDITOR`),
  KEY `FK444DD9DC0A32E6A` (`SUT`),
  KEY `FK444DD9DA61A50BD` (`EXTERNAL_IMPLEMENTATION_ID`),
  KEY `FK444DD9D57B37182` (`ENV`),
  KEY `FK444DD9DBE5DD0C9` (`ROOT`),
  KEY `FK444DD9D61B887AC` (`CONFIG`),
  KEY `FK444DD9D452B8624` (`MEMBER_OF_GROUP`),
  KEY `FK444DD9D5D37692A` (`TEST_SERIES_RESULT`),
  KEY `FK444DD9D23B83707` (`EXTERNAL_DESCRIPTION_ID`),
  CONSTRAINT `FK444DD9D22D00E51` FOREIGN KEY (`STATE`) REFERENCES `kl_cfg_state_def` (`KL__ID`),
  CONSTRAINT `FK444DD9D23B83707` FOREIGN KEY (`EXTERNAL_DESCRIPTION_ID`) REFERENCES `kl_external_link` (`KL__ID`),
  CONSTRAINT `FK444DD9D3218CC3E` FOREIGN KEY (`TESTSERIES`) REFERENCES `kl_po` (`KL__ID`),
  CONSTRAINT `FK444DD9D44FD59B0` FOREIGN KEY (`TESTCASE`) REFERENCES `kl_po` (`KL__ID`),
  CONSTRAINT `FK444DD9D452B8624` FOREIGN KEY (`MEMBER_OF_GROUP`) REFERENCES `kl_po` (`KL__ID`),
  CONSTRAINT `FK444DD9D57B37182` FOREIGN KEY (`ENV`) REFERENCES `kl_po` (`KL__ID`),
  CONSTRAINT `FK444DD9D5D37692A` FOREIGN KEY (`TEST_SERIES_RESULT`) REFERENCES `kl_po` (`KL__ID`),
  CONSTRAINT `FK444DD9D61B887AC` FOREIGN KEY (`CONFIG`) REFERENCES `kl_cfg` (`KL__ID`),
  CONSTRAINT `FK444DD9D66C6BC74` FOREIGN KEY (`TRUNK_ROOT`) REFERENCES `kl_po` (`KL__ID`),
  CONSTRAINT `FK444DD9D6C2477A6` FOREIGN KEY (`ASSIGNEE`) REFERENCES `kl_po` (`KL__ID`),
  CONSTRAINT `FK444DD9D83099946` FOREIGN KEY (`BRANCH_ROOT`) REFERENCES `kl_po` (`KL__ID`),
  CONSTRAINT `FK444DD9D9FF61117` FOREIGN KEY (`STATE_DEF`) REFERENCES `kl_cfg_state_def` (`KL__ID`),
  CONSTRAINT `FK444DD9DA61A50BD` FOREIGN KEY (`EXTERNAL_IMPLEMENTATION_ID`) REFERENCES `kl_external_link` (`KL__ID`),
  CONSTRAINT `FK444DD9DAF94A86B` FOREIGN KEY (`TEST_RUN`) REFERENCES `kl_po` (`KL__ID`),
  CONSTRAINT `FK444DD9DBE5DD0C9` FOREIGN KEY (`ROOT`) REFERENCES `kl_po` (`KL__ID`),
  CONSTRAINT `FK444DD9DBF7EEA03` FOREIGN KEY (`CREATOR`) REFERENCES `kl_po` (`KL__ID`),
  CONSTRAINT `FK444DD9DBFE87933` FOREIGN KEY (`ITEM_UNDER_TEST`) REFERENCES `kl_item` (`KL__ID`),
  CONSTRAINT `FK444DD9DC0A32E6A` FOREIGN KEY (`SUT`) REFERENCES `kl_po` (`KL__ID`),
  CONSTRAINT `FK444DD9DC75FAD64` FOREIGN KEY (`FATHER`) REFERENCES `kl_po` (`KL__ID`),
  CONSTRAINT `FK444DD9DE2C2010D` FOREIGN KEY (`LAST_EDITOR`) REFERENCES `kl_po` (`KL__ID`),
  CONSTRAINT `FK444DD9DF68DA90D` FOREIGN KEY (`SUCCESSOR`) REFERENCES `kl_po` (`KL__ID`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;

-- ----------------------------
--  Table structure for `kl_property`
-- ----------------------------
DROP TABLE IF EXISTS `kl_property`;
CREATE TABLE `kl_property` (
  `KL__ID` int(11) NOT NULL AUTO_INCREMENT,
  `TYPE` varchar(255) NOT NULL,
  `OWNER` int(11) DEFAULT NULL,
  `NAME` varchar(255) DEFAULT NULL,
  `VALUE` longtext,
  `DASHBOARD` int(11) DEFAULT NULL,
  PRIMARY KEY (`KL__ID`),
  KEY `FK1DA6F2F3D0A959F0` (`DASHBOARD`),
  KEY `FK1DA6F2F330AE3267` (`OWNER`),
  CONSTRAINT `FK1DA6F2F330AE3267` FOREIGN KEY (`OWNER`) REFERENCES `kl_po` (`KL__ID`),
  CONSTRAINT `FK1DA6F2F3D0A959F0` FOREIGN KEY (`DASHBOARD`) REFERENCES `kl_dashboard_report` (`KL__ID`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=latin1;

-- ----------------------------
--  Table structure for `kl_property_values_list`
-- ----------------------------
DROP TABLE IF EXISTS `kl_property_values_list`;
CREATE TABLE `kl_property_values_list` (
  `PROPERTY_ID` int(11) NOT NULL,
  `VALUE` longtext,
  `I` int(11) NOT NULL,
  PRIMARY KEY (`PROPERTY_ID`,`I`),
  KEY `FK54B4B24F71236E64` (`PROPERTY_ID`),
  CONSTRAINT `FK54B4B24F71236E64` FOREIGN KEY (`PROPERTY_ID`) REFERENCES `kl_property` (`KL__ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
--  Table structure for `kl_protocol_message`
-- ----------------------------
DROP TABLE IF EXISTS `kl_protocol_message`;
CREATE TABLE `kl_protocol_message` (
  `KL__ID` int(11) NOT NULL,
  PRIMARY KEY (`KL__ID`),
  KEY `FK767DC05E122F8CCA` (`KL__ID`),
  CONSTRAINT `FK767DC05E122F8CCA` FOREIGN KEY (`KL__ID`) REFERENCES `kl_item` (`KL__ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
--  Table structure for `kl_relation_config_server`
-- ----------------------------
DROP TABLE IF EXISTS `kl_relation_config_server`;
CREATE TABLE `kl_relation_config_server` (
  `CONFIG` int(11) NOT NULL,
  `EXTERNAL_SERVER` int(11) NOT NULL,
  `I` int(11) NOT NULL,
  PRIMARY KEY (`EXTERNAL_SERVER`,`CONFIG`),
  KEY `FK19B9C67BAEC99831` (`EXTERNAL_SERVER`),
  KEY `FK19B9C67B61B887AC` (`CONFIG`),
  CONSTRAINT `FK19B9C67B61B887AC` FOREIGN KEY (`CONFIG`) REFERENCES `kl_cfg` (`KL__ID`),
  CONSTRAINT `FK19B9C67BAEC99831` FOREIGN KEY (`EXTERNAL_SERVER`) REFERENCES `kl_external_server` (`KL__ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
--  Table structure for `kl_relation_ts_to_tc`
-- ----------------------------
DROP TABLE IF EXISTS `kl_relation_ts_to_tc`;
CREATE TABLE `kl_relation_ts_to_tc` (
  `TESTCASE` int(11) NOT NULL,
  `TESTSERIES` int(11) NOT NULL,
  `ID` int(11) NOT NULL,
  PRIMARY KEY (`TESTSERIES`,`ID`),
  KEY `FK44B7E0783218CC3E` (`TESTSERIES`),
  KEY `FK44B7E07844FD59B0` (`TESTCASE`),
  CONSTRAINT `FK44B7E0783218CC3E` FOREIGN KEY (`TESTSERIES`) REFERENCES `kl_po` (`KL__ID`),
  CONSTRAINT `FK44B7E07844FD59B0` FOREIGN KEY (`TESTCASE`) REFERENCES `kl_po` (`KL__ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
--  Table structure for `kl_revisions_tags`
-- ----------------------------
DROP TABLE IF EXISTS `kl_revisions_tags`;
CREATE TABLE `kl_revisions_tags` (
  `REVISION` int(11) NOT NULL,
  `TAG` int(11) NOT NULL,
  PRIMARY KEY (`REVISION`,`TAG`),
  KEY `FKD9B88EBEAE9D07C2` (`REVISION`),
  KEY `FKD9B88EBEA11C0FA8` (`TAG`),
  CONSTRAINT `FKD9B88EBEA11C0FA8` FOREIGN KEY (`TAG`) REFERENCES `kl_tags` (`KL__ID`),
  CONSTRAINT `FKD9B88EBEAE9D07C2` FOREIGN KEY (`REVISION`) REFERENCES `kl_po` (`KL__ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
--  Table structure for `kl_status_messages`
-- ----------------------------
DROP TABLE IF EXISTS `kl_status_messages`;
CREATE TABLE `kl_status_messages` (
  `KL__ID` int(11) NOT NULL AUTO_INCREMENT,
  `STATUS` varchar(128) NOT NULL,
  `MESSAGE` longtext,
  `TIMESTAMP` datetime NOT NULL,
  `USER_ID` int(11) NOT NULL,
  PRIMARY KEY (`KL__ID`),
  KEY `FK4F042C1B796B57E6` (`USER_ID`),
  CONSTRAINT `FK4F042C1B796B57E6` FOREIGN KEY (`USER_ID`) REFERENCES `kl_po` (`KL__ID`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

-- ----------------------------
--  Table structure for `kl_system_interface`
-- ----------------------------
DROP TABLE IF EXISTS `kl_system_interface`;
CREATE TABLE `kl_system_interface` (
  `KL__ID` int(11) NOT NULL,
  PRIMARY KEY (`KL__ID`),
  KEY `FKAFB65627122F8CCA` (`KL__ID`),
  CONSTRAINT `FKAFB65627122F8CCA` FOREIGN KEY (`KL__ID`) REFERENCES `kl_item` (`KL__ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
--  Table structure for `kl_system_requirement`
-- ----------------------------
DROP TABLE IF EXISTS `kl_system_requirement`;
CREATE TABLE `kl_system_requirement` (
  `KL__ID` int(11) NOT NULL,
  PRIMARY KEY (`KL__ID`),
  KEY `FK3AD33DB1122F8CCA` (`KL__ID`),
  CONSTRAINT `FK3AD33DB1122F8CCA` FOREIGN KEY (`KL__ID`) REFERENCES `kl_item` (`KL__ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
--  Table structure for `kl_tags`
-- ----------------------------
DROP TABLE IF EXISTS `kl_tags`;
CREATE TABLE `kl_tags` (
  `KL__ID` int(11) NOT NULL AUTO_INCREMENT,
  `TAG_ID` varchar(100) DEFAULT NULL,
  `Timestamp` time DEFAULT NULL,
  PRIMARY KEY (`KL__ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
--  Table structure for `kl_test_case_step`
-- ----------------------------
DROP TABLE IF EXISTS `kl_test_case_step`;
CREATE TABLE `kl_test_case_step` (
  `KL__ID` int(11) NOT NULL AUTO_INCREMENT,
  `PRE_CONDITION` longtext,
  `ACTION` longtext,
  `POST_CONDITION` longtext,
  `TESTCASE_ID` int(11) DEFAULT NULL,
  `I` int(11) DEFAULT NULL,
  PRIMARY KEY (`KL__ID`),
  KEY `FK285441AC2FC4EEA6` (`TESTCASE_ID`),
  CONSTRAINT `FK285441AC2FC4EEA6` FOREIGN KEY (`TESTCASE_ID`) REFERENCES `kl_po` (`KL__ID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

-- ----------------------------
--  Table structure for `kl_testcase_state`
-- ----------------------------
DROP TABLE IF EXISTS `kl_testcase_state`;
CREATE TABLE `kl_testcase_state` (
  `KL__ID` int(11) NOT NULL AUTO_INCREMENT,
  `STATE_DEF` int(11) DEFAULT NULL,
  `TESTCASE` int(11) DEFAULT NULL,
  `SUT` int(11) DEFAULT NULL,
  `Issue` int(11) DEFAULT NULL,
  PRIMARY KEY (`KL__ID`),
  KEY `FKDCB60352C0A32E6A` (`SUT`),
  KEY `FKDCB60352C9319526` (`Issue`),
  KEY `FKDCB6035244FD59B0` (`TESTCASE`),
  KEY `FKDCB603529FF61117` (`STATE_DEF`),
  CONSTRAINT `FKDCB6035244FD59B0` FOREIGN KEY (`TESTCASE`) REFERENCES `kl_po` (`KL__ID`),
  CONSTRAINT `FKDCB603529FF61117` FOREIGN KEY (`STATE_DEF`) REFERENCES `kl_cfg_state_def` (`KL__ID`),
  CONSTRAINT `FKDCB60352C0A32E6A` FOREIGN KEY (`SUT`) REFERENCES `kl_po` (`KL__ID`),
  CONSTRAINT `FKDCB60352C9319526` FOREIGN KEY (`Issue`) REFERENCES `kl_issue` (`KL__ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
--  Table structure for `kl_used_protocol_messages`
-- ----------------------------
DROP TABLE IF EXISTS `kl_used_protocol_messages`;
CREATE TABLE `kl_used_protocol_messages` (
  `USED_IN_TCs` int(11) NOT NULL,
  `elt` int(11) NOT NULL,
  `USED_PROTOCOL_MESSAGES` int(11) NOT NULL,
  PRIMARY KEY (`USED_PROTOCOL_MESSAGES`,`elt`),
  KEY `FK511F9FAF511B01FF` (`USED_PROTOCOL_MESSAGES`),
  KEY `FK511F9FAF1090F970` (`elt`),
  KEY `FK511F9FAF8952BB9B` (`elt`),
  KEY `FK511F9FAF47E0254F` (`USED_IN_TCs`),
  CONSTRAINT `FK511F9FAF1090F970` FOREIGN KEY (`elt`) REFERENCES `kl_protocol_message` (`KL__ID`),
  CONSTRAINT `FK511F9FAF47E0254F` FOREIGN KEY (`USED_IN_TCs`) REFERENCES `kl_protocol_message` (`KL__ID`),
  CONSTRAINT `FK511F9FAF511B01FF` FOREIGN KEY (`USED_PROTOCOL_MESSAGES`) REFERENCES `kl_po` (`KL__ID`),
  CONSTRAINT `FK511F9FAF8952BB9B` FOREIGN KEY (`elt`) REFERENCES `kl_po` (`KL__ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
--  Table structure for `kl_used_system_interfaces`
-- ----------------------------
DROP TABLE IF EXISTS `kl_used_system_interfaces`;
CREATE TABLE `kl_used_system_interfaces` (
  `USED_IN_TCs` int(11) NOT NULL,
  `elt` int(11) NOT NULL,
  `USED_SYSTEM_INTERFACES` int(11) NOT NULL,
  PRIMARY KEY (`USED_SYSTEM_INTERFACES`,`elt`),
  KEY `FK3EF9C3062AECAD56` (`USED_SYSTEM_INTERFACES`),
  KEY `FK3EF9C3069BC82AEB` (`elt`),
  KEY `FK3EF9C3068952BB9B` (`elt`),
  KEY `FK3EF9C306D31756CA` (`USED_IN_TCs`),
  CONSTRAINT `FK3EF9C3062AECAD56` FOREIGN KEY (`USED_SYSTEM_INTERFACES`) REFERENCES `kl_po` (`KL__ID`),
  CONSTRAINT `FK3EF9C3068952BB9B` FOREIGN KEY (`elt`) REFERENCES `kl_po` (`KL__ID`),
  CONSTRAINT `FK3EF9C3069BC82AEB` FOREIGN KEY (`elt`) REFERENCES `kl_system_interface` (`KL__ID`),
  CONSTRAINT `FK3EF9C306D31756CA` FOREIGN KEY (`USED_IN_TCs`) REFERENCES `kl_system_interface` (`KL__ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
--  Records 
-- ----------------------------
INSERT INTO `kl_business_codes` VALUES ('1','2','P','de.verit.klaros.persistent.Configuration',NULL), ('2','1','TC','de.verit.klaros.persistent.TestCase','1');
INSERT INTO `kl_cfg` VALUES ('1','P00001','','','CV9035DK'), ('2','P00002','','','CV90120TH');
INSERT INTO `kl_cfg_initial_states` VALUES ('1','1','de.verit.klaros.persistent.TestCase'), ('2','5','de.verit.klaros.persistent.TestCase');
INSERT INTO `kl_cfg_property_def` VALUES ('1','de.verit.klaros.persistent.TestCaseResult','testCase','String','/testresults/testresult[$]/testCase','\0','','1'), ('2','de.verit.klaros.persistent.TestSeries','testCases','List',NULL,'\0','','1'), ('3','de.verit.klaros.persistent.Project','name','String',NULL,'\0','\0','1'), ('4','de.verit.klaros.persistent.TestCase','inputvalues','String',NULL,'\0','','1'), ('5','de.verit.klaros.persistent.TestCase','method','String',NULL,'\0','','1'), ('6','de.verit.klaros.persistent.TestSeriesResult','type','String',NULL,'\0','','1'), ('7','de.verit.klaros.persistent.TestCase','priority','String',NULL,'\0','','1'), ('8','de.verit.klaros.persistent.TestCaseResult','type','String','/testresults/testresult[$]/type','\0','','1'), ('9','de.verit.klaros.persistent.TestCase','depends','String',NULL,'\0','','1'), ('10','de.verit.klaros.persistent.TestEnvironment','jdk','String',NULL,'\0','','1'), ('11','de.verit.klaros.persistent.TestCase','docbase','String',NULL,'\0','','1'), ('12','de.verit.klaros.persistent.TestCase','state','String',NULL,'\0','','1'), ('13','de.verit.klaros.persistent.TestSeriesResult','running','String',NULL,'\0','','1'), ('14','de.verit.klaros.persistent.TestCase','evaluation','String',NULL,'\0','','1'), ('15','de.verit.klaros.persistent.TestCase','note','String',NULL,'\0','','1'), ('16','de.verit.klaros.persistent.TestSeriesResult','timestamp','String',NULL,'\0','','1'), ('17','de.verit.klaros.persistent.TestSeriesResult','currentTestCase','String',NULL,'\0','','1'), ('18','de.verit.klaros.persistent.TestCase','shortname','String',NULL,'\0','','1'), ('19','de.verit.klaros.persistent.TestCase','cut','String',NULL,'\0','','1'), ('20','de.verit.klaros.persistent.TestSeries','enabled','String',NULL,'\0','','1'), ('21','de.verit.klaros.persistent.TestRequirement','stateName','String',NULL,'\0','\0','1'), ('22','de.verit.klaros.persistent.TestSeriesResult','testCasePassed','String',NULL,'\0','','1'), ('23','de.verit.klaros.persistent.TestCase','detectedIssues','String',NULL,'\0','\0','1'), ('24','de.verit.klaros.persistent.TestCaseResult','executor','String','/testresults/testresult[$]/executor','\0','','1'), ('25','de.verit.klaros.persistent.TestSeriesResult','enabled','String',NULL,'\0','','1'), ('26','de.verit.klaros.persistent.TestSeriesResult','executionTime','String',NULL,'\0','','1'), ('27','de.verit.klaros.persistent.TestRequirement','stateDescription','String',NULL,'\0','\0','1'), ('28','de.verit.klaros.persistent.SUTImplementation','name','String',NULL,'\0','\0','1'), ('29','de.verit.klaros.persistent.TestCase','covers','String',NULL,'\0','\0','1'), ('30','de.verit.klaros.persistent.TestCase','areatopic','String',NULL,'\0','','1'), ('31','de.verit.klaros.persistent.TestSeries','description','String',NULL,'\0','','1'), ('32','de.verit.klaros.persistent.TestCase','postcondition','String',NULL,'\0','','1'), ('33','de.verit.klaros.persistent.TestCase','precondition','String',NULL,'\0','','1'), ('34','de.verit.klaros.persistent.TestCase','name','String',NULL,'\0','\0','1'), ('35','de.verit.klaros.persistent.TestEnvironment','os','String',NULL,'\0','','1'), ('36','de.verit.klaros.persistent.TestCaseResult','testCasePassed','String','/testresults/testresult[$]/testCasePassed','\0','','1'), ('37','de.verit.klaros.persistent.TestRequirement','name','String',NULL,'\0','\0','1'), ('38','de.verit.klaros.persistent.TestSeries','name','String',NULL,'\0','\0','1'), ('39','de.verit.klaros.persistent.TestCase','sut','String',NULL,'\0','\0','1'), ('40','de.verit.klaros.persistent.TestCaseResult','description','String','/testresults/testresult[$]/description','\0','','1'), ('41','de.verit.klaros.persistent.TestCase','message','String',NULL,'\0','','1'), ('42','de.verit.klaros.persistent.TestEnvironment','webserver','String',NULL,'\0','','1'), ('43','de.verit.klaros.persistent.TestCaseResult','executionTime','String','/testresults/testresult[$]/executionTime','\0','','1'), ('44','de.verit.klaros.persistent.TestCase','revision','String',NULL,'\0','','1'), ('45','de.verit.klaros.persistent.TestCase','traceability','String',NULL,'\0','','1'), ('46','de.verit.klaros.persistent.TestCaseResult','summary','String','/testresults/testresult[$]/summary','\0','','1'), ('47','de.verit.klaros.persistent.TestCase','Issues','List',NULL,'\0','','1'), ('48','de.verit.klaros.persistent.TestCase','level','String',NULL,'\0','','1'), ('49','de.verit.klaros.persistent.TestEnvironment','vendor','String',NULL,'\0','','1'), ('50','de.verit.klaros.persistent.TestCase','equiclass','String',NULL,'\0','','1'), ('51','de.verit.klaros.persistent.TestCaseResult','timestamp','String','/testresults/testresult[$]/timestamp','\0','','1'), ('52','de.verit.klaros.persistent.TestCase','execution','String',NULL,'\0','','1'), ('53','de.verit.klaros.persistent.TestSeriesResult','testRun','String',NULL,'\0','','1'), ('54','de.verit.klaros.persistent.TestCase','description','String',NULL,'\0','','1'), ('55','de.verit.klaros.persistent.TestCaseResult','name','String','/testresults/testresult[$]/name','\0','','1'), ('56','de.verit.klaros.persistent.TestSeriesResult','finished','String',NULL,'\0','','1'), ('57','de.verit.klaros.persistent.TestCase','team','String',NULL,'\0','','1'), ('58','de.verit.klaros.persistent.TestCase','type','String',NULL,'\0','','1'), ('59','de.verit.klaros.persistent.RequirementGroup','name','String',NULL,'\0','\0','1'), ('60','de.verit.klaros.persistent.TestSeriesResult','executor','String',NULL,'\0','','1'), ('61','de.verit.klaros.persistent.TestCase','variety','String',NULL,'\0','','1'), ('62','de.verit.klaros.persistent.TestCaseResult','testCasePassed','String','/testresults/testresult[$]/testCasePassed','\0','','2'), ('63','de.verit.klaros.persistent.TestCase','method','String',NULL,'\0','','2'), ('64','de.verit.klaros.persistent.TestSeriesResult','testRun','String',NULL,'\0','','2'), ('65','de.verit.klaros.persistent.TestEnvironment','vendor','String',NULL,'\0','','2'), ('66','de.verit.klaros.persistent.TestCase','message','String',NULL,'\0','','2'), ('67','de.verit.klaros.persistent.Project','name','String',NULL,'\0','\0','2'), ('68','de.verit.klaros.persistent.TestRequirement','name','String',NULL,'\0','\0','2'), ('69','de.verit.klaros.persistent.TestCase','inputvalues','String',NULL,'\0','','2'), ('70','de.verit.klaros.persistent.TestCase','detectedIssues','String',NULL,'\0','\0','2'), ('71','de.verit.klaros.persistent.TestCaseResult','description','String','/testresults/testresult[$]/description','\0','','2'), ('72','de.verit.klaros.persistent.TestCase','shortname','String',NULL,'\0','','2'), ('73','de.verit.klaros.persistent.TestSeriesResult','currentTestCase','String',NULL,'\0','','2'), ('74','de.verit.klaros.persistent.TestEnvironment','webserver','String',NULL,'\0','','2'), ('75','de.verit.klaros.persistent.TestSeries','testCases','List',NULL,'\0','','2'), ('76','de.verit.klaros.persistent.TestCase','postcondition','String',NULL,'\0','','2'), ('77','de.verit.klaros.persistent.TestCase','precondition','String',NULL,'\0','','2'), ('78','de.verit.klaros.persistent.TestCase','evaluation','String',NULL,'\0','','2'), ('79','de.verit.klaros.persistent.TestRequirement','stateName','String',NULL,'\0','\0','2'), ('80','de.verit.klaros.persistent.TestCase','revision','String',NULL,'\0','','2'), ('81','de.verit.klaros.persistent.TestCaseResult','timestamp','String','/testresults/testresult[$]/timestamp','\0','','2'), ('82','de.verit.klaros.persistent.TestCase','team','String',NULL,'\0','','2'), ('83','de.verit.klaros.persistent.TestCase','type','String',NULL,'\0','','2'), ('84','de.verit.klaros.persistent.TestCase','docbase','String',NULL,'\0','','2'), ('85','de.verit.klaros.persistent.TestCase','name','String',NULL,'\0','\0','2'), ('86','de.verit.klaros.persistent.TestSeriesResult','finished','String',NULL,'\0','','2'), ('87','de.verit.klaros.persistent.SUTImplementation','name','String',NULL,'\0','\0','2'), ('88','de.verit.klaros.persistent.TestCaseResult','summary','String','/testresults/testresult[$]/summary','\0','','2'), ('89','de.verit.klaros.persistent.TestCase','description','String',NULL,'\0','','2'), ('90','de.verit.klaros.persistent.TestEnvironment','os','String',NULL,'\0','','2'), ('91','de.verit.klaros.persistent.TestCase','cut','String',NULL,'\0','','2'), ('92','de.verit.klaros.persistent.TestCaseResult','executionTime','String','/testresults/testresult[$]/executionTime','\0','','2'), ('93','de.verit.klaros.persistent.TestCase','traceability','String',NULL,'\0','','2'), ('94','de.verit.klaros.persistent.TestCase','depends','String',NULL,'\0','','2'), ('95','de.verit.klaros.persistent.TestCase','priority','String',NULL,'\0','','2'), ('96','de.verit.klaros.persistent.TestSeriesResult','testCasePassed','String',NULL,'\0','','2'), ('97','de.verit.klaros.persistent.RequirementGroup','name','String',NULL,'\0','\0','2'), ('98','de.verit.klaros.persistent.TestSeries','description','String',NULL,'\0','','2'), ('99','de.verit.klaros.persistent.TestSeriesResult','executionTime','String',NULL,'\0','','2'), ('100','de.verit.klaros.persistent.TestRequirement','stateDescription','String',NULL,'\0','\0','2');
INSERT INTO `kl_cfg_property_def` VALUES ('101','de.verit.klaros.persistent.TestCase','Issues','List',NULL,'\0','','2'), ('102','de.verit.klaros.persistent.TestSeriesResult','type','String',NULL,'\0','','2'), ('103','de.verit.klaros.persistent.TestSeries','enabled','String',NULL,'\0','','2'), ('104','de.verit.klaros.persistent.TestCaseResult','name','String','/testresults/testresult[$]/name','\0','','2'), ('105','de.verit.klaros.persistent.TestCaseResult','type','String','/testresults/testresult[$]/type','\0','','2'), ('106','de.verit.klaros.persistent.TestCase','note','String',NULL,'\0','','2'), ('107','de.verit.klaros.persistent.TestCase','state','String',NULL,'\0','','2'), ('108','de.verit.klaros.persistent.TestSeries','name','String',NULL,'\0','\0','2'), ('109','de.verit.klaros.persistent.TestCase','variety','String',NULL,'\0','','2'), ('110','de.verit.klaros.persistent.TestSeriesResult','enabled','String',NULL,'\0','','2'), ('111','de.verit.klaros.persistent.TestCase','sut','String',NULL,'\0','\0','2'), ('112','de.verit.klaros.persistent.TestCase','areatopic','String',NULL,'\0','','2'), ('113','de.verit.klaros.persistent.TestCase','execution','String',NULL,'\0','','2'), ('114','de.verit.klaros.persistent.TestCase','equiclass','String',NULL,'\0','','2'), ('115','de.verit.klaros.persistent.TestEnvironment','jdk','String',NULL,'\0','','2'), ('116','de.verit.klaros.persistent.TestCase','covers','String',NULL,'\0','\0','2'), ('117','de.verit.klaros.persistent.TestCase','level','String',NULL,'\0','','2'), ('118','de.verit.klaros.persistent.TestCaseResult','executor','String','/testresults/testresult[$]/executor','\0','','2'), ('119','de.verit.klaros.persistent.TestSeriesResult','running','String',NULL,'\0','','2'), ('120','de.verit.klaros.persistent.TestSeriesResult','timestamp','String',NULL,'\0','','2'), ('121','de.verit.klaros.persistent.TestCaseResult','testCase','String','/testresults/testresult[$]/testCase','\0','','2'), ('122','de.verit.klaros.persistent.TestSeriesResult','executor','String',NULL,'\0','','2');
INSERT INTO `kl_cfg_state_def` VALUES ('1','new',NULL,'de.verit.klaros.persistent.TestCase','1'), ('2','approved',NULL,'de.verit.klaros.persistent.TestCase','1'), ('3','locked',NULL,'de.verit.klaros.persistent.TestCase','1'), ('4','invisible',NULL,'de.verit.klaros.persistent.TestCase','1'), ('5','new',NULL,'de.verit.klaros.persistent.TestCase','2'), ('6','approved',NULL,'de.verit.klaros.persistent.TestCase','2'), ('7','locked',NULL,'de.verit.klaros.persistent.TestCase','2'), ('8','invisible',NULL,'de.verit.klaros.persistent.TestCase','2');
INSERT INTO `kl_db_revision` VALUES ('1','2.5','2010-01-27 12:27:20','');
INSERT INTO `kl_po` VALUES ('1','USR',NULL,'Felix Mustermann','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'admin','21232f297a57a5a743894ae4a801fc3','admin',''), ('2','USR',NULL,'Max Mustermann','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'manager','1d258c244a8d19e716292b231e3190','manager',''), ('3','USR',NULL,'Erika Mustermann','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'tester','f5d1278e819edd94e1e4197e04873b9','tester',''), ('4','USR',NULL,'System Account','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'system','54b5307254eeeb8f8e9343e71f28176','tester',''), ('5','USR',NULL,'Anders Forslund','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'AForslund','48c2d140fcc4e8d54dca589dd1b66eab','admin',''), ('6','USR',NULL,'Markus Dahlberg','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'MDahlberg','1b383ea316a2a9dfefbae7502eeca62d','tester',''), ('7','USR',NULL,'Matthias Abrahamsson','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Biffen','5f8d67219578d74a10d3ce65eb69532','tester',''), ('8','USR',NULL,'Sofie Wallander','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'SWallander','6d2aa9b5919c441d959b4195ce14e2a','manager',''), ('9','USR',NULL,'Daniel Mattila','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'DMattila','e1f98024a39413cf153bf4343f5e17','manager',''), ('10','TC','1','TC00001','',NULL,'8','8','2010-01-28 13:00:18','2010-02-02 11:25:19',NULL,NULL,'1.1',NULL,NULL,'Deleted','10','10',NULL,NULL,NULL,NULL,NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `kl_property` VALUES ('1','String','1','system','false',NULL), ('2','String','2','system','false',NULL), ('3','String','3','system','false',NULL), ('4','String','4','system','true',NULL), ('5','String','5','system','true',NULL), ('6','String','6','system','true',NULL), ('7','String','7','system','false',NULL), ('8','String','8','system','false',NULL), ('9','String','9','system','false',NULL), ('10','String','10','docbase','',NULL), ('11','String','10','areatopic',NULL,NULL), ('12','String','10','state','Entwurf',NULL), ('13','String','10','team','',NULL), ('14','String','10','type',NULL,NULL), ('15','String','10','variety',NULL,NULL), ('16','String','10','evaluation','',NULL), ('17','String','10','execution','Manuell',NULL), ('18','String','10','postcondition','',NULL), ('19','String','10','traceability','',NULL), ('20','String','10','message','',NULL), ('21','String','10','revision','1.0',NULL), ('22','String','10','precondition','',NULL), ('23','List','10','Issues',NULL,NULL), ('24','String','10','level','',NULL), ('25','String','10','description','',NULL), ('26','String','10','priority','Mittel',NULL), ('27','String','10','shortname','Fire Exinguisher',NULL), ('28','String','10','method','',NULL), ('29','String','10','cut','',NULL), ('30','String','10','equiclass','',NULL), ('31','String','10','depends','',NULL), ('32','String','10','note','',NULL), ('33','String','10','inputvalues','',NULL);
INSERT INTO `kl_status_messages` VALUES ('1','NONE','No missing properties found.','2010-01-27 12:35:25','8'), ('2','NONE','No missing properties found.','2010-01-27 12:57:16','8'), ('3','NONE','No missing properties found.','2010-01-27 12:57:19','8'), ('4','NONE','No missing properties found.','2010-01-27 13:45:41','8'), ('5','ERROR','This account has no permissions to login.','2010-01-27 13:59:52','5'), ('6','NONE','No missing properties found.','2010-01-27 14:09:33','8'), ('7','NONE','No missing properties found.','2010-01-27 14:12:27','1');
INSERT INTO `kl_test_case_step` VALUES ('1','Fordonet är ej i bruk','Tryck på brandsläcknings knapp','','10','0'), ('2','','Brandsläckningssystemet aktiveras','Smäll och systemet aktiverasl.','10','1');
